/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.login.codec;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import se.ericsson.security.login.codec.CodecException;
import se.ericsson.security.login.codec.CodecFactory;
import se.ericsson.security.login.codec.CodecFactorySpi;

class X509Provider
extends CodecFactorySpi {
    private static final String CERT_HEADER = "-----BEGIN CERTIFICATE-----\n";
    private static final String CERT_FOOTER = "\n-----END CERTIFICATE-----";

    X509Provider() {
    }

    public byte[] engineEncode(Object object) throws CodecException {
        if (!(object instanceof Certificate)) {
            throw new CodecException("Unkown certificate object: " + object.getClass().getName());
        }
        try {
            Certificate certificate = (Certificate)object;
            StringBuffer stringBuffer = new StringBuffer();
            CodecFactory codecFactory = CodecFactory.getInstance("BASE64");
            stringBuffer.append(CERT_HEADER);
            stringBuffer.append(codecFactory.encodeAsString(certificate.getEncoded()));
            stringBuffer.append(CERT_FOOTER);
            return stringBuffer.toString().getBytes(this.getCharacterEncoding());
        }
        catch (IOException iOException) {
            throw new CodecException("Failed to encode data", iOException);
        }
        catch (CertificateException certificateException) {
            throw new CodecException("Failed to encode certificate", certificateException);
        }
    }

    public Object engineDecode(byte[] byArray) throws CodecException {
        String string = null;
        try {
            string = new String(byArray, this.getCharacterEncoding());
            int n = string.indexOf(CERT_HEADER);
            if (n < 0) {
                throw new CodecException("Could not find PEM header");
            }
            int n2 = string.indexOf(CERT_FOOTER);
            if (n2 < 0) {
                throw new CodecException("Could not find PEM footer");
            }
            int n3 = n + CERT_HEADER.length();
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            CodecFactory codecFactory = CodecFactory.getInstance("BASE64");
            byte[] byArray2 = (byte[])codecFactory.decode(string.substring(n3, n2));
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
            return certificateFactory.generateCertificate(byteArrayInputStream);
        }
        catch (IOException iOException) {
            throw new CodecException("Failed to decode PEM string", iOException);
        }
        catch (CertificateException certificateException) {
            throw new CodecException("Failed to decode PEM data", certificateException);
        }
    }

    public byte[] engineEncodeAndEncrypt(Object object, char[] cArray) throws CodecException {
        throw new CodecException("Not implemented");
    }

    public Object engineDecodeAndDecrypt(byte[] byArray, char[] cArray) throws CodecException {
        throw new CodecException("Not implemented");
    }
}

