/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.login.creds;

import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import se.ericsson.security.login.Log;
import se.ericsson.security.login.creds.Credentials;
import se.ericsson.security.login.creds.CredentialsException;
import se.ericsson.security.login.creds.CredentialsExpiredException;

public class CredentialsValidator {
    private static Log log = Log.getInstance();

    public static void checkValidity(Credentials credentials) throws CredentialsException {
        log.debug("Checking validity of credentials");
        if (Boolean.getBoolean("se.ericsson.security.ssu.testing") && Boolean.getBoolean("se.ericsson.security.ssu.invalidcreds")) {
            throw new CredentialsException("TESTING:Credentials are invalid");
        }
        X509Certificate[] x509CertificateArray = (X509Certificate[])credentials.getCertificateChain();
        PrivateKey privateKey = credentials.getPrivateKey();
        if (privateKey == null) {
            throw new CredentialsException("Credentials did not contain a private key");
        }
        log.debug("Credentials contains a private key with algorithm name " + privateKey.getAlgorithm() + " and format " + privateKey.getFormat());
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            try {
                x509CertificateArray[i].checkValidity();
                if (i < x509CertificateArray.length - 1) {
                    x509CertificateArray[i].verify(x509CertificateArray[i + 1].getPublicKey());
                    continue;
                }
                x509CertificateArray[i].verify(x509CertificateArray[i].getPublicKey());
                continue;
            }
            catch (CertificateException certificateException) {
                log.error("Certificate is not valid " + x509CertificateArray[i]);
                throw new CredentialsExpiredException("Credentials are not valid", certificateException);
            }
            catch (GeneralSecurityException generalSecurityException) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Could not verify signature of certificate ");
                stringBuffer.append(x509CertificateArray[i].getSubjectDN()).append("\n");
                stringBuffer.append("Certificate chain consists of: \n");
                for (int j = 0; j < x509CertificateArray.length; ++j) {
                    stringBuffer.append(x509CertificateArray[j].getSubjectDN()).append("\n");
                }
                log.error(stringBuffer.toString());
                throw new CredentialsException("Failed to verify credentials certificate chain", generalSecurityException);
            }
        }
        log.debug("Credentials found to be valid");
    }
}

