/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.login.creds;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Properties;
import java.util.Vector;
import se.ericsson.security.login.Log;
import se.ericsson.security.login.creds.Credentials;
import se.ericsson.security.login.creds.CredentialsException;
import se.ericsson.security.login.creds.CredentialsFactorySpi;
import se.ericsson.security.login.creds.CredentialsParsingException;
import se.ericsson.security.sls.UserCredentials;

class SLSCredentialsFactory
extends CredentialsFactorySpi {
    private static Log logger = Log.getInstance();

    SLSCredentialsFactory() {
    }

    public Credentials engineGenerateCredentials(InputStream inputStream) throws CredentialsException {
        Credentials credentials = new Credentials();
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            Object object = objectInputStream.readObject();
            this.setSystemParameter(credentials, object);
            this.setTrustedCertificates(credentials, objectInputStream.readObject());
            this.setUserCredentials(credentials, objectInputStream.readObject());
            objectInputStream.close();
        }
        catch (IOException iOException) {
            throw new CredentialsParsingException("Could not parse data", iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new CredentialsParsingException("Unkown data type", classNotFoundException);
        }
        return credentials;
    }

    public Credentials engineGenerateCredentials(InputStream inputStream, char[] cArray) throws CredentialsException {
        throw new CredentialsParsingException("Encrypted SLS credentials not supported");
    }

    private void setSystemParameter(Credentials credentials, Object object) throws CredentialsException {
        if (!(object instanceof Properties)) {
            throw new CredentialsParsingException("Unkown System Property format :" + object.getClass().getName());
        }
        credentials.setProperties((Properties)object);
    }

    private void setTrustedCertificates(Credentials credentials, Object object) throws CredentialsException {
        if (!(object instanceof Vector)) {
            throw new CredentialsParsingException("Unkown Trusted Certificates format : " + object.getClass().getName());
        }
        Vector vector = (Vector)object;
        Certificate[] certificateArray = new Certificate[vector.size()];
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream byteArrayInputStream = null;
            Object object2 = null;
            for (int i = 0; i < certificateArray.length; ++i) {
                object2 = vector.elementAt(i);
                if (!(object2 instanceof byte[])) {
                    throw new CredentialsException("Unkown certificate format" + object2.getClass().getName());
                }
                byteArrayInputStream = new ByteArrayInputStream((byte[])object2);
                certificateArray[i] = certificateFactory.generateCertificate(byteArrayInputStream);
                try {
                    byteArrayInputStream.close();
                    continue;
                }
                catch (IOException iOException) {
                    logger.warning("Failed to close ByteArrayInputStream", iOException);
                }
            }
        }
        catch (CertificateException certificateException) {
            throw new CredentialsParsingException("Could not parse trusted certificates", certificateException);
        }
        credentials.setTrustedCertificates(certificateArray);
    }

    private void setUserCredentials(Credentials credentials, Object object) throws CredentialsException {
        if (!(object instanceof UserCredentials)) {
            throw new CredentialsParsingException("User credentials format: " + object.getClass().getName());
        }
        UserCredentials userCredentials = (UserCredentials)object;
        try {
            credentials.setPrivateKey(userCredentials.getPrivateKey());
            credentials.setCertificateChain(userCredentials.getCertificateChain());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CredentialsParsingException("Error parsing user credentials", generalSecurityException);
        }
    }
}

