/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.login.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import se.ericsson.security.login.SSULocalizer;
import se.ericsson.security.login.gui.GridBagPanel;

class LoginDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final String OK = SSULocalizer.getString("ok");
    private static final String CANCEL = SSULocalizer.getString("cancel");
    private static final String OPTIONS = SSULocalizer.getString("options");
    private JLabel ssoNameField;
    private JTextField nameField;
    private JPasswordField passwordField;
    private JButton okButton;
    private JButton cancelButton;
    private JButton optionsButton;
    private NameCallback nameCallback;
    private PasswordCallback passwordCallback;
    private ConfirmationCallback confirmationCallback;
    private ConfirmationCallback optionsCallback;
    private Set actionListeners;
    private String uniqueId = null;
    private boolean alwaysOnTop = true;

    LoginDialog(NameCallback nameCallback, PasswordCallback passwordCallback, ConfirmationCallback confirmationCallback, ConfirmationCallback confirmationCallback2) {
        this(nameCallback, passwordCallback, confirmationCallback, confirmationCallback2, null);
    }

    LoginDialog(NameCallback nameCallback, PasswordCallback passwordCallback, ConfirmationCallback confirmationCallback, String string) {
        this(nameCallback, passwordCallback, confirmationCallback, null, string);
    }

    private LoginDialog(NameCallback nameCallback, PasswordCallback passwordCallback, ConfirmationCallback confirmationCallback, ConfirmationCallback confirmationCallback2, String string) {
        this.nameCallback = nameCallback;
        this.passwordCallback = passwordCallback;
        this.confirmationCallback = confirmationCallback;
        this.uniqueId = string;
        this.optionsCallback = confirmationCallback2;
        this.initGUI();
    }

    private void initGUI() {
        this.setTitle(SSULocalizer.getTitle());
        this.actionListeners = new HashSet(1);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            unsupportedLookAndFeelException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                LoginDialog.this.actionPerformed(new ActionEvent(windowEvent.getWindow(), 0, CANCEL));
            }

            public void windowDeactivated(WindowEvent windowEvent) {
                if (LoginDialog.this.alwaysOnTop) {
                    windowEvent.getWindow().toFront();
                }
            }
        });
        this.getContentPane().add(this.getMainPanel());
        this.setResizable(false);
        if (this.optionsCallback != null && this.optionsCallback.getOptions().length == 1) {
            this.optionsButton.setEnabled(false);
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (dimension.width - this.getSize().width) / 3;
        int n2 = (dimension.height - this.getSize().height) / 3;
        this.setLocation(n, n2);
        this.pack();
    }

    void addActionListener(ActionListener actionListener) {
        this.actionListeners.add(actionListener);
    }

    void update() {
        this.nameField.setText(this.nameCallback.getName());
    }

    private JPanel getMainPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = this.getInputPanel();
        JPanel jPanel3 = this.getButtonPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel3, "South");
        jPanel.setSize(320, 170);
        return jPanel;
    }

    private JPanel getInputPanel() {
        GridBagPanel gridBagPanel = new GridBagPanel();
        this.passwordField = new JPasswordField();
        this.passwordField.setPreferredSize(new Dimension(200, 21));
        this.passwordField.setEchoChar('*');
        this.passwordField.setActionCommand(OK);
        this.passwordField.addActionListener(this);
        if (this.uniqueId == null) {
            this.nameField = new JTextField(this.nameCallback.getName());
            this.nameField.setPreferredSize(new Dimension(200, 21));
            this.nameField.setActionCommand(OK);
            this.nameField.addActionListener(this);
            this.nameField.requestFocus();
            this.nameField.setName("userNameTF");
        } else {
            this.ssoNameField = new JLabel(this.uniqueId);
        }
        JLabel jLabel = new JLabel(this.nameCallback.getPrompt());
        JLabel jLabel2 = new JLabel(this.passwordCallback.getPrompt());
        gridBagPanel.setAnchor(18);
        gridBagPanel.setInsets(10, 10, 2, 10);
        gridBagPanel.setWeightX(1);
        gridBagPanel.add(jLabel, 0, 0, 1, 1);
        gridBagPanel.setAnchor(16);
        gridBagPanel.setInsets(2, 10, 10, 10);
        gridBagPanel.setWeightX(2);
        gridBagPanel.add(jLabel2, 0, 1, 1, 1);
        gridBagPanel.setAnchor(18);
        gridBagPanel.setInsets(10, 0, 2, 10);
        gridBagPanel.setWeightX(1);
        if (this.uniqueId == null) {
            gridBagPanel.add(this.nameField, 1, 0, 1, 1);
        } else {
            gridBagPanel.add(this.ssoNameField, 1, 0, 1, 1);
        }
        gridBagPanel.setAnchor(14);
        gridBagPanel.setInsets(2, 0, 10, 10);
        gridBagPanel.setWeightX(2);
        gridBagPanel.add(this.passwordField, 1, 1, 1, 1);
        return gridBagPanel;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2, 5, 10));
        this.okButton = new JButton(OK);
        this.okButton.setActionCommand(OK);
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(CANCEL);
        this.cancelButton.setActionCommand(CANCEL);
        this.cancelButton.addActionListener(this);
        jPanel.add(this.okButton);
        jPanel.add(this.cancelButton);
        if (this.uniqueId == null) {
            this.optionsButton = new JButton(OPTIONS);
            this.optionsButton.setActionCommand(OPTIONS);
            this.optionsButton.addActionListener(this);
            this.optionsButton.setToolTipText(SSULocalizer.getString("choose_login_mode"));
            jPanel.add(this.optionsButton);
        }
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.uniqueId == null) {
            this.nameCallback.setName(this.nameField.getText());
        } else {
            this.nameCallback.setName(this.ssoNameField.getText());
        }
        this.passwordCallback.setPassword(this.passwordField.getPassword());
        if (actionEvent.getActionCommand().equals(OK)) {
            this.confirmationCallback.setSelectedIndex(3);
        } else {
            if (actionEvent.getActionCommand().equals(OPTIONS)) {
                this.alwaysOnTop = false;
                Object[] objectArray = this.optionsCallback.getOptions();
                Object object = JOptionPane.showInputDialog(this, this.optionsCallback.getPrompt(), SSULocalizer.getString("login") + " " + SSULocalizer.getString("options"), 1, null, objectArray, objectArray[this.optionsCallback.getSelectedIndex()]);
                for (int i = 0; i < objectArray.length; ++i) {
                    if (!((String)objectArray[i]).equals(object)) continue;
                    this.optionsCallback.setSelectedIndex(i);
                    break;
                }
                this.alwaysOnTop = true;
                return;
            }
            this.confirmationCallback.setSelectedIndex(2);
        }
        Iterator iterator = this.actionListeners.iterator();
        while (iterator.hasNext()) {
            ((ActionListener)iterator.next()).actionPerformed(actionEvent);
        }
    }
}

