/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.omf.aue.step1;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import se.ericsson.cello.aueframework.collector.CollectorContext;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.common.TransactionWrapper;
import se.ericsson.cello.aueframework.common.TransactionWrapperFactory;
import se.ericsson.cello.equipment.intma.PiuTypeAccess;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.swmanagement.PiuTypeMo;
import se.ericsson.cello.swmanagement.RepertoireMo;
import se.ericsson.cello.swmanagement.SwAllocationMo;
import se.ericsson.cello.swmanagement.suaccess.LoadModuleMoSU_Access;
import se.ericsson.cello.swmanagement.suaccess.PiuTypeMoSU_Access;
import se.ericsson.cello.swmanagement.suaccess.RepertoireMoSU_Access;
import se.ericsson.cello.swmanagement.suaccess.SwAllocationMoSU_Access;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.upgradepackage.main.interfaces.InstallRejectReason;
import se.ericsson.cello.upgradepackage.main.interfaces.PiuTypeInstallListener;
import se.ericsson.cello.upgradepackage.main.interfaces.PiuTypeInstallSupportAdaptor;
import se.ericsson.cello.util.library.Lib;
import se.ericsson.crbs.cat.omf.aue.step1.helper.FileHelper;
import se.ericsson.crbs.cat.omf.aue.step1.helper.FileHelperFactory;
import se.ericsson.crbs.cat.omf.aue.step1.helper.LoadModuleRecoverer;
import se.ericsson.crbs.cat.omf.aue.step1.helper.ProductNumberHelper;
import se.ericsson.crbs.cat.omf.aue.step1.helper.RevisionHolder;
import se.ericsson.crbs.cat.omf.aue.step1.helper.RuDataHolder;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;

public class AuxPluginUnitInstaller
implements PiuTypeInstallListener {
    private static final Class THIS_CLASS = AuxPluginUnitInstaller.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String PIU_TYPE_ATTR = "piuType";
    private static final String UNIT_TYPE = "unitType";
    private static final String PRODUCT_DATA = "productData";
    private static final String PRODUCT_NAME = "productName";
    private static final String PRODUCT_NUMBER = "productNumber";
    private static final String PRODUCT_REVISION = "productRevision";
    private static final String NULL = "null";
    private static final String PIU_TYPE_SERIAL_NUMBER = "00000000";
    private static final String SERIAL_NUMBER = "serialNumber";
    private static final String PIU_TYPE_TYPE = "PiuType";
    private static final String RESERVED_BY_ATTR = "reservedBy";
    private static final String EMPTY_STRING = "";
    private static final String LOADMODULE_INSTALLATION_PATH = "/c/loadmodules_norepl/";
    private static final String MAO_FRO_PIC_PREINSTALLED_SW = "preinsSW";
    private static final String MAO_FRO_PIC_INCOMPATIBLE_SW = "incompSW";
    private static final String MAO_FRO_PIC_COMPATIBILITY_LIST_FAULTY = "compLstFault";
    private static final String MAO_FRO_PIC_RUNNING_SW = "runningSW";
    private static final String MAO_FRO_PIC_INCOMPATIBLE_HW = "incompHW";
    private static final String TAG = "tag";
    private static final String LOAD_MODULE_DN = "loadModuleDN";
    private static final int INSTALLED = 2;
    private static final String PIUTYPE_INITIAL_RD = "INITIALRBSRD_*";
    private CollectorContext collectorContext;
    private RuDataHolder ruDataHolder;
    private volatile boolean installPiuTypeIsDone;

    public AuxPluginUnitInstaller(CollectorContext inCollectorContext) {
        logger.traceEnter(THIS_CLASS, "AuxPluginUnitInstaller()");
        this.collectorContext = inCollectorContext;
        logger.traceReturn(THIS_CLASS, "AuxPluginUnitInstaller()");
    }

    public void installAuxPluginUnits() {
        logger.traceEnter(THIS_CLASS, "installAuxPluginUnits()");
        MoIterator moIterator = this.collectorContext.getMoAccessor().lookupType("AuxPlugInUnit");
        if (moIterator != null) {
            logger.traceDebug(THIS_CLASS, "Number of AuxPluginUnits: " + moIterator.size());
            while (moIterator.hasMoreElements()) {
                ManagedObject nextMo = moIterator.nextMo();
                this.ruDataHolder = new RuDataHolder();
                try {
                    this.installAuxPluginUnit(nextMo);
                }
                catch (NoSuchAttributeException e) {
                    logger.traceError(THIS_CLASS, "Error during installing software on auxpluginunit: " + nextMo.getLocalDistinguishedName() + " during upgrade: " + e.toString());
                }
                catch (MoAccessException e) {
                    logger.traceError(THIS_CLASS, "Error during installing software on auxpluginunit: " + nextMo.getLocalDistinguishedName() + " during upgrade: " + e.toString());
                }
            }
        } else {
            logger.traceDebug(THIS_CLASS, "No AuxPluginUnit is found.");
        }
        logger.traceReturn(THIS_CLASS, "installAuxPluginUnits()");
    }

    private void installAuxPluginUnit(ManagedObject mo) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "installAuxPluginUnit() with: " + mo);
        PiuTypeAccess currentPiuType = (PiuTypeAccess)this.getPiuType(mo);
        logger.traceDebug(THIS_CLASS, "Current PiuType for: " + mo + " is: " + currentPiuType);
        if (this.hsiSupported(currentPiuType)) {
            this.setRuDataFromCorrectSource(mo, currentPiuType);
            PiuTypeMoSU_Access piuTypeMo = this.getPiuTypeForHwPid();
            logger.traceDebug(THIS_CLASS, "New PiuType for: " + mo + " is: " + piuTypeMo);
            if (piuTypeMo != null) {
                try {
                    this.downloadAndInstallMissingSW(mo, piuTypeMo);
                }
                catch (Exception e) {
                    logger.traceError(THIS_CLASS, "Error during SW installation on: " + mo + ". More detailes: " + e.toString());
                }
            } else {
                logger.traceDebug(THIS_CLASS, "New PiuType is null, skip and return.");
            }
        } else {
            logger.traceDebug(THIS_CLASS, "Current PiuType is null or Radio DOT, skip and return.");
        }
        logger.traceReturn(THIS_CLASS, "installAuxPluginUnit() with: " + mo);
    }

    private boolean hsiSupported(PiuTypeAccess piuType) {
        logger.traceEnter(THIS_CLASS, "hsiSupported()");
        boolean hsiSupported = piuType != null && piuType.getLocalDistinguishedName().indexOf(PIUTYPE_INITIAL_RD) == -1;
        logger.traceReturn(THIS_CLASS, "hsiSupported() for piuType=" + piuType + " (" + hsiSupported + ")");
        return hsiSupported;
    }

    private ManagedObject getPiuType(ManagedObject mo) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getPiuType() for: " + mo);
        ManagedObject piuType = (ManagedObject)this.getAttribute(mo, PIU_TYPE_ATTR);
        logger.traceReturn(THIS_CLASS, "getPiuType() for: " + mo + " ,PiuType: " + piuType);
        return piuType;
    }

    private Object getAttribute(ManagedObject mo, String attributeName) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getAttribute(), mo: " + mo + " ,Attribute name: " + attributeName);
        Object result = null;
        result = UNIT_TYPE.equalsIgnoreCase(attributeName) ? this.getUnitType(mo) : mo.getAttribute(attributeName, null);
        String attrValue = NULL;
        if (result != null) {
            attrValue = result instanceof ManagedObject ? ((ManagedObject)result).getLocalDistinguishedName() : result.toString();
        }
        logger.traceReturn(THIS_CLASS, "getAttribute() - " + attributeName + " - " + attrValue);
        return result;
    }

    private final String getUnitType(ManagedObject mo) throws MoAccessException, NoSuchAttributeException {
        logger.traceEnter(THIS_CLASS, "getUnitType() for mo: " + mo);
        ManagedObject thePiuType = (ManagedObject)mo.getAttribute(PIU_TYPE_ATTR, null);
        Object productData = thePiuType.getAttribute(PRODUCT_DATA, null);
        String localProductName = (String)((Struct)productData).getValue(PRODUCT_NAME);
        logger.traceReturn(THIS_CLASS, "getUnitType() : " + localProductName);
        return localProductName;
    }

    private void setRuDataFromCorrectSource(ManagedObject mo, PiuTypeAccess currentPiuType) {
        logger.traceEnter(THIS_CLASS, "setRuDataFromCorrectSource()");
        RuDataHolder ruDataFromProductData = this.getRuDataFromProductData(mo);
        if (ruDataFromProductData.isRequiredDataInitialized()) {
            this.ruDataHolder = ruDataFromProductData;
            logger.traceDebug(THIS_CLASS, "RU data read from product data: " + this.ruDataHolder.toString());
        } else {
            RuDataHolder ruDataFromPiuType;
            this.ruDataHolder = ruDataFromPiuType = this.getRuDataFromPiuType(mo, currentPiuType);
            logger.traceDebug(THIS_CLASS, "RU data read from PiuType: " + this.ruDataHolder.toString());
        }
        logger.traceReturn(THIS_CLASS, "setRuDataFromCorrectSource()");
    }

    private RuDataHolder getRuDataFromProductData(ManagedObject mo) {
        RuDataHolder ruDataFromProductData;
        logger.traceEnter(THIS_CLASS, "getRuDataFromProductData()");
        try {
            ruDataFromProductData = new RuDataHolder();
            Struct productData = (Struct)this.getAttribute(mo, PRODUCT_DATA);
            String productDataProductName = (String)productData.getValue(PRODUCT_NAME);
            String productDataProductNumber = (String)productData.getValue(PRODUCT_NUMBER);
            String productDataProductRevision = (String)productData.getValue(PRODUCT_REVISION);
            String productDataSerialNumber = (String)productData.getValue(SERIAL_NUMBER);
            ruDataFromProductData.setLdn(mo.getLocalDistinguishedName());
            ruDataFromProductData.setProductName(productDataProductName);
            ruDataFromProductData.setProductNumber(productDataProductNumber);
            ruDataFromProductData.setProductRevision(productDataProductRevision);
            ruDataFromProductData.setSerialNumber(productDataSerialNumber);
        }
        catch (Exception e) {
            logger.traceError(THIS_CLASS, "Failed to retrieve RU data from product data.", (Throwable)e);
            ruDataFromProductData = new RuDataHolder();
        }
        logger.traceReturn(THIS_CLASS, "getRuDataFromProductData()");
        return ruDataFromProductData;
    }

    private RuDataHolder getRuDataFromPiuType(ManagedObject mo, PiuTypeAccess currentPiuType) {
        RuDataHolder ruDataFromPiuType;
        logger.traceEnter(THIS_CLASS, "getRuDataFromPiuType()");
        try {
            ruDataFromPiuType = new RuDataHolder();
            Struct productData = currentPiuType.getProductData(null);
            String piuTypeProductName = (String)productData.getValue(PRODUCT_NAME);
            String piuTypeProductNumber = (String)productData.getValue(PRODUCT_NUMBER);
            String piuTypeProductRevision = (String)productData.getValue(PRODUCT_REVISION);
            ruDataFromPiuType.setLdn(mo.getLocalDistinguishedName());
            ruDataFromPiuType.setProductName(piuTypeProductName);
            ruDataFromPiuType.setProductNumber(piuTypeProductNumber);
            ruDataFromPiuType.setProductRevision(piuTypeProductRevision);
            ruDataFromPiuType.setSerialNumber(PIU_TYPE_SERIAL_NUMBER);
        }
        catch (Exception e) {
            logger.traceError(THIS_CLASS, "Failed to retrieve RU data from current PiuType MO.", (Throwable)e);
            ruDataFromPiuType = new RuDataHolder();
        }
        logger.traceReturn(THIS_CLASS, "getRuDataFromPiuType()");
        return ruDataFromPiuType;
    }

    private boolean productNumbersMatch(String productNumberOne, String productNumberTwo) {
        String localProductNumberOne = ProductNumberHelper.convertProductNumber(productNumberOne);
        String localProductNumberTwo = ProductNumberHelper.convertProductNumber(productNumberTwo);
        boolean result = localProductNumberOne.equalsIgnoreCase(localProductNumberTwo);
        return result;
    }

    private boolean productRevisionsMatch(String productRevisionOne, String productRevisionTwo) {
        boolean match = false;
        if (productRevisionOne.equalsIgnoreCase(productRevisionTwo)) {
            match = true;
        } else {
            try {
                RevisionHolder revisionOne = new RevisionHolder(productRevisionOne);
                RevisionHolder revisionTwo = new RevisionHolder(productRevisionTwo);
                match = revisionOne.equals(revisionTwo);
            }
            catch (Exception rpe) {
                match = false;
            }
        }
        return match;
    }

    private boolean piuTypeMatchesHwPid(Struct piuTypeProductData) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "piuTypeMatchesHwPid()");
        String ruProductNumber = this.ruDataHolder.getProductNumber();
        String piuTypeProductNumber = (String)piuTypeProductData.getValue(PRODUCT_NUMBER);
        piuTypeProductNumber = ProductNumberHelper.convertProductNumber(piuTypeProductNumber);
        String ruProductRevision = this.ruDataHolder.getProductRevision();
        String piuTypeProductRevision = (String)piuTypeProductData.getValue(PRODUCT_REVISION);
        boolean result = this.productNumbersMatch(ruProductNumber, piuTypeProductNumber) && this.productRevisionsMatch(ruProductRevision, piuTypeProductRevision);
        logger.traceReturn(THIS_CLASS, "piuTypeMatchesHwPid(" + result + ")");
        return result;
    }

    public PiuTypeMoSU_Access getPiuTypeForHwPid() throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getPiuTypeForHwPid()");
        PiuTypeMoSU_Access result = null;
        MoIterator piuTypeIterator = this.collectorContext.getMoAccessor().lookupType(PIU_TYPE_TYPE);
        if (piuTypeIterator == null || piuTypeIterator.size() == 0) {
            logger.traceGeneral(THIS_CLASS, "No \"PiuType\" found.");
        } else {
            while (piuTypeIterator.hasMoreElements()) {
                PiuTypeMoSU_Access piuTypeMo = (PiuTypeMoSU_Access)piuTypeIterator.nextMo();
                Struct piuTypeProductData = piuTypeMo.getProductData(null);
                if (!this.piuTypeMatchesHwPid(piuTypeProductData)) continue;
                result = piuTypeMo;
                break;
            }
        }
        if (result == null) {
            logger.traceGeneral(THIS_CLASS, "Found no match for HW PID: " + this.ruDataHolder.getHwPidString());
        } else {
            logger.traceGeneral(THIS_CLASS, "Found PiuType, \"" + result.getLocalDistinguishedName() + "\" that matches the HW PID: " + this.ruDataHolder.getHwPidString());
        }
        logger.traceReturn(THIS_CLASS, "getPiuTypeForHwPid()");
        return result;
    }

    private void downloadAndInstallMissingSW(ManagedObject mo, PiuTypeMoSU_Access piuTypeMo) throws Exception {
        logger.traceEnter(THIS_CLASS, "downloadAndInstallMissingSW(), mo: " + mo + " , PiuType: " + piuTypeMo);
        if (!this.isLmInInstalledState(mo, piuTypeMo)) {
            this.fixMissingSwAllocationConnection(mo);
            this.installPiuType(mo, (PiuTypeMo)piuTypeMo);
        } else {
            logger.traceDebug(THIS_CLASS, "PiuType is already installed, skip and return. mo: " + mo + " , PiuType: " + piuTypeMo);
        }
        logger.traceReturn(THIS_CLASS, "downloadAndInstallMissingSW(), mo: " + mo + " , PiuType: " + piuTypeMo);
    }

    private boolean isLmInInstalledState(ManagedObject mo, PiuTypeMoSU_Access piuTypeMo) throws Exception {
        logger.traceEnter(THIS_CLASS, "isLmInInstalledState(), mo: " + mo + " , PiuType: " + piuTypeMo);
        LoadModuleMoSU_Access lm = this.getInstalledLoadModuleMo(mo, piuTypeMo);
        boolean result = false;
        if (lm != null) {
            int lmFilesInstalledState = piuTypeMo.getLmFilesInstallState(null);
            logger.traceDebug(THIS_CLASS, "lmFilesInstalledState: " + lmFilesInstalledState);
            result = lmFilesInstalledState == 2;
        } else {
            logger.traceDebug(THIS_CLASS, "LM is null");
            result = true;
        }
        logger.traceReturn(THIS_CLASS, "isLmInInstalledState(), mo: " + mo + " , PiuType: " + piuTypeMo + " , Return value: " + result);
        return result;
    }

    public LoadModuleMoSU_Access getInstalledLoadModuleMo(ManagedObject mo, PiuTypeMoSU_Access piuTypeMo) throws Exception {
        logger.traceEnter(THIS_CLASS, "getInstalledLoadModuleMo(), mo: " + mo + " , PiuType: " + piuTypeMo);
        HashSet loadModuleLdnSet = new HashSet();
        ManagedObject[] repertoires = null;
        SwAllocationMoSU_Access swAllocation = (SwAllocationMoSU_Access)this.getSwAllocation(mo);
        if (swAllocation == null) {
            String errorMsg = "No SwAllocation found for the AuxPlugInUnit MO: \"" + mo.getLocalDistinguishedName() + "\"";
            logger.traceError(THIS_CLASS, errorMsg);
            throw new Exception(errorMsg);
        }
        logger.traceDebug(THIS_CLASS, "This plug in unit is connected to SwAllocation MO: " + swAllocation.getRole(null));
        repertoires = swAllocation.getRepertoireList(null);
        if (repertoires == null || repertoires.length == 0) {
            String errorMsg = "No Repertoires for the SwAllocation MO: \"" + swAllocation + "\"";
            logger.traceError(THIS_CLASS, errorMsg);
            throw new Exception(errorMsg);
        }
        for (int i = 0; i < repertoires.length; ++i) {
            logger.traceDebug(THIS_CLASS, "Repertoire: " + repertoires[i]);
            RepertoireMoSU_Access repertoireMo = (RepertoireMoSU_Access)repertoires[i];
            Set ldnSet = this.collectLoadModuleLdns(mo, repertoireMo, piuTypeMo);
            loadModuleLdnSet.addAll(ldnSet);
        }
        LoadModuleMoSU_Access localLoadModuleMo = null;
        if (loadModuleLdnSet.isEmpty()) {
            logger.traceGeneral(THIS_CLASS, "No load module was found for the PiuType: \"" + piuTypeMo + "\"");
        } else {
            Iterator ldnIterator = loadModuleLdnSet.iterator();
            String loadModuleLdn = (String)ldnIterator.next();
            localLoadModuleMo = (LoadModuleMoSU_Access)this.collectorContext.getMoAccessor().lookup(loadModuleLdn);
            logger.traceGeneral(THIS_CLASS, "Load module found: " + loadModuleLdn);
        }
        logger.traceReturn(THIS_CLASS, "getInstalledLoadModuleMo(), mo: " + mo + " , PiuType: " + piuTypeMo + " , LM: " + localLoadModuleMo);
        return localLoadModuleMo;
    }

    private ManagedObject getSwAllocation(ManagedObject mo) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getSwAllocation()");
        ManagedObject swa = null;
        ManagedObject[] mos = (ManagedObject[])this.getAttribute(mo, RESERVED_BY_ATTR);
        if (mos != null) {
            for (int i = 0; i < mos.length; ++i) {
                if (!(mos[i] instanceof SwAllocationMo)) continue;
                swa = mos[i];
                logger.traceGeneral(THIS_CLASS, "Yes mo[" + i + "]  " + mos[i].getFullDistinguishedName());
                break;
            }
        }
        if (swa == null) {
            swa = this.findSwAllocationThroughPiuType(mo);
        }
        logger.traceReturn(THIS_CLASS, "getSwAllocation(): " + swa);
        return swa;
    }

    private ManagedObject findSwAllocationThroughPiuType(ManagedObject mo) throws MoAccessException {
        ManagedObject swa = null;
        ManagedObject piuType = this.getPiuType(mo);
        ManagedObject[] piuTypeReserved = (ManagedObject[])piuType.getAttribute(RESERVED_BY_ATTR, null);
        ManagedObject[] repertoireReservedBy = null;
        if (piuTypeReserved != null) {
            block0: for (int i = 0; i < piuTypeReserved.length && swa == null; ++i) {
                if (!(piuTypeReserved[i] instanceof RepertoireMo) || (repertoireReservedBy = (ManagedObject[])piuTypeReserved[i].getAttribute(RESERVED_BY_ATTR, null)) == null) continue;
                for (int j = 0; j < repertoireReservedBy.length; ++j) {
                    if (!(repertoireReservedBy[j] instanceof SwAllocationMo)) continue;
                    swa = repertoireReservedBy[j];
                    continue block0;
                }
            }
        }
        return swa;
    }

    private Set collectLoadModuleLdns(ManagedObject mo, RepertoireMoSU_Access repertoireMo, PiuTypeMoSU_Access piuTypeMo) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "collectLoadModuleLdns()");
        Struct[] programConfigurationsInPiuType = piuTypeMo.getProgramConfiguration(null);
        logger.traceDebug(THIS_CLASS, "programConfigurationsInPiuType: " + Lib.toString((Struct[])programConfigurationsInPiuType) + "\n\trepertoireMo: " + repertoireMo.getName(null) + "\n\tpiuTypeMo: " + piuTypeMo + "\n\tcoordinator: null");
        HashSet<String> loadModuleLdns = new HashSet<String>();
        RepertoireMo tmpRepertoireMo = (RepertoireMo)repertoireMo;
        Struct[] loadModulesDataInRepertoire = tmpRepertoireMo.getLMData((PiuTypeMo)piuTypeMo, null);
        if (loadModulesDataInRepertoire == null || loadModulesDataInRepertoire.length == 0) {
            logger.traceGeneral(THIS_CLASS, "No Load Module Data in Repertoire: " + repertoireMo.getName(null) + "\n\tupgradeablePlugInUnit: " + mo.getLocalDistinguishedName() + "\n\tprogramConfigurationsInPiuType: " + Lib.toString((Struct[])programConfigurationsInPiuType) + "\n\trepertoireMo: " + repertoireMo.getName(null) + "\n\tcoordinator: null");
        } else {
            logger.traceDebug(THIS_CLASS, "The load module information held by the Repertoire are: " + repertoireMo.getName(null) + "\n\trepertoireMo: " + repertoireMo.getName(null) + "\n\tLoad Module Information: " + Lib.toString((Struct[])loadModulesDataInRepertoire));
            for (int i = 0; i < loadModulesDataInRepertoire.length; ++i) {
                String tag = (String)loadModulesDataInRepertoire[i].getValue(TAG);
                String loadModuleLdn = (String)loadModulesDataInRepertoire[i].getValue(LOAD_MODULE_DN);
                if (!this.loadModuleExistsInUp(loadModuleLdn, null) || !this.isTagInProgramConfigurationInPiuType(tag, programConfigurationsInPiuType)) continue;
                loadModuleLdns.add(loadModuleLdn);
                logger.traceDebug(THIS_CLASS, "Added LoadModule MO: \"" + loadModuleLdn + "\"");
            }
        }
        logger.traceReturn(THIS_CLASS, "collectLoadModuleLdns()");
        return loadModuleLdns;
    }

    private boolean loadModuleExistsInUp(String loadModuleLdn, Coordinator localCoordinator) throws MoAccessException {
        String lmFilePath = EMPTY_STRING;
        try {
            if (loadModuleLdn != null) {
                ManagedObject managedObject = this.collectorContext.getMoAccessor().lookup(loadModuleLdn);
                if (managedObject == null) {
                    managedObject = LoadModuleRecoverer.getInstance().restoreLoadModuleFromLdn(loadModuleLdn, this.collectorContext, localCoordinator);
                }
                if (managedObject != null) {
                    LoadModuleMoSU_Access loadModule = (LoadModuleMoSU_Access)managedObject;
                    lmFilePath = loadModule.getRealLoadModuleFilePath(localCoordinator);
                }
            }
        }
        catch (Exception e) {
            lmFilePath = EMPTY_STRING;
        }
        boolean loadModuleMoInUcf = this.lmFilePathPointsOutLoadModuleOnDu(loadModuleLdn, lmFilePath, localCoordinator);
        logger.traceGeneral(THIS_CLASS, loadModuleLdn + " exists in UCF: " + loadModuleMoInUcf);
        return loadModuleMoInUcf;
    }

    private boolean lmFilePathPointsOutLoadModuleOnDu(String loadModuleLdn, String lmFilePath, Coordinator localCoordinator) throws MoAccessException {
        boolean pointsOutLm;
        logger.traceEnter(THIS_CLASS, "lmFilePathPointsOutLoadModuleOnDu() loadModuleLdn: " + loadModuleLdn + " lmFilePath: " + lmFilePath);
        boolean incompatibleSw = lmFilePath.startsWith(MAO_FRO_PIC_INCOMPATIBLE_SW);
        boolean faultyCompatibilityList = lmFilePath.startsWith(MAO_FRO_PIC_COMPATIBILITY_LIST_FAULTY);
        boolean incompatibleHw = lmFilePath.startsWith(MAO_FRO_PIC_INCOMPATIBLE_HW);
        boolean empty = EMPTY_STRING.equalsIgnoreCase(lmFilePath);
        boolean preInstalledSw = lmFilePath.startsWith(MAO_FRO_PIC_PREINSTALLED_SW);
        boolean runningSw = lmFilePath.startsWith(MAO_FRO_PIC_RUNNING_SW);
        boolean bl = pointsOutLm = !incompatibleSw && !faultyCompatibilityList && !incompatibleHw;
        if (empty || preInstalledSw || runningSw) {
            LoadModuleMoSU_Access localLoadModuleMo = (LoadModuleMoSU_Access)this.collectorContext.getMoAccessor().lookup(loadModuleLdn);
            String theLmFilePath = AuxPluginUnitInstaller.getLoadModuleFilePath(localLoadModuleMo, localCoordinator);
            pointsOutLm = theLmFilePath.startsWith(LOADMODULE_INSTALLATION_PATH);
        }
        logger.traceReturn(THIS_CLASS, "lmFilePathPointsOutLoadModuleOnDu() return: " + pointsOutLm);
        return pointsOutLm;
    }

    private static String getLoadModuleFilePath(LoadModuleMoSU_Access localLoadModuleMo, Coordinator localCoordinator) throws MoAccessException {
        String lmFilePath = localLoadModuleMo.getRealLoadModuleFilePath(localCoordinator);
        String productNumber = localLoadModuleMo.getProductNumber(localCoordinator).toUpperCase(Locale.getDefault());
        productNumber = ProductNumberHelper.convertSlashToPercent(productNumber);
        String productRevision = localLoadModuleMo.getProductRevision(localCoordinator).toUpperCase(Locale.getDefault());
        productRevision = ProductNumberHelper.convertSlashToPercent(productRevision);
        String filePath = LOADMODULE_INSTALLATION_PATH + productNumber + "_" + productRevision;
        FileHelper fileHelper = FileHelperFactory.getInstance().getFileHelper();
        boolean pointsOutLm = fileHelper.filePathExists(filePath);
        if (pointsOutLm && !lmFilePath.equalsIgnoreCase(filePath)) {
            lmFilePath = filePath;
            logger.traceDebug(THIS_CLASS, "The LoadModule MO file path updated as the file exisits: \"" + lmFilePath + "\"");
        }
        return lmFilePath;
    }

    private boolean isTagInProgramConfigurationInPiuType(String tag, Struct[] programConfigurationsInPiuType) throws MoAccessException {
        logger.traceGeneral(THIS_CLASS, "tag: " + tag + "\n\tprogramConfigurationsInPiuType: " + Lib.toString((Struct[])programConfigurationsInPiuType));
        return this.getProgramConfigurationIndex(tag, programConfigurationsInPiuType) != -1;
    }

    private int getProgramConfigurationIndex(String tag, Struct[] programConfigurationsInPiuType) throws MoAccessException {
        int result = -1;
        logger.traceEnter(THIS_CLASS, "getProgramConfigurationIndex()");
        logger.traceGeneral(THIS_CLASS, "tag: " + tag + "\n\tprogramConfigurationsInPiuType: " + Lib.toString((Struct[])programConfigurationsInPiuType));
        for (int i = 0; i < programConfigurationsInPiuType.length; ++i) {
            if (!tag.equals(programConfigurationsInPiuType[i].getValue(TAG))) continue;
            result = i;
            break;
        }
        if (result == -1) {
            logger.traceGeneral(THIS_CLASS, "The tag '" + tag + "' was NOT found.");
        } else {
            logger.traceGeneral(THIS_CLASS, "The tag '" + tag + "' was found at index '" + result + "'.");
        }
        logger.traceReturn(THIS_CLASS, "getProgramConfigurationIndex()");
        return result;
    }

    private void fixMissingSwAllocationConnection(ManagedObject mo) throws NoSuchAttributeException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "fixMissingSwAllocationConnection()");
        String AuxPiuLDN = mo.getLocalDistinguishedName();
        SwAllocationMo moSwARu = this.getSwAllocationForRU();
        logger.traceDebug(THIS_CLASS, "AuxPiuLdn: " + AuxPiuLDN);
        logger.traceDebug(THIS_CLASS, "moSwARu " + moSwARu);
        boolean auxPiuLdnFoundInSlotList = false;
        if (moSwARu != null) {
            logger.traceDebug(THIS_CLASS, "moSwARU exists");
            ManagedObject[] slotList = moSwARu.getSlotList(null);
            for (int i = 0; i < slotList.length; ++i) {
                logger.traceDebug(THIS_CLASS, "looping : " + slotList[i]);
                String slot = slotList[i].getLocalDistinguishedName();
                logger.traceDebug(THIS_CLASS, "slot : " + slot);
                if (!slot.equals(AuxPiuLDN)) continue;
                logger.traceDebug(THIS_CLASS, "AuxPiu Already configured in SwAllocation");
                auxPiuLdnFoundInSlotList = true;
                return;
            }
            if (!auxPiuLdnFoundInSlotList) {
                logger.traceDebug(THIS_CLASS, "AddSlot : " + mo.getLocalDistinguishedName());
                TransactionWrapperFactory transactionWrapperFactory = this.collectorContext.getTransactionWrapperFactory();
                try {
                    TransactionWrapper transactionWrapper = transactionWrapperFactory.create();
                    Coordinator coordinator = transactionWrapper.getCoordinator();
                    moSwARu.actionAddSlot(mo, coordinator);
                    transactionWrapper.commit();
                }
                catch (AueException e) {
                    logger.traceError(THIS_CLASS, "Cannot get coordinator to add slot." + e.toString());
                }
                logger.traceReturn(THIS_CLASS, "fixMissingSwAllocationConnection addSlot: " + mo.getLocalDistinguishedName());
                return;
            }
        }
        logger.traceError(THIS_CLASS, "SwAllocation MO not found for auxpluginunit " + mo.getLocalDistinguishedName());
    }

    private SwAllocationMo getSwAllocationForRU() throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getSwAllocationForRU()");
        MoIterator moiterator = this.collectorContext.getMoAccessor().lookupType("SwAllocation");
        while (moiterator != null && moiterator.hasMoreElements()) {
            logger.traceDebug(THIS_CLASS, "getSwAllocationForRU() moIterator not null");
            ManagedObject mo = moiterator.nextMo();
            if (!(mo instanceof SwAllocationMo)) continue;
            logger.traceDebug(THIS_CLASS, "getSwAllocationForRU() moSwA is of type SwAllocation : " + mo.getLocalDistinguishedName());
            SwAllocationMo moSwA = (SwAllocationMo)mo;
            ManagedObject[] list = moSwA.getRepertoireList(null);
            for (int i = 0; i < list.length; ++i) {
                String ldn = list[i].getLocalDistinguishedName();
                logger.traceDebug(THIS_CLASS, "ldn of Repertoire : " + ldn);
                if (!ldn.equals("ManagedElement=1,SwManagement=1,Repertoire=LTE_RBS_RU")) continue;
                logger.traceReturn(THIS_CLASS, "getSwAllocationForRU() found : " + ldn);
                return moSwA;
            }
        }
        logger.traceReturn(THIS_CLASS, "getSwAllocationForRU() not found");
        return null;
    }

    private void installPiuType(ManagedObject mo, PiuTypeMo piuTypeMo) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "installPiuType()");
        if (piuTypeMo == null) {
            logger.traceDebug(THIS_CLASS, "piuTypeMo is null -> installPiuType() return");
            return;
        }
        try {
            PiuTypeInstallSupportAdaptor.class.getDeclaredMethod("installPiuTypeAtUpgrade", PiuTypeMo.class, PiuTypeInstallListener.class);
        }
        catch (SecurityException e1) {
            logger.traceDebug(THIS_CLASS, "Cannot check if the method installPiuTypeAtUpgrade(PiuTypeMo, PiuTypeInstallListener) is available or not." + e1.toString());
        }
        catch (NoSuchMethodException e1) {
            logger.traceError(THIS_CLASS, "The method installPiuTypeAtUpgrade(PiuTypeMo, PiuTypeInstallListener) is not available." + e1.toString());
            return;
        }
        int lmFilesInstalledState = piuTypeMo.getLmFilesInstallState(null);
        logger.traceDebug(THIS_CLASS, "SW download (lmFilesInstalledState=" + lmFilesInstalledState + ")");
        PiuTypeInstallSupportAdaptor installAdaptor = PiuTypeInstallSupportAdaptor.instance();
        if (installAdaptor != null) {
            logger.traceDebug(THIS_CLASS, "Found PiuTypeMo instance: " + piuTypeMo.getLocalDistinguishedName());
            this.installPiuTypeIsDone = false;
            int id1 = installAdaptor.installPiuTypeAtUpgrade(piuTypeMo, (PiuTypeInstallListener)this);
            logger.traceDebug(THIS_CLASS, "installPiuTypeAtUpgrade triggered. actionId=" + id1);
            int installedState = piuTypeMo.getLmFilesInstallState(null);
            logger.traceDebug(THIS_CLASS, "piuType installedState=" + installedState + ". ldn=" + mo.getFullDistinguishedName());
            try {
                int i = 0;
                while (!this.installPiuTypeIsDone) {
                    logger.traceDebug(THIS_CLASS, i + ". installPiuTypeConfirmed=" + this.installPiuTypeIsDone);
                    Thread.sleep(10000L);
                    ++i;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            logger.traceDebug(THIS_CLASS, "actionReconfigureProgramPrepare(): *** installPiuTypeConfirmed=" + this.installPiuTypeIsDone);
        }
        logger.traceReturn(THIS_CLASS, "installPiuType()");
    }

    public void installPiuTypeConfirmed(int arg0) {
        logger.traceEnter(THIS_CLASS, "installPiuTypeConfirmed(): id=" + arg0);
        this.installPiuTypeIsDone = true;
        logger.traceReturn(THIS_CLASS, "installPiuTypeConfirmed(): id=" + arg0);
    }

    public void installPiuTypeRejected(int arg0, InstallRejectReason arg1) {
        logger.traceError(THIS_CLASS, "installPiuTypeRejected(): " + arg0 + ". " + arg1);
        this.installPiuTypeIsDone = true;
    }

    public void installPiuTypeRejected(int arg0, InstallRejectReason arg1, String arg2) {
        logger.traceError(THIS_CLASS, "installPiuTypeRejected(): " + arg0 + ". " + arg1 + ". " + arg2);
        this.installPiuTypeIsDone = true;
    }
}

