/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.omf.aue.step1.actions;

import com.polyhedra.sql.ResultSet;
import com.polyhedra.sql.SQLException;
import java.util.Iterator;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.cat.omf.aue.step1.util.MoRef;
import se.ericsson.crbs.cat.omf.aue.step1.util.MoRefArray;
import se.ericsson.crbs.cat.omf.aue.step1.util.MoRefArrayParser;
import se.ericsson.crbs.cat.omf.aue.step1.util.MoRefParser;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.actions.NoSuchTableException;
import se.ericsson.crbs.omf.aue.common.db.DbWrapperFactory;
import se.ericsson.crbs.omf.aue.common.db.sql.Sql;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.FroAttributesData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;

public class ConvertFroTypeIdInReferences
extends AbstractConversionAction {
    private static final Class THIS_CLASS = ConvertFroTypeIdInReferences.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String NOAM_FRO_VERSIONS = "fro_versions";

    public void convert(AueContext context) throws CrbsAueException, NoSuchTableException {
        logger.traceEnter(THIS_CLASS, "convert()");
        try {
            TableHandler tableHandler = (TableHandler)context.getAttribute("CURRENT_TABLE_HANDLER");
            TableData[] tableDatas = tableHandler.getAllTableDatas();
            for (int t = 0; t < tableDatas.length; ++t) {
                logger.traceDebug(THIS_CLASS, "convert() " + tableDatas[t].getFroTypeName());
                FroAttributesData[] froAttrDatas = tableDatas[t].getFroAttributesTable().getDatas();
                for (int a = 0; a < froAttrDatas.length; ++a) {
                    if (tableDatas[t].getFroTypeId() != froAttrDatas[a].froType || !"moref".equalsIgnoreCase(froAttrDatas[a].attrType) && !"ARRAY".equalsIgnoreCase(froAttrDatas[a].attrType) || "parentRef".equalsIgnoreCase(froAttrDatas[a].attrName)) continue;
                    logger.traceDebug(THIS_CLASS, "convert() " + froAttrDatas[a].attrName);
                    Object[] values = tableDatas[t].getAttributeValues(froAttrDatas[a].attrName);
                    for (int v = 0; v < values.length; ++v) {
                        if ("moref".equalsIgnoreCase(froAttrDatas[a].attrType)) {
                            MoRef moRef = MoRefParser.parseMoRef(values[v].toString());
                            if (!this.convertMoRef(moRef, tableHandler)) continue;
                            tableDatas[t].setAttributeValue(v, froAttrDatas[a].attrName, (Object)moRef.toString());
                            continue;
                        }
                        MoRefArray moRefArray = MoRefArrayParser.parseMoRefArray(values[v].toString());
                        if (!this.convertMoRefArray(moRefArray, tableHandler)) continue;
                        tableDatas[t].setAttributeValue(v, froAttrDatas[a].attrName, (Object)moRefArray.toString());
                    }
                }
            }
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Failed to read cached table data", (Throwable)tableDataException);
        }
        catch (SQLException sqlException) {
            throw new CrbsAueException("Failed to read NOAM fro tables", (Throwable)sqlException);
        }
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    private boolean convertMoRef(MoRef moRef, TableHandler tableHandler) throws CrbsAueException, SQLException, TableDataException {
        logger.traceEnter(THIS_CLASS, "convertMoRef()");
        boolean converted = false;
        if (moRef.froTypeId != -1) {
            String noamFroTypeName = this.noamFroTypeIdToFroTypeName(moRef.froTypeId);
            logger.traceDebug(THIS_CLASS, "convert() " + moRef.froTypeId + " == " + noamFroTypeName);
            TableData tableDataForRef = tableHandler.getTableData(noamFroTypeName);
            moRef.froTypeId = tableDataForRef.getFroTypeId();
            converted = true;
        }
        logger.traceReturn(THIS_CLASS, "convertMoRef() " + converted);
        return converted;
    }

    private boolean convertMoRefArray(MoRefArray moRefArray, TableHandler tableHandler) throws CrbsAueException, SQLException, TableDataException {
        logger.traceEnter(THIS_CLASS, "convertMoRef()");
        boolean converted = false;
        Iterator itMoRef = moRefArray.getMoRefList().iterator();
        while (itMoRef.hasNext()) {
            MoRef moRef = (MoRef)itMoRef.next();
            converted = this.convertMoRef(moRef, tableHandler) || converted;
        }
        logger.traceReturn(THIS_CLASS, "convertMoRef() " + converted);
        return converted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String noamFroTypeIdToFroTypeName(int froTypeId) throws SQLException, CrbsAueException {
        String result = null;
        Sql.Select selectFroVersions = new Sql.Select(NOAM_FRO_VERSIONS, new Sql.Select.ColumnValue("frotype", froTypeId));
        ResultSet resultSet = DbWrapperFactory.getInstance().getDbWrapper().executeQuery(selectFroVersions);
        try {
            if (resultSet.next()) {
                result = resultSet.getString(2);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        return result;
    }
}

