/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.omf.aue.step1.actions;

import com.polyhedra.sql.ResultSet;
import com.polyhedra.sql.ResultSetMetaData;
import com.polyhedra.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.actions.NoSuchTableException;
import se.ericsson.crbs.omf.aue.common.db.DbWrapper;
import se.ericsson.crbs.omf.aue.common.db.DbWrapperFactory;
import se.ericsson.crbs.omf.aue.common.db.sql.Sql;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.AddAttributeAction;
import se.ericsson.crbs.omf.aue.step1.actions.CreateOneInstanceAction;

public class CopyLicenseTableAction
extends AbstractConversionAction {
    private static final Class THIS_CLASS = CopyLicenseTableAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String UL_ATTR_NAME = "userLabel";
    private static final String KID_ATTR_NAME = "keyId";
    private static final String FS_ATTR_NAME = "featureState";
    private static final String MFD_ATTR_NAME = "markedForDeletion";
    private static final String GPRT_ATTR_NAME = "gracePeriodResetThreshold";
    private static final String GPAT_ATTR_NAME = "gracePeriodActivationThreshold";
    private static final String GPL_ATTR_NAME = "gracePeriodLength";
    private static final String CU_ATTR_NAME = "capacityUnit";
    private static final String CT_ATTR_NAME = "capacityType";
    private static final String GP_ATTR_NAME = "gracePeriod";
    private static final String FRO_VERSIONS = "licensing_fro_versions";
    private static final String FRO_VERSIONS_UPGR = "licensing_fro_versions_new";

    public void convert(AueContext context) throws CrbsAueException {
        DbWrapper dbWrapper = DbWrapperFactory.getInstance().getDbWrapper();
        try {
            this.convertLicense(context, true);
        }
        catch (SQLException e) {
            logger.traceGeneral(THIS_CLASS, "OptionalFeatureLicense " + e.toString());
        }
        catch (NoSuchTableException e) {
            logger.traceGeneral(THIS_CLASS, "OptionalFeatureLicense " + e.toString());
        }
        try {
            this.convertLicense(context, false);
        }
        catch (SQLException e) {
            logger.traceGeneral(THIS_CLASS, "CapacityFeatureLicense " + e.toString());
        }
        catch (NoSuchTableException e) {
            logger.traceGeneral(THIS_CLASS, "CapacityFeatureLicense " + e.toString());
        }
        try {
            dbWrapper.executeUpdate((Sql.Modification)new Sql.DropTable("licensing_fro_attributes"));
        }
        catch (SQLException e) {
            logger.traceGeneral(THIS_CLASS, "Failed to drop table  licensing_fro_attributes ");
        }
        try {
            dbWrapper.executeUpdate((Sql.Modification)new Sql.DropTable(FRO_VERSIONS));
        }
        catch (SQLException e) {
            logger.traceGeneral(THIS_CLASS, "Failed to drop table  licensing_fro_versions ");
        }
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertLicense(AueContext context, boolean OptionalFeatureLicense) throws CrbsAueException, NoSuchTableException, SQLException {
        logger.traceEnter(THIS_CLASS, "convertLicense()");
        String FRO_TYPE_NAME = null;
        String FRO_DATA_TABLE_NAME = null;
        DbWrapper dbWrapper = DbWrapperFactory.getInstance().getDbWrapper();
        FRO_TYPE_NAME = OptionalFeatureLicense ? "OptionalFeatureLicense" : "CapacityFeatureLicense";
        FRO_DATA_TABLE_NAME = this.getLegacyFroDataTableName(FRO_TYPE_NAME);
        if (FRO_DATA_TABLE_NAME == null) {
            logger.traceGeneral(THIS_CLASS, "No table found for " + FRO_TYPE_NAME);
            return;
        }
        try {
            Sql.Select selectFroData = new Sql.Select(FRO_DATA_TABLE_NAME);
            ResultSet featLicFroDataRs = dbWrapper.executeQuery(selectFroData);
            try {
                dbWrapper.executeUpdate((Sql.Modification)new Sql.DropTable(FRO_DATA_TABLE_NAME));
            }
            catch (SQLException e) {
                logger.traceGeneral(THIS_CLASS, "Failed to drop table " + FRO_DATA_TABLE_NAME);
            }
            try {
                boolean firstInstance = true;
                while (featLicFroDataRs.next()) {
                    this.createOneInstance(firstInstance, featLicFroDataRs, context, FRO_TYPE_NAME, OptionalFeatureLicense);
                    firstInstance = false;
                }
            }
            finally {
                if (featLicFroDataRs != null) {
                    featLicFroDataRs.close();
                }
            }
        }
        catch (SQLException sqlException) {
            logger.info(THIS_CLASS, "Failed to copy FRO data for (SQL) " + FRO_TYPE_NAME);
        }
        logger.traceReturn(THIS_CLASS, "convertLicense()");
    }

    private void createOneInstance(boolean firstInstance, ResultSet froDataRs, AueContext context, String froTypeName, boolean OptionalFeatureLicense) throws CrbsAueException, SQLException {
        logger.traceEnter(THIS_CLASS, "createOneInstance()");
        int FRO_TYPE_ID = 0;
        FRO_TYPE_ID = OptionalFeatureLicense ? 0x1020000 : 0x1020001;
        HashMap<String, String> paramMap = new HashMap<String, String>();
        int column = 0;
        String attrValue = "";
        paramMap.put("name", froTypeName);
        paramMap.put("frotype", Integer.toString(FRO_TYPE_ID));
        this.addFroId(paramMap, froDataRs);
        this.addIdentity(paramMap, froDataRs);
        paramMap.put("parentldn", "ManagedElement=1,SystemFunctions=1,Licensing=1");
        if (OptionalFeatureLicense) {
            column = froDataRs.findColumn(UL_ATTR_NAME);
            attrValue = froDataRs.getObject(column).toString();
            paramMap.put(UL_ATTR_NAME, attrValue);
            column = froDataRs.findColumn(KID_ATTR_NAME);
            attrValue = froDataRs.getObject(column).toString();
            paramMap.put(KID_ATTR_NAME, attrValue);
            column = froDataRs.findColumn(FS_ATTR_NAME);
            attrValue = froDataRs.getObject(column).toString();
            paramMap.put(FS_ATTR_NAME, attrValue);
            column = froDataRs.findColumn(MFD_ATTR_NAME);
            attrValue = froDataRs.getObject(column).toString();
            paramMap.put(MFD_ATTR_NAME, attrValue);
        } else {
            column = froDataRs.findColumn(UL_ATTR_NAME);
            attrValue = froDataRs.getObject(column).toString();
            paramMap.put(UL_ATTR_NAME, attrValue);
            column = froDataRs.findColumn(KID_ATTR_NAME);
            attrValue = froDataRs.getObject(column).toString();
            paramMap.put(KID_ATTR_NAME, attrValue);
            column = froDataRs.findColumn(GPRT_ATTR_NAME);
            attrValue = froDataRs.getObject(column).toString();
            paramMap.put(GPRT_ATTR_NAME, attrValue);
            column = froDataRs.findColumn(GPAT_ATTR_NAME);
            attrValue = froDataRs.getObject(column).toString();
            paramMap.put(GPAT_ATTR_NAME, attrValue);
            column = froDataRs.findColumn(GPL_ATTR_NAME);
            attrValue = froDataRs.getObject(column).toString();
            paramMap.put(GPL_ATTR_NAME, attrValue);
            column = froDataRs.findColumn(CU_ATTR_NAME);
            attrValue = froDataRs.getObject(column).toString();
            paramMap.put(CU_ATTR_NAME, attrValue);
            column = froDataRs.findColumn(CT_ATTR_NAME);
            attrValue = froDataRs.getObject(column).toString();
            paramMap.put(CT_ATTR_NAME, attrValue);
            column = froDataRs.findColumn(GP_ATTR_NAME);
            attrValue = froDataRs.getObject(column).toString();
            paramMap.put(GP_ATTR_NAME, attrValue);
            column = froDataRs.findColumn(MFD_ATTR_NAME);
            attrValue = froDataRs.getObject(column).toString();
            paramMap.put(MFD_ATTR_NAME, attrValue);
        }
        if (!firstInstance) {
            logger.traceDebug(THIS_CLASS, "createOneInstance() addMoTypeSpecificAttributesAsChildAttributes");
            this.addMoTypeSpecificAttributesAsChildAttributes(paramMap, froDataRs, OptionalFeatureLicense);
        }
        CreateOneInstanceAction createOneInstanceAction = new CreateOneInstanceAction();
        createOneInstanceAction.setMoActionArgs(paramMap);
        createOneInstanceAction.convert(context);
        if (firstInstance) {
            logger.traceDebug(THIS_CLASS, "createOneInstance() addMoTypeSpecificAttributes");
            this.addMoTypeSpecificAttributes(froDataRs, context, froTypeName, OptionalFeatureLicense);
        }
        logger.traceReturn(THIS_CLASS, "createOneInstance()");
    }

    protected void addFroId(Map paramMap, ResultSet froDataRs) throws SQLException, CrbsAueException {
        logger.traceEnter(THIS_CLASS, "addFroId()");
        ResultSetMetaData rsMetaData = froDataRs.getMetaData();
        int numColumns = froDataRs.getMetaData().getColumnCount();
        if (numColumns < 1 || !rsMetaData.getColumnName(1).equalsIgnoreCase("froid")) {
            throw new CrbsAueException("Failed to add froId");
        }
        paramMap.put("froid", new Integer(froDataRs.getInt(1)).toString());
        logger.traceReturn(THIS_CLASS, "addFroId()");
    }

    protected void addIdentity(Map paramMap, ResultSet froDataRs) throws SQLException, CrbsAueException {
        int pos;
        logger.traceEnter(THIS_CLASS, "addIdentity()");
        ResultSetMetaData rsMetaData = froDataRs.getMetaData();
        int numColumns = froDataRs.getMetaData().getColumnCount();
        String ldn = null;
        String identity = null;
        if (numColumns >= 2 && rsMetaData.getColumnName(2).equalsIgnoreCase("ldn") && (pos = (ldn = froDataRs.getString(2)).lastIndexOf("=")) != -1 && pos < ldn.length() - 1) {
            identity = ldn.substring(pos + 1);
        }
        if (identity == null) {
            throw new CrbsAueException("Failed to extract identity" + (ldn != null ? " from " + ldn : ""));
        }
        paramMap.put("rdnValue", identity);
        logger.traceReturn(THIS_CLASS, "addIdentity()");
    }

    protected void addMoTypeSpecificAttributesAsChildAttributes(Map paramMap, ResultSet froDataRs, boolean OptionalL) throws SQLException, CrbsAueException {
        logger.traceEnter(THIS_CLASS, "addMoTypeSpecificAttributesAsChildAttributes()");
        String[] specAttrs = null;
        String[] specAttrsType = null;
        boolean areSpecificAttributes = false;
        StringBuffer childAttributes = new StringBuffer("<attributes>");
        if (OptionalL) {
            specAttrs = new String[]{UL_ATTR_NAME, KID_ATTR_NAME, FS_ATTR_NAME, MFD_ATTR_NAME};
            specAttrsType = new String[]{"STRING", "STRING", "S32", "STRING"};
        } else {
            specAttrs = new String[]{UL_ATTR_NAME, KID_ATTR_NAME, GPRT_ATTR_NAME, GPAT_ATTR_NAME, GPL_ATTR_NAME, CU_ATTR_NAME, CT_ATTR_NAME, GP_ATTR_NAME, MFD_ATTR_NAME};
            specAttrsType = new String[]{"STRING", "STRING", "S32", "S32", "S32", "STRING", "S32", "struct", "STRING"};
        }
        for (int a = 0; a < specAttrs.length; ++a) {
            String attrName = specAttrs[a];
            if ("parentRef".equalsIgnoreCase(attrName)) continue;
            int column = froDataRs.findColumn(attrName);
            childAttributes.append("<attr name=\"" + attrName + "\" type=\"" + specAttrsType[a] + "\" value=\"" + froDataRs.getObject(column).toString() + "\" />");
            areSpecificAttributes = true;
        }
        childAttributes.append("</attributes>");
        if (areSpecificAttributes) {
            paramMap.put("childAttributes", childAttributes.toString());
        }
        logger.traceReturn(THIS_CLASS, "addMoTypeSpecificAttributesAsChildAttributes()");
    }

    protected void addMoTypeSpecificAttributes(ResultSet froDataRs, AueContext context, String froTypeName, boolean OptionalL) throws SQLException, CrbsAueException {
        logger.traceEnter(THIS_CLASS, "addMoTypeSpecificAttributes()");
        String[] specAttrs = null;
        String[] specAttrsType = null;
        HashMap<String, String> paramMap = new HashMap<String, String>();
        if (OptionalL) {
            specAttrs = new String[]{UL_ATTR_NAME, KID_ATTR_NAME, FS_ATTR_NAME, MFD_ATTR_NAME};
            specAttrsType = new String[]{"STRING", "STRING", "S32", "STRING"};
        } else {
            specAttrs = new String[]{UL_ATTR_NAME, KID_ATTR_NAME, GPRT_ATTR_NAME, GPAT_ATTR_NAME, GPL_ATTR_NAME, CU_ATTR_NAME, CT_ATTR_NAME, GP_ATTR_NAME, MFD_ATTR_NAME};
            specAttrsType = new String[]{"STRING", "STRING", "S32", "S32", "S32", "STRING", "S32", "struct", "STRING"};
        }
        for (int a = 0; a < specAttrs.length; ++a) {
            String attrName = specAttrs[a];
            if ("parentRef".equalsIgnoreCase(attrName)) continue;
            paramMap.put("Mo", froTypeName);
            paramMap.put("name", attrName);
            paramMap.put("type", specAttrsType[a]);
            int column = froDataRs.findColumn(attrName);
            Object defValue = froDataRs.getObject(column);
            paramMap.put("defaultValue", defValue != null ? defValue.toString() : "");
            AddAttributeAction addAttributeAction = new AddAttributeAction();
            addAttributeAction.setMoActionArgs(paramMap);
            addAttributeAction.convert(context);
            paramMap.clear();
        }
        logger.traceReturn(THIS_CLASS, "addMoTypeSpecificAttributes()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLegacyFroDataTableName(String froTypeName) throws SQLException, CrbsAueException {
        logger.traceEnter(THIS_CLASS, "getFroLicenseData()");
        String froDataTableName = null;
        DbWrapper dbWrapper = DbWrapperFactory.getInstance().getDbWrapper();
        String noamFroVersions = dbWrapper.doTableExist(FRO_VERSIONS_UPGR) ? FRO_VERSIONS_UPGR : FRO_VERSIONS;
        Sql.Select selectFroVersions = new Sql.Select(noamFroVersions, new Sql.Select.ColumnValue("frotypename", (Object)froTypeName));
        ResultSet resultSet = dbWrapper.executeQuery(selectFroVersions);
        try {
            if (resultSet.next()) {
                froDataTableName = resultSet.getString(3);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        logger.traceReturn(THIS_CLASS, "getFroLicenseData()");
        return froDataTableName;
    }
}

