/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.omf.aue.step1.actions;

import com.polyhedra.sql.ResultSet;
import com.polyhedra.sql.ResultSetMetaData;
import com.polyhedra.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.cat.omf.aue.step1.util.MoRefParser;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.db.DbWrapper;
import se.ericsson.crbs.omf.aue.common.db.DbWrapperFactory;
import se.ericsson.crbs.omf.aue.common.db.sql.Sql;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.AddAttributeAction;
import se.ericsson.crbs.omf.aue.step1.actions.CreateOneInstanceAction;

public class CopyLteFroTableAction
extends AbstractConversionAction {
    private static final Class THIS_CLASS = CopyLteFroTableAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String NOAM_FRO_VERSIONS = "fro_versions";
    private static final String NOAM_FRO_VERSIONS_UPGR = "fro_versions_new";
    private static final String NOAM_FRO_ATTR = "fro_attributes";
    private static final String NOAM_FRO_ATTR_UPGR = "fro_attributes_new";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convert(AueContext context) throws CrbsAueException {
        block7: {
            logger.traceEnter(THIS_CLASS, "convert()");
            String froTypeName = this.getAndCheckParamMapString("Mo", this.paramMap, "The FRO type name is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
            String froTypeIdStr = this.getAndCheckParamMapString("frotype", this.paramMap, "The FRO type is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
            int froTypeId = Integer.parseInt(froTypeIdStr, 16);
            try {
                NoamFroVersions noamFroVersions = this.getNoamFroVersions(froTypeName);
                if (noamFroVersions == null || !DbWrapperFactory.getInstance().getDbWrapper().doTableExist(noamFroVersions.froDataTableName)) break block7;
                NoamFroAttributes[] noamFroAttributes = this.getNoamFroAttributes(noamFroVersions.froTypeId);
                logger.traceDebug(THIS_CLASS, "convert() " + froTypeName);
                ResultSet froDataRs = this.getNoamFroData(noamFroVersions.froDataTableName);
                try {
                    boolean firstInstance = true;
                    while (froDataRs.next()) {
                        this.createOneInstance(froTypeName, noamFroVersions.froTypeId, froTypeId, firstInstance, froDataRs, noamFroAttributes, context);
                        firstInstance = false;
                    }
                }
                finally {
                    if (froDataRs != null) {
                        froDataRs.close();
                    }
                }
            }
            catch (SQLException sqlException) {
                throw new CrbsAueException("Failed to copy FRO data for (SQL) " + froTypeName, (Throwable)sqlException);
            }
        }
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    private void createOneInstance(String froTypeName, int noamFroTypeId, int froTypeId, boolean firstInstance, ResultSet froDataRs, NoamFroAttributes[] noamFroAttributes, AueContext context) throws CrbsAueException, SQLException {
        logger.traceEnter(THIS_CLASS, "createOneInstance() froTypeName:" + froTypeName);
        try {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("name", froTypeName);
            paramMap.put("frotype", Integer.toString(froTypeId));
            this.addFroId(paramMap, froDataRs);
            this.addIdentity(paramMap, froDataRs);
            this.addParentLdn(paramMap, froDataRs);
            if (!firstInstance) {
                logger.traceDebug(THIS_CLASS, "createOneInstance() addMoTypeSpecificAttributesAsChildAttributes");
                this.addMoTypeSpecificAttributesAsChildAttributes(noamFroTypeId, paramMap, froDataRs, noamFroAttributes);
            }
            CreateOneInstanceAction createOneInstanceAction = new CreateOneInstanceAction();
            createOneInstanceAction.setMoActionArgs(paramMap);
            createOneInstanceAction.convert(context);
            if (firstInstance) {
                logger.traceDebug(THIS_CLASS, "createOneInstance() addMoTypeSpecificAttributes");
                this.addMoTypeSpecificAttributes(froTypeName, noamFroTypeId, froDataRs, noamFroAttributes, context);
            }
        }
        catch (CrbsAueException cae) {
            throw new CrbsAueException(this.toString(noamFroAttributes) + this.toString(froDataRs), (Throwable)cae);
        }
        logger.traceReturn(THIS_CLASS, "createOneInstance()");
    }

    private String toString(NoamFroAttributes[] noamFroAttributes) {
        StringBuffer sb = new StringBuffer(" attr:");
        for (int a = 0; a < noamFroAttributes.length; ++a) {
            sb.append((a == 0 ? "" : ", ") + noamFroAttributes[a].attrName + "-" + noamFroAttributes[a].attrType);
        }
        return sb.toString();
    }

    private String toString(ResultSet froDataRs) throws SQLException {
        StringBuffer sb = new StringBuffer(" data:");
        int numColumns = froDataRs.getMetaData().getColumnCount();
        for (int c = 0; c < numColumns; ++c) {
            sb.append((c == 0 ? "" : ", ") + froDataRs.getObject(c + 1));
        }
        return sb.toString();
    }

    protected void addFroId(Map paramMap, ResultSet froDataRs) throws SQLException, CrbsAueException {
        logger.traceEnter(THIS_CLASS, "addFroId()");
        ResultSetMetaData rsMetaData = froDataRs.getMetaData();
        int numColumns = froDataRs.getMetaData().getColumnCount();
        if (numColumns < 1 || !rsMetaData.getColumnName(1).equalsIgnoreCase("froid")) {
            throw new CrbsAueException("Failed to add froId");
        }
        paramMap.put("froid", new Integer(froDataRs.getInt(1)).toString());
        logger.traceReturn(THIS_CLASS, "addFroId()");
    }

    protected void addIdentity(Map paramMap, ResultSet froDataRs) throws SQLException, CrbsAueException {
        int pos;
        logger.traceEnter(THIS_CLASS, "addIdentity()");
        ResultSetMetaData rsMetaData = froDataRs.getMetaData();
        int numColumns = froDataRs.getMetaData().getColumnCount();
        String ldn = null;
        String identity = null;
        if (numColumns >= 2 && rsMetaData.getColumnName(2).equalsIgnoreCase("ldn") && (pos = (ldn = froDataRs.getString(2)).lastIndexOf("=")) != -1 && pos < ldn.length() - 1) {
            identity = ldn.substring(pos + 1);
        }
        if (identity == null) {
            throw new CrbsAueException("Failed to extract identity" + (ldn != null ? " from " + ldn : ""));
        }
        paramMap.put("rdnValue", identity);
        logger.traceReturn(THIS_CLASS, "addIdentity()");
    }

    protected void addParentLdn(Map paramMap, ResultSet froDataRs) throws SQLException, CrbsAueException {
        logger.traceEnter(THIS_CLASS, "addParentLdn()");
        ResultSetMetaData rsMetaData = froDataRs.getMetaData();
        int numColumns = froDataRs.getMetaData().getColumnCount();
        if (numColumns >= 3 && rsMetaData.getColumnName(3).equalsIgnoreCase("parentRef")) {
            String parentMoRef = froDataRs.getString(3);
            String parentLdn = MoRefParser.parseMoRef((String)parentMoRef).ldn;
            if (parentLdn == null) {
                throw new CrbsAueException("Failed to extract parent LDN from " + parentMoRef);
            }
            paramMap.put("parentldn", parentLdn);
        } else {
            paramMap.put("parentldn", "");
            paramMap.put("parentRefExists", "FALSE");
        }
        logger.traceReturn(THIS_CLASS, "addParentLdn()");
    }

    protected void addMoTypeSpecificAttributesAsChildAttributes(int noamFroTypeId, Map paramMap, ResultSet froDataRs, NoamFroAttributes[] noamFroAttributes) throws SQLException, CrbsAueException {
        logger.traceEnter(THIS_CLASS, "addMoTypeSpecificAttributesAsChildAttributes()");
        boolean areSpecificAttributes = false;
        StringBuffer childAttributes = new StringBuffer("<attributes>");
        for (int a = 0; a < noamFroAttributes.length; ++a) {
            String attrName = noamFroAttributes[a].attrName;
            if ("parentRef".equalsIgnoreCase(attrName)) continue;
            int column = froDataRs.findColumn(attrName);
            childAttributes.append("<attr name=\"" + attrName + "\" type=\"" + noamFroAttributes[a].attrType + "\" value=\"" + froDataRs.getObject(column) + "\" />");
            areSpecificAttributes = true;
        }
        childAttributes.append("</attributes>");
        if (areSpecificAttributes) {
            paramMap.put("childAttributes", childAttributes.toString());
        }
        logger.traceReturn(THIS_CLASS, "addMoTypeSpecificAttributesAsChildAttributes()");
    }

    protected void addMoTypeSpecificAttributes(String froTypeName, int noamFroTypeId, ResultSet froDataRs, NoamFroAttributes[] noamFroAttributes, AueContext context) throws SQLException, CrbsAueException {
        logger.traceEnter(THIS_CLASS, "addMoTypeSpecificAttributes()");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (int a = 0; a < noamFroAttributes.length; ++a) {
            String attrName = noamFroAttributes[a].attrName;
            if ("parentRef".equalsIgnoreCase(attrName)) continue;
            paramMap.put("Mo", froTypeName);
            paramMap.put("name", attrName);
            paramMap.put("type", noamFroAttributes[a].attrType);
            int column = froDataRs.findColumn(attrName);
            Object defValue = froDataRs.getObject(column);
            paramMap.put("defaultValue", defValue != null ? defValue.toString() : "");
            AddAttributeAction addAttributeAction = new AddAttributeAction();
            addAttributeAction.setMoActionArgs(paramMap);
            addAttributeAction.convert(context);
            paramMap.clear();
        }
        logger.traceReturn(THIS_CLASS, "addMoTypeSpecificAttributes()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NoamFroVersions getNoamFroVersions(String moTypeName) throws SQLException, CrbsAueException {
        logger.traceEnter(THIS_CLASS, "getNoamFroVersions()");
        NoamFroVersions result = null;
        DbWrapper dbWrapper = DbWrapperFactory.getInstance().getDbWrapper();
        String noamFroVersions = dbWrapper.doTableExist(NOAM_FRO_VERSIONS_UPGR) ? NOAM_FRO_VERSIONS_UPGR : NOAM_FRO_VERSIONS;
        Sql.Select selectFroVersions = new Sql.Select(noamFroVersions, new Sql.Select.ColumnValue("frotypename", (Object)moTypeName));
        ResultSet resultSet = DbWrapperFactory.getInstance().getDbWrapper().executeQuery(selectFroVersions);
        try {
            if (resultSet.next()) {
                result = new NoamFroVersions(resultSet.getInt(1), resultSet.getString(2), resultSet.getString(3));
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        logger.traceReturn(THIS_CLASS, "getNoamFroVersions()");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NoamFroAttributes[] getNoamFroAttributes(int froTypeId) throws SQLException, CrbsAueException {
        logger.traceEnter(THIS_CLASS, "getNoamFroAttributes()");
        ArrayList<NoamFroAttributes> result = new ArrayList<NoamFroAttributes>();
        DbWrapper dbWrapper = DbWrapperFactory.getInstance().getDbWrapper();
        String noamFroAttr = dbWrapper.doTableExist(NOAM_FRO_ATTR_UPGR) ? NOAM_FRO_ATTR_UPGR : NOAM_FRO_ATTR;
        Sql.Select selectFroAttributes = new Sql.Select(noamFroAttr, new Sql.Select.ColumnValue("frotype", froTypeId));
        ResultSet resultSet = dbWrapper.executeQuery(selectFroAttributes);
        try {
            while (resultSet.next()) {
                result.add(new NoamFroAttributes(resultSet.getInt(1), resultSet.getString(2), resultSet.getString(3)));
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        logger.traceReturn(THIS_CLASS, "getNoamFroAttributes()");
        return result.toArray(new NoamFroAttributes[result.size()]);
    }

    protected ResultSet getNoamFroData(String froDataTableName) throws SQLException, CrbsAueException {
        logger.traceEnter(THIS_CLASS, "getNoamFroData()");
        Sql.Select selectFroData = new Sql.Select(froDataTableName);
        ResultSet result = DbWrapperFactory.getInstance().getDbWrapper().executeQuery(selectFroData);
        logger.traceReturn(THIS_CLASS, "getNoamFroData()");
        return result;
    }

    protected class NoamFroAttributes {
        protected final int froTypeId;
        protected final String attrName;
        protected final String attrType;

        protected NoamFroAttributes(int froTypeId, String attrName, String attrType) {
            logger.traceEnter(this.getClass(), "NoamFroVersions()");
            this.froTypeId = froTypeId;
            this.attrName = attrName;
            this.attrType = attrType;
            logger.traceReturn(this.getClass(), "NoamFroVersions()");
        }
    }

    protected class NoamFroVersions {
        protected final int froTypeId;
        protected final String froTypeName;
        protected final String froDataTableName;

        protected NoamFroVersions(int froTypeId, String froTypeName, String froDataTableName) {
            logger.traceEnter(this.getClass(), "NoamFroVersions()");
            this.froTypeId = froTypeId;
            this.froTypeName = froTypeName;
            this.froDataTableName = froDataTableName;
            logger.traceReturn(this.getClass(), "NoamFroVersions()");
        }
    }
}

