/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.omf.aue.step1.actions;

import com.polyhedra.sql.ResultSet;
import com.polyhedra.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.actions.NoSuchTableException;
import se.ericsson.crbs.omf.aue.common.db.DbWrapper;
import se.ericsson.crbs.omf.aue.common.db.DbWrapperFactory;
import se.ericsson.crbs.omf.aue.common.db.sql.Sql;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.AddAttributeAction;
import se.ericsson.crbs.omf.aue.step1.actions.CreateOneInstanceAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;

public class CopyLteOptionalFeatureToGlmsAction
extends AbstractConversionAction {
    private static final Class THIS_CLASS = CopyLteOptionalFeatureToGlmsAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String NOAM_FRO_VERSIONS = "fro_versions";
    private static final String NOAM_FRO_VERSIONS_UPGR = "fro_versions_new";
    private static final String PARENT_LDN = "ManagedElement=1,SystemFunctions=1,Licensing=1";
    private static final int GLMS_FRO_TYPE_ID = 0x1020000;
    private static final String GLMS_MO_TYPE_NAME = "OptionalFeatureLicense";
    private static final String[] GLMS_ATTR_NAMES_ARRAY = new String[]{"userLabel", "keyId", "featureState", "markedForDeletion"};
    private static final String[] GLMS_ATTR_TYPES_ARRAY = new String[]{"STRING", "STRING", "S32", "STRING"};
    private final String[] GLMS_ATTR_VALUES_ARRAY = new String[]{"", "0", "0", ""};
    private String featureStateAttributeName = "";
    private boolean glmsFroDataTableExists = false;
    private boolean glmsInstanceExists = false;

    public void convert(AueContext aueContext) throws CrbsAueException, NoSuchTableException {
        logger.traceEnter(THIS_CLASS, "convert()");
        String legacyMoTypeName = this.getAndCheckParamMapString("fromMo", this.paramMap, "The Legacy License MO Type name is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
        String glmsInstanceName = this.getAndCheckParamMapString("rdnValue", this.paramMap, "The Glms Instance name is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
        String keyId = this.getAndCheckParamMapString("keyId", this.paramMap, "The Key Id is not specified in " + AueUtil.doubleQuote((String)((Object)((Object)this)).getClass().getName()));
        this.featureStateAttributeName = "featureState" + this.getAttributeNamePrefix(legacyMoTypeName);
        this.GLMS_ATTR_VALUES_ARRAY[0] = glmsInstanceName;
        this.GLMS_ATTR_VALUES_ARRAY[1] = keyId;
        try {
            this.checkGlmsFroData(keyId, aueContext);
        }
        catch (TableDataException tde) {
            throw new CrbsAueException("Failed to read Glms FRO table for " + glmsInstanceName, (Throwable)tde);
        }
        if (!this.glmsInstanceExists) {
            try {
                String froDataTableName = this.getLegacyFroDataTableName(legacyMoTypeName);
                if (froDataTableName != null) {
                    Integer legacyFeatureState = this.readLegacyFeatureState(froDataTableName);
                    this.GLMS_ATTR_VALUES_ARRAY[2] = legacyFeatureState.toString();
                } else {
                    logger.traceError(THIS_CLASS, "Failed to read featureState from " + legacyMoTypeName);
                }
            }
            catch (SQLException sqlException) {
                logger.traceError(THIS_CLASS, "Failed to read featureState from " + legacyMoTypeName, (Throwable)sqlException);
            }
            try {
                this.createOneInstance(glmsInstanceName, aueContext);
                logger.traceGeneral(THIS_CLASS, "Glms Mo Instance " + glmsInstanceName + " successfully created.");
            }
            catch (SQLException sqlException) {
                throw new CrbsAueException("Failed to create Glms Mo instance " + glmsInstanceName, (Throwable)sqlException);
            }
        }
        logger.traceGeneral(THIS_CLASS, "Glms Mo Instance " + glmsInstanceName + " already exists. Do nothing.");
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    private String getAttributeNamePrefix(String legacyMoTypeName) {
        String attributeNamePrefix = "AirIfLoadGenerator".equalsIgnoreCase(legacyMoTypeName) ? "Ailg" : ("RbsEventStreamer".equalsIgnoreCase(legacyMoTypeName) ? "EventStreaming" : ("UePosCellId".equalsIgnoreCase(legacyMoTypeName) ? "CellId" : legacyMoTypeName));
        return attributeNamePrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLegacyFroDataTableName(String froTypeName) throws SQLException, CrbsAueException {
        logger.traceEnter(THIS_CLASS, "getFroLicenseData()");
        String froDataTableName = null;
        DbWrapper dbWrapper = DbWrapperFactory.getInstance().getDbWrapper();
        String noamFroVersions = dbWrapper.doTableExist(NOAM_FRO_VERSIONS_UPGR) ? NOAM_FRO_VERSIONS_UPGR : NOAM_FRO_VERSIONS;
        Sql.Select selectFroVersions = new Sql.Select(noamFroVersions, new Sql.Select.ColumnValue("frotypename", (Object)froTypeName));
        ResultSet resultSet = dbWrapper.executeQuery(selectFroVersions);
        try {
            if (resultSet.next()) {
                froDataTableName = resultSet.getString(3);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        logger.traceReturn(THIS_CLASS, "getFroLicenseData()");
        return froDataTableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer readLegacyFeatureState(String froDataTableName) throws SQLException, CrbsAueException {
        logger.traceEnter(THIS_CLASS, "readFroData()");
        Integer featureState = new Integer(0);
        Sql.Select selectFroData = new Sql.Select(froDataTableName);
        ResultSet froData = DbWrapperFactory.getInstance().getDbWrapper().executeQuery(selectFroData);
        try {
            if (froData.next()) {
                int column = froData.findColumn(this.featureStateAttributeName);
                Object value = froData.getObject(column);
                featureState = (Integer)value;
            }
        }
        finally {
            if (froData != null) {
                froData.close();
            }
        }
        logger.traceReturn(THIS_CLASS, "readFroData()");
        return featureState;
    }

    private void checkGlmsFroData(String keyId, AueContext aueContext) throws TableDataException {
        TableHandler tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
        TableData glmsTableData = tableHandler.getTableData(GLMS_MO_TYPE_NAME);
        if (!"".equals(glmsTableData.getTableName())) {
            this.glmsFroDataTableExists = true;
        }
        if (glmsTableData.isNotEmpty()) {
            Object[] keyIds = glmsTableData.getAttributeValues("keyId");
            for (int i = 0; i < keyIds.length; ++i) {
                if (!keyId.equals(keyIds[i])) continue;
                this.glmsInstanceExists = true;
            }
        }
    }

    private void createOneInstance(String glmsId, AueContext aueContext) throws CrbsAueException, SQLException {
        logger.traceEnter(THIS_CLASS, "createOneInstance() froTypeName:OptionalFeatureLicense");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("name", GLMS_MO_TYPE_NAME);
        paramMap.put("frotype", Integer.toString(0x1020000));
        paramMap.put("rdnValue", glmsId);
        paramMap.put("parentldn", PARENT_LDN);
        if (this.glmsFroDataTableExists) {
            this.addMoTypeSpecificAttributesAsChildAttributes(paramMap);
        }
        CreateOneInstanceAction createOneInstanceAction = new CreateOneInstanceAction();
        createOneInstanceAction.setMoActionArgs(paramMap);
        createOneInstanceAction.convert(aueContext);
        if (!this.glmsFroDataTableExists) {
            this.addMoTypeSpecificAttributes(aueContext);
        }
        logger.traceReturn(THIS_CLASS, "createOneInstance()");
    }

    private void addMoTypeSpecificAttributesAsChildAttributes(Map paramMap) throws SQLException, CrbsAueException {
        logger.traceEnter(THIS_CLASS, "addMoTypeSpecificAttributesAsChildAttributes()");
        StringBuffer childAttributes = new StringBuffer("<attributes>");
        for (int a = 0; a < GLMS_ATTR_NAMES_ARRAY.length; ++a) {
            childAttributes.append("<attr name=\"" + GLMS_ATTR_NAMES_ARRAY[a] + "\" type=\"" + GLMS_ATTR_TYPES_ARRAY[a] + "\" value=\"" + this.GLMS_ATTR_VALUES_ARRAY[a] + "\" />");
        }
        childAttributes.append("</attributes>");
        paramMap.put("childAttributes", childAttributes.toString());
        logger.traceReturn(THIS_CLASS, "addMoTypeSpecificAttributesAsChildAttributes()");
    }

    private void addMoTypeSpecificAttributes(AueContext context) throws SQLException, CrbsAueException {
        logger.traceEnter(THIS_CLASS, "addMoTypeSpecificAttributes()");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (int a = 0; a < GLMS_ATTR_NAMES_ARRAY.length; ++a) {
            paramMap.put("Mo", GLMS_MO_TYPE_NAME);
            paramMap.put("name", GLMS_ATTR_NAMES_ARRAY[a]);
            paramMap.put("type", GLMS_ATTR_TYPES_ARRAY[a]);
            paramMap.put("defaultValue", this.GLMS_ATTR_VALUES_ARRAY[a]);
            AddAttributeAction addAttributeAction = new AddAttributeAction();
            addAttributeAction.setMoActionArgs(paramMap);
            addAttributeAction.convert(context);
            paramMap.clear();
        }
        logger.traceReturn(THIS_CLASS, "addMoTypeSpecificAttributes()");
    }
}

