/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.omf.aue.step1.actions;

import java.io.File;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;

public class DeleteOldSecurityFilesAction
extends AbstractConversionAction {
    private static final Class THIS_CLASS = DeleteOldSecurityFilesAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public void convert(AueContext context) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "convert()");
        String SECURITY_FOLDER = File.separator + "c" + File.separator + "security";
        String RSA_KEY_FILE = SECURITY_FOLDER + File.separator + "ssh_host_rsa_key";
        String DSA_KEY_FILE = SECURITY_FOLDER + File.separator + "ssh_host_dsa_key";
        this.deleteFile(RSA_KEY_FILE);
        this.deleteFile(DSA_KEY_FILE);
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    protected void deleteFile(String filePath) {
        File fileHandle = new File(filePath);
        if (fileHandle.exists()) {
            try {
                fileHandle.delete();
                logger.traceDebug(THIS_CLASS, "File deleted:" + filePath);
            }
            catch (Exception E) {
                logger.traceError(THIS_CLASS, "Failed to delete:" + filePath + E.getMessage());
            }
        } else {
            logger.traceDebug(THIS_CLASS, "file:" + filePath + "does not exist");
        }
    }
}

