/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.omf.aue.step1.helper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import se.ericsson.cello.aueframework.collector.CollectorContext;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.swmanagement.suaccess.LoadModuleMoSU_Access;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.omf.aue.step1.helper.FileHelper;
import se.ericsson.crbs.cat.omf.aue.step1.helper.FileHelperFactory;
import se.ericsson.crbs.cat.omf.aue.step1.helper.StructImpl;
import se.ericsson.crbs.common.LdnHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class LoadModuleRecoverer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String NOT_RESOLVED_YET = "Not resolved yet";
    private static final String LOAD_MODULE_TYPE = "LoadModule";
    private static final String SW_MANAGEMENT_LDN = "ManagedElement=1,SwManagement=1";
    private static final Object MUTEX = new Object();
    private static LoadModuleRecoverer theInstance = null;
    private static final Class THIS_CLASS = LoadModuleRecoverer.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final Map loadModuleMap = new HashMap();
    private boolean fileHasBeenRead = false;

    private LoadModuleRecoverer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LoadModuleRecoverer getInstance() {
        Object object = MUTEX;
        synchronized (object) {
            if (theInstance == null) {
                theInstance = new LoadModuleRecoverer();
            }
            return theInstance;
        }
    }

    public void saveLoadModuleData(String loadModuleId, AttrListImpl theLoadModuleAttributes) {
        logger.traceEnter(THIS_CLASS, "saveLoadModuleData(" + loadModuleId + ")");
        this.readFile();
        ArrayList<NameValue> nameValuesList = new ArrayList<NameValue>();
        for (int i = 0; i < theLoadModuleAttributes.size(); ++i) {
            String attrName = theLoadModuleAttributes.getName(i);
            Object attrValue = theLoadModuleAttributes.getValue(i);
            if (attrValue instanceof Struct) {
                nameValuesList.add(new NameValue(attrName, new SerializeableStruct((Struct)attrValue)));
                continue;
            }
            nameValuesList.add(new NameValue(attrName, attrValue));
        }
        this.loadModuleMap.put(loadModuleId, nameValuesList);
        this.saveFile();
        logger.traceGeneral(THIS_CLASS, "Saved LoadModule data for restoration later: " + loadModuleId);
        logger.traceReturn(THIS_CLASS, "saveLoadModuleData(" + loadModuleId + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveFile() {
        LoadModuleRecoverer loadModuleRecoverer = theInstance;
        synchronized (loadModuleRecoverer) {
            String recoveryFilePath = FileHelperFactory.getInstance().getFileHelper().getLoadModuleRecoveryFilePath();
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(recoveryFilePath);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                this.writeObject(objectOutputStream);
                fileOutputStream.close();
            }
            catch (Exception e) {
                logger.traceError(THIS_CLASS, "Failed to store LoadModule recovery data to file: " + recoveryFilePath, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFile() {
        LoadModuleRecoverer loadModuleRecoverer = theInstance;
        synchronized (loadModuleRecoverer) {
            if (!this.fileHasBeenRead) {
                String recoveryFilePath = NOT_RESOLVED_YET;
                try {
                    logger.traceGeneral(THIS_CLASS, "FileHelperFactory.getInstance(): " + FileHelperFactory.getInstance());
                    FileHelper fileHelper = FileHelperFactory.getInstance().getFileHelper();
                    logger.traceGeneral(THIS_CLASS, "fileHelper: " + fileHelper);
                    recoveryFilePath = fileHelper.getLoadModuleRecoveryFilePath();
                    if (fileHelper.filePathExists(recoveryFilePath)) {
                        FileInputStream fileInputStream = new FileInputStream(recoveryFilePath);
                        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                        try {
                            this.readObject(objectInputStream);
                        }
                        catch (InvalidClassException e) {
                            File file = new File(recoveryFilePath);
                            byte[] fileContent = new byte[(int)file.length()];
                            fileInputStream.read(fileContent);
                            String hexcode = "";
                            for (int i = 0; i < fileContent.length; ++i) {
                                hexcode = hexcode + Integer.toString((fileContent[i] & 0xFF) + 256, 16).substring(1);
                            }
                            logger.traceDebug(THIS_CLASS, "Restore has failed " + e.getMessage() + " dumping file " + recoveryFilePath + " as hexcode. " + hexcode);
                        }
                        fileInputStream.close();
                    }
                    this.fileHasBeenRead = true;
                }
                catch (Exception e) {
                    logger.traceError(THIS_CLASS, "Failed to read LoadModule recovery data from file: " + recoveryFilePath, (Throwable)e);
                }
            }
        }
    }

    public ManagedObject restoreLoadModuleFromLdn(String theLoadModuleLdn, CollectorContext collectorContext, Coordinator theCoordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "restoreLoadModuleFromLdn(" + theLoadModuleLdn + ")");
        try {
            this.readFile();
            String loadModuleId = this.convertToIdFromLdn(theLoadModuleLdn);
            logger.traceDebug(THIS_CLASS, "LoadModule ID: " + loadModuleId);
            Object retrivedObject = this.loadModuleMap.get(loadModuleId);
            if (retrivedObject instanceof List) {
                AttrListImpl attributes = new AttrListImpl();
                List retrievedDataList = (List)retrivedObject;
                NameValue[] nameValues = new NameValue[retrievedDataList.size()];
                retrievedDataList.toArray(nameValues);
                for (int i = 0; i < nameValues.length; ++i) {
                    if (nameValues[i].value instanceof SerializeableStruct) {
                        SerializeableStruct serializeableStruct = (SerializeableStruct)nameValues[i].value;
                        attributes.addElement(nameValues[i].name, (Object)serializeableStruct.getRealStruct());
                        continue;
                    }
                    attributes.addElement(nameValues[i].name, nameValues[i].value);
                }
                MoFactory moFactory = collectorContext.getMoAccessor().lookupMoFactory(LOAD_MODULE_TYPE);
                ManagedObject swManagementMo = collectorContext.getMoAccessor().lookup(SW_MANAGEMENT_LDN);
                LoadModuleMoSU_Access localLoadModuleMo = (LoadModuleMoSU_Access)moFactory.createMo(swManagementMo, (AttrList)attributes, loadModuleId, null, theCoordinator);
                localLoadModuleMo.reserve(theCoordinator);
                logger.traceGeneral(THIS_CLASS, "Restored LoadModule MO: " + localLoadModuleMo);
            }
        }
        catch (MoAccessException mae) {
            logger.traceError(THIS_CLASS, "failed to restore LoadModule MO, " + theLoadModuleLdn + ", deleted by CPP!");
            throw mae;
        }
        ManagedObject managedObject = collectorContext.getMoAccessor().lookup(theLoadModuleLdn);
        logger.traceReturn(THIS_CLASS, "restoreLoadModuleFromLdn(" + (managedObject == null ? "null" : managedObject.getLocalDistinguishedName()) + ")");
        return managedObject;
    }

    private String convertToIdFromLdn(String theLoadModuleLdn) {
        String loadModuleId = theLoadModuleLdn;
        if (LdnHelper.isLdn((String)theLoadModuleLdn)) {
            loadModuleId = LdnHelper.getRdnAttributeValue((String)theLoadModuleLdn);
        }
        return loadModuleId;
    }

    private void readObject(ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
        Object readObject = inputStream.readObject();
        if (readObject instanceof Map) {
            this.loadModuleMap.clear();
            this.loadModuleMap.putAll((Map)readObject);
        }
    }

    private void writeObject(ObjectOutputStream outputStream) throws IOException {
        outputStream.writeObject(this.loadModuleMap);
    }

    private static class SerializeableStruct
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final Object DEFAULT_VALUE = new Object();
        private final NameValue[] nameValues;
        private final String structClassName;

        public SerializeableStruct(Struct theStruct) {
            int length = theStruct.size();
            this.nameValues = new NameValue[length];
            String[] names = theStruct.getNames();
            for (int i = 0; i < names.length; ++i) {
                Object theValue = DEFAULT_VALUE;
                try {
                    theValue = theStruct.getValue(names[i]);
                }
                catch (Exception ignore) {
                    theValue = DEFAULT_VALUE;
                }
                this.nameValues[i] = new NameValue(names[i], theValue);
            }
            this.structClassName = theStruct.getClass().getName();
        }

        public Struct getRealStruct() {
            String[] names = new String[this.nameValues.length];
            Object[] values = new String[this.nameValues.length];
            for (int i = 0; i < names.length; ++i) {
                names[i] = this.nameValues[i].name;
                values[i] = this.nameValues[i].value;
            }
            Object result = "se.ericsson.cello.moframework.StructImpl".equalsIgnoreCase(this.structClassName) ? new se.ericsson.cello.moframework.StructImpl(names, values) : new StructImpl(names, values);
            return result;
        }
    }

    private static class NameValue
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String name;
        private final Object value;

        public NameValue(String theName, Object theValue) {
            this.name = theName;
            this.value = theValue;
        }
    }
}

