/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.omf.aue.step1.util;

import java.io.CharArrayReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import se.ericsson.crbs.cat.omf.aue.step1.util.MoRef;
import se.ericsson.crbs.cat.omf.aue.step1.util.MoRefArray;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;

public class MoRefArrayParser
extends DefaultHandler {
    private static final Class THIS_CLASS = MoRefArrayParser.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private MoRefArray moRefArray;
    private MoRef moRef;

    public static MoRefArray parseMoRefArray(String moRef) throws CrbsAueException {
        try {
            logger.traceEnter(THIS_CLASS, "parseMoRef() " + moRef);
            CharArrayReader reader = new CharArrayReader(moRef.trim().toCharArray());
            InputSource input = new InputSource(reader);
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            SAXParser saxParser = saxParserFactory.newSAXParser();
            XMLReader parser = saxParser.getXMLReader();
            MoRefArrayParser handler = new MoRefArrayParser();
            parser.setContentHandler(handler);
            parser.setErrorHandler(handler);
            parser.parse(input);
            return handler.getMoRefArray();
        }
        catch (Exception e) {
            throw new CrbsAueException("Failed to parse moref " + moRef, (Throwable)e);
        }
    }

    protected MoRefArray getMoRefArray() {
        return this.moRefArray;
    }

    public void startElement(String namespaceUri, String localName, String qName, Attributes attributes) throws SAXException {
        logger.traceEnter(this.getClass(), "startElement " + qName);
        if ("ARRAY".equalsIgnoreCase(qName)) {
            String attrName = null;
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.getQName(i).equalsIgnoreCase("name")) continue;
                attrName = attributes.getValue(i);
            }
            this.moRefArray = new MoRefArray(attrName);
        } else if ("moref".equalsIgnoreCase(qName)) {
            this.moRef = new MoRef();
            this.moRefArray.addMoRef(this.moRef);
        } else if ("attr".equalsIgnoreCase(qName)) {
            String attrName = null;
            String attrValue = null;
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (attributes.getQName(i).equalsIgnoreCase("name")) {
                    attrName = attributes.getValue(i);
                    continue;
                }
                if (!attributes.getQName(i).equalsIgnoreCase("value")) continue;
                attrValue = attributes.getValue(i);
            }
            if ("ldn".equalsIgnoreCase(attrName)) {
                this.moRef.ldn = attrValue;
            } else if ("frotype".equalsIgnoreCase(attrName)) {
                this.moRef.froTypeId = Integer.parseInt(attrValue);
            } else if ("froid".equalsIgnoreCase(attrName)) {
                this.moRef.froId = Integer.parseInt(attrValue);
            }
        }
        logger.traceReturn(this.getClass(), "startElement");
    }
}

