/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.omf.aue.step1.util;

import com.polyhedra.sql.SQLException;
import se.ericsson.crbs.cat.omf.aue.common.RbsCatMetaData;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.db.DbWrapper;
import se.ericsson.crbs.omf.aue.common.db.DbWrapperFactory;
import se.ericsson.crbs.omf.aue.common.db.sql.Sql;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;

public class RbsCatStep1DbUtil {
    private static final Class THIS_CLASS = RbsCatStep1DbUtil.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public void createVersionAndAttrTableIfNotExists(RbsCatMetaData rbsCatMetaData) throws CrbsAueException {
        String methodName = "createVersionAndAttrTableIfNotExists()";
        logger.traceEnter(THIS_CLASS, "createVersionAndAttrTableIfNotExists()");
        DbWrapper dbWrapper = null;
        try {
            dbWrapper = DbWrapperFactory.getInstance().getDbWrapper();
            dbWrapper.openConnection();
            boolean froVersionExists = dbWrapper.doTableExist(rbsCatMetaData.getFroVersionsTableName());
            logger.traceDebug(THIS_CLASS, "createVersionAndAttrTableIfNotExists() froVersionExists:" + froVersionExists);
            if (!froVersionExists) {
                this.createFroVersionsTable(rbsCatMetaData.getFroVersionsTableName(), dbWrapper);
            }
            boolean froAttrExists = dbWrapper.doTableExist(rbsCatMetaData.getFroAttributesTableName());
            logger.traceDebug(THIS_CLASS, "createVersionAndAttrTableIfNotExists() froAttrExists:" + froAttrExists);
            if (!froAttrExists) {
                this.createFroAttributesTable(rbsCatMetaData.getFroAttributesTableName(), dbWrapper);
            }
        }
        catch (SQLException e) {
            throw new CrbsAueException(AueUtil.appendReason((String)"createVersionAndAttrTableIfNotExists() Failed to retrive information from db.", (Throwable)e), (Throwable)e);
        }
        finally {
            try {
                dbWrapper.closeConnection(1);
            }
            catch (Exception ignore) {
                logger.traceAbnormal(THIS_CLASS, "createVersionAndAttrTableIfNotExists() Failed to close DB connection");
            }
        }
        logger.traceReturn(THIS_CLASS, "createVersionAndAttrTableIfNotExists()");
    }

    private void createFroVersionsTable(String tableName, DbWrapper dbWrapper) throws SQLException {
        Sql.CreateTable createFroVersions = new Sql.CreateTable(tableName);
        createFroVersions.addColumn(new Sql.CreateTable.ColumnSpec("frotype", Sql.MomDataType.MOM_S32, 0, "UNIQUE", true));
        createFroVersions.addColumn(new Sql.CreateTable.ColumnSpec("frotypename", Sql.MomDataType.MOM_STRING, 0, "UNIQUE", true));
        createFroVersions.addColumn(new Sql.CreateTable.ColumnSpec("frodataTableName", Sql.MomDataType.MOM_STRING, 0, null, false));
        dbWrapper.executeUpdate((Sql.Modification)createFroVersions);
    }

    private void createFroAttributesTable(String tableName, DbWrapper dbWrapper) throws SQLException {
        Sql.CreateTable createFroAttr = new Sql.CreateTable(tableName);
        createFroAttr.addColumn(new Sql.CreateTable.ColumnSpec("frotype", Sql.MomDataType.MOM_S32, 0, null, true));
        createFroAttr.addColumn(new Sql.CreateTable.ColumnSpec("attrName", Sql.MomDataType.MOM_STRING, 0, null, true));
        createFroAttr.addColumn(new Sql.CreateTable.ColumnSpec("attrType", Sql.MomDataType.MOM_STRING, 0, null, false));
        dbWrapper.executeUpdate((Sql.Modification)createFroAttr);
    }
}

