/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.nex;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.PrivilegedExceptionAction;
import java.util.Observer;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import se.ericsson.cello.emt.nodeservices.NodeServices;
import se.ericsson.cello.emt.utils.guihelper.MessageDialogFactory;
import se.ericsson.cello.neal.NodeConnectionListener;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.nex.ConfigurationFactory;
import se.ericsson.cello.nex.ConfigurationI;
import se.ericsson.cello.nex.NexLog;
import se.ericsson.cello.nex.gui.Gui;
import se.ericsson.cello.nex.toolservices.StartFailureException;
import se.ericsson.cello.nex.toolservices.ToolServiceFactory;
import se.ericsson.cello.nex.toolservices.ToolServicesI;
import se.ericsson.cello.nex.viewservices.ViewServicesFactory;
import se.ericsson.cello.nex.viewservices.ViewServicesI;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.LauncherException;
import se.ericsson.security.launcher.LauncherInterface;
import se.ericsson.security.launcher.ReusableLaunchable;
import se.ericsson.security.launcher.emnotification.EmEventInterface;
import se.ericsson.security.launcher.emnotification.EmNotificationListenerInterface;
import se.ericsson.security.launcher.emnotification.EmNotificationServiceInterface;
import se.ericsson.security.launcher.eprops.EKEY;
import se.ericsson.security.launcher.eprops.EProps;

public class NEX
implements ReusableLaunchable {
    private LauncherInterface launcher;
    private String launchableName = null;
    private ToolServicesI toolServices;
    private ViewServicesI viewServices;
    private Gui ui;
    static final String DEFAULT_SCHEME = "se/ericsson/cello/nex/viewservices/parser/NEX.xsd";
    private CountDownLatch guiInitialized;
    private static final String STARTTIMEKEY = "StartTime";
    public static final String VIEW_EXPANDED_NOTIFICATION = "se.ericsson.cello.nex.VIEW_EXPANDED";
    public static final String START_TIMER_TRACE_PREFIX = "StartTimer: ";

    public NEX() {
        NexLog.logger().log(Level.INFO, " NEX constructor");
    }

    public void exit() {
        if (this.toolServices != null) {
            try {
                this.toolServices.getNodeServices().getNode().removeConnectionListener((NodeConnectionListener)this.ui);
                NexLog.logger().log(Level.INFO, "NEX removed connection listener. ");
            }
            catch (StartFailureException e) {
                NexLog.logger().log(Level.SEVERE, "NEX is unable to remove connection listener. ");
            }
            if (this.launcher instanceof LauncherInterface.RevE) {
                try {
                    ((LauncherInterface.RevE)this.launcher).removeObserver((Observer)this.toolServices);
                }
                catch (AbstractMethodError abstractMethodError) {
                    // empty catch block
                }
            }
        }
        if (null != this.viewServices) {
            this.viewServices.prepareClose();
        }
        if (null != this.ui) {
            this.ui.destroy();
        }
        if (null != this.viewServices) {
            this.viewServices.destroy();
        }
        if (null != this.toolServices) {
            this.toolServices.destroy();
        }
        this.ui = null;
        this.viewServices = null;
        this.toolServices = null;
        this.launcher.onExit((Launchable)this);
    }

    public boolean reconnect(String hostname, Properties arg1) {
        return true;
    }

    public String toString() {
        return this.launchableName;
    }

    public void run(String hostName, Properties parameters, LauncherInterface launcher, Launchable parent) {
        long startTimeForNexRunMethod = System.currentTimeMillis();
        EProps ep = new EProps();
        ep.put(EKEY.JAVA_METHOD, "NEX.run");
        ep.append(EKEY.JAVA_METHOD, "hostName     = " + hostName);
        ep.append(EKEY.JAVA_METHOD, "parameters   = " + parameters);
        ep.append(EKEY.JAVA_METHOD, "launcher     = " + launcher);
        ep.append(EKEY.JAVA_METHOD, "parent       = " + parent);
        ep.append(EKEY.JAVA_METHOD, "classloader  = " + this.getClass().getClassLoader());
        ep.append(EKEY.JAVA_METHOD, "cl.parent    = " + this.getClass().getClassLoader().getParent());
        NexLog.logger().log(Level.INFO, " NEX run method");
        NexLog.logger().info("NEX run called with properties:\n" + parameters.toString());
        this.launcher = launcher;
        this.setDebugLevel(parameters);
        parameters.setProperty("HOST", hostName);
        final ConfigurationI configReader = ConfigurationFactory.createConfigurationHandler(parameters);
        this.launchableName = configReader.getTitle() + " Main Window";
        final LauncherInterface aLauncher = launcher;
        final String aHost = hostName;
        NexLog.logger().log(Level.FINE, " create the tool services");
        this.toolServices = ToolServiceFactory.createToolServices((Launchable)this, aHost, aLauncher, configReader);
        if (launcher instanceof LauncherInterface.RevE) {
            try {
                ((LauncherInterface.RevE)launcher).addObserver((Observer)this.toolServices);
            }
            catch (AbstractMethodError error) {}
        } else {
            NexLog.logger().warning("Launcher is not of instance RevE. Cannot display file version data in exceptions.");
        }
        long startTime = 0L;
        String startTimeString = parameters.getProperty(STARTTIMEKEY);
        if (startTimeString == null) {
            startTime = 0L;
        } else {
            EProps.getRevisionProperties().set(EKEY.ENV_DATE_TIME, (Object)startTimeString);
            try {
                startTime = Long.parseLong(startTimeString);
            }
            catch (Exception e) {
                startTime = 0L;
            }
        }
        if (startTime == 0L) {
            NexLog.logger().info("StartTimer: The NEX application startup time cannot be measured");
        } else {
            new StartupCompletedListener(startTime);
        }
        final Properties props = configReader.getSupersedingProperties();
        String iconPath = configReader.getIconToPassOn();
        if (null != iconPath && iconPath.length() > 0) {
            props.put("TOOL_ICON", iconPath);
        }
        NexLog.logger().log(Level.FINE, " create the node services");
        PrivilegedExceptionAction<Launchable> launchNodeServiceAction = new PrivilegedExceptionAction<Launchable>(){

            @Override
            public Launchable run() throws LauncherException {
                try {
                    Launchable ns = aLauncher.runResource(configReader.getNodeServicesTool().getConfigFile(), aHost, props, (Launchable)NEX.this);
                    return ns;
                }
                catch (Exception e) {
                    NEX.this.ui.setMessage("Node connection problem.", "\nIt is not possible to open any view.", e, true);
                    NEX.this.ui.setStatusMessage("Node connection problem. No view can be opened.");
                    return null;
                }
            }
        };
        Callable<Object> launchResourceCallable = Executors.callable(launchNodeServiceAction);
        ExecutorService exec = Executors.newSingleThreadExecutor();
        Future<Object> nsFuture = exec.submit(launchResourceCallable);
        NexLog.logger().log(Level.FINE, " creates the User Interface");
        this.ui = new Gui(configReader, this.toolServices);
        this.guiInitialized = new CountDownLatch(1);
        this.initGui();
        this.createViewLib(parameters);
        NexLog.logger().log(Level.FINE, " create the view services");
        this.viewServices = ViewServicesFactory.createViewServices(this.toolServices, configReader);
        this.viewServices.setUI(this.ui);
        this.ui.setViewServices(this.viewServices);
        NodeServices nodeServices = null;
        try {
            Object obj = nsFuture.get();
            exec.shutdown();
            nodeServices = (NodeServices)obj;
            if (nodeServices == null) {
                return;
            }
            nodeServices.getNode();
            nodeServices.getMimModel();
            nodeServices.getNode().addConnectionListener((NodeConnectionListener)this.ui);
        }
        catch (Exception e) {
            NexLog.logger().log(Level.WARNING, "It was not possible to launch Node Services.\n" + NexLog.stackToString(e));
            this.ui.setMessage("Node connection problem.", "\nIt is not possible to open any view. Please exit, and try to start again.", e, true);
            this.ui.setStatusMessage("Node connection problem. No view can be opened.");
            return;
        }
        this.toolServices.setNodeServices(nodeServices);
        this.ui.setStatusMessage("Connection to the node established. Will continue initiation...");
        this.ui.connectionEstablished();
        try {
            this.guiInitialized.await(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            NexLog.logger().warning("InterruptedException while waiting for GUI to become initaized.");
            this.ui.setMessage("Initialization problem.", "\nIt is not possible to open any view. Please exit, and try to start again.", e, true);
        }
        if (this.ui.isInitialized()) {
            NexLog.logger().fine("Got NodeServices, and NEX GUI is initialized. Continue with updateGuiAfterConnection and startAView");
            this.ui.updateGuiAfterConnection();
            this.startAView(parameters);
            this.updateTitle(configReader);
        } else {
            NexLog.logger().warning("The NEX GUI was never initialized");
            this.ui.setMessage("Initialization problem.", "\nIt is not possible to open any view. Please exit, and try to start again.", true);
        }
        long currentTime = System.currentTimeMillis();
        long startupTime = currentTime - startTimeForNexRunMethod;
        NexLog.logger().info("StartTimer: Execution time of NEX.run() method is: " + startupTime + " milliseconds.");
    }

    public void reuse(String hostName, Properties parameters, LauncherInterface launcher, Launchable parent) {
        final String ldn = parameters.getProperty("LDNs");
        final String viewname = parameters.getProperty("VIEW");
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    NexLog.logger().log(Level.INFO, "Reusing NEX. LDN is:" + ldn + "    VIEW is:" + viewname);
                    NEX.this.ui.toFront();
                    NexLog.logger().log(Level.FINE, "Restore Frame");
                    NEX.this.ui.restoreFrame();
                    if (ldn != null || viewname != null) {
                        NEX.this.viewServices.startView(viewname, ldn);
                    }
                }
                catch (Exception e) {
                    MessageDialogFactory.createMessageDialog((String)"The View was not possible to open.", (Exception)e, (boolean)false, null).setVisible(true);
                }
            }
        };
        ExecutorService exec = Executors.newSingleThreadExecutor();
        exec.execute(runnable);
        exec.shutdown();
    }

    private void initGui() {
        if (!SwingUtilities.isEventDispatchThread()) {
            Runnable runner = new Runnable(){

                public void run() {
                    NEX.this.initGui();
                }
            };
            SwingUtilities.invokeLater(runner);
        } else {
            NexLog.logger().log(Level.INFO, " initializes the User Interface");
            this.ui.initialize();
            NexLog.logger().log(Level.FINE, " visualize the GUI");
            this.ui.showUI(true);
            this.ui.setStatusMessage("Establishing connection with the node...");
            this.toolServices.setUI(this.ui);
            this.guiInitialized.countDown();
        }
    }

    private void createViewLib(Properties parameters) {
        String sep = System.getProperty("file.separator");
        String viewLibDir = System.getProperty("user.home") + sep + "Ericsson" + sep + "UserDefinedViews";
        String schemeName = "ViewSchema";
        String schemaVersion = null;
        String schemeType = ".xsd";
        String schemaFileName = null;
        try {
            schemaVersion = this.fetchXMLversion();
        }
        catch (IOException e) {
            NexLog.logger().log(Level.INFO, "XML Schema could not be saved to client.\n" + NexLog.stackToString(e));
            this.ui.setMessage("User's UserDefinedViews directory problem:", "An exception occured while loading XSD Schema to user view file directory.\nYou can still put your private view files in the view directory at " + viewLibDir, e, false);
            return;
        }
        schemaFileName = schemeName + "_" + schemaVersion + schemeType;
        parameters.setProperty("XSD_VERSION", schemaFileName);
        File schemeInCache = new File(viewLibDir + sep + schemaFileName);
        if (!schemeInCache.exists()) {
            try {
                File lib = new File(viewLibDir);
                boolean dirExists = lib.exists();
                if (!dirExists) {
                    NexLog.logger().log(Level.FINE, " create view library");
                    dirExists = lib.mkdir();
                }
                if (dirExists) {
                    int bytedata;
                    NexLog.logger().log(Level.FINE, " load the schema file");
                    BufferedInputStream inBuffer = null;
                    BufferedOutputStream outBuffer = null;
                    InputStream in = null;
                    in = this.getClass().getClassLoader().getResourceAsStream(DEFAULT_SCHEME);
                    inBuffer = new BufferedInputStream(in);
                    FileOutputStream out = new FileOutputStream(schemeInCache);
                    outBuffer = new BufferedOutputStream(out);
                    while ((bytedata = inBuffer.read()) != -1) {
                        ((OutputStream)out).write(bytedata);
                    }
                    if (inBuffer != null) {
                        inBuffer.close();
                    }
                    if (outBuffer != null) {
                        outBuffer.close();
                    }
                }
            }
            catch (IOException e) {
                if (schemeInCache.exists()) {
                    schemeInCache.deleteOnExit();
                }
                this.ui.setMessage("User's UserDefinedViews directory problem:", "An exception occured while loading the XSD Schema to user view file directory.\nYou can still put your private view files in the view directory at " + viewLibDir, e, false);
            }
        }
    }

    private String fetchXMLversion() throws IOException {
        String xsdVersion = null;
        InputStream xmlSchemaAsStream = null;
        xmlSchemaAsStream = this.getClass().getClassLoader().getResourceAsStream(DEFAULT_SCHEME);
        if (xmlSchemaAsStream == null) {
            throw new IOException("\nIt was not possible to create stream from: se/ericsson/cello/nex/viewservices/parser/NEX.xsd");
        }
        BufferedReader inputstream = null;
        inputstream = new BufferedReader(new InputStreamReader(xmlSchemaAsStream));
        String regex = "XMLSchema\" version=\"([A-Za-z0-9.]+)\"";
        while (inputstream.read() != -1 && inputstream.ready()) {
            String nextLine = inputstream.readLine();
            Pattern compiledPattern = Pattern.compile(regex);
            Matcher matcher = compiledPattern.matcher(nextLine);
            if (!matcher.find()) continue;
            xsdVersion = matcher.group(1);
        }
        xmlSchemaAsStream.close();
        inputstream.close();
        return xsdVersion;
    }

    private void startAView(Properties parameters) {
        String ldn = parameters.getProperty("LDNs", "");
        String startViewName = "Containment (MOM based)";
        String startFromAppView = parameters.getProperty("VIEW");
        String startFromConfigViewName = parameters.getProperty("START_VIEW");
        if (ldn.equals("")) {
            if (null != startFromAppView && startFromAppView.length() > 0) {
                startViewName = startFromAppView;
            } else if (null != startFromConfigViewName && startFromConfigViewName.length() > 0) {
                startViewName = startFromConfigViewName;
            }
        }
        if (null != startViewName) {
            this.ui.setStatusMessage("Initiating the view " + startViewName + "...");
            this.viewServices.startView(startViewName, ldn);
        }
    }

    private void setDebugLevel(Properties params) {
        String debugString = params.getProperty("se.ericsson.cello.nex.debug");
        if (null == debugString) {
            debugString = System.getProperty("se.ericsson.cello.nex.debug");
        }
        if (null == debugString || debugString.equalsIgnoreCase("false")) {
            return;
        }
        if (debugString.equalsIgnoreCase("true")) {
            String level = params.getProperty("se.ericsson.cello.nex.debug.level");
            if (null == level) {
                level = System.getProperty("se.ericsson.cello.nex.debug.level");
            }
            if (null == level) {
                level = "ALL";
            }
            NexLog.setDebugLevel(level);
        }
    }

    private void updateTitle(ConfigurationI configReader) {
        String userLabelName = "userLabel";
        String logicalNameTag = "logicalName";
        String userLabel = null;
        String logicalName = null;
        String updatedManagerTitle = configReader.getTitle();
        String rbsName = null;
        try {
            Mo managedElementMo = this.toolServices.getNodeServices().getNode().getCmService().getMo("ManagedElement=1");
            userLabel = managedElementMo.getAttribute(userLabelName, null).valueToString();
            logicalName = managedElementMo.getAttribute(logicalNameTag, null).valueToString();
        }
        catch (Exception e) {
            NexLog.logger().log(Level.SEVERE, "Failed reading userLabel or logicalName attribute when audating manager title.", e);
        }
        try {
            Mo cvMo = this.toolServices.getNodeServices().getNode().getCmService().getMo("ManagedElement=1,SwManagement=1,ConfigurationVersion=1");
            String executingCv = cvMo.getAttribute("executingCv", null).valueToString();
            String upLdn = cvMo.getAttribute("currentUpgradePackage", null).valueToString();
            if (executingCv != null) {
                EProps.getRevisionProperties().set(EKEY.REV_CV_CURRENT, (Object)executingCv);
            }
            if (upLdn != null && upLdn.length() > 0 && upLdn.lastIndexOf("=") < upLdn.length() - 1) {
                int prodNumStartIndex = upLdn.lastIndexOf("=") + 1;
                EProps.getRevisionProperties().set(EKEY.REV_UP, (Object)upLdn.substring(prodNumStartIndex));
            }
        }
        catch (Exception e) {
            NexLog.logger().log(Level.WARNING, "Failed reading revision information from MOs on node", e);
        }
        if (userLabel != null && userLabel.length() > 0) {
            if (!updatedManagerTitle.startsWith(userLabel)) {
                updatedManagerTitle = userLabel + " - " + configReader.getTitle();
                rbsName = userLabel;
            }
        } else if (logicalName != null && logicalName.length() > 0 && !updatedManagerTitle.startsWith(logicalName)) {
            updatedManagerTitle = logicalName + " - " + configReader.getTitle();
            rbsName = logicalName;
        }
        if (rbsName != null) {
            EProps.getRevisionProperties().set(EKEY.NODE_TYPE, rbsName);
        }
        if (!updatedManagerTitle.equals(configReader.getTitle())) {
            Properties props = configReader.getProperties();
            props.setProperty("MANAGER_TITLE", updatedManagerTitle);
            this.launchableName = updatedManagerTitle + " Main Window";
            this.ui.updateTitleForInitialTool();
        }
    }

    private class StartupCompletedListener
    implements EmNotificationListenerInterface {
        private long startTimeOfLauncher = 0L;
        private static final String START_TIMER_THE_NEX_APPLICATION_STARTUP_TIME_CANNOT_BE_MEASURED = "StartTimer: The NEX application startup time cannot be measured";

        public StartupCompletedListener(long startTime) {
            if (startTime == 0L) {
                NexLog.logger().info(START_TIMER_THE_NEX_APPLICATION_STARTUP_TIME_CANNOT_BE_MEASURED);
            } else {
                LauncherInterface launcher = NEX.this.toolServices.getLauncher();
                if (launcher instanceof EmNotificationServiceInterface) {
                    this.startTimeOfLauncher = startTime;
                    NEX.this.toolServices.addEmNotificationListener(this);
                } else {
                    NexLog.logger().info(START_TIMER_THE_NEX_APPLICATION_STARTUP_TIME_CANNOT_BE_MEASURED);
                }
            }
        }

        public synchronized void notificationFromEM(EmEventInterface event) {
            NexLog.logger().fine("StartTimer: A notification has arrived");
            String type = event.getType();
            if (type.equals(NEX.VIEW_EXPANDED_NOTIFICATION)) {
                long currentTime = event.getTimestamp();
                long startupTime = currentTime - this.startTimeOfLauncher;
                NexLog.logger().info("StartTimer: NEX application startup time is: " + startupTime + " milliseconds.");
                NEX.this.toolServices.removeEmNotificationListener(this);
            }
        }
    }
}

