/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.nex.gui.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.logging.Level;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import se.ericsson.cello.nex.NexLog;
import se.ericsson.cello.nex.gui.view.NexTreeNode;

public class ViewElementCellRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = -2740551811404330292L;
    private Color sel_fg;
    private Color fg;
    private Font tableFont;

    public ViewElementCellRenderer(Color selectionForegroundColor, Color foregroundColor, Font aFont) {
        this.sel_fg = selectionForegroundColor;
        this.fg = foregroundColor;
        this.tableFont = aFont;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object obj, boolean is_selected, boolean is_expanded, boolean is_leaf, int row, boolean focus) {
        NexLog.logger().log(Level.FINEST, " obj= " + obj + "   getClass= " + obj.getClass());
        NexTreeNode node = (NexTreeNode)obj;
        if (node.isFolder()) {
            this.setLeafIcon(super.getDefaultClosedIcon());
            this.setClosedIcon(super.getDefaultClosedIcon());
            this.setOpenIcon(super.getDefaultOpenIcon());
        } else {
            this.setClosedIcon(null);
            this.setOpenIcon(null);
            this.setLeafIcon(null);
        }
        this.hasFocus = focus;
        this.setText(obj.toString());
        this.setEnabled(true);
        if (is_leaf) {
            this.setIcon(this.getLeafIcon());
        } else if (is_expanded) {
            this.setIcon(this.getOpenIcon());
        } else {
            this.setIcon(this.getClosedIcon());
        }
        this.setComponentOrientation(tree.getComponentOrientation());
        this.selected = is_selected;
        if (is_selected) {
            this.setOpaque(true);
            this.setForeground(this.sel_fg);
        } else {
            this.setOpaque(true);
            this.setForeground(this.fg);
        }
        boolean hasFetchedChildren = node.hasFetchedChildren();
        boolean leaf = !node.getAllowsChildren();
        Font aFont = this.getFont();
        if (null == aFont) {
            aFont = this.tableFont;
        }
        if (hasFetchedChildren || leaf) {
            if (aFont.getStyle() != 0) {
                this.setFont(aFont.deriveFont(0));
            }
        } else if (node.isPartiallyExpanded() && aFont.getStyle() != 2) {
            this.setFont(aFont.deriveFont(2));
        }
        return this;
    }
}

