/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.nex.viewservices.model;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.Action;
import se.ericsson.cello.nex.NexLog;
import se.ericsson.cello.nex.UI;
import se.ericsson.cello.nex.toolservices.ToolServicesI;

public class Task
implements Action {
    public static final int ACTION = 0;
    public static final int COMMAND = 1;
    public static final int TOOL = 2;
    private int type;
    private boolean enabled = true;
    private String cmdString = null;
    private Properties originalArguments = null;
    private HashMap<String, Object> map = new HashMap();
    private ToolServicesI toolServ;
    private boolean isResource;

    public Task(int actionType, String name, String commandString, Properties toolArguments, ToolServicesI toolServices) {
        this(actionType, name, commandString, false, toolArguments, toolServices);
    }

    public Task(int actionType, String name, String commandString, boolean isResource, Properties toolArguments, ToolServicesI toolServices) {
        this.type = actionType;
        this.cmdString = commandString;
        this.originalArguments = toolArguments;
        this.toolServ = toolServices;
        this.map.put("Name", name);
        this.isResource = isResource;
    }

    public String getCmdString() {
        return this.cmdString;
    }

    public String getName() {
        return (String)this.map.get("Name");
    }

    public int getType() {
        return this.type;
    }

    public Object getValue(String key) {
        return this.map.get(key);
    }

    public void putValue(String key, Object value) {
        this.map.put(key, value);
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }

    public void actionPerformed(ActionEvent event) {
        if (this.type == 1) {
            this.executeCommand();
        } else if (this.type == 0) {
            this.executeAction();
        } else if (this.type == 2) {
            this.executeTool();
        }
    }

    private void executeCommand() {
        try {
            NexLog.logger().info("Executing command" + this.cmdString);
            Runtime.getRuntime().exec(this.cmdString);
        }
        catch (Exception e) {
            NexLog.logger().warning("Failed to ececute the command: " + this.cmdString + "\n" + NexLog.stackToString(e));
        }
    }

    private void executeAction() {
        NexLog.logger().fine("Launching MO Properties to execute action" + this.cmdString);
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.originalArguments);
        props.put("MOACTION", this.cmdString);
        props.put("LDNs", this.getValue("LDNs"));
        try {
            this.toolServ.startMoPropsTool(props);
        }
        catch (Exception ex) {
            NexLog.logger().warning("Was not able to start MO Properties\n" + NexLog.stackToString(ex));
        }
    }

    private void executeTool() {
        block3: {
            Object ldnObj;
            NexLog.logger().info("Task will start tool " + this.cmdString);
            NexLog.logger().fine("Task executeTool LDNs in arguments:" + this.originalArguments.get("LDNs"));
            NexLog.logger().fine("Task executeTool LDNs in map:" + this.map.get("LDNs"));
            Properties props = new Properties();
            props.putAll((Map<?, ?>)this.originalArguments);
            if (null == this.originalArguments.get("LDNs") && null != (ldnObj = this.map.get("LDNs"))) {
                NexLog.logger().info("Task read argument LDNs: " + ldnObj);
                props.setProperty("LDNs", ldnObj.toString());
            }
            try {
                this.toolServ.startAnyTool(this.cmdString, props, this.isResource);
            }
            catch (Exception exep) {
                NexLog.logger().warning("Was not able to start the tool\n" + NexLog.stackToString(exep));
                UI theUI = this.toolServ.getUI();
                if (null == theUI) break block3;
                theUI.setMessage("Failed to start a tool", "The tool " + this.cmdString + " could not be started.", exep, false);
            }
        }
    }
}

