/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sctp;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.iptransport.IpAccessHostGpbMo;
import se.ericsson.cello.iptransport.IpAccessSctpMo;
import se.ericsson.cello.iptransport.SctpBuildIF;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.ConfigurationMismatchException;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.MaoFroTypeConverter;
import se.ericsson.cello.mao.MaxNumberExceededException;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.OperationNotAllowedException;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.maofro.framework.IllegalParameterValueException;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.framework.UnsignedIntParameter;
import se.ericsson.cello.maofro.proxy.MaoFroGenericEventInd;
import se.ericsson.cello.maofro.proxy.TagNameDictionaries;
import se.ericsson.cello.maofro.proxy.TagNameDictionary;
import se.ericsson.cello.maofro.proxy.TagNameDictionaryException;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.sctp.M3uAssociationBuildIF;
import se.ericsson.cello.sctp.M3uaLocalSpBuildIF;
import se.ericsson.cello.sctp.SctpAssociationMoFactory;
import se.ericsson.cello.sctp.SctpMo;
import se.ericsson.cello.sctp.SctpMoEnum;
import se.ericsson.cello.sctp.fropxy.IpacSctpMICreateFroCfm;
import se.ericsson.cello.sctp.fropxy.IpacSctpMIDeleteFroCfm;
import se.ericsson.cello.sctp.fropxy.IpacSctpMIGetFroAttributeCfm;
import se.ericsson.cello.sctp.fropxy.IpacSctpMIGetPmStatusCfm;
import se.ericsson.cello.sctp.fropxy.IpacSctpMISetFroAttributeCfm;
import se.ericsson.cello.sctp.fropxy.IpacSctpProxy;
import se.ericsson.cello.sctp.mom.EnumPathSelectionTypeCheck;
import se.ericsson.cello.sctp.mom.EnumSwitchbackModeTypeCheck;
import se.ericsson.cello.sctp.sctp_support_mi;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.swmanagement.ReliableProgramUniterMo;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionServiceImpl;

public class SctpMoImpl
extends CelloMao
implements SctpMo,
SctpMoEnum,
FroInfo,
SctpBuildIF {
    private MoData data;
    private StringAttribute userLabel;
    private SequenceAttribute reservedBy;
    private ReferenceAttribute ipAccessHostGpbId;
    private ReferenceAttribute ipAccessSctpRef;
    private ReferenceAttribute rpuId;
    private IntegerAttribute sctpFroId;
    private MaoFroIndicationHandler indications = null;
    private static final String SCTP_FRO_ID = "sctpFroId";
    private static final int SCTP_ASSOC_EVENT_CREATE = 1;
    private static final int BUNDLING_ACTIVATED_DEFAULT = 1;
    private static final int BUNDLING_ACTIVATED_MIN = 0;
    private static final int BUNDLING_ACTIVATED_MAX = 1;
    private static final int BUNDLING_TIMER_DEFAULT = 10;
    private static final int BUNDLING_TIMER_MIN = 0;
    private static final int BUNDLING_TIMER_MAX = 1000;
    private static final int NR_ASSOCIATIONS_DEFAULT = 0;
    private static final int NR_ASSOCIATIONS_MIN = 1;
    private static final int NR_ASSOCIATIONS_MAX = 512;
    private static final int MINIMUM_RTO_DEFAULT = 10;
    private static final int MINIMUM_RTO_MIN = 1;
    private static final int MINIMUM_RTO_MAX = 500;
    private static final int MAXIMUM_RTO_DEFAULT = 40;
    private static final int MAXIMUM_RTO_MIN = 1;
    private static final int MAXIMUM_RTO_MAX = 12000;
    private static final int INITIAL_RTO_DEFAULT = 20;
    private static final int INITIAL_RTO_MIN = 1;
    private static final int INITIAL_RTO_MAX = 12000;
    private static final int R2ALPHA_INDEX_DEFAULT = 3;
    private static final int R2ALPHA_INDEX_MIN = 1;
    private static final int R2ALPHA_INDEX_MAX = 4;
    private static final int R2BETA_INDEX_DEFAULT = 2;
    private static final int R2BETA_INDEX_MIN = 1;
    private static final int R2BETA_INDEX_MAX = 4;
    private static final int VALID_COOKIE_LIFE_DEFAULT = 60;
    private static final int VALID_COOKIE_LIFE_MIN = 1;
    private static final int VALID_COOKIE_LIFE_MAX = 180;
    private static final int ALLOWED_INCR_COOKIE_LIFE_DEFAULT = 30;
    private static final int ALLOWED_INCR_COOKIE_LIFE_MIN = 0;
    private static final int ALLOWED_INCR_COOKIE_LIFE_MAX = 180;
    private static final int KEY_CHANGE_PERIOD_DEFAULT = 4;
    private static final int KEY_CHANGE_PERIOD_MIN = 1;
    private static final int KEY_CHANGE_PERIOD_MAX = 180;
    private static final int ASSOCIATION_MAX_RTX_DEFAULT = 8;
    private static final int ASSOCIATION_MAX_RTX_MIN = 1;
    private static final int ASSOCIATION_MAX_RTX_MAX = 20;
    private static final int PATH_MAX_RTX_DEFAULT = 4;
    private static final int PATH_MAX_RTX_MIN = 1;
    private static final int PATH_MAX_RTX_MAX = 20;
    private static final int MAX_INITIAL_RTR_ATT_DEFAULT = 8;
    private static final int MAX_INITIAL_RTR_ATT_MIN = 1;
    private static final int MAX_INITIAL_RTR_ATT_MAX = 16;
    private static final int MAX_SHUT_DOWN_RTR_ATT_DEFAULT = 5;
    private static final int MAX_SHUT_DOWN_RTR_ATT_MIN = 1;
    private static final int MAX_SHUT_DOWN_RTR_ATT_MAX = 20;
    private static final int HEARTBEAT_INTERVAL_DEFAULT = 30;
    private static final int HEARTBEAT_INTERVAL_MIN = 1;
    private static final int HEARTBEAT_INTERVAL_MAX = 1800;
    private static final int MAX_INCOMING_STREAM_DEFAULT = 17;
    private static final int MAX_INCOMING_STREAM_MIN = 1;
    private static final int MAX_INCOMING_STREAM_MAX = 16384;
    private static final int MAX_USER_DATA_SIZE_DEFAULT = 1480;
    private static final int MAX_USER_DATA_SIZE_MIN = 508;
    private static final int MAX_USER_DATA_SIZE_MAX = 1480;
    private static final int M_BUFFER_DEFAULT = 256;
    private static final int M_BUFFER_MIN = 1;
    private static final int M_BUFFER_MAX = 2048;
    private static final int N_THRESHOLD_DEFAULT = 192;
    private static final int N_THRESHOLD_MIN = 1;
    private static final int N_THRESHOLD_MAX = 2048;
    private static final int MAX_DATA_SIZE_IP_DEFAULT = 1500;
    private static final int MAX_DATA_SIZE_IP_MIN = 1500;
    private static final int MAX_DATA_SIZE_IP_MAX = 65535;
    private static final int INITIAL_AD_REC_WIN_DEFAULT = 32768;
    private static final int INITIAL_AD_REC_WIN_MIN = 1500;
    private static final int INITIAL_AD_REC_WIN_MAX = 0x100000;
    private static final int INTERVAL_OOB_PKTS_DEFAULT = 3600;
    private static final int INTERVAL_OOB_PKTS_MIN = 1;
    private static final int INTERVAL_OOB_PKTS_MAX = 6500;
    private static final int INTERVAL_LOST_USER_DEFAULT = 0;
    private static final int INTERVAL_LOST_USER_MIN = 0;
    private static final int INTERVAL_LOST_USER_MAX = 3600;
    private static final int MAX_BURST_DEFAULT = 4;
    private static final int MAX_BURST_MIN = 1;
    private static final int MAX_BURST_MAX = 16384;
    private static final int N_PERCENTAGE_DEFAULT = 85;
    private static final int N_PERCENTAGE_MIN = 1;
    private static final int N_PERCENTAGE_MAX = 100;
    private static final int T_SACK_DEFAULT = 4;
    private static final int T_SACK_MIN = 0;
    private static final int T_SACK_MAX = 50;
    private static final int FACTOR_TEN = 10;
    private static final int FACTOR_THOUSAND = 1000;
    private static final int FACTOR_BYTES = 1024;
    private static final int DUMMY_MAX_NR_OOB_PKTS = 16384;
    public static final int MAX_OUTGOING_STREAM_DEFAULT = 17;
    public static final int MAX_OUTGOING_STREAM_MIN = 1;
    public static final int MAX_OUTGOING_STREAM_MAX = 16384;
    private static final int MO_DATA_REVISION_5000 = 5000;
    private static final int MO_DATA_REVISION_7000 = 7000;
    private static final int MO_DATA_REVISION_LATEST = 7000;
    private static TagNameDictionary sctpAssocTagNameDictionary = TagNameDictionaries.create((ResourceBundle)ResourceBundle.getBundle(sctp_support_mi.class.getName()));
    private SctpAssociationMoFactory sctpAssocFactory = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator, MaoFroIndicationHandler maoFroIndicationHandler, SctpAssociationMoFactory sctpAssociationMoFactory) throws MoAccessException {
        int n;
        MoAttributeValidator.checkIdentity((String)"Sctp", (String)string);
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"TransportNetwork");
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"Sctp", (int)128, (int)128);
        int n2 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"numberOfAssociations", (AttrList)attrList, (boolean)true, (int)0, (int)1, (int)512, (String)"Sctp");
        ManagedObject managedObject3 = MoAttributeValidator.checkAndGetReferenceAttribute((String)"ipAccessHostGpbId", (AttrList)attrList, (boolean)false, (String)"Sctp");
        ManagedObject managedObject4 = MoAttributeValidator.checkAndGetReferenceAttribute((String)"ipAccessSctpRef", (AttrList)attrList, (boolean)false, (String)"Sctp");
        if (managedObject3 != null && !(managedObject3 instanceof IpAccessHostGpbMo)) {
            throw new WrongAttributeTypeException("ipAccessHostGpbId", "Sctp");
        }
        if (managedObject4 != null && !(managedObject4 instanceof IpAccessSctpMo)) {
            throw new WrongAttributeTypeException("ipAccessSctpRef", "Sctp");
        }
        ManagedObject managedObject5 = MoAttributeValidator.checkAndGetReferenceAttribute((String)"rpuId", (AttrList)attrList, (boolean)true, (String)"Sctp");
        if (!(managedObject5 instanceof ReliableProgramUniterMo)) {
            throw new WrongAttributeTypeException("rpuId", "Sctp");
        }
        if (managedObject3 != null) {
            SctpMoImpl.checkRelatedSlot(managedObject3, managedObject5, coordinator);
        }
        int n3 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"minimumRto", (AttrList)attrList, (boolean)false, (int)10, (int)1, (int)500, (String)"Sctp");
        int n4 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"maximumRto", (AttrList)attrList, (boolean)false, (int)40, (int)1, (int)12000, (String)"Sctp");
        int n5 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"initialRto", (AttrList)attrList, (boolean)false, (int)20, (int)1, (int)12000, (String)"Sctp");
        if (n3 > n5 || n5 > n4) {
            throw new ValueOutOfRangeException("maximumRto must be larger than or equal to initialRto which in turn must be larger than or equal to minimumRto", "Sctp");
        }
        int n6 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"rtoAlphaIndex", (AttrList)attrList, (boolean)false, (int)3, (int)1, (int)4, (String)"Sctp");
        int n7 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"rtoBetaIndex", (AttrList)attrList, (boolean)false, (int)2, (int)1, (int)4, (String)"Sctp");
        int n8 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"validCookieLife", (AttrList)attrList, (boolean)false, (int)60, (int)1, (int)180, (String)"Sctp");
        int n9 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"allowedIncrementCookieLife", (AttrList)attrList, (boolean)false, (int)30, (int)0, (int)180, (String)"Sctp");
        int n10 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"keyChangePeriod", (AttrList)attrList, (boolean)false, (int)4, (int)1, (int)180, (String)"Sctp");
        int n11 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"associationMaxRtx", (AttrList)attrList, (boolean)false, (int)8, (int)1, (int)20, (String)"Sctp");
        if (n11 < (n = MoAttributeValidator.checkAndGetIntegerAttribute((String)"pathMaxRtx", (AttrList)attrList, (boolean)false, (int)4, (int)1, (int)20, (String)"Sctp"))) {
            throw new ValueOutOfRangeException("associationMaxRtx must be greater than or equal to pathMaxRtx", "Sctp");
        }
        int n12 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"maxInitialRtrAtt", (AttrList)attrList, (boolean)false, (int)8, (int)1, (int)16, (String)"Sctp");
        int n13 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"maxShutDownRtrAtt", (AttrList)attrList, (boolean)false, (int)5, (int)1, (int)20, (String)"Sctp");
        int n14 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"heartbeatInterval", (AttrList)attrList, (boolean)false, (int)30, (int)1, (int)1800, (String)"Sctp");
        boolean bl = MoAttributeValidator.checkAndGetBooleanAttribute((String)"heartbeatStatus", (AttrList)attrList, (boolean)false, (boolean)true, (String)"Sctp");
        int n15 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"maxIncomingStream", (AttrList)attrList, (boolean)false, (int)17, (int)1, (int)16384, (String)"Sctp");
        int n16 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"maxOutgoingStream", (AttrList)attrList, (boolean)false, (int)17, (int)1, (int)16384, (String)"Sctp");
        int n17 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"maxUserDataSize", (AttrList)attrList, (boolean)false, (int)1480, (int)508, (int)1480, (String)"Sctp");
        int n18 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"mBuffer", (AttrList)attrList, (boolean)false, (int)256, (int)1, (int)2048, (String)"Sctp");
        int n19 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"nThreshold", (AttrList)attrList, (boolean)false, (int)192, (int)1, (int)2048, (String)"Sctp");
        int n20 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"maxDataSizeIp", (AttrList)attrList, (boolean)false, (int)1500, (int)1500, (int)65535, (String)"Sctp");
        n20 = 1500;
        int n21 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"initialAdRecWin", (AttrList)attrList, (boolean)false, (int)32768, (int)1500, (int)0x100000, (String)"Sctp");
        int n22 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"intervalOobPkts", (AttrList)attrList, (boolean)false, (int)3600, (int)1, (int)6500, (String)"Sctp");
        int n23 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"intervalLostUser", (AttrList)attrList, (boolean)false, (int)0, (int)0, (int)3600, (String)"Sctp");
        int n24 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"maxBurst", (AttrList)attrList, (boolean)false, (int)4, (int)1, (int)16384, (String)"Sctp");
        int n25 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"nPercentage", (AttrList)attrList, (boolean)false, (int)85, (int)1, (int)100, (String)"Sctp");
        int n26 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"tSack", (AttrList)attrList, (boolean)false, (int)4, (int)0, (int)50, (String)"Sctp");
        int n27 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"bundlingActivated", (AttrList)attrList, (boolean)false, (int)1, (int)0, (int)1, (String)"Sctp");
        int n28 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"bundlingTimer", (AttrList)attrList, (boolean)false, (int)10, (int)0, (int)1000, (String)"Sctp");
        int n29 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"heartbeatMaxBurst", (AttrList)attrList, (boolean)false, (int)0, (int)0, (int)4, (String)"Sctp");
        int n30 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"heartbeatPathProbingInterval", (AttrList)attrList, (boolean)false, (int)500, (int)1, (int)180000, (String)"Sctp");
        if (n30 < n4 || n30 > n14 * 100) {
            throw new ValueOutOfRangeException("heartbeatPathProbingInterval value must be greater than or equal to maximumRto and less than or equal to 100 times of heartbeatInterval", "Sctp");
        }
        int n31 = MoAttributeValidator.checkAndGetEnumAttribute((String)"pathSelection", (AttrList)attrList, (boolean)false, (int)1, (int[])EnumPathSelectionTypeCheck.VALUES_ARRAY, (String)"Sctp");
        int n32 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"sctpAssocDeleteTimeout", (AttrList)attrList, (boolean)false, (int)168, (int)1, (int)168, (String)"Sctp");
        int n33 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"switchbackMinThreshold", (AttrList)attrList, (boolean)false, (int)1, (int)1, (int)65535, (String)"Sctp");
        int n34 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"switchbackMaxThreshold", (AttrList)attrList, (boolean)false, (int)65535, (int)1, (int)65535, (String)"Sctp");
        if (n34 < n33) {
            throw new ValueOutOfRangeException("switchbackMaxThreshold must be greater than or equal to switchbackMinThreshold", "Sctp");
        }
        int n35 = SctpMoImpl.checkandGetPotentiallyFailedMaxRtx("potentiallyFailedMaxRtx", attrList, n, 0, 0, 20, "Sctp");
        int n36 = MoAttributeValidator.checkAndGetEnumAttribute((String)"switchbackMode", (AttrList)attrList, (boolean)false, (int)0, (int[])EnumSwitchbackModeTypeCheck.VALUES_ARRAY, (String)"Sctp");
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"Sctp");
        if (managedObject3 != null && managedObject4 != null) {
            throw new OperationNotAllowedException("IpAccessHostGpbId and IpAccessSctpRef can not both have values", "Sctp");
        }
        return new SctpMoImpl(managedObject, string, string2, n2, managedObject5, managedObject3, managedObject4, n3, n4, n5, n6, n7, n8, n9, n10, n11, n, n12, n13, n14, bl, n15, n16, n17, n18, n19, n20, n21, n22, n23, n24, n25, n26, n27, n28, n29, n30, n31, n32, n33, n34, n35, n36, coordinator, maoFroIndicationHandler, sctpAssociationMoFactory);
    }

    private SctpMoImpl(ManagedObject managedObject, String string, String string2, int n, ManagedObject managedObject2, ManagedObject managedObject3, ManagedObject managedObject4, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, boolean bl, int n15, int n16, int n17, int n18, int n19, int n20, int n21, int n22, int n23, int n24, int n25, int n26, int n27, int n28, int n29, int n30, int n31, int n32, int n33, int n34, int n35, int n36, Coordinator coordinator, MaoFroIndicationHandler maoFroIndicationHandler, SctpAssociationMoFactory sctpAssociationMoFactory) throws MoAccessException {
        super(managedObject, "Sctp", string, coordinator);
        IpacSctpMICreateFroCfm ipacSctpMICreateFroCfm;
        this.sctpAssocFactory = sctpAssociationMoFactory;
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.userLabel = new StringAttribute("userLabel", true, string2);
        this.data.registerPersistentAttr((Attribute)this.userLabel);
        this.reservedBy = new SequenceAttribute("reservedBy", false);
        this.data.registerPersistentAttr((Attribute)this.reservedBy);
        this.ipAccessHostGpbId = new ReferenceAttribute("ipAccessHostGpbId", false, managedObject3);
        this.data.registerPersistentAttr((Attribute)this.ipAccessHostGpbId);
        this.ipAccessSctpRef = new ReferenceAttribute("ipAccessSctpRef", false, managedObject4);
        this.data.registerPersistentAttr((Attribute)this.ipAccessSctpRef);
        this.rpuId = new ReferenceAttribute("rpuId", false, managedObject2);
        this.data.registerPersistentAttr((Attribute)this.rpuId);
        int n37 = 0;
        if (managedObject3 != null) {
            ((Reservable)managedObject3).reserve((ManagedObject)this, coordinator);
            n37 = ((FroInfo)managedObject3).getFroId(coordinator);
        }
        int n38 = 0;
        if (managedObject4 != null) {
            ((Reservable)managedObject4).reserve((ManagedObject)this, coordinator);
            n38 = ((FroInfo)managedObject4).getFroId(coordinator);
        }
        int n39 = 0;
        if (managedObject2 != null) {
            ((Reservable)managedObject2).reserve((ManagedObject)this, coordinator);
            n39 = (int)((ReliableProgramUniterMo)managedObject2).getRpuId(coordinator);
        }
        if ((ipacSctpMICreateFroCfm = IpacSctpProxy.instance().sendIpacSctpMICreateFroReq(coordinator.getTransactionID(), n39, n37, n38, n, n2 * 10, n3 * 10, n4 * 10, n5, n6, n7 * 1000, n8 * 1000, n9 * 1000, n10, n11, n12, n13, n14 * 1000, MaoFroTypeConverter.boolean2int((boolean)bl), n15, n16, n17, n18 * 1024, n19 * 1024, n20, n21, n22 * 1000, n23 * 1000, n24, n25, n26 * 10, n27, n28, n29, n30, n31, n32, n33, n34, n35, n36)) == null) {
            throw new FroNotAccessibleException("Sctp", "createFroReqFailed");
        }
        if (ipacSctpMICreateFroCfm.getResult() != 0) {
            throw new FroRequestFailedException("Sctp", "Sctp", "CreateFroReq: " + IpacSctpProxy.instance().getResultMsg(ipacSctpMICreateFroCfm.getResult()), ipacSctpMICreateFroCfm.getResult());
        }
        int n40 = ipacSctpMICreateFroCfm.getFroId();
        this.sctpFroId = new IntegerAttribute(SCTP_FRO_ID, false, n40);
        this.data.registerPersistentAttr((Attribute)this.sctpFroId);
        this.data.setRevision(7000);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.indications = maoFroIndicationHandler;
        maoFroIndicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, n40);
    }

    public SctpMoImpl(MoData moData, MaoFroIndicationHandler maoFroIndicationHandler, SctpAssociationMoFactory sctpAssociationMoFactory) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(7000);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("ipAccessHostGpbId");
        moDataRecoveryHelper.assertAttribute("ipAccessSctpRef");
        moDataRecoveryHelper.assertAttribute("reservedBy");
        moDataRecoveryHelper.assertAttribute("rpuId");
        moDataRecoveryHelper.assertAttribute(SCTP_FRO_ID);
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
        this.reservedBy = (SequenceAttribute)moData.getAttribute("reservedBy");
        this.ipAccessHostGpbId = (ReferenceAttribute)moData.getAttribute("ipAccessHostGpbId");
        this.ipAccessSctpRef = (ReferenceAttribute)moData.getAttribute("ipAccessSctpRef");
        this.rpuId = (ReferenceAttribute)moData.getAttribute("rpuId");
        this.sctpFroId = (IntegerAttribute)moData.getAttribute(SCTP_FRO_ID);
        this.indications = maoFroIndicationHandler;
        maoFroIndicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, this.sctpFroId.getValue(null));
        this.sctpAssocFactory = sctpAssociationMoFactory;
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject;
        ManagedObject managedObject2;
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (!this.reservedBy.isEmpty()) {
            throw new MoReservedNotDeletableException("Sctp");
        }
        ManagedObject managedObject3 = (ManagedObject)this.getAttribute("ipAccessHostGpbId", coordinator);
        if (managedObject3 instanceof Reservable) {
            ((Reservable)managedObject3).release((ManagedObject)this, coordinator);
        }
        if ((managedObject2 = (ManagedObject)this.getAttribute("ipAccessSctpRef", coordinator)) instanceof Reservable) {
            ((Reservable)managedObject2).release((ManagedObject)this, coordinator);
        }
        if ((managedObject = (ManagedObject)this.getAttribute("rpuId", coordinator)) instanceof Reservable) {
            ((Reservable)managedObject).release((ManagedObject)this, coordinator);
        }
        this.deleteSctpChildren(coordinator);
        IpacSctpMIDeleteFroCfm ipacSctpMIDeleteFroCfm = IpacSctpProxy.instance().sendIpacSctpMIDeleteFroReq(coordinator.getTransactionID(), this.sctpFroId.getValue(coordinator));
        if (ipacSctpMIDeleteFroCfm == null) {
            throw new FroNotAccessibleException("Sctp", "deleteFroReqFailed");
        }
        if (ipacSctpMIDeleteFroCfm.getResult() != 0) {
            throw new FroRequestFailedException("Sctp", "Sctp", "DeleteFroReq: " + IpacSctpProxy.instance().getResultMsg(ipacSctpMIDeleteFroCfm.getResult()), ipacSctpMIDeleteFroCfm.getResult());
        }
        super.delete(coordinator);
        this.data.delete(coordinator);
        this.indications.deregisterForNotifications(coordinator, this.sctpFroId.getValue(coordinator));
    }

    private void deleteSctpChildren(Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject = null;
        MoIterator moIterator = this.getChildren();
        while (moIterator.hasMoreElements()) {
            managedObject = moIterator.nextMo();
            if (!managedObject.getType().equals("SctpAssociation")) continue;
            managedObject.delete(coordinator);
        }
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        Object object;
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        boolean bl = managedObject instanceof M3uAssociationBuildIF;
        boolean bl2 = managedObject instanceof M3uaLocalSpBuildIF;
        if (bl || bl2) {
            Object[] objectArray = this.getAttributes(new String[]{"ipAccessHostGpbId", "ipAccessSctpRef"}, coordinator);
            object = objectArray[0];
            IpAccessSctpMo ipAccessSctpMo = (IpAccessSctpMo)objectArray[1];
            if (object == null) {
                if (ipAccessSctpMo == null) {
                    throw new OperationNotAllowedException("Either ipAccessSctpRef or ipAccessHostGpbId must be set on this instance before you can reserve it with M3uAssociation or M3uaLocalSp", "Sctp");
                }
                if (ipAccessSctpMo.getPortDistribution(coordinator)) {
                    throw new OperationNotAllowedException("ipAccessSctpRef.portDistribution must be false in order to reserve this instance with M3uAssociation/M3uaLocalSp", "Sctp");
                }
            }
        }
        if (bl) {
            int n = (Integer)this.getAttribute("numberOfAssociations", coordinator);
            object = this.getReservedBy(coordinator);
            int n2 = 0;
            for (int i = 0; i < ((ManagedObject[])object).length; ++i) {
                if (!(object[i] instanceof M3uAssociationBuildIF)) continue;
                ++n2;
            }
            if (n2 >= n) {
                throw new MaxNumberExceededException("Max number of references handled by thisSctp MO has already been reached.", "Sctp");
            }
        }
        this.reservedBy = ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (String)"Sctp", (MoData)this.data, (SequenceAttribute)this.reservedBy);
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.reservedBy = ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (String)"Sctp", (MoData)this.data, (SequenceAttribute)this.reservedBy);
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        int n;
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = -1;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = -1;
        int n10 = -1;
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].equalsIgnoreCase("associationMaxRtx")) {
                n3 = (Integer)objectArray[n];
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("pathMaxRtx")) {
                n4 = (Integer)objectArray[n];
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("maximumRto")) {
                n7 = (Integer)objectArray[n];
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("minimumRto")) {
                n8 = (Integer)objectArray[n];
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("potentiallyFailedMaxRtx")) {
                n5 = (Integer)objectArray[n];
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("switchbackMinThreshold")) {
                n9 = (Integer)objectArray[n];
                continue;
            }
            if (!stringArray[n].equalsIgnoreCase("switchbackMaxThreshold")) continue;
            n10 = (Integer)objectArray[n];
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].equalsIgnoreCase("userLabel")) {
                if (!objectArray[n].getClass().equals(class$java$lang$String == null ? SctpMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("userLabel", "Sctp");
                }
                String string = (String)objectArray[n];
                MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"Sctp", (int)128, (int)0);
                this.userLabel.setValue(string);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("minimumRto")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? SctpMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("minimumRto", "Sctp");
                }
                n2 = (Integer)objectArray[n];
                MoAttributeValidator.checkIntegerAttribute((String)"minimumRto", (int)n2, (int)1, (int)500, (String)"Sctp");
                int n11 = (Integer)this.getAttribute("initialRto", coordinator);
                int n12 = (Integer)this.getAttribute("maximumRto", coordinator);
                if (n6 > 0 ? n2 > n6 : n2 > n11) {
                    throw new ValueOutOfRangeException("minimumRtomust be smaller than or equal toinitialRto", "Sctp");
                }
                if (n7 > 0 ? n2 > n7 : n2 > n12) {
                    throw new ValueOutOfRangeException("minimumRtomust be smaller than or equal to maximumRto", "Sctp");
                }
                this.setAttributeValueToFroProxy(coordinator, 1, 1, n2 * 10);
                String[] stringArray2 = new String[]{"minimumRto"};
                Object[] objectArray2 = new Object[]{new Integer(n2)};
                SctpMoImpl.sendChangeNotification(this, stringArray2, objectArray2, coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("maximumRto")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? SctpMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("maximumRto", "Sctp");
                }
                n2 = (Integer)objectArray[n];
                MoAttributeValidator.checkIntegerAttribute((String)"maximumRto", (int)n2, (int)1, (int)12000, (String)"Sctp");
                int n13 = (Integer)this.getAttribute("initialRto", coordinator);
                int n14 = (Integer)this.getAttribute("minimumRto", coordinator);
                if (n8 > 0 ? n2 < n8 : n2 < n14) {
                    throw new ValueOutOfRangeException("maximumRtomust be larger than or equal to minimumRto", "Sctp");
                }
                if (n6 > 0 ? n2 < n6 : n2 < n13) {
                    throw new ValueOutOfRangeException("maximumRtomust be larger than or equal to initialRto", "Sctp");
                }
                this.setAttributeValueToFroProxy(coordinator, 1, 2, n2 * 10);
                String[] stringArray3 = new String[]{"maximumRto"};
                Object[] objectArray3 = new Object[]{new Integer(n2)};
                SctpMoImpl.sendChangeNotification(this, stringArray3, objectArray3, coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("initialRto")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? SctpMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("initialRto", "Sctp");
                }
                n2 = (Integer)objectArray[n];
                int n15 = (Integer)this.getAttribute("maximumRto", coordinator);
                int n16 = (Integer)this.getAttribute("minimumRto", coordinator);
                if (n8 > 0 ? n2 < n8 : n2 < n16) {
                    throw new ValueOutOfRangeException("initialRtomust be larger than or equal tominimumRto", "Sctp");
                }
                if (n7 > 0 ? n2 > n7 : n2 > n15) {
                    throw new ValueOutOfRangeException("initialRtomust be smaller than or equal to maximumRto", "Sctp");
                }
                MoAttributeValidator.checkIntegerAttribute((String)"initialRto", (int)n2, (int)1, (int)12000, (String)"Sctp");
                this.setAttributeValueToFroProxy(coordinator, 1, 3, n2 * 10);
                String[] stringArray4 = new String[]{"initialRto"};
                Object[] objectArray4 = new Object[]{new Integer(n2)};
                SctpMoImpl.sendChangeNotification(this, stringArray4, objectArray4, coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("rtoAlphaIndex")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? SctpMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("rtoAlphaIndex", "Sctp");
                }
                n2 = (Integer)objectArray[n];
                MoAttributeValidator.checkIntegerAttribute((String)"rtoAlphaIndex", (int)n2, (int)1, (int)4, (String)"Sctp");
                this.setAttributeValueToFroProxy(coordinator, 1, 4, n2);
                String[] stringArray5 = new String[]{"rtoAlphaIndex"};
                Object[] objectArray5 = new Object[]{new Integer(n2)};
                SctpMoImpl.sendChangeNotification(this, stringArray5, objectArray5, coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("rtoBetaIndex")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? SctpMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("rtoBetaIndex", "Sctp");
                }
                n2 = (Integer)objectArray[n];
                MoAttributeValidator.checkIntegerAttribute((String)"rtoBetaIndex", (int)n2, (int)1, (int)4, (String)"Sctp");
                this.setAttributeValueToFroProxy(coordinator, 1, 5, n2);
                String[] stringArray6 = new String[]{"rtoBetaIndex"};
                Object[] objectArray6 = new Object[]{new Integer(n2)};
                SctpMoImpl.sendChangeNotification(this, stringArray6, objectArray6, coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("validCookieLife")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? SctpMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("validCookieLife", "Sctp");
                }
                n2 = (Integer)objectArray[n];
                MoAttributeValidator.checkIntegerAttribute((String)"validCookieLife", (int)n2, (int)1, (int)180, (String)"Sctp");
                this.setAttributeValueToFroProxy(coordinator, 1, 6, n2 * 1000);
                String[] stringArray7 = new String[]{"validCookieLife"};
                Object[] objectArray7 = new Object[]{new Integer(n2)};
                SctpMoImpl.sendChangeNotification(this, stringArray7, objectArray7, coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("allowedIncrementCookieLife")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? SctpMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("allowedIncrementCookieLife", "Sctp");
                }
                n2 = (Integer)objectArray[n];
                MoAttributeValidator.checkIntegerAttribute((String)"allowedIncrementCookieLife", (int)n2, (int)0, (int)180, (String)"Sctp");
                this.setAttributeValueToFroProxy(coordinator, 1, 7, n2 * 1000);
                String[] stringArray8 = new String[]{"allowedIncrementCookieLife"};
                Object[] objectArray8 = new Object[]{new Integer(n2)};
                SctpMoImpl.sendChangeNotification(this, stringArray8, objectArray8, coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("keyChangePeriod")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? SctpMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("keyChangePeriod", "Sctp");
                }
                n2 = (Integer)objectArray[n];
                MoAttributeValidator.checkIntegerAttribute((String)"keyChangePeriod", (int)n2, (int)1, (int)180, (String)"Sctp");
                this.setAttributeValueToFroProxy(coordinator, 1, 8, n2 * 1000);
                String[] stringArray9 = new String[]{"keyChangePeriod"};
                Object[] objectArray9 = new Object[]{new Integer(n2)};
                SctpMoImpl.sendChangeNotification(this, stringArray9, objectArray9, coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("associationMaxRtx")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? SctpMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("associationMaxRtx", "Sctp");
                }
                n2 = (Integer)objectArray[n];
                MoAttributeValidator.checkIntegerAttribute((String)"associationMaxRtx", (int)n2, (int)1, (int)20, (String)"Sctp");
                if (n3 != 0 && n4 != 0) {
                    if (n3 < n4) {
                        throw new ValueOutOfRangeException("associationMaxRtx must be greater than or equal to pathMaxRtx", "Sctp");
                    }
                    this.setAttributeValueToFroProxy(coordinator, 1, 9, n2);
                } else {
                    int n17 = (Integer)this.getAttribute("pathMaxRtx", coordinator);
                    if (n2 < n17) {
                        throw new ValueOutOfRangeException("associationMaxRtx must be greater than or equal to pathMaxRtx", "Sctp");
                    }
                    this.setAttributeValueToFroProxy(coordinator, 1, 9, n2);
                }
                String[] stringArray10 = new String[]{"associationMaxRtx"};
                Object[] objectArray10 = new Object[]{new Integer(n2)};
                SctpMoImpl.sendChangeNotification(this, stringArray10, objectArray10, coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("pathMaxRtx")) {
                int n18;
                int n19;
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? SctpMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("pathMaxRtx", "Sctp");
                }
                n2 = (Integer)objectArray[n];
                MoAttributeValidator.checkIntegerAttribute((String)"pathMaxRtx", (int)n2, (int)1, (int)20, (String)"Sctp");
                if (n3 != 0 && n4 != 0 ? n3 < n4 : n2 > (n19 = ((Integer)this.getAttribute("associationMaxRtx", coordinator)).intValue())) {
                    throw new ValueOutOfRangeException("associationMaxRtx must be greater than or equal to pathMaxRtx", "Sctp");
                }
                if (n5 != -1 && n4 != 0 ? n5 > n4 : n2 < (n18 = ((Integer)this.getAttribute("potentiallyFailedMaxRtx", coordinator)).intValue())) {
                    throw new ValueOutOfRangeException("pathMaxRtx must be greater than or equal to potentiallyFailedMaxRtx", "Sctp");
                }
                this.setAttributeValueToFroProxy(coordinator, 1, 10, n2);
                String[] stringArray11 = new String[]{"pathMaxRtx"};
                Object[] objectArray11 = new Object[]{new Integer(n2)};
                SctpMoImpl.sendChangeNotification(this, stringArray11, objectArray11, coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("sctpAssocDeleteTimeout")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? SctpMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("sctpAssocDeleteTimeout", "Sctp");
                }
                n2 = (Integer)objectArray[n];
                MoAttributeValidator.checkIntegerAttribute((String)"sctpAssocDeleteTimeout", (int)n2, (int)1, (int)168, (String)"Sctp");
                this.setAttributeValueToFroProxy(coordinator, 1, 38, n2);
                String[] stringArray12 = new String[]{"sctpAssocDeleteTimeout"};
                Object[] objectArray12 = new Object[]{new Integer(n2)};
                SctpMoImpl.sendChangeNotification(this, stringArray12, objectArray12, coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("potentiallyFailedMaxRtx")) {
                int n20;
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? SctpMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("potentiallyFailedMaxRtx", "Sctp");
                }
                n2 = (Integer)objectArray[n];
                MoAttributeValidator.checkIntegerAttribute((String)"potentiallyFailedMaxRtx", (int)n2, (int)0, (int)20, (String)"Sctp");
                if (n5 != -1 && n4 != 0 ? n5 > n4 : n2 > (n20 = ((Integer)this.getAttribute("pathMaxRtx", coordinator)).intValue())) {
                    throw new ValueOutOfRangeException("pathMaxRtx must be greater than or equal to potentiallyFailedMaxRtx", "Sctp");
                }
                this.setAttributeValueToFroProxy(coordinator, 1, 41, n2);
                String[] stringArray13 = new String[]{"pathMaxRtx"};
                Object[] objectArray13 = new Object[]{new Integer(n2)};
                SctpMoImpl.sendChangeNotification(this, stringArray13, objectArray13, coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("maxInitialRtrAtt")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? SctpMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("maxInitialRtrAtt", "Sctp");
                }
                n2 = (Integer)objectArray[n];
                MoAttributeValidator.checkIntegerAttribute((String)"maxInitialRtrAtt", (int)n2, (int)1, (int)16, (String)"Sctp");
                this.setAttributeValueToFroProxy(coordinator, 1, 11, n2);
                String[] stringArray14 = new String[]{"maxInitialRtrAtt"};
                Object[] objectArray14 = new Object[]{new Integer(n2)};
                SctpMoImpl.sendChangeNotification(this, stringArray14, objectArray14, coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("maxShutDownRtrAtt")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? SctpMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("maxShutDownRtrAtt", "Sctp");
                }
                n2 = (Integer)objectArray[n];
                MoAttributeValidator.checkIntegerAttribute((String)"maxShutDownRtrAtt", (int)n2, (int)1, (int)20, (String)"Sctp");
                this.setAttributeValueToFroProxy(coordinator, 1, 12, n2);
                String[] stringArray15 = new String[]{"maxShutDownRtrAtt"};
                Object[] objectArray15 = new Object[]{new Integer(n2)};
                SctpMoImpl.sendChangeNotification(this, stringArray15, objectArray15, coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("heartbeatInterval")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? SctpMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("heartbeatInterval", "Sctp");
                }
                n2 = (Integer)objectArray[n];
                MoAttributeValidator.checkIntegerAttribute((String)"heartbeatInterval", (int)n2, (int)1, (int)1800, (String)"Sctp");
                this.setAttributeValueToFroProxy(coordinator, 1, 13, n2 * 1000);
                String[] stringArray16 = new String[]{"heartbeatInterval"};
                Object[] objectArray16 = new Object[]{new Integer(n2)};
                SctpMoImpl.sendChangeNotification(this, stringArray16, objectArray16, coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("heartbeatStatus")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Boolean == null ? SctpMoImpl.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                    throw new WrongAttributeTypeException("heartbeatStatus", "Sctp");
                }
                boolean bl = (Boolean)objectArray[n];
                this.setAttributeValueToFroProxy(coordinator, 1, 14, MaoFroTypeConverter.boolean2int((boolean)bl));
                String[] stringArray17 = new String[]{"heartbeatStatus"};
                Object[] objectArray17 = new Object[]{new Boolean(bl)};
                SctpMoImpl.sendChangeNotification(this, stringArray17, objectArray17, coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("maxIncomingStream")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? SctpMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("maxIncomingStream", "Sctp");
                }
                n2 = (Integer)objectArray[n];
                MoAttributeValidator.checkIntegerAttribute((String)"maxIncomingStream", (int)n2, (int)1, (int)16384, (String)"Sctp");
                this.setAttributeValueToFroProxy(coordinator, 1, 15, n2);
                String[] stringArray18 = new String[]{"maxIncomingStream"};
                Object[] objectArray18 = new Object[]{new Integer(n2)};
                SctpMoImpl.sendChangeNotification(this, stringArray18, objectArray18, coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("maxOutgoingStream")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? SctpMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("maxOutgoingStream", "Sctp");
                }
                n2 = (Integer)objectArray[n];
                MoAttributeValidator.checkIntegerAttribute((String)"maxOutgoingStream", (int)n2, (int)1, (int)16384, (String)"Sctp");
                this.setAttributeValueToFroProxy(coordinator, 1, 16, n2);
                String[] stringArray19 = new String[]{"maxOutgoingStream"};
                Object[] objectArray19 = new Object[]{new Integer(n2)};
                SctpMoImpl.sendChangeNotification(this, stringArray19, objectArray19, coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("maxUserDataSize")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? SctpMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("maxUserDataSize", "Sctp");
                }
                n2 = (Integer)objectArray[n];
                MoAttributeValidator.checkIntegerAttribute((String)"maxUserDataSize", (int)n2, (int)508, (int)1480, (String)"Sctp");
                this.setAttributeValueToFroProxy(coordinator, 1, 17, n2);
                String[] stringArray20 = new String[]{"maxUserDataSize"};
                Object[] objectArray20 = new Object[]{new Integer(n2)};
                SctpMoImpl.sendChangeNotification(this, stringArray20, objectArray20, coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("mBuffer")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? SctpMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("mBuffer", "Sctp");
                }
                n2 = (Integer)objectArray[n];
                MoAttributeValidator.checkIntegerAttribute((String)"mBuffer", (int)n2, (int)1, (int)2048, (String)"Sctp");
                this.setAttributeValueToFroProxy(coordinator, 1, 18, n2 * 1024);
                String[] stringArray21 = new String[]{"mBuffer"};
                Object[] objectArray21 = new Object[]{new Integer(n2)};
                SctpMoImpl.sendChangeNotification(this, stringArray21, objectArray21, coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("nThreshold")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? SctpMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("nThreshold", "Sctp");
                }
                n2 = (Integer)objectArray[n];
                MoAttributeValidator.checkIntegerAttribute((String)"nThreshold", (int)n2, (int)1, (int)2048, (String)"Sctp");
                this.setAttributeValueToFroProxy(coordinator, 1, 19, n2 * 1024);
                String[] stringArray22 = new String[]{"nThreshold"};
                Object[] objectArray22 = new Object[]{new Integer(n2)};
                SctpMoImpl.sendChangeNotification(this, stringArray22, objectArray22, coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("maxDataSizeIp")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? SctpMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("maxDataSizeIp", "Sctp");
                }
                n2 = (Integer)objectArray[n];
                MoAttributeValidator.checkIntegerAttribute((String)"maxDataSizeIp", (int)n2, (int)1500, (int)65535, (String)"Sctp");
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("initialAdRecWin")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? SctpMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("initialAdRecWin", "Sctp");
                }
                n2 = (Integer)objectArray[n];
                MoAttributeValidator.checkIntegerAttribute((String)"initialAdRecWin", (int)n2, (int)1500, (int)0x100000, (String)"Sctp");
                this.setAttributeValueToFroProxy(coordinator, 1, 21, n2);
                String[] stringArray23 = new String[]{"initialAdRecWin"};
                Object[] objectArray23 = new Object[]{new Integer(n2)};
                SctpMoImpl.sendChangeNotification(this, stringArray23, objectArray23, coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("intervalOobPkts")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? SctpMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("intervalOobPkts", "Sctp");
                }
                n2 = (Integer)objectArray[n];
                MoAttributeValidator.checkIntegerAttribute((String)"intervalOobPkts", (int)n2, (int)1, (int)6500, (String)"Sctp");
                this.setAttributeValueToFroProxy(coordinator, 1, 23, n2 * 1000);
                String[] stringArray24 = new String[]{"intervalOobPkts"};
                Object[] objectArray24 = new Object[]{new Integer(n2)};
                SctpMoImpl.sendChangeNotification(this, stringArray24, objectArray24, coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("intervalLostUser")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? SctpMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("intervalLostUser", "Sctp");
                }
                n2 = (Integer)objectArray[n];
                MoAttributeValidator.checkIntegerAttribute((String)"intervalLostUser", (int)n2, (int)0, (int)3600, (String)"Sctp");
                this.setAttributeValueToFroProxy(coordinator, 1, 24, n2 * 1000);
                String[] stringArray25 = new String[]{"intervalLostUser"};
                Object[] objectArray25 = new Object[]{new Integer(n2)};
                SctpMoImpl.sendChangeNotification(this, stringArray25, objectArray25, coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("maxBurst")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? SctpMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("maxBurst", "Sctp");
                }
                n2 = (Integer)objectArray[n];
                MoAttributeValidator.checkIntegerAttribute((String)"maxBurst", (int)n2, (int)1, (int)16384, (String)"Sctp");
                this.setAttributeValueToFroProxy(coordinator, 1, 25, n2);
                String[] stringArray26 = new String[]{"maxBurst"};
                Object[] objectArray26 = new Object[]{new Integer(n2)};
                SctpMoImpl.sendChangeNotification(this, stringArray26, objectArray26, coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("nPercentage")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? SctpMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("nPercentage", "Sctp");
                }
                n2 = (Integer)objectArray[n];
                MoAttributeValidator.checkIntegerAttribute((String)"nPercentage", (int)n2, (int)1, (int)100, (String)"Sctp");
                this.setAttributeValueToFroProxy(coordinator, 1, 26, n2);
                String[] stringArray27 = new String[]{"nPercentage"};
                Object[] objectArray27 = new Object[]{new Integer(n2)};
                SctpMoImpl.sendChangeNotification(this, stringArray27, objectArray27, coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("tSack")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? SctpMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("tSack", "Sctp");
                }
                n2 = (Integer)objectArray[n];
                MoAttributeValidator.checkIntegerAttribute((String)"tSack", (int)n2, (int)0, (int)50, (String)"Sctp");
                this.setAttributeValueToFroProxy(coordinator, 1, 30, n2 * 10);
                String[] stringArray28 = new String[]{"tSack"};
                Object[] objectArray28 = new Object[]{new Integer(n2)};
                SctpMoImpl.sendChangeNotification(this, stringArray28, objectArray28, coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("bundlingActivated")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? SctpMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("bundlingActivated", "Sctp");
                }
                n2 = (Integer)objectArray[n];
                MoAttributeValidator.checkIntegerAttribute((String)"bundlingActivated", (int)n2, (int)0, (int)1, (String)"Sctp");
                this.setAttributeValueToFroProxy(coordinator, 1, 31, n2);
                String[] stringArray29 = new String[]{"bundlingActivated"};
                Object[] objectArray29 = new Object[]{new Integer(n2)};
                SctpMoImpl.sendChangeNotification(this, stringArray29, objectArray29, coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("bundlingTimer")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? SctpMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("bundlingTimer", "Sctp");
                }
                n2 = (Integer)objectArray[n];
                MoAttributeValidator.checkIntegerAttribute((String)"bundlingTimer", (int)n2, (int)0, (int)1000, (String)"Sctp");
                this.setAttributeValueToFroProxy(coordinator, 1, 32, n2);
                String[] stringArray30 = new String[]{"bundlingTimer"};
                Object[] objectArray30 = new Object[]{new Integer(n2)};
                SctpMoImpl.sendChangeNotification(this, stringArray30, objectArray30, coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("heartbeatMaxBurst")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? SctpMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("heartbeatMaxBurst", "Sctp");
                }
                n2 = (Integer)objectArray[n];
                MoAttributeValidator.checkIntegerAttribute((String)"heartbeatMaxBurst", (int)n2, (int)0, (int)4, (String)"Sctp");
                this.setAttributeValueToFroProxy(coordinator, 1, 35, n2);
                String[] stringArray31 = new String[]{"heartbeatMaxBurst"};
                Object[] objectArray31 = new Object[]{new Integer(n2)};
                SctpMoImpl.sendChangeNotification(this, stringArray31, objectArray31, coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("heartbeatPathProbingInterval")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? SctpMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("heartbeatPathProbingInterval", "Sctp");
                }
                n2 = (Integer)objectArray[n];
                MoAttributeValidator.checkIntegerAttribute((String)"heartbeatPathProbingInterval", (int)n2, (int)1, (int)180000, (String)"Sctp");
                int n21 = (Integer)this.getAttribute("maximumRto", coordinator);
                int n22 = (Integer)this.getAttribute("heartbeatInterval", coordinator);
                if (n2 < n21 || n2 > n22 * 100) {
                    throw new ValueOutOfRangeException("heartbeatPathProbingInterval value must be greater than or equal tomaximumRto and less than or equal to 100 times of heartbeatInterval", "Sctp");
                }
                this.setAttributeValueToFroProxy(coordinator, 1, 36, n2);
                String[] stringArray32 = new String[]{"heartbeatPathProbingInterval"};
                Object[] objectArray32 = new Object[]{new Integer(n2)};
                SctpMoImpl.sendChangeNotification(this, stringArray32, objectArray32, coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("pathSelection")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? SctpMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("pathSelection", "Sctp");
                }
                n2 = (Integer)objectArray[n];
                MoAttributeValidator.checkIntegerAttribute((String)"pathSelection", (int)n2, (int)0, (int)2, (String)"Sctp");
                this.setAttributeValueToFroProxy(coordinator, 1, 37, n2);
                String[] stringArray33 = new String[]{"pathSelection"};
                Object[] objectArray33 = new Object[]{new Integer(n2)};
                SctpMoImpl.sendChangeNotification(this, stringArray33, objectArray33, coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("switchbackMode")) {
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? SctpMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("switchbackMode", "Sctp");
                }
                n2 = (Integer)objectArray[n];
                MoAttributeValidator.checkEnumAttribute((String)"switchbackMode", (int)n2, (int[])EnumSwitchbackModeTypeCheck.VALUES_ARRAY, (String)"Sctp");
                this.setAttributeValueToFroProxy(coordinator, 1, 42, n2);
                String[] stringArray34 = new String[]{"switchbackMode"};
                Object[] objectArray34 = new Object[]{new Integer(n2)};
                SctpMoImpl.sendChangeNotification(this, stringArray34, objectArray34, coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("ipAccessHostGpbId")) {
                if (objectArray[n] == null) {
                    ManagedObject[] managedObjectArray = this.getReservedBy(coordinator);
                    boolean bl = false;
                    for (int i = 0; i < managedObjectArray.length; ++i) {
                        if (!(managedObjectArray[i] instanceof M3uAssociationBuildIF)) continue;
                        bl = true;
                    }
                    if (bl) {
                        throw new OperationNotAllowedException("set ipAccessHostGpbId with null is not allowed", "Sctp");
                    }
                    ManagedObject managedObject = this.getIpAccessHostGpbId(coordinator);
                    if (managedObject != null && managedObject instanceof Reservable) {
                        ((Reservable)managedObject).release((ManagedObject)this, coordinator);
                    }
                    this.ipAccessHostGpbId.setValue((ManagedObject)objectArray[n]);
                    this.setAttributeValueToFroProxy(coordinator, 1, 33, 0);
                    continue;
                }
                if (!(objectArray[n] instanceof IpAccessHostGpbMo)) {
                    throw new WrongAttributeTypeException("ipAccessHostGpbId", "Sctp");
                }
                n2 = ((FroInfo)objectArray[n]).getFroId(coordinator);
                ManagedObject managedObject = this.getIpAccessHostGpbId(coordinator);
                if (this.getIpAccessSctpRef(coordinator) != null) {
                    throw new OperationNotAllowedException("set ipAccessHostGpbId not allowed", "Sctp");
                }
                ManagedObject[] managedObjectArray = this.getReservedBy(coordinator);
                boolean bl = false;
                for (int i = 0; i < managedObjectArray.length; ++i) {
                    if (!(managedObjectArray[i] instanceof M3uAssociationBuildIF)) continue;
                    bl = true;
                }
                if (bl && managedObject == null) {
                    throw new OperationNotAllowedException("set ipAccessHostGpbId not allowed", "Sctp");
                }
                if (managedObject != null && managedObject instanceof Reservable) {
                    ((Reservable)managedObject).release((ManagedObject)this, coordinator);
                }
                this.ipAccessHostGpbId.setValue((ManagedObject)objectArray[n]);
                this.setAttributeValueToFroProxy(coordinator, 1, 33, n2);
                ((Reservable)objectArray[n]).reserve((ManagedObject)this, coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("ipAccessSctpRef")) {
                if (objectArray[n] == null) {
                    ManagedObject managedObject = this.getIpAccessSctpRef(coordinator);
                    if (managedObject != null && managedObject instanceof Reservable) {
                        ((Reservable)managedObject).release((ManagedObject)this, coordinator);
                    }
                    this.ipAccessSctpRef.setValue((ManagedObject)objectArray[n]);
                    this.setAttributeValueToFroProxy(coordinator, 1, 34, 0);
                    continue;
                }
                if (!(objectArray[n] instanceof IpAccessSctpMo)) {
                    throw new WrongAttributeTypeException("ipAccessSctpRef", "Sctp");
                }
                n2 = ((FroInfo)objectArray[n]).getFroId(coordinator);
                ManagedObject managedObject = this.getIpAccessSctpRef(coordinator);
                if (this.getIpAccessHostGpbId(coordinator) != null) {
                    throw new OperationNotAllowedException("set ipAccessSctpRef not allowed", "Sctp");
                }
                if (managedObject != null && managedObject instanceof Reservable) {
                    ((Reservable)managedObject).release((ManagedObject)this, coordinator);
                }
                this.ipAccessSctpRef.setValue((ManagedObject)objectArray[n]);
                this.setAttributeValueToFroProxy(coordinator, 1, 34, n2);
                ((Reservable)objectArray[n]).reserve((ManagedObject)this, coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("switchbackMinThreshold")) {
                int n23;
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? SctpMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("switchbackMinThreshold", "Sctp");
                }
                n2 = (Integer)objectArray[n];
                MoAttributeValidator.checkIntegerAttribute((String)"switchbackMinThreshold", (int)n2, (int)1, (int)65535, (String)"Sctp");
                if (n9 != -1 && n10 != -1 ? n9 > n10 : n2 > (n23 = ((Integer)this.getAttribute("switchbackMaxThreshold", coordinator)).intValue())) {
                    throw new ValueOutOfRangeException("switchbackMaxThreshold must be greater than or equal to switchbackMinThreshold", "Sctp");
                }
                this.setAttributeValueToFroProxy(coordinator, 1, 39, n2);
                String[] stringArray35 = new String[]{"switchbackMinThreshold"};
                Object[] objectArray35 = new Object[]{new Integer(n2)};
                SctpMoImpl.sendChangeNotification(this, stringArray35, objectArray35, coordinator);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("switchbackMaxThreshold")) {
                int n24;
                if (!objectArray[n].getClass().equals(class$java$lang$Integer == null ? SctpMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("switchbackMaxThreshold", "Sctp");
                }
                n2 = (Integer)objectArray[n];
                MoAttributeValidator.checkIntegerAttribute((String)"switchbackMaxThreshold", (int)n2, (int)1, (int)65535, (String)"Sctp");
                if (n9 != -1 && n10 != -1 ? n9 > n10 : n2 < (n24 = ((Integer)this.getAttribute("switchbackMinThreshold", coordinator)).intValue())) {
                    throw new ValueOutOfRangeException("switchbackMaxThreshold must be greater than or equal to switchbackMinThreshold", "Sctp");
                }
                this.setAttributeValueToFroProxy(coordinator, 1, 40, n2);
                String[] stringArray36 = new String[]{"switchbackMaxThreshold"};
                Object[] objectArray36 = new Object[]{new Integer(n2)};
                SctpMoImpl.sendChangeNotification(this, stringArray36, objectArray36, coordinator);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[n], "Sctp");
        }
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException {
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        IpacSctpMIGetPmStatusCfm ipacSctpMIGetPmStatusCfm = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("allowedIncrementCookieLife")) {
                objectArray[i] = new Integer(this.getAttributeValueFromFroProxy(coordinator, 7) / 1000);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("associationMaxRtx")) {
                objectArray[i] = new Integer(this.getAttributeValueFromFroProxy(coordinator, 9));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("availabilityStatus")) {
                objectArray[i] = new Integer(this.getAttributeValueFromFroProxy(coordinator, 29));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("bundlingActivated")) {
                objectArray[i] = new Integer(this.getAttributeValueFromFroProxy(coordinator, 31));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("bundlingTimer")) {
                objectArray[i] = new Integer(this.getAttributeValueFromFroProxy(coordinator, 32));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("heartbeatMaxBurst")) {
                objectArray[i] = new Integer(this.getAttributeValueFromFroProxy(coordinator, 35));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("heartbeatPathProbingInterval")) {
                objectArray[i] = new Integer(this.getAttributeValueFromFroProxy(coordinator, 36));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pathSelection")) {
                objectArray[i] = new Integer(this.getAttributeValueFromFroProxy(coordinator, 37));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("switchbackMode")) {
                objectArray[i] = new Integer(this.getAttributeValueFromFroProxy(coordinator, 42));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("heartbeatInterval")) {
                objectArray[i] = new Integer(this.getAttributeValueFromFroProxy(coordinator, 13) / 1000);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("heartbeatStatus")) {
                boolean bl = MaoFroTypeConverter.int2boolean((int)this.getAttributeValueFromFroProxy(coordinator, 14));
                objectArray[i] = new Boolean(bl);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("initialAdRecWin")) {
                objectArray[i] = new Integer(this.getAttributeValueFromFroProxy(coordinator, 21));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("initialRto")) {
                objectArray[i] = new Integer(this.getAttributeValueFromFroProxy(coordinator, 3) / 10);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("intervalLostUser")) {
                objectArray[i] = new Integer(this.getAttributeValueFromFroProxy(coordinator, 24) / 1000);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("intervalOobPkts")) {
                objectArray[i] = new Integer(this.getAttributeValueFromFroProxy(coordinator, 23) / 1000);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("keyChangePeriod")) {
                objectArray[i] = new Integer(this.getAttributeValueFromFroProxy(coordinator, 8) / 1000);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("maxBurst")) {
                objectArray[i] = new Integer(this.getAttributeValueFromFroProxy(coordinator, 25));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("maxDataSizeIp")) {
                objectArray[i] = new Integer(this.getAttributeValueFromFroProxy(coordinator, 20));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("maximumRto")) {
                objectArray[i] = new Integer(this.getAttributeValueFromFroProxy(coordinator, 2) / 10);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("maxIncomingStream")) {
                objectArray[i] = new Integer(this.getAttributeValueFromFroProxy(coordinator, 15));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("maxInitialRtrAtt")) {
                objectArray[i] = new Integer(this.getAttributeValueFromFroProxy(coordinator, 11));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("maxOutgoingStream")) {
                objectArray[i] = new Integer(this.getAttributeValueFromFroProxy(coordinator, 16));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("maxShutDownRtrAtt")) {
                objectArray[i] = new Integer(this.getAttributeValueFromFroProxy(coordinator, 12));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("maxUserDataSize")) {
                objectArray[i] = new Integer(this.getAttributeValueFromFroProxy(coordinator, 17));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("mBuffer")) {
                objectArray[i] = new Integer(this.getAttributeValueFromFroProxy(coordinator, 18) / 1024);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("minimumRto")) {
                objectArray[i] = new Integer(this.getAttributeValueFromFroProxy(coordinator, 1) / 10);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("nPercentage")) {
                objectArray[i] = new Integer(this.getAttributeValueFromFroProxy(coordinator, 26));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("nThreshold")) {
                objectArray[i] = new Integer(this.getAttributeValueFromFroProxy(coordinator, 19) / 1024);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("numberOfAssociations")) {
                objectArray[i] = new Integer(this.getAttributeValueFromFroProxy(coordinator, 0));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("operationalState")) {
                objectArray[i] = new Integer(this.getAttributeValueFromFroProxy(coordinator, 27));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pathMaxRtx")) {
                objectArray[i] = new Integer(this.getAttributeValueFromFroProxy(coordinator, 10));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("potentiallyFailedMaxRtx")) {
                objectArray[i] = new Integer(this.getAttributeValueFromFroProxy(coordinator, 41));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("switchbackMinThreshold")) {
                objectArray[i] = new Integer(this.getAttributeValueFromFroProxy(coordinator, 39));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("switchbackMaxThreshold")) {
                objectArray[i] = new Integer(this.getAttributeValueFromFroProxy(coordinator, 40));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("sctpAssocDeleteTimeout")) {
                objectArray[i] = new Integer(this.getAttributeValueFromFroProxy(coordinator, 38));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ipAccessHostGpbId")) {
                objectArray[i] = ((ReferenceAttribute)this.data.getAttribute("ipAccessHostGpbId")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ipAccessSctpRef")) {
                objectArray[i] = ((ReferenceAttribute)this.data.getAttribute("ipAccessSctpRef")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmSctpAborted")) {
                ipacSctpMIGetPmStatusCfm = this.getPmAttributeValueFromFroProxy(coordinator, ipacSctpMIGetPmStatusCfm);
                objectArray[i] = new Integer(ipacSctpMIGetPmStatusCfm.getPmSctpAborted());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmSctpActiveEstab")) {
                ipacSctpMIGetPmStatusCfm = this.getPmAttributeValueFromFroProxy(coordinator, ipacSctpMIGetPmStatusCfm);
                objectArray[i] = new Integer(ipacSctpMIGetPmStatusCfm.getPmSctpActiveEstab());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmSctpCurrEstab")) {
                ipacSctpMIGetPmStatusCfm = this.getPmAttributeValueFromFroProxy(coordinator, ipacSctpMIGetPmStatusCfm);
                objectArray[i] = new Integer(ipacSctpMIGetPmStatusCfm.getPmSctpCurrEstab());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmSctpPassiveEstab")) {
                ipacSctpMIGetPmStatusCfm = this.getPmAttributeValueFromFroProxy(coordinator, ipacSctpMIGetPmStatusCfm);
                objectArray[i] = new Integer(ipacSctpMIGetPmStatusCfm.getPmSctpPassiveEstab());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmSctpShutdowns")) {
                ipacSctpMIGetPmStatusCfm = this.getPmAttributeValueFromFroProxy(coordinator, ipacSctpMIGetPmStatusCfm);
                objectArray[i] = new Integer(ipacSctpMIGetPmStatusCfm.getPmSctpShutdowns());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmSctpStatAssocOutOfBlue")) {
                ipacSctpMIGetPmStatusCfm = this.getPmAttributeValueFromFroProxy(coordinator, ipacSctpMIGetPmStatusCfm);
                objectArray[i] = new Integer(ipacSctpMIGetPmStatusCfm.getPmSctpStatAssocOutOfBlue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmSctpStatChecksumErrorCounter")) {
                ipacSctpMIGetPmStatusCfm = this.getPmAttributeValueFromFroProxy(coordinator, ipacSctpMIGetPmStatusCfm);
                objectArray[i] = new Integer(ipacSctpMIGetPmStatusCfm.getPmSctpStatChecksumErrorCounter());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmSctpStatCommResume")) {
                ipacSctpMIGetPmStatusCfm = this.getPmAttributeValueFromFroProxy(coordinator, ipacSctpMIGetPmStatusCfm);
                objectArray[i] = new Integer(ipacSctpMIGetPmStatusCfm.getPmSctpStatCommResume());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmSctpStatCommStop")) {
                ipacSctpMIGetPmStatusCfm = this.getPmAttributeValueFromFroProxy(coordinator, ipacSctpMIGetPmStatusCfm);
                objectArray[i] = new Integer(ipacSctpMIGetPmStatusCfm.getPmSctpStatCommStop());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmSctpStatFragmentedUserMsg")) {
                ipacSctpMIGetPmStatusCfm = this.getPmAttributeValueFromFroProxy(coordinator, ipacSctpMIGetPmStatusCfm);
                objectArray[i] = new Integer(ipacSctpMIGetPmStatusCfm.getPmSctpStatFragmentedUserMsg());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmSctpStatOutOfOrderRecChunks")) {
                ipacSctpMIGetPmStatusCfm = this.getPmAttributeValueFromFroProxy(coordinator, ipacSctpMIGetPmStatusCfm);
                objectArray[i] = new Integer(ipacSctpMIGetPmStatusCfm.getPmSctpStatOutOfOrderRecChunks());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmSctpStatOutOfOrderSendChunks")) {
                ipacSctpMIGetPmStatusCfm = this.getPmAttributeValueFromFroProxy(coordinator, ipacSctpMIGetPmStatusCfm);
                objectArray[i] = new Integer(ipacSctpMIGetPmStatusCfm.getPmSctpStatOutOfOrderSendChunks());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmSctpStatReassembledUserMsg")) {
                ipacSctpMIGetPmStatusCfm = this.getPmAttributeValueFromFroProxy(coordinator, ipacSctpMIGetPmStatusCfm);
                objectArray[i] = new Integer(ipacSctpMIGetPmStatusCfm.getPmSctpStatReassembledUserMsg());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmSctpStatRecChunks")) {
                ipacSctpMIGetPmStatusCfm = this.getPmAttributeValueFromFroProxy(coordinator, ipacSctpMIGetPmStatusCfm);
                objectArray[i] = new Integer(ipacSctpMIGetPmStatusCfm.getPmSctpStatRecChunks());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmSctpStatRecChunksDropped")) {
                ipacSctpMIGetPmStatusCfm = this.getPmAttributeValueFromFroProxy(coordinator, ipacSctpMIGetPmStatusCfm);
                objectArray[i] = new Integer(ipacSctpMIGetPmStatusCfm.getPmSctpStatRecChunksDropped());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmSctpStatReceivedControlChunks")) {
                ipacSctpMIGetPmStatusCfm = this.getPmAttributeValueFromFroProxy(coordinator, ipacSctpMIGetPmStatusCfm);
                objectArray[i] = new Integer(ipacSctpMIGetPmStatusCfm.getPmSctpStatReceivedControlChunks());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmSctpStatReceivedPackages")) {
                ipacSctpMIGetPmStatusCfm = this.getPmAttributeValueFromFroProxy(coordinator, ipacSctpMIGetPmStatusCfm);
                objectArray[i] = new Integer(ipacSctpMIGetPmStatusCfm.getPmSctpStatReceivedPackages());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmSctpStatRetransChunks")) {
                ipacSctpMIGetPmStatusCfm = this.getPmAttributeValueFromFroProxy(coordinator, ipacSctpMIGetPmStatusCfm);
                objectArray[i] = new Integer(ipacSctpMIGetPmStatusCfm.getPmSctpStatRetransChunks());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmSctpStatSentChunks")) {
                ipacSctpMIGetPmStatusCfm = this.getPmAttributeValueFromFroProxy(coordinator, ipacSctpMIGetPmStatusCfm);
                objectArray[i] = new Integer(ipacSctpMIGetPmStatusCfm.getPmSctpStatSentChunks());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmSctpStatSentChunksDropped")) {
                ipacSctpMIGetPmStatusCfm = this.getPmAttributeValueFromFroProxy(coordinator, ipacSctpMIGetPmStatusCfm);
                objectArray[i] = new Integer(ipacSctpMIGetPmStatusCfm.getPmSctpStatSentChunksDropped());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmSctpStatSentControlChunks")) {
                ipacSctpMIGetPmStatusCfm = this.getPmAttributeValueFromFroProxy(coordinator, ipacSctpMIGetPmStatusCfm);
                objectArray[i] = new Integer(ipacSctpMIGetPmStatusCfm.getPmSctpStatSentControlChunks());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmSctpStatSentPackages")) {
                ipacSctpMIGetPmStatusCfm = this.getPmAttributeValueFromFroProxy(coordinator, ipacSctpMIGetPmStatusCfm);
                objectArray[i] = new Integer(ipacSctpMIGetPmStatusCfm.getPmSctpStatSentPackages());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmSctpInNoPorts")) {
                ipacSctpMIGetPmStatusCfm = this.getPmAttributeValueFromFroProxy(coordinator, ipacSctpMIGetPmStatusCfm);
                objectArray[i] = new Integer(ipacSctpMIGetPmStatusCfm.getPmSctpInNoPorts());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmSctpInErrors")) {
                ipacSctpMIGetPmStatusCfm = this.getPmAttributeValueFromFroProxy(coordinator, ipacSctpMIGetPmStatusCfm);
                objectArray[i] = new Integer(ipacSctpMIGetPmStatusCfm.getPmSctpInErrors());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("reservedBy")) {
                objectArray[i] = ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)this.reservedBy, (Coordinator)coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("rpuId")) {
                objectArray[i] = this.rpuId.getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("rtoAlphaIndex")) {
                objectArray[i] = new Integer(this.getAttributeValueFromFroProxy(coordinator, 4));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("rtoBetaIndex")) {
                objectArray[i] = new Integer(this.getAttributeValueFromFroProxy(coordinator, 5));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("SctpId")) {
                objectArray[i] = this.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("tSack")) {
                objectArray[i] = new Integer(this.getAttributeValueFromFroProxy(coordinator, 30) / 10);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = this.userLabel.getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("validCookieLife")) {
                objectArray[i] = new Integer(this.getAttributeValueFromFroProxy(coordinator, 6) / 1000);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "Sctp");
        }
        return objectArray;
    }

    private int[] getAttributeArrayFromFroProxy(Coordinator coordinator, int n) throws MoAccessException {
        IpacSctpMIGetFroAttributeCfm ipacSctpMIGetFroAttributeCfm;
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        int n2 = 0;
        if (coordinator != null) {
            n2 = coordinator.getTransactionID();
        }
        if ((ipacSctpMIGetFroAttributeCfm = IpacSctpProxy.instance().sendIpacSctpMIGetFroAttributeReq(n2, this.sctpFroId.getValue(coordinator), n)) == null) {
            throw new FroNotAccessibleException("Sctp", "getAttributeValueFromFroProxy");
        }
        if (ipacSctpMIGetFroAttributeCfm.getResult() != 0) {
            throw new FroRequestFailedException("Sctp", "Sctp", "GetAttrReq: " + IpacSctpProxy.instance().getResultMsg(ipacSctpMIGetFroAttributeCfm.getResult()), ipacSctpMIGetFroAttributeCfm.getResult());
        }
        return ipacSctpMIGetFroAttributeCfm.getAttrArray();
    }

    private int getAttributeValueFromFroProxy(Coordinator coordinator, int n) throws MoAccessException {
        int[] nArray = this.getAttributeArrayFromFroProxy(coordinator, n);
        int n2 = nArray[0];
        return n2;
    }

    private void setAttributeValueToFroProxy(Coordinator coordinator, int n, int n2, int n3) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        int[] nArray = new int[]{n3};
        IpacSctpMISetFroAttributeCfm ipacSctpMISetFroAttributeCfm = IpacSctpProxy.instance().sendIpacSctpMISetFroAttributeReq(coordinator.getTransactionID(), this.sctpFroId.getValue(coordinator), n, n2, nArray.length * 4, nArray);
        if (ipacSctpMISetFroAttributeCfm == null) {
            throw new FroNotAccessibleException("Sctp", "setAttributeValueFromFroProxy");
        }
        if (ipacSctpMISetFroAttributeCfm.getResult() != 0) {
            throw new FroRequestFailedException("Sctp", "Sctp", "SetAttrReq: " + IpacSctpProxy.instance().getResultMsg(ipacSctpMISetFroAttributeCfm.getResult()), ipacSctpMISetFroAttributeCfm.getResult());
        }
    }

    private IpacSctpMIGetPmStatusCfm getPmAttributeValueFromFroProxy(Coordinator coordinator, IpacSctpMIGetPmStatusCfm ipacSctpMIGetPmStatusCfm) throws MoAccessException {
        if (ipacSctpMIGetPmStatusCfm == null) {
            int n = 0;
            if (coordinator != null) {
                n = coordinator.getTransactionID();
            }
            if ((ipacSctpMIGetPmStatusCfm = IpacSctpProxy.instance().sendIpacSctpMIGetPmStatusReq(n, this.sctpFroId.getValue(coordinator), 0)) == null) {
                throw new FroNotAccessibleException("Sctp", "getPmAttributeValueFromFroProxy");
            }
            if (ipacSctpMIGetPmStatusCfm.getResult() == 100) {
                ipacSctpMIGetPmStatusCfm.setPmCountersUnavailable();
            } else if (ipacSctpMIGetPmStatusCfm.getResult() != 0) {
                throw new FroRequestFailedException("Sctp", "Sctp", "GetPmCountersReq: " + IpacSctpProxy.instance().getResultMsg(ipacSctpMIGetPmStatusCfm.getResult()), ipacSctpMIGetPmStatusCfm.getResult());
            }
        }
        return ipacSctpMIGetPmStatusCfm;
    }

    private static void sendChangeNotification(ManagedObject managedObject, String[] stringArray, Object[] objectArray, Coordinator coordinator) {
        NotificationSender.instance().pushAVC(managedObject, stringArray, objectArray, coordinator);
    }

    public String getType() {
        return "Sctp";
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.sctpFroId.getValue(coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("operationalState", coordinator);
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("availabilityStatus", coordinator);
    }

    public int getPathSelection(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pathSelection", coordinator);
    }

    public void setPathSelection(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("pathSelection", new Integer(n), coordinator);
    }

    public int getSwitchbackMode(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("switchbackMode", coordinator);
    }

    public void setSwitchbackMode(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("switchbackMode", new Integer(n), coordinator);
    }

    public int getHeartbeatMaxBurst(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("heartbeatMaxBurst", coordinator);
    }

    public void setHeartbeatMaxBurst(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("heartbeatMaxBurst", new Integer(n), coordinator);
    }

    public int getHeartbeatPathProbingInterval(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("heartbeatPathProbingInterval", coordinator);
    }

    public void setHeartbeatPathProbingInterval(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("heartbeatPathProbingInterval", new Integer(n), coordinator);
    }

    public String getSctpId(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("SctpId", coordinator);
    }

    public int getNumberOfAssociations(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("numberOfAssociations", coordinator);
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject[])this.getAttribute("reservedBy", coordinator);
    }

    public ManagedObject getIpAccessHostGpbId(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("ipAccessHostGpbId", coordinator);
    }

    public int getMinimumRto(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("minimumRto", coordinator);
    }

    public void setMinimumRto(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("minimumRto", new Integer(n), coordinator);
    }

    public int getMaximumRto(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("maximumRto", coordinator);
    }

    public void setMaximumRto(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("maximumRto", new Integer(n), coordinator);
    }

    public int getInitialRto(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("initialRto", coordinator);
    }

    public void setInitialRto(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("initialRto", new Integer(n), coordinator);
    }

    public int getRtoAlphaIndex(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("rtoAlphaIndex", coordinator);
    }

    public void setRtoAlphaIndex(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("rtoAlphaIndex", new Integer(n), coordinator);
    }

    public int getRtoBetaIndex(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("rtoBetaIndex", coordinator);
    }

    public void setRtoBetaIndex(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("rtoBetaIndex", new Integer(n), coordinator);
    }

    public int getValidCookieLife(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("validCookieLife", coordinator);
    }

    public void setValidCookieLife(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("validCookieLife", new Integer(n), coordinator);
    }

    public int getAllowedIncrementCookieLife(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("allowedIncrementCookieLife", coordinator);
    }

    public void setAllowedIncrementCookieLife(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("allowedIncrementCookieLife", new Integer(n), coordinator);
    }

    public int getKeyChangePeriod(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("keyChangePeriod", coordinator);
    }

    public void setKeyChangePeriod(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("keyChangePeriod", new Integer(n), coordinator);
    }

    public int getAssociationMaxRtx(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("associationMaxRtx", coordinator);
    }

    public void setAssociationMaxRtx(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("associationMaxRtx", new Integer(n), coordinator);
    }

    public int getPathMaxRtx(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pathMaxRtx", coordinator);
    }

    public void setPathMaxRtx(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("pathMaxRtx", new Integer(n), coordinator);
    }

    public int getPotentiallyFailedMaxRtx(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("potentiallyFailedMaxRtx", coordinator);
    }

    public void setPotentiallyFailedMaxRtx(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("potentiallyFailedMaxRtx", new Integer(n), coordinator);
    }

    public int getSwitchbackMinThreshold(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("switchbackMinThreshold", coordinator);
    }

    public void setSwitchbackMinThreshold(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("switchbackMinThreshold", new Integer(n), coordinator);
    }

    public int getSwitchbackMaxThreshold(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("switchbackMaxThreshold", coordinator);
    }

    public void setSwitchbackMaxThreshold(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("switchbackMaxThreshold", new Integer(n), coordinator);
    }

    public int getMaxInitialRtrAtt(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("maxInitialRtrAtt", coordinator);
    }

    public void setMaxInitialRtrAtt(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("maxInitialRtrAtt", new Integer(n), coordinator);
    }

    public int getMaxShutDownRtrAtt(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("maxShutDownRtrAtt", coordinator);
    }

    public void setMaxShutDownRtrAtt(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("maxShutDownRtrAtt", new Integer(n), coordinator);
    }

    public int getHeartbeatInterval(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("heartbeatInterval", coordinator);
    }

    public void setHeartbeatInterval(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("heartbeatInterval", new Integer(n), coordinator);
    }

    public boolean getHeartbeatStatus(Coordinator coordinator) throws MoAccessException {
        return (Boolean)this.getAttribute("heartbeatStatus", coordinator);
    }

    public void setHeartbeatStatus(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("heartbeatStatus", new Boolean(bl), coordinator);
    }

    public int getMaxIncomingStream(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("maxIncomingStream", coordinator);
    }

    public void setMaxIncomingStream(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("maxIncomingStream", new Integer(n), coordinator);
    }

    public int getMaxOutgoingStream(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("maxOutgoingStream", coordinator);
    }

    public void setMaxOutgoingStream(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("maxOutgoingStream", new Integer(n), coordinator);
    }

    public int getMaxUserDataSize(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("maxUserDataSize", coordinator);
    }

    public void setMaxUserDataSize(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("maxUserDataSize", new Integer(n), coordinator);
    }

    public int getMBuffer(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("mBuffer", coordinator);
    }

    public int getSctpAssocDeleteTimeout(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("sctpAssocDeleteTimeout", coordinator);
    }

    public void setSctpAssocDeleteTimeout(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("sctpAssocDeleteTimeout", new Integer(n), coordinator);
    }

    public void setMBuffer(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("mBuffer", new Integer(n), coordinator);
    }

    public int getNThreshold(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("nThreshold", coordinator);
    }

    public void setNThreshold(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("nThreshold", new Integer(n), coordinator);
    }

    public int getTSack(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("tSack", coordinator);
    }

    public void setTSack(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("tSack", new Integer(n), coordinator);
    }

    public int getMaxDataSizeIp(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("maxDataSizeIp", coordinator);
    }

    public void setMaxDataSizeIp(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("maxDataSizeIp", new Integer(n), coordinator);
    }

    public int getInitialAdRecWin(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("initialAdRecWin", coordinator);
    }

    public void setInitialAdRecWin(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("initialAdRecWin", new Integer(n), coordinator);
    }

    public int getIntervalOobPkts(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("intervalOobPkts", coordinator);
    }

    public void setIntervalOobPkts(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("intervalOobPkts", new Integer(n), coordinator);
    }

    public int getIntervalLostUser(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("intervalLostUser", coordinator);
    }

    public void setIntervalLostUser(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("intervalLostUser", new Integer(n), coordinator);
    }

    public int getMaxBurst(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("maxBurst", coordinator);
    }

    public void setMaxBurst(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("maxBurst", new Integer(n), coordinator);
    }

    public int getNPercentage(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("nPercentage", coordinator);
    }

    public void setNPercentage(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("nPercentage", new Integer(n), coordinator);
    }

    public int getBundlingActivated(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("bundlingActivated", coordinator);
    }

    public void setBundlingActivated(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("bundlingActivated", new Integer(n), coordinator);
    }

    public int getBundlingTimer(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("bundlingTimer", coordinator);
    }

    public void setBundlingTimer(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("bundlingTimer", new Integer(n), coordinator);
    }

    public void setIpAccessHostGpbId(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("ipAccessHostGpbId", managedObject, coordinator);
    }

    public ManagedObject getIpAccessSctpRef(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("ipAccessSctpRef", coordinator);
    }

    public void setIpAccessSctpRef(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("ipAccessSctpRef", managedObject, coordinator);
    }

    public int getPmSctpCurrEstab(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmSctpCurrEstab", coordinator);
    }

    public int getPmSctpActiveEstab(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmSctpActiveEstab", coordinator);
    }

    public int getPmSctpPassiveEstab(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmSctpPassiveEstab", coordinator);
    }

    public int getPmSctpAborted(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmSctpAborted", coordinator);
    }

    public int getPmSctpShutdowns(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmSctpShutdowns", coordinator);
    }

    public int getPmSctpStatAssocOutOfBlue(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmSctpStatAssocOutOfBlue", coordinator);
    }

    public int getPmSctpStatSentChunks(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmSctpStatSentChunks", coordinator);
    }

    public int getPmSctpStatRecChunks(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmSctpStatRecChunks", coordinator);
    }

    public int getPmSctpStatOutOfOrderSendChunks(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmSctpStatOutOfOrderSendChunks", coordinator);
    }

    public int getPmSctpStatOutOfOrderRecChunks(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmSctpStatOutOfOrderRecChunks", coordinator);
    }

    public int getPmSctpStatChecksumErrorCounter(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmSctpStatChecksumErrorCounter", coordinator);
    }

    public int getPmSctpStatRetransChunks(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmSctpStatRetransChunks", coordinator);
    }

    public int getPmSctpStatSentControlChunks(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmSctpStatSentControlChunks", coordinator);
    }

    public int getPmSctpStatReceivedControlChunks(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmSctpStatReceivedControlChunks", coordinator);
    }

    public int getPmSctpStatFragmentedUserMsg(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmSctpStatFragmentedUserMsg", coordinator);
    }

    public int getPmSctpStatReassembledUserMsg(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmSctpStatReassembledUserMsg", coordinator);
    }

    public int getPmSctpStatSentPackages(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmSctpStatSentPackages", coordinator);
    }

    public int getPmSctpStatReceivedPackages(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmSctpStatReceivedPackages", coordinator);
    }

    public int getPmSctpStatCommStop(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmSctpStatCommStop", coordinator);
    }

    public int getPmSctpStatCommResume(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmSctpStatCommResume", coordinator);
    }

    public int getPmSctpStatSentChunksDropped(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmSctpStatSentChunksDropped", coordinator);
    }

    public int getPmSctpStatRecChunksDropped(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmSctpStatRecChunksDropped", coordinator);
    }

    public int getPmSctpInNoPorts(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmSctpInNoPorts", coordinator);
    }

    public int getPmSctpInErrors(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmSctpInErrors", coordinator);
    }

    public ManagedObject getRpuId(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("rpuId", coordinator);
    }

    public static void checkRelatedSlot(ManagedObject managedObject, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject3 = ((ReliableProgramUniterMo)managedObject2).getAdmActiveSlot(coordinator);
        ManagedObject managedObject4 = ((IpAccessHostGpbMo)managedObject).getGeneralProcessorUnitId(coordinator).getParent();
        ManagedObject managedObject5 = ((IpAccessHostGpbMo)managedObject).getGeneralProcessorUnitId(coordinator).getParent().getParent();
        if (managedObject4.getType().equals("PlugInUnit")) {
            managedObject5 = managedObject4.getParent();
        } else if (managedObject4.getType().equals("Cbu")) {
            managedObject5 = managedObject4.getParent().getParent();
        } else {
            throw new ConfigurationMismatchException("The ipAccessHostGpbRef points to a GPB with an unsupported parent type:" + managedObject4.getType());
        }
        if (!managedObject3.getLocalDistinguishedName().equals(managedObject5.getLocalDistinguishedName())) {
            throw new ConfigurationMismatchException("The related Slot to IpAccessHostGpb should be same as the admActiveSlot on the ReliableProgramUniter Mo Sctp");
        }
    }

    private static ManagedObject checkReferenceAttributeWithNullValue(String string, AttrList attrList, boolean bl, String string2) throws MoAccessException {
        int n = attrList.indexOf(string);
        if (n != -1 && attrList.getValue(n) == null) {
            return null;
        }
        return MoAttributeValidator.checkAndGetReferenceAttribute((String)string, (AttrList)attrList, (boolean)bl, (String)string2);
    }

    public void eventRaised(MaoFroGenericEventInd maoFroGenericEventInd) {
        Map map = null;
        Control control = null;
        try {
            map = maoFroGenericEventInd.getParameters(sctpAssocTagNameDictionary);
            if (maoFroGenericEventInd.getSpecificEvent() == 1) {
                Coordinator coordinator;
                TransactionFactory transactionFactory;
                int n = maoFroGenericEventInd.getFroId();
                map.put(SCTP_FRO_ID, new UnsignedIntParameter(SCTP_FRO_ID, (long)n));
                ArrayList<Coordinator> arrayList = new ArrayList<Coordinator>();
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    transactionFactory = iterator.next();
                    if (transactionFactory.getValue() instanceof StringParameter) {
                        coordinator = new StringParameter((String)transactionFactory.getKey(), ((StringParameter)transactionFactory.getValue()).getValue());
                        arrayList.add(coordinator);
                        continue;
                    }
                    if (transactionFactory.getValue() instanceof SignedIntParameter) {
                        coordinator = new SignedIntParameter((String)transactionFactory.getKey(), ((SignedIntParameter)transactionFactory.getValue()).getValue());
                        arrayList.add(coordinator);
                        continue;
                    }
                    if (transactionFactory.getValue() instanceof UnsignedIntParameter) {
                        coordinator = new UnsignedIntParameter((String)transactionFactory.getKey(), (long)((int)((UnsignedIntParameter)transactionFactory.getValue()).getValue()));
                        arrayList.add(coordinator);
                        continue;
                    }
                    throw new WrongAttributeTypeException((String)transactionFactory.getKey(), "Sctp");
                }
                if (this.sctpAssocFactory != null) {
                    transactionFactory = TransactionServiceImpl.instance().getTransactionFactory();
                    control = transactionFactory.create(3600);
                    coordinator = control.getCoordinator();
                    this.sctpAssocFactory.autoCreateMo(this, arrayList, coordinator);
                    control.getTerminator().commit();
                } else {
                    MessageLog.traceError(this.getClass(), (String)" Mo factory not found! SctpAssociation", null);
                }
            } else {
                MessageLog.traceError(this.getClass(), (String)("ERROR - Unknown specificEvent: " + maoFroGenericEventInd.getSpecificEvent() + " sent in signal MaoFroGenericEventInd"));
            }
        }
        catch (TagNameDictionaryException tagNameDictionaryException) {
            MessageLog.traceError(this.getClass(), (String)(" Unable to read parameters from event indication in " + this.getLocalDistinguishedName()), (Throwable)tagNameDictionaryException);
            this.rollbackTransaction(control);
        }
        catch (IllegalParameterValueException illegalParameterValueException) {
            MessageLog.traceError(this.getClass(), (String)(" Unable to read parameters from event indication in " + this.getLocalDistinguishedName()), (Throwable)illegalParameterValueException);
            this.rollbackTransaction(control);
        }
        catch (TransactionRequiredException transactionRequiredException) {
            MessageLog.traceError(this.getClass(), (String)" start of TransportNetwork failed", (Throwable)transactionRequiredException);
        }
        catch (TransactionRolledBackException transactionRolledBackException) {
            MessageLog.traceError(this.getClass(), (String)" start of TransportNetwork failed", (Throwable)transactionRolledBackException);
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            MessageLog.traceError(this.getClass(), (String)" start of TransportNetwork failed", (Throwable)inactiveTransactionException);
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)" SctpAssociationMo not created", (Throwable)moAccessException);
            this.rollbackTransaction(control);
        }
    }

    private void rollbackTransaction(Control control) {
        try {
            if (control != null) {
                control.getTerminator().rollback();
            }
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            MessageLog.info(this.getClass(), (String)("rollback failed - Inactive Transaction " + (Object)((Object)inactiveTransactionException)));
        }
    }

    private static int checkandGetPotentiallyFailedMaxRtx(String string, AttrList attrList, int n, int n2, int n3, int n4, String string2) throws MoAccessException {
        int n5 = attrList.indexOf(string);
        if (n5 == -1 && n == 4) {
            return n2;
        }
        if (n5 == -1 && n != 4) {
            return -1;
        }
        if (!(attrList.getValue(n5) instanceof Integer)) {
            throw new WrongAttributeTypeException(string, string2);
        }
        int n6 = (Integer)attrList.getValue(n5);
        if (n6 < n3 || n6 > n4) {
            throw new ValueOutOfRangeException(string, string2);
        }
        attrList.removeElementAt(n5);
        return n6;
    }
}

