/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.logging;

import enea.ose.system.InSignal;
import enea.ose.system.OseProcess;
import enea.ose.system.OutSignal;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import se.ericsson.lte.rbs.omf.aue.logging.AbstractLogger;
import se.ericsson.lte.rbs.omf.aue.logging.TraceGroup;

public class StdioLogger
implements AbstractLogger {
    protected boolean basicOn;
    protected boolean debugOn;
    protected boolean enterReturnOn;
    private final List listeningLoggers = new ArrayList();

    public StdioLogger() {
        this(true, true, true);
    }

    StdioLogger(boolean bl, boolean bl2, boolean bl3) {
        String string = System.getProperty("show.output", "false");
        boolean bl4 = string.equalsIgnoreCase("on") || string.equalsIgnoreCase("true");
        this.basicOn = bl && bl4;
        this.debugOn = bl2 && bl4;
        this.enterReturnOn = bl3 && bl4;
    }

    public void info(Class clazz, String string) {
        if (this.basicOn) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("INFO :");
            stringBuffer.append(clazz).append(' ');
            stringBuffer.append(string);
            System.out.println(stringBuffer.toString());
        }
        for (int i = 0; i < this.listeningLoggers.size(); ++i) {
            AbstractLogger abstractLogger = (AbstractLogger)this.listeningLoggers.get(i);
            abstractLogger.info(clazz, string);
        }
    }

    private void trace(TraceGroup traceGroup, Class clazz, String string) {
        if (this.debugOn) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("TRACE:");
            stringBuffer.append(traceGroup).append(' ');
            stringBuffer.append(clazz).append(' ');
            stringBuffer.append(string);
            System.out.println(stringBuffer.toString());
        }
    }

    public void traceAbnormal(Class clazz, String string) {
        this.trace(TraceGroup.ABNORMAL, clazz, string);
        for (int i = 0; i < this.listeningLoggers.size(); ++i) {
            AbstractLogger abstractLogger = (AbstractLogger)this.listeningLoggers.get(i);
            abstractLogger.traceAbnormal(clazz, string);
        }
    }

    public void traceDebug(Class clazz, String string) {
        if (this.debugOn) {
            this.trace(TraceGroup.DEBUG, clazz, string);
        }
        for (int i = 0; i < this.listeningLoggers.size(); ++i) {
            AbstractLogger abstractLogger = (AbstractLogger)this.listeningLoggers.get(i);
            abstractLogger.traceDebug(clazz, string);
        }
    }

    public void traceDebugStackTrace(Class clazz, Throwable throwable) {
        Object object;
        if (this.debugOn) {
            StringWriter stringWriter = new StringWriter();
            object = new PrintWriter(stringWriter);
            throwable.printStackTrace((PrintWriter)object);
            stringWriter.flush();
            String string = "";
            try {
                stringWriter.close();
            }
            catch (IOException iOException) {
                string = string + iOException.getMessage();
            }
            string = string + stringWriter.toString();
            this.trace(TraceGroup.DEBUG, clazz, string);
        }
        for (int i = 0; i < this.listeningLoggers.size(); ++i) {
            object = (AbstractLogger)this.listeningLoggers.get(i);
            object.traceDebugStackTrace(clazz, throwable);
        }
    }

    public void traceEnter(Class clazz, String string) {
        if (this.enterReturnOn) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("ENTER:");
            stringBuffer.append(clazz).append(' ');
            stringBuffer.append(string);
            System.out.println(stringBuffer.toString());
        }
        for (int i = 0; i < this.listeningLoggers.size(); ++i) {
            AbstractLogger abstractLogger = (AbstractLogger)this.listeningLoggers.get(i);
            abstractLogger.traceEnter(clazz, string);
        }
    }

    public void traceError(Class clazz, String string) {
        if (this.basicOn) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("ERROR:");
            stringBuffer.append(clazz).append(' ');
            stringBuffer.append(string);
            System.err.println(stringBuffer.toString());
        }
        for (int i = 0; i < this.listeningLoggers.size(); ++i) {
            AbstractLogger abstractLogger = (AbstractLogger)this.listeningLoggers.get(i);
            abstractLogger.traceError(clazz, string);
        }
    }

    public void traceError(Class clazz, String string, Throwable throwable) {
        if (this.basicOn) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("ERROR:");
            stringBuffer.append(clazz).append(' ');
            stringBuffer.append(string).append(' ');
            stringBuffer.append(throwable);
            System.err.println(stringBuffer.toString());
        }
        for (int i = 0; i < this.listeningLoggers.size(); ++i) {
            AbstractLogger abstractLogger = (AbstractLogger)this.listeningLoggers.get(i);
            abstractLogger.traceError(clazz, string, throwable);
        }
    }

    public void traceGeneral(Class clazz, String string) {
        if (this.debugOn) {
            this.trace(TraceGroup.GENERAL, clazz, string);
        }
        for (int i = 0; i < this.listeningLoggers.size(); ++i) {
            AbstractLogger abstractLogger = (AbstractLogger)this.listeningLoggers.get(i);
            abstractLogger.traceGeneral(clazz, string);
        }
    }

    public void traceParam(Class clazz, String string) {
        if (this.debugOn) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("PARAM:");
            stringBuffer.append(clazz).append(' ');
            stringBuffer.append(string);
            System.out.println(stringBuffer.toString());
        }
        for (int i = 0; i < this.listeningLoggers.size(); ++i) {
            AbstractLogger abstractLogger = (AbstractLogger)this.listeningLoggers.get(i);
            abstractLogger.traceParam(clazz, string);
        }
    }

    public void traceReturn(Class clazz, String string) {
        if (this.enterReturnOn) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("RETRN:");
            stringBuffer.append(clazz).append(' ');
            stringBuffer.append(string);
            System.out.println(stringBuffer.toString());
        }
        for (int i = 0; i < this.listeningLoggers.size(); ++i) {
            AbstractLogger abstractLogger = (AbstractLogger)this.listeningLoggers.get(i);
            abstractLogger.traceReturn(clazz, string);
        }
    }

    public void traceTimer(Class clazz, String string) {
        this.trace(TraceGroup.TIMER, clazz, string);
        for (int i = 0; i < this.listeningLoggers.size(); ++i) {
            AbstractLogger abstractLogger = (AbstractLogger)this.listeningLoggers.get(i);
            abstractLogger.traceTimer(clazz, string);
        }
    }

    public void traceRecSig(Class clazz, String string, InSignal inSignal) {
        if (this.debugOn) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("RESIG:");
            stringBuffer.append(clazz).append(' ');
            stringBuffer.append(string);
            try {
                int n = inSignal.getSigNo();
                stringBuffer.append(", SigNo: ");
                stringBuffer.append(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println(stringBuffer.toString());
        }
        for (int i = 0; i < this.listeningLoggers.size(); ++i) {
            AbstractLogger abstractLogger = (AbstractLogger)this.listeningLoggers.get(i);
            abstractLogger.traceRecSig(clazz, string, inSignal);
        }
    }

    public void traceSendSig(Class clazz, String string, OutSignal outSignal, OseProcess oseProcess) {
        if (this.debugOn) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SESIG:");
            stringBuffer.append(clazz).append(' ');
            stringBuffer.append(string);
            try {
                int n = outSignal.javaToOse();
                stringBuffer.append(", SigNo: ");
                stringBuffer.append(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println(stringBuffer.toString());
        }
        for (int i = 0; i < this.listeningLoggers.size(); ++i) {
            AbstractLogger abstractLogger = (AbstractLogger)this.listeningLoggers.get(i);
            abstractLogger.traceSendSig(clazz, string, outSignal, oseProcess);
        }
    }

    public void traceState(Class clazz, String string) {
        if (this.debugOn) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("STATE:");
            stringBuffer.append(clazz).append(' ');
            stringBuffer.append(string);
            System.out.println(stringBuffer.toString());
        }
        for (int i = 0; i < this.listeningLoggers.size(); ++i) {
            AbstractLogger abstractLogger = (AbstractLogger)this.listeningLoggers.get(i);
            abstractLogger.traceState(clazz, string);
        }
    }

    public void addListeningLogger(AbstractLogger abstractLogger) {
        this.listeningLoggers.add(abstractLogger);
    }

    public void removeListeningLogger(AbstractLogger abstractLogger) {
        this.listeningLoggers.remove(abstractLogger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractLogger[] getListeningLoggers() {
        List list = this.listeningLoggers;
        synchronized (list) {
            AbstractLogger[] abstractLoggerArray = new AbstractLogger[this.listeningLoggers.size()];
            this.listeningLoggers.toArray(abstractLoggerArray);
            return abstractLoggerArray;
        }
    }
}

