/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.aue.verifyUpgrade;

import java.io.FileNotFoundException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.upgradepackage.main.interfaces.DynamicClass;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradeMaster;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradeMasterExtended;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradeParticipator;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradeParticipatorExtended;
import se.ericsson.lte.rbs.omf.aue.logging.AbstractLogger;
import se.ericsson.lte.rbs.omf.aue.logging.LoggingService;
import se.ericsson.lte.rbs.omf.aue.verifyUpgrade.LKFParser;
import se.ericsson.lte.rbs.omf.aue.verifyUpgrade.MoRepositoryWrapper;
import se.ericsson.lte.rbs.omf.aue.verifyUpgrade.MoRepositoryWrapperFactory;
import se.ericsson.lte.rbs.omf.aue.verifyUpgrade.TriggerCentralWrapper;

public class AueVerifyUpgrade
implements UpgradeParticipatorExtended,
DynamicClass {
    private static final Class THIS_CLASS = AueVerifyUpgrade.class;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    private static final int KEY_EXIST = 1;
    private static final int KEY_MISSING = 2;
    private static final int LKF_MISSING = 3;
    private static final int KEY_MISSING_NO_LTE_CELLS = 4;
    private static final int UNDEF = 0;
    private static final String[] RESULT_REASON = new String[]{"UNDEF(Failed to parse)", "KEY EXIST", "LICENSE_KEY_MISSING - 5+5 MHZ_SC", "LKF MISSING", "LICENSE_KEY_MISSING - 5+5 MHZ_SC(But no LTE Cells Found)"};
    private String pathLKF = "/c/license/licensekeys.xml";
    private static final String AUX_PLUG_IN_UNIT = "AuxPlugInUnit";
    private static final String DEVICE_GROUP = "DeviceGroup";
    private static final String XMU_DEVICE_SET = "XmuDeviceSet";
    private static final String EUTRAN_CELL_FDD = "EUtranCellFDD";
    private static final String EUTRAN_CELL_TDD = "EUtranCellTDD";
    private static final Coordinator NO_COORDINATOR = null;

    public AueVerifyUpgrade() {
        logger.info(THIS_CLASS, "AueVerifyUpdate(): Constructor AueVerifyUpgrade called");
    }

    public void triggerIndicated(UpgradeMaster upgradeMaster, String string) {
        logger.traceError(THIS_CLASS, "triggerIndicated(final UpgradeMaster arg0,final String arg1): triggerIndicated(UpgradeMaster anUpgradeMaster, String aTriggerName) SHALL NOT BE INVOKED AT ALL");
    }

    public void init() {
        logger.info(THIS_CLASS, "init(): Operation init(); called");
        TriggerCentralWrapper.addUpgradeParticipator((UpgradeParticipator)this);
    }

    public void terminate() {
        logger.info(THIS_CLASS, "terminate(): Operation terminate(); called");
        TriggerCentralWrapper.removeUpgradeParticipator((UpgradeParticipator)this);
    }

    public String participatorName() {
        return "AUE participator:" + this.getClass().getName();
    }

    public void triggerIndicated(UpgradeMasterExtended upgradeMasterExtended, String string, int n) {
        logger.info(THIS_CLASS, "triggerIndicated(): trigger name: " + string + "  tanUpgradeMasterExtended: " + upgradeMasterExtended + "  anUpgradePackageState: " + n);
        if ("RBS_VERIFY_UPGRADE".equals(string) || "RBS_VERIFY_HARD_UPGRADE".equals(string) || "RBS_VERIFY_SOFT_UPGRADE".equals(string)) {
            String[] stringArray = new String[1];
            int n2 = this.parsingLKF();
            logger.info(THIS_CLASS, "triggerIndicated(): " + RESULT_REASON[n2]);
            switch (n2) {
                case 1: 
                case 3: 
                case 4: {
                    upgradeMasterExtended.triggerConfirmed((UpgradeParticipator)this, string, true);
                    break;
                }
                case 0: 
                case 2: {
                    stringArray[0] = "FATAL FAILURE AT EXECUTION OF TRIGGER " + string + " (" + RESULT_REASON[n2] + ").";
                    upgradeMasterExtended.triggerConfirmed((UpgradeParticipator)this, string, 0, stringArray);
                    break;
                }
            }
        } else {
            logger.info(THIS_CLASS, "triggerIndicated(): REGARDLESS TRIGGER " + string);
            upgradeMasterExtended.triggerConfirmed((UpgradeParticipator)this, string, true);
        }
    }

    private boolean isXMU02Present() {
        boolean bl = false;
        MoRepositoryWrapper moRepositoryWrapper = MoRepositoryWrapperFactory.getInstance().getMoRepositoryWrapper();
        MoIterator moIterator = moRepositoryWrapper.lookupType(XMU_DEVICE_SET);
        if (moIterator != null) {
            while (moIterator.hasMoreElements()) {
                ManagedObject managedObject = moIterator.nextMo();
                ManagedObject managedObject2 = managedObject.getParent();
                ManagedObject managedObject3 = managedObject2.getParent();
                if (!managedObject2.getType().equals(DEVICE_GROUP) || !managedObject3.getType().equals(AUX_PLUG_IN_UNIT)) continue;
                bl = this.isXMU02Enabled(managedObject);
            }
        }
        return bl;
    }

    private boolean isXMU02Enabled(ManagedObject managedObject) {
        boolean bl = false;
        String string = managedObject.getType();
        try {
            bl = (Integer)managedObject.getAttribute("operationalState", NO_COORDINATOR) == 1;
        }
        catch (NoSuchAttributeException noSuchAttributeException) {
            logger.traceError(THIS_CLASS, "Exception caught when getting attribute " + string + "." + "operationalState" + " " + noSuchAttributeException.getMessage());
        }
        catch (MoAccessException moAccessException) {
            logger.traceError(THIS_CLASS, "Exception caught when getting or setting attribute " + string + "." + "operationalState" + " " + moAccessException.getMessage());
        }
        return bl;
    }

    private boolean areLTECellsPresent() {
        boolean bl = true;
        MoRepositoryWrapper moRepositoryWrapper = MoRepositoryWrapperFactory.getInstance().getMoRepositoryWrapper();
        MoIterator moIterator = moRepositoryWrapper.lookupType(EUTRAN_CELL_FDD);
        MoIterator moIterator2 = moRepositoryWrapper.lookupType(EUTRAN_CELL_TDD);
        if (moIterator == null && moIterator2 == null) {
            bl = false;
        }
        return bl;
    }

    private int parsingLKF() {
        int n = 0;
        try {
            LKFParser lKFParser = new LKFParser();
            long l = System.currentTimeMillis();
            lKFParser.startStringParsing(this.getLKFPath());
            long l2 = System.currentTimeMillis();
            logger.info(THIS_CLASS, "parsingLKF(): XML parsing elapsed time: " + (l2 - l));
            logger.info(THIS_CLASS, "parsingLKF(): License Status: " + Boolean.toString(lKFParser.isUpgradeAvail()));
            n = lKFParser.isUpgradeAvail() ? 1 : (this.isXMU02Present() && !this.areLTECellsPresent() ? 4 : 2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.info(THIS_CLASS, "parsingLKF(): License Key File (LKF) is missing: " + fileNotFoundException.getMessage());
            n = 3;
        }
        catch (Exception exception) {
            logger.traceError(THIS_CLASS, "parsingLKF(): " + exception.getMessage());
        }
        return n;
    }

    public String getLKFPath() {
        return this.pathLKF;
    }

    public void setLKFPath(String string) {
        this.pathLKF = string;
    }
}

