/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.efuse;

import java.util.TreeMap;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.genericmo.GenericMao;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;
import se.ericsson.crbs.supsys.efuse.HwNotPresentException;
import se.ericsson.crbs.supsys.efuse.NotRemoteControllableException;
import se.ericsson.crbs.supsys.efuse.ParamNotSupportedException;

public class EFuseMaoImpl
extends GenericMao {
    private static final Class THIS_CLASS = EFuseMaoImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String MO_TYPE = "EFuse";
    private static final String EQUIPMENT_SUPPORT_FUNCTION = "EquipmentSupportFunction";
    private static final String ACTION_SETLOADTYPE = "setLoadType";
    private static final String ACTION_SETCOLDSTARTUP = "setColdStartup";
    private static final String ACTION_SETREMOTECONTROLLABLE = "setRemoteControllable";
    private static final String ARGUMENT_LOADTYPE = "loadType";
    private static final String ARGUMENT_ONATCOLDSTARTUP = "onAtColdStartup";
    private static final String ARGUMENT_REMOTECONTROLLABLE = "remoteControllable";
    protected static final int LOADTYPE_MIN = 0;
    protected static final int LOADTYPE_MAX = 1;
    protected static final String RESULT_HW_NOT_PRESENT = Integer.toString(17039373);
    protected static final String RESULT_PARAM_NOT_SUPPORTED = Integer.toString(17039374);
    protected static final String RESULT_NOT_REMOTE_CONTROLLABLE = Integer.toString(17039375);
    public static final String SUPPORT_SYSTEM_CONTROL = "supportSystemControl";

    public EFuseMaoImpl(ManagedObject managedObject, AttrList attrList, String string, GenericMaoContext genericMaoContext, Integer n, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoAccessException {
        super(managedObject, attrList, string, MO_TYPE, genericMaoContext, n, coordinator, initialMaoContext);
        ManagedObject managedObject2;
        Boolean bl;
        logger.traceEnter(THIS_CLASS, "EFuseMaoImpl() - constructor");
        MoIterator moIterator = this.getMaoContext().getMoAccessor().lookupType(EQUIPMENT_SUPPORT_FUNCTION);
        if (moIterator == null) {
            logger.traceError(THIS_CLASS, "Couldn't find EquipmentSupportFunction");
        }
        if (!(bl = (Boolean)(managedObject2 = moIterator.nextMo()).getAttribute(SUPPORT_SYSTEM_CONTROL, coordinator)).booleanValue()) {
            throw new ProcessingFailureException("MO cannot be created unless EquipmentSupportFunction.supportSystemControl is set to true");
        }
        logger.traceReturn(THIS_CLASS, "EFuseMaoImpl() - constructor");
    }

    public EFuseMaoImpl(MoDataWrapper moDataWrapper, String string, GenericMaoContext genericMaoContext, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException, MoAccessException {
        super(moDataWrapper, string, genericMaoContext, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "EFuseMaoImpl() - Constructor used at restore");
        logger.traceReturn(THIS_CLASS, "EFuseMaoImpl() - Constructor used at restore");
    }

    public void actionSetLoadType(int n, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "actionSetLoadType()");
        if (n < 0 || n > 1) {
            throw new ParamNotSupportedException(MO_TYPE, "Value out of range. Arguments name: loadType & value: " + n);
        }
        if (null != coordinator) {
            this.handleTransactionWrite(coordinator);
        }
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
        treeMap.put(ARGUMENT_LOADTYPE, new Integer(n));
        try {
            this.sendActionWithCfm(ACTION_SETLOADTYPE, coordinator, treeMap);
        }
        catch (FroRequestFailedException froRequestFailedException) {
            String string = froRequestFailedException.getVariablesAsString();
            String string2 = this.getResultFromString(string);
            if (string2.equals(RESULT_HW_NOT_PRESENT)) {
                String string3 = "Hardware is not present " + (Object)((Object)froRequestFailedException);
                logger.traceGeneral(THIS_CLASS, string3);
                throw new HwNotPresentException(MO_TYPE, string3);
            }
            if (string2.equals(RESULT_PARAM_NOT_SUPPORTED)) {
                String string4 = "Does not support setting of this parameter " + (Object)((Object)froRequestFailedException);
                logger.traceGeneral(THIS_CLASS, string4);
                throw new ParamNotSupportedException(MO_TYPE, string4);
            }
            if (string2.equals(RESULT_NOT_REMOTE_CONTROLLABLE)) {
                String string5 = "Not configured for remote control " + (Object)((Object)froRequestFailedException);
                logger.traceGeneral(THIS_CLASS, string5);
                throw new NotRemoteControllableException(MO_TYPE, string5);
            }
            logger.traceAbnormal(THIS_CLASS, "Exception = " + (Object)((Object)froRequestFailedException));
            throw froRequestFailedException;
        }
        logger.traceReturn(THIS_CLASS, "actionSetLoadType()");
    }

    public void actionSetColdStartup(boolean bl, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "actionSetColdStartup()");
        if (null != coordinator) {
            this.handleTransactionWrite(coordinator);
        }
        TreeMap<String, Boolean> treeMap = new TreeMap<String, Boolean>();
        treeMap.put(ARGUMENT_ONATCOLDSTARTUP, bl);
        try {
            this.sendActionWithCfm(ACTION_SETCOLDSTARTUP, coordinator, treeMap);
        }
        catch (FroRequestFailedException froRequestFailedException) {
            String string = froRequestFailedException.getVariablesAsString();
            String string2 = this.getResultFromString(string);
            if (string2.equals(RESULT_HW_NOT_PRESENT)) {
                String string3 = "Hardware is not present " + (Object)((Object)froRequestFailedException);
                logger.traceGeneral(THIS_CLASS, string3);
                throw new HwNotPresentException(MO_TYPE, string3);
            }
            if (string2.equals(RESULT_PARAM_NOT_SUPPORTED)) {
                String string4 = "Does not support setting of this parameter " + (Object)((Object)froRequestFailedException);
                logger.traceGeneral(THIS_CLASS, string4);
                throw new ParamNotSupportedException(MO_TYPE, string4);
            }
            if (string2.equals(RESULT_NOT_REMOTE_CONTROLLABLE)) {
                String string5 = "Not configured for remote control " + (Object)((Object)froRequestFailedException);
                logger.traceGeneral(THIS_CLASS, string5);
                throw new NotRemoteControllableException(MO_TYPE, string5);
            }
            logger.traceAbnormal(THIS_CLASS, "Exception = " + (Object)((Object)froRequestFailedException));
            throw froRequestFailedException;
        }
        logger.traceReturn(THIS_CLASS, "actionSetColdStartup()");
    }

    public void actionSetRemoteControllable(boolean bl, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "actionSetRemoteControllable()");
        if (null != coordinator) {
            this.handleTransactionWrite(coordinator);
        }
        TreeMap<String, Boolean> treeMap = new TreeMap<String, Boolean>();
        treeMap.put(ARGUMENT_REMOTECONTROLLABLE, bl);
        try {
            this.sendActionWithCfm(ACTION_SETREMOTECONTROLLABLE, coordinator, treeMap);
        }
        catch (FroRequestFailedException froRequestFailedException) {
            String string = froRequestFailedException.getVariablesAsString();
            String string2 = this.getResultFromString(string);
            if (string2.equals(RESULT_HW_NOT_PRESENT)) {
                String string3 = "Hardware is not present " + (Object)((Object)froRequestFailedException);
                logger.traceGeneral(THIS_CLASS, string3);
                throw new HwNotPresentException(MO_TYPE, string3);
            }
            if (string2.equals(RESULT_PARAM_NOT_SUPPORTED)) {
                String string4 = "Does not support setting of this parameter " + (Object)((Object)froRequestFailedException);
                logger.traceGeneral(THIS_CLASS, string4);
                throw new ParamNotSupportedException(MO_TYPE, string4);
            }
            logger.traceAbnormal(THIS_CLASS, "Exception = " + (Object)((Object)froRequestFailedException));
            throw froRequestFailedException;
        }
        logger.traceReturn(THIS_CLASS, "actionSetRemoteControllable()");
    }
}

