/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.energymeasurement;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.genericmo.GenericMao;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class EnergyMeasurementMaoImpl
extends GenericMao {
    private static final Class THIS_CLASS = EnergyMeasurementMaoImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    public static final String MO_TYPE = "EnergyMeasurement";
    private static final String UNIT_TYPE = "unitType";
    public static final String SUPPORT_SYSTEM_CONTROL = "supportSystemControl";
    private static final String EQUIPMENT_SUPPORT_FUNCTION = "EquipmentSupportFunction";

    public EnergyMeasurementMaoImpl(ManagedObject managedObject, AttrList attrList, String string, GenericMaoContext genericMaoContext, Integer n, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoAccessException {
        super(managedObject, attrList, string, MO_TYPE, genericMaoContext, n, coordinator, initialMaoContext);
        Object object;
        Object object2;
        Object object3;
        ManagedObject managedObject2;
        Boolean bl;
        MoRepositoryWrapper moRepositoryWrapper = genericMaoContext.getMoRepositoryWrapper();
        logger.traceEnter(THIS_CLASS, "EnergyMeasurementMaoImpl() - constructor");
        MoIterator moIterator = this.getMaoContext().getMoAccessor().lookupType(EQUIPMENT_SUPPORT_FUNCTION);
        if (moIterator == null) {
            logger.traceError(THIS_CLASS, "Couldn't find EquipmentSupportFunction");
        }
        if (!(bl = (Boolean)(managedObject2 = moIterator.nextMo()).getAttribute(SUPPORT_SYSTEM_CONTROL, coordinator)).booleanValue()) {
            throw new ProcessingFailureException("MO cannot be created unless EquipmentSupportFunction.supportSystemControl is set to true");
        }
        int n2 = attrList.indexOf("energyMeterListRef");
        if (n2 >= 0) {
            object3 = (ManagedObject[])attrList.getValue(n2);
            for (int i = 0; i < ((ManagedObject[])object3).length; ++i) {
                object2 = moRepositoryWrapper.lookupType("HwUnit");
                object = null;
                while (object2 != null && object2.hasMoreElements()) {
                    object = object2.nextMo();
                    if (!object.getLocalDistinguishedName().equals(object3[i].toString())) continue;
                    if (!object.getAttribute(UNIT_TYPE, coordinator).equals("EMU") && !object.getAttribute(UNIT_TYPE, coordinator).equals("PSU")) {
                        String string2 = "HwUnit MO (" + object3[i].toString() + ") cannot be used for creating EnergyMeasurement. Valid HwUnits for EnergyMeasurement are EMU and PSU.";
                        logger.traceGeneral(THIS_CLASS, string2);
                        throw new ProcessingFailureException(string2);
                    }
                    logger.info(THIS_CLASS, "Adding " + object3[i].toString() + " to energyMeasurement.");
                }
            }
        }
        object3 = (String)attrList.getValue(attrList.indexOf("startTime"));
        String string3 = (String)attrList.getValue(attrList.indexOf("stopTime"));
        object2 = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        ((DateFormat)object2).setLenient(false);
        object = new Date();
        Date date = new Date();
        Date date2 = new Date();
        if (((String)object3).length() > 0) {
            try {
                date = ((DateFormat)object2).parse((String)object3);
            }
            catch (ParseException parseException) {
                throw new ProcessingFailureException("StartTime incorrectly formated or invalid date, correct format is: yyyy-MM-dd HH:mm");
            }
        } else {
            String string4 = ((DateFormat)object2).format((Date)object);
            this.setRestrictedAttribute("startTime", string4, coordinator);
            date = object;
        }
        if (((String)object3).length() > 0 && date.compareTo((Date)object) < 0) {
            throw new ProcessingFailureException("StartTime must be in the future or left default");
        }
        if (string3.length() > 0) {
            try {
                date2 = ((DateFormat)object2).parse(string3);
            }
            catch (ParseException parseException) {
                throw new ProcessingFailureException("StopTime incorrectly formated or invalid date, correct format is: yyyy-MM-dd HH:mm");
            }
        }
        if (string3.length() > 0 && date2.compareTo((Date)object) < 0) {
            throw new ProcessingFailureException("StopTime must be in the future or left blank");
        }
        if (((String)object3).length() > 0 && string3.length() > 0 && date.compareTo(date2) > 0) {
            throw new ProcessingFailureException("StartTime must be before stopStime");
        }
        logger.traceReturn(THIS_CLASS, "EnergyMeasurementMaoImpl() - constructor");
    }

    public EnergyMeasurementMaoImpl(MoDataWrapper moDataWrapper, String string, GenericMaoContext genericMaoContext, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException, MoAccessException {
        super(moDataWrapper, string, genericMaoContext, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "Constructor used at restore");
        logger.traceReturn(THIS_CLASS, "Constructor used at restore");
    }

    public Object preSet(String string, Map map, Object object, Coordinator coordinator) throws MoAccessException, ValueOutOfRangeException {
        logger.traceEnter(THIS_CLASS, "preSet()");
        return object;
    }

    public void postCreate(AttrList attrList, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(((Object)((Object)this)).getClass(), "postCreate");
        super.postCreate(attrList, coordinator);
        logger.traceReturn(((Object)((Object)this)).getClass(), "postCreate");
    }

    public void postSet(String string, Object object, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "postSet()");
        logger.traceReturn(THIS_CLASS, "postSet()");
    }
}

