/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.hwunit;

import java.util.Map;
import java.util.TreeMap;
import se.ericsson.cello.equipment.GenericUpgradeablePlugInUnit;
import se.ericsson.cello.equipment.UpgradeRegistryBase;
import se.ericsson.cello.equipment.UpgradeablePlugInUnit;
import se.ericsson.cello.equipment.intma.PiuTypeAccess;
import se.ericsson.cello.managedelement.ManagedElementDataMo;
import se.ericsson.cello.managedelement.SwAllocationReservable;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.support.servloc.ServiceRepository;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.upgradepackage.main.interfaces.ProgramMO_HandlerExternalFactory;
import se.ericsson.cello.upgradepackage.main.interfaces.ProgramMO_HandlerExternalInterface;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonifu.InternalErrorException;
import se.ericsson.crbs.omf.mao.commonmo.AttrListImpl;
import se.ericsson.crbs.omf.mao.commonmo.NoConnectionWithUnitException;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.commonmo.ResourceUnavailableException;
import se.ericsson.crbs.omf.mao.genericmo.GenericMao;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoDataWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoFactoryMgrWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;
import se.ericsson.crbs.omf.mao.wrappers.ServiceLocatorWrapper;
import se.ericsson.crbs.supsys.supportsystemconfiguration.helper.CabinetHelper;

public class HwUnitMaoImpl
extends GenericMao
implements UpgradeablePlugInUnit,
SwAllocationReservable {
    private static final int LOCKED = 0;
    private static final int SHUTTING_DOWN = 2;
    public static final String SUPPORT_SYSTEM_CONTROL = "supportSystemControl";
    public static final String EQUIPMENT_SUPPORT_FUNCTION_LDN = "ManagedElement=1,EquipmentSupportFunction=1";
    public static final String MO_TYPE = "HwUnit";
    public static final String MO_TYPE_CABINET = "Cabinet";
    private static final String MANAGED_ELEMENT_DATA_LDN = "ManagedElement=1,ManagedElementData=1";
    private static final String PIU_TYPE = "piuType";
    private static final String OPERATIONAL_STATE = "operationalState";
    private static final String ADMINISTRATIVE_STATE = "administrativeState";
    private static final String RESTART_UNIT = "restartUnit";
    private static final String PRODUCT_NAME = "productName";
    private static final String PRODUCT_DATA = "productData";
    private static final String UNIT_TYPE = "unitType";
    private static final String POSITION_REF = "positionRef";
    private static boolean isCppRegistered = false;
    private static final int CRBS_RESULT_CODE_BASE = 0x1040000;
    private static final int CRBS_SUP_SYS_CTRL_RESULT_CODE_BASE = 0x1040000;
    private static final int CRBS_SUP_SYS_CTRL_ACTION_RESULT_CODE_BASE = 0x1040000;
    public static final int CRBS_MAOFRO_NO_CONN_WITH_HW_UNIT = 17039362;
    public static final int CRBS_MAOFRO_INTERNAL_ERROR = 0x1040001;
    private static final String CRBS_MAOFRO_NO_CONN_WITH_HW_UNIT_STRING = Integer.toString(17039362);
    private static final String CRBS_MAOFRO_INTERNAL_ERROR_STRING = Integer.toString(0x1040001);
    private static final Class THIS_CLASS = HwUnitMaoImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)HwUnitMaoImpl.class.getName());
    private final MoRepositoryWrapper aWrapper;

    public HwUnitMaoImpl(ManagedObject managedObject, AttrList attrList, String string, GenericMaoContext genericMaoContext, Integer n, Coordinator coordinator, InitialMaoContext initialMaoContext) throws MoAccessException {
        super(managedObject, attrList, string, MO_TYPE, genericMaoContext, n, coordinator, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "HwUnitMaoImpl() - constructor");
        this.aWrapper = genericMaoContext.getMoRepositoryWrapper();
        ManagedObject managedObject2 = this.getMaoContext().getMoAccessor().lookup(EQUIPMENT_SUPPORT_FUNCTION_LDN);
        if (managedObject2 == null) {
            throw new MoCanNotBeCreatedException("Could not find ManagedElement=1,EquipmentSupportFunction=1");
        }
        ManagedObject managedObject3 = this.getMaoContext().getMoAccessor().lookup(MANAGED_ELEMENT_DATA_LDN);
        if (managedObject3 == null) {
            throw new MoCanNotBeCreatedException("Could not find ManagedElement=1,ManagedElementData=1");
        }
        Boolean bl = (Boolean)managedObject2.getAttribute(SUPPORT_SYSTEM_CONTROL, coordinator);
        if (!bl.booleanValue()) {
            throw new ProcessingFailureException("MO cannot be created unless EquipmentSupportFunction.supportSystemControl is set to true");
        }
        this.registerForCppUpgrade();
        Reservable reservable = (Reservable)attrList.getValue(attrList.indexOf(PIU_TYPE));
        if (reservable != null) {
            reservable.reserve((ManagedObject)this, coordinator);
        }
        if (((ManagedElementDataMo)managedObject3).getAutoConfigurationAllowed(coordinator) && ((Boolean)managedObject2.getAttribute(SUPPORT_SYSTEM_CONTROL, coordinator)).booleanValue()) {
            logger.traceDebug(THIS_CLASS, "Autocreating children according to PiuType.");
            this.createChildren(coordinator);
        } else {
            logger.traceDebug(THIS_CLASS, "Autocreating children according to PiuType is not performed due AutoConfiguration is not allowed or SupportSystem is false");
        }
        logger.traceReturn(THIS_CLASS, "HwUnitMaoImpl() - constructor");
    }

    public AttrList addFroParametersAtCreate(AttrList attrList, AttrList attrList2, Coordinator coordinator) throws MoAccessException {
        PiuTypeAccess piuTypeAccess = (PiuTypeAccess)attrList2.getValue(attrList2.indexOf(PIU_TYPE));
        String string = piuTypeAccess.getProductName(coordinator);
        ((AttrListImpl)attrList).addAttribute(UNIT_TYPE, (Object)string);
        return attrList;
    }

    public HwUnitMaoImpl(MoDataWrapper moDataWrapper, String string, GenericMaoContext genericMaoContext, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException, MoAccessException {
        super(moDataWrapper, string, genericMaoContext, initialMaoContext);
        logger.traceEnter(THIS_CLASS, "HwUnitMaoImpl() - reconstructor");
        this.aWrapper = genericMaoContext.getMoRepositoryWrapper();
        this.registerForCppUpgrade();
        logger.traceReturn(THIS_CLASS, "HwUnitMaoImpl() - reconstructor");
    }

    private final String getUnitType(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        logger.traceEnter(THIS_CLASS, "getUnitType()");
        ManagedObject managedObject2 = managedObject;
        if (managedObject2 == null) {
            managedObject2 = (ManagedObject)this.getAttribute(PIU_TYPE, false, coordinator);
        }
        Object object = managedObject2.getAttribute(PRODUCT_DATA, coordinator);
        String string = (String)((Struct)object).getValue(PRODUCT_NAME);
        logger.traceReturn(THIS_CLASS, "getUnitType() : " + string);
        return string;
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getAttributes()");
        this.preGetAttributes(stringArray, coordinator);
        ManagedObject managedObject = null;
        String string = "null";
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            if (UNIT_TYPE.equalsIgnoreCase(stringArray[i])) {
                objectArray[i] = this.getUnitType(managedObject, coordinator);
            } else {
                objectArray[i] = this.getAttribute(stringArray[i], false, coordinator);
                if (stringArray[i].equalsIgnoreCase(PIU_TYPE)) {
                    managedObject = (ManagedObject)objectArray[i];
                }
            }
            if (objectArray[i] != null) {
                string = objectArray[i].getClass().getName();
            }
            logger.traceDebug(THIS_CLASS, "getAttributes() - HwUnit - " + stringArray[i] + " = " + string + ":" + objectArray[i]);
        }
        logger.traceReturn(THIS_CLASS, "getAttributes()");
        return objectArray;
    }

    private void registerForCppUpgrade() {
        if (!isCppRegistered) {
            ServiceRepository serviceRepository = ServiceLocatorWrapper.getServiceRepository();
            UpgradeRegistryBase upgradeRegistryBase = (UpgradeRegistryBase)serviceRepository.getService(UpgradeRegistryBase.class);
            upgradeRegistryBase.addPlugInUnitMoTypeName(MO_TYPE);
            isCppRegistered = true;
        }
    }

    public void actionRestartUnit(Coordinator coordinator) throws MoAccessException, NoConnectionWithUnitException {
        logger.traceEnter(THIS_CLASS, "actionRestartUnit()");
        try {
            this.sendActionWithCfm(RESTART_UNIT, coordinator, new TreeMap());
        }
        catch (FroRequestFailedException froRequestFailedException) {
            String string = froRequestFailedException.getVariablesAsString();
            String string2 = this.getResultFromString(string);
            if (string2.equals(CRBS_MAOFRO_NO_CONN_WITH_HW_UNIT_STRING)) {
                throw new NoConnectionWithUnitException(MO_TYPE, "No connection with " + this.getLocalDistinguishedName());
            }
            if (string2.equals(CRBS_MAOFRO_INTERNAL_ERROR_STRING)) {
                throw new InternalErrorException(MO_TYPE, "Internal error for " + this.getLocalDistinguishedName());
            }
            logger.traceAbnormal(THIS_CLASS, "Got an unexpected exception " + (Object)((Object)froRequestFailedException));
        }
        logger.traceReturn(THIS_CLASS, "actionRestartUnit()");
    }

    public void postCreate(AttrList attrList, Coordinator coordinator) throws MoAccessException {
        CabinetHelper cabinetHelper;
        ManagedObject managedObject;
        logger.traceEnter(((Object)((Object)this)).getClass(), "postCreate");
        super.postCreate(attrList, coordinator);
        PiuTypeAccess piuTypeAccess = (PiuTypeAccess)attrList.getValue(attrList.indexOf(PIU_TYPE));
        String string = piuTypeAccess.getProductName(coordinator);
        ManagedObject managedObject2 = (ManagedObject)attrList.getValue(attrList.indexOf(POSITION_REF));
        if (managedObject2 == null && (string.equalsIgnoreCase("SUP") || string.equalsIgnoreCase("SCU")) && (managedObject = (cabinetHelper = new CabinetHelper(this.genericMaoContext)).getCabinet(coordinator)) != null) {
            this.setAttribute(POSITION_REF, managedObject, coordinator);
        }
        logger.traceReturn(((Object)((Object)this)).getClass(), "postCreate");
    }

    public Object preSet(String string, Map map, Object object, Coordinator coordinator) throws ResourceUnavailableException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "preSet()");
        Object object2 = object;
        if (string.equalsIgnoreCase(ADMINISTRATIVE_STATE)) {
            object2 = this.preSetAdministrativeState((Integer)object);
        } else if (string.equalsIgnoreCase(POSITION_REF)) {
            this.preSetPositionRef((ManagedObject)object);
        }
        logger.traceReturn(THIS_CLASS, "preSet()");
        return object2;
    }

    private Object preSetAdministrativeState(Integer n) {
        logger.traceEnter(THIS_CLASS, "preSetAdministrativeState()");
        Integer n2 = 2 == n ? new Integer(0) : n;
        logger.traceReturn(THIS_CLASS, "preSetAdministrativeState()");
        return n2;
    }

    private void preSetPositionRef(ManagedObject managedObject) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "preSetPositionRef()");
        this.validatePositionRef(managedObject);
        logger.traceReturn(THIS_CLASS, "preSetPositionRef()");
    }

    private void validatePositionRef(ManagedObject managedObject) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "validatePositionRef()");
        if (managedObject != null && !managedObject.getType().equals(MO_TYPE_CABINET)) {
            logger.traceGeneral(THIS_CLASS, "Attribute positionRef can only refer to MO of type Cabinet.");
            throw new ValueOutOfRangeException(POSITION_REF, MO_TYPE, "Attribute positionRef can only refer to MO of type Cabinet.");
        }
        logger.traceReturn(THIS_CLASS, "validatePositionRef()");
    }

    public void postSet(String string, Object object, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "postSet()");
        if (PIU_TYPE.equals(string)) {
            this.createChildren(coordinator);
        }
        logger.traceReturn(THIS_CLASS, "postSet()");
    }

    protected final void createChildren(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "createChildren()");
        PiuTypeAccess piuTypeAccess = (PiuTypeAccess)this.getPiuType(coordinator);
        if (piuTypeAccess == null) {
            logger.traceDebug(THIS_CLASS, "No PiuType specified, can not autoCreate children.");
        } else {
            MoRepositoryWrapper moRepositoryWrapper = this.genericMaoContext.getMoRepositoryWrapper();
            MoFactoryMgrWrapper moFactoryMgrWrapper = this.genericMaoContext.getMoFactoryMgrWrapper();
            AttrListImpl attrListImpl = new AttrListImpl(this.aWrapper);
            Struct[] structArray = piuTypeAccess.getMoConfiguration(coordinator);
            if (structArray == null) {
                logger.traceDebug(THIS_CLASS, "No Mo Configuration list found. No autocreation will be performed.");
            } else {
                MoFactory moFactory;
                Object[] objectArray;
                ManagedObject managedObject;
                Struct[] structArray2;
                String string;
                if (this.getLocalDistinguishedName().toLowerCase().indexOf("hwunit=pdu-") >= 0 && structArray.length == 16) {
                    logger.traceEnter(THIS_CLASS, "Autocreating 24 EFuse for new PDU");
                    String string2 = piuTypeAccess.getMoConfigurationHardwaresSubParentLDN(structArray[0]);
                    string = piuTypeAccess.getMoConfigurationHardwareMoTypeName(structArray[0]);
                    int n = structArray.length;
                    structArray2 = new Struct[structArray.length + 8];
                    System.arraycopy(structArray, 0, structArray2, 0, structArray.length);
                    structArray = structArray2;
                    for (int i = 17; i <= 24; ++i) {
                        managedObject = new String[]{"spSubParentLDN", "moTypeNamea", "identity"};
                        objectArray = new String[]{string2, string, Integer.toString(i)};
                        MoFactory moFactory2 = moFactory = new StructImpl((String[])managedObject, objectArray);
                        structArray[n++] = moFactory2;
                    }
                    logger.traceReturn(THIS_CLASS, "Autocreating 24 EFuse for new PDU");
                }
                for (int i = 0; i < structArray.length; ++i) {
                    String string3;
                    string = piuTypeAccess.getMoConfigurationHardwaresSubParentLDN(structArray[i]);
                    String string4 = piuTypeAccess.getMoConfigurationHardwareMoTypeName(structArray[i]);
                    structArray2 = piuTypeAccess.getMoConfigurationMoIdentity(structArray[i]);
                    if ("".equals(string)) {
                        managedObject = this;
                        string3 = this.getLocalDistinguishedName();
                    } else {
                        string3 = this.getLocalDistinguishedName() + "," + string;
                        managedObject = moRepositoryWrapper.lookup(string3);
                        if (managedObject == null) {
                            logger.traceDebug(THIS_CLASS, "WARNING: MO Parent defined in PiuType not found under HwUnit, parent:" + string3);
                            continue;
                        }
                    }
                    objectArray = string3 + "," + string4 + "=" + (String)structArray2;
                    if (moRepositoryWrapper.lookup((String)objectArray) == null) {
                        logger.traceDebug(THIS_CLASS, "Creating MO " + (String)objectArray);
                        moFactory = moFactoryMgrWrapper.lookup(string4);
                        if (moFactory == null) {
                            logger.traceDebug(THIS_CLASS, "WARNING:MoFactory not found " + string4);
                            continue;
                        }
                        moFactory.createMo(managedObject, (AttrList)attrListImpl, (String)structArray2, null, coordinator);
                        continue;
                    }
                    logger.traceDebug(THIS_CLASS, "Mo " + (String)objectArray + " does already exist");
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "createChildren()");
    }

    public void delete(Coordinator coordinator) throws ResourceUnavailableException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "delete()");
        this.deleteChildren((ManagedObject)this, coordinator);
        super.delete(coordinator);
        logger.traceReturn(THIS_CLASS, "delete()");
    }

    private void deleteChildren(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "deleteChildren()");
        MoIterator moIterator = managedObject.getChildren();
        while (moIterator.hasMoreElements()) {
            ManagedObject managedObject2 = moIterator.nextMo();
            managedObject2.delete(coordinator);
        }
        logger.traceReturn(THIS_CLASS, "deleteChildren()");
    }

    public int getAdministrativeState(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getAdministrativeState()");
        int n = (Integer)this.getAttribute(ADMINISTRATIVE_STATE, coordinator);
        logger.traceReturn(THIS_CLASS, "getAdministrativeState()");
        return n;
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getOperationalState()");
        int n = (Integer)this.getAttribute(OPERATIONAL_STATE, coordinator);
        logger.traceReturn(THIS_CLASS, "getOperationalState()");
        return n;
    }

    public final ManagedObject getPiuType(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getPiuType()");
        ManagedObject managedObject = (ManagedObject)this.getAttribute(PIU_TYPE, coordinator);
        logger.traceReturn(THIS_CLASS, "getPiuType()");
        return managedObject;
    }

    public int getResourceId(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getResourceId()");
        int n = this.getFroId(coordinator);
        logger.traceReturn(THIS_CLASS, "getResourceId()");
        return n;
    }

    public int getShutDownTimer(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getShutDownTimer()");
        logger.traceReturn(THIS_CLASS, "getShutDownTimer()");
        return 0;
    }

    public ManagedObject getSwAllocation(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "getSwAllocation()");
        logger.traceReturn(THIS_CLASS, "getSwAllocation()");
        return null;
    }

    public void setAdministrativeState(int n, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setAdministrativeState()");
        this.setAttribute(ADMINISTRATIVE_STATE, new Integer(n), coordinator);
        logger.traceReturn(THIS_CLASS, "setAdministrativeState()");
    }

    public void setAdministrativeStateSwitch(int n, int n2, Coordinator coordinator) throws MoAccessException, ValueOutOfRangeException {
        logger.traceEnter(THIS_CLASS, "setAdministrativeStateSwitch()");
        if (n2 != 1 && n2 != 2) {
            throw new ValueOutOfRangeException(ADMINISTRATIVE_STATE, MO_TYPE, "SwitchAtLock needs to be 1 or 2.");
        }
        this.setAdministrativeState(n, coordinator);
        logger.traceReturn(THIS_CLASS, "setAdministrativeStateSwitch()");
    }

    public void setPiuTypeForSwUpgrade(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setPiuTypeForSwUpgrade()");
        if (managedObject == null) {
            this.setAttributeWithoutValidation(PIU_TYPE, managedObject, coordinator);
        } else {
            this.setAttribute(PIU_TYPE, managedObject, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "setPiuTypeForSwUpgrade()");
    }

    public void setShutDownTimer(int n, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "setShutDownTimer()");
        logger.traceReturn(THIS_CLASS, "setShutDownTimer()");
    }

    public void actionRestart(int n, int n2, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "actionRestart()");
        this.actionRestartUnit(coordinator);
        logger.traceReturn(THIS_CLASS, "actionRestart()");
    }

    public void actionRemoveDisabledPrograms(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "actionRemoveDisabledPrograms()");
        this.handleTransactionRead(coordinator);
        ProgramMO_HandlerExternalFactory programMO_HandlerExternalFactory = (ProgramMO_HandlerExternalFactory)this.getMaoContext().getServiceRepository().getService(ProgramMO_HandlerExternalFactory.class);
        ProgramMO_HandlerExternalInterface programMO_HandlerExternalInterface = programMO_HandlerExternalFactory.getProgramMO_Handler((GenericUpgradeablePlugInUnit)this);
        programMO_HandlerExternalInterface.removeDisabledPrograms(coordinator);
        logger.traceReturn(THIS_CLASS, "actionRemoveDisabledPrograms()");
    }

    public final void actionReconfigureProgramPrepare(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "actionReconfigureProgramPrepare()");
        ProgramMO_HandlerExternalFactory programMO_HandlerExternalFactory = (ProgramMO_HandlerExternalFactory)this.getMaoContext().getServiceRepository().getService(ProgramMO_HandlerExternalFactory.class);
        ProgramMO_HandlerExternalInterface programMO_HandlerExternalInterface = programMO_HandlerExternalFactory.getProgramMO_Handler((GenericUpgradeablePlugInUnit)this);
        programMO_HandlerExternalInterface.reconfigurePrograms(coordinator);
        logger.traceReturn(THIS_CLASS, "actionReconfigureProgramPrepare()");
    }

    public static void disableRegisterForCppUpgradeOnlyForTest() {
        isCppRegistered = true;
    }
}

