/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.omfapplication;

import java.io.IOException;
import se.ericsson.cello.moframework.Mopplet;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.metadata.finder.MoMetaDataNames;
import se.ericsson.crbs.omf.omfapplication.OmfContext;
import se.ericsson.crbs.omf.omfapplication.OmfContextAlreadyExists;
import se.ericsson.crbs.omf.omfapplication.OmfContextCreateFailureException;
import se.ericsson.crbs.omf.omfapplication.OmfContextFactoryFactory;
import se.ericsson.crbs.omf.omfapplication.OmfContextId;
import se.ericsson.crbs.supsys.equipmentsupportfunction.EquipmentSupportFunctionMaoImpl;
import se.ericsson.crbs.supsys.omfapplication.MoMetaDataNamesSoam;

public class OmfApplication
implements Mopplet {
    private static AbstractLogger logger = LoggingService.getLogger();
    private final OmfContext theOmfContext;
    private Thread theUpdateRATandFDNthread = null;

    public OmfApplication() {
        logger.traceEnter(this.getClass(), "OmfApplication");
        OmfContext omfContext = null;
        try {
            logger.traceDebug(this.getClass(), "Creating OMF Context.");
            MoMetaDataNamesSoam moMetaDataNamesSoam = new MoMetaDataNamesSoam();
            omfContext = OmfContextFactoryFactory.getOmfContextFactoryInstance((String)"").createOmfContext(new OmfContextId("SOAM"), null, (MoMetaDataNames)moMetaDataNamesSoam);
        }
        catch (IOException iOException) {
            logger.traceError(this.getClass(), "Error in OmfApplication Constructor!" + iOException.getMessage());
        }
        catch (OmfContextAlreadyExists omfContextAlreadyExists) {
            logger.traceError(this.getClass(), "Error in OmfApplication Constructor!" + omfContextAlreadyExists.getMessage());
        }
        catch (OmfContextCreateFailureException omfContextCreateFailureException) {
            logger.traceError(this.getClass(), "Error in OmfApplication Constructor!" + omfContextCreateFailureException.getMessage());
        }
        this.theOmfContext = omfContext;
        logger.traceReturn(this.getClass(), "OmfApplication");
    }

    public OmfApplication(OmfContext omfContext) {
        logger.traceEnter(this.getClass(), "OmfApplication");
        this.theOmfContext = omfContext;
        logger.traceReturn(this.getClass(), "OmfApplication");
    }

    public void init() {
        logger.traceEnter(this.getClass(), "init");
        logger.info(this.getClass(), "LM Loaded - soamLm");
        logger.info(this.getClass(), "Starting soamLm");
        this.theOmfContext.getGenericFactoryInitializer().initializeFactories();
        logger.traceReturn(this.getClass(), "init");
    }

    public void start() {
        logger.traceEnter(this.getClass(), "start");
        this.theOmfContext.getGenericFactoryInitializer().startFactories();
        this.theOmfContext.getGenericFactoryInitializer().synch();
        logger.info(this.getClass(), "LM Started - soamLm");
        if (!"TRUE".equalsIgnoreCase(System.getProperty("UNIT_TEST"))) {
            this.theUpdateRATandFDNthread = EquipmentSupportFunctionMaoImpl.startUpdateRATandFDNthread(this.theOmfContext.getMoRepositoryWrapper());
        }
        logger.traceReturn(this.getClass(), "start");
    }

    public OmfContext getOmfContextOnlyForTest() {
        return this.theOmfContext;
    }

    public Thread getTheUpdateRATandFDNthreadOnlyForTest() {
        return this.theUpdateRATandFDNthread;
    }
}

