/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.supportsystemconfiguration.datastructure;

import java.io.IOException;

public class CabinetData {
    public final transient String cabinetId;
    public final transient int climateSystem;
    public final transient int climateRegulationSystem;
    public final transient boolean smokeDetector;
    public final transient String userLabel;
    public final transient String sharedCabinetIdentifier;
    public static final String CLIMATE_REGULATION_SYSTEM_NOT_APPLICABLE = "NOT_APPLICABLE";
    public static final String CLIMATE_REGULATION_SYSTEM_DAC = "DAC";
    public static final String CLIMATE_REGULATION_SYSTEM_TS = "TS";
    public static final String CLIMATE_SYSTEM_STANDARD = "STANDARD";
    public static final String CLIMATE_SYSTEM_EXTENDED = "EXTENDED";

    public CabinetData(String string, String string2, String string3, boolean bl, String string4, String string5) throws IOException {
        this.cabinetId = string;
        this.climateSystem = this.convertClimateSystem(string2);
        this.climateRegulationSystem = this.convertClimateRegulationSystem(string3);
        this.smokeDetector = bl;
        this.userLabel = string4;
        this.sharedCabinetIdentifier = string5;
    }

    protected final int convertClimateRegulationSystem(String string) throws IOException {
        int n;
        if (CLIMATE_REGULATION_SYSTEM_NOT_APPLICABLE.equalsIgnoreCase(string)) {
            n = 0;
        } else if (CLIMATE_REGULATION_SYSTEM_DAC.equalsIgnoreCase(string)) {
            n = 1;
        } else if (CLIMATE_REGULATION_SYSTEM_TS.equalsIgnoreCase(string)) {
            n = 2;
        } else {
            String string2 = "Invalid format for climateRegulationSystem: " + string;
            throw new IOException(string2);
        }
        return n;
    }

    protected final int convertClimateSystem(String string) throws IOException {
        int n;
        if (CLIMATE_SYSTEM_STANDARD.equalsIgnoreCase(string)) {
            n = 0;
        } else if (CLIMATE_SYSTEM_EXTENDED.equalsIgnoreCase(string)) {
            n = 1;
        } else {
            String string2 = "Invalid format for climateSystem: " + string;
            throw new IOException(string2);
        }
        return n;
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        String string2 = "CabinetData: " + string;
        string2 = string2 + "cabinetId = " + this.cabinetId + string;
        string2 = string2 + "climateSystem = " + this.climateSystem + string;
        string2 = string2 + "climateRegulationSystem = " + this.climateRegulationSystem + string;
        string2 = string2 + "smokeDetector = " + this.smokeDetector + string;
        string2 = string2 + "userLabel = " + this.userLabel + string;
        string2 = string2 + "sharedCabinetIdentifier = " + this.sharedCabinetIdentifier + string;
        string2 = string2 + "~CabinetData" + string;
        return string2;
    }
}

