/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.pmapplication;

import se.ericsson.cello.pms.generic.BasicScannerFactory;
import se.ericsson.cello.pms.generic.PmStateListener;
import se.ericsson.cello.pms.generic.PmsPortal;
import se.ericsson.crbs.cat.pmapplication.PmCounterRegistrationI;
import se.ericsson.crbs.cat.pmcommon.PmBase;
import se.ericsson.crbs.cat.pmproxy.signals.PmSignals;

public class PmStateListenerImpl
extends PmBase
implements PmStateListener,
PmCounterRegistrationI {
    private PmsPortal m_pmsPortal;
    private BasicScannerFactory m_scannerFactory;
    private Callback m_callback;

    public PmStateListenerImpl(Callback callback, PmsPortal pmsPortal, BasicScannerFactory scannerFactory) {
        this.info("PmStateListener created");
        this.m_pmsPortal = pmsPortal;
        this.m_scannerFactory = scannerFactory;
        this.m_callback = callback;
    }

    public synchronized void init() {
        this.enter("init");
        this.general("Start signal proxy and wait for counter registrations");
        this.m_callback.stateListener_mopplet_startEvent();
        String riLinkName = "RiLink";
        String riPortName = "RiPort";
        String[] riLinkCounterNames = new String[]{"pmLinkDelayHigh", "pmLinkDelayLow", "pmLinkRestart", "pmLinkStabilityError", "pmPancakeCounter", "pmCurrentGanacheConsumptionCounter", "pmMaxGanacheConsumptionCounter", "pmMinGanacheConsumptionCounter", "pmMuffinsCounter", "pmPancakeCounter", "pmPieCounter", "pmSorbetCounter", "pmTarteCounter"};
        String[] riPortCounterNames = new String[]{"pmBitError", "pmL3OamBadCrc", "pmL3OamRetransmission", "pmLossOfFrame", "pmLossOfSignal", "pmSfpRxPower", "pmSfpTemperature", "pmSfpTxBias", "pmSfpTxPower", "pmSfpVoltage", "pmCheescakeCounter", "pmCinnamonBunCounter", "pmIceCreamCounter"};
        int[] riLinkMultiplicities = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        int[] riPortMultiplicities = new int[]{6, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 16, 1};
        this.m_pmsPortal.registerCounterTypes(riLinkName, riLinkCounterNames, riLinkMultiplicities, this.m_scannerFactory);
        this.m_pmsPortal.registerCounterTypes(riPortName, riPortCounterNames, riPortMultiplicities, this.m_scannerFactory);
    }

    public void start() {
        this.enter("start");
    }

    private static void appendKeyValue(StringBuffer buffer, String key, String value) {
        int length;
        if (value == null) {
            length = 0;
            value = "<NULL>";
        } else {
            length = value.length();
        }
        buffer.append("\n");
        buffer.append(key);
        buffer.append(": (");
        buffer.append(length);
        buffer.append(")'");
        buffer.append(value);
        buffer.append("'");
    }

    private static void appendKeyValue(StringBuffer buffer, String key, long value) {
        buffer.append("\n");
        buffer.append(key);
        buffer.append(": ");
        buffer.append(value);
    }

    public void registerCounters(PmSignals.PmcciMoClassItem[] moClassDefs) {
        this.enter("registerCounters");
        for (int outer = 0; outer < moClassDefs.length; ++outer) {
            PmSignals.PmcciMoClassItem moClassDef = moClassDefs[outer];
            PmSignals.PmcciCounterRegistrationItem[] counterDefs = moClassDef.counterRegistrationItems;
            String[] counterNames = new String[counterDefs.length];
            int[] multiplicities = new int[counterDefs.length];
            for (int inner = 0; inner < counterDefs.length; ++inner) {
                PmSignals.PmcciCounterRegistrationItem counterDef = counterDefs[inner];
                counterNames[inner] = counterDef.counterName;
                multiplicities[inner] = counterDef.multiplicity;
                StringBuffer buffer = new StringBuffer();
                buffer.append("About to register counter def");
                PmStateListenerImpl.appendKeyValue(buffer, "moClassName", moClassDef.moClassName);
                PmStateListenerImpl.appendKeyValue(buffer, "counterName", counterDef.counterName);
                PmStateListenerImpl.appendKeyValue(buffer, "multiplicity", counterDef.multiplicity);
                this.general(buffer.toString());
            }
            this.m_pmsPortal.registerCounterTypes(moClassDef.moClassName, counterNames, multiplicities, this.m_scannerFactory);
            StringBuffer buffer = new StringBuffer();
            buffer.append("Registered counter types");
            PmStateListenerImpl.appendKeyValue(buffer, "moClassName", moClassDef.moClassName);
            PmStateListenerImpl.appendKeyValue(buffer, "count", counterDefs.length);
            this.general(buffer.toString());
        }
        this.info("Catoam PM applicaton registered counter types for " + moClassDefs.length + " MO classes to PMS");
    }

    public synchronized void counterRegistrationsFinished() {
        this.enter("counterRegistrationsFinished");
    }

    public static interface Callback {
        public void stateListener_mopplet_startEvent();
    }
}

