/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.pmcommon;

import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class PmBase {
    protected final Class THIS_CLASS = this.getClass();
    private final AbstractLogger logger = PmBase.getLogger(this.THIS_CLASS.getName());
    private static PmLoggerFactory loggerFactory;

    public static void setLoggerFactory(PmLoggerFactory lf) {
        loggerFactory = lf;
    }

    public static AbstractLogger getDefaultLogger(String name) {
        return LoggingService.getLogger((String)name);
    }

    public static AbstractLogger getLogger(String name) {
        PmLoggerFactory lf = loggerFactory;
        if (lf != null) {
            return lf.createLogger(name);
        }
        return PmBase.getDefaultLogger(name);
    }

    public void info(String msg) {
        this.logger.info(this.THIS_CLASS, msg);
    }

    public void general(String msg) {
        this.logger.traceGeneral(this.THIS_CLASS, msg);
    }

    public void error(String msg) {
        this.logger.traceError(this.THIS_CLASS, msg);
    }

    public void abnormal(String msg) {
        this.logger.traceAbnormal(this.THIS_CLASS, msg);
    }

    public void debug(String msg) {
        this.logger.traceDebug(this.THIS_CLASS, msg);
    }

    public void param(String msg) {
        this.logger.traceParam(this.THIS_CLASS, msg);
    }

    public void enter(String msg) {
        this.logger.traceEnter(this.THIS_CLASS, msg);
    }

    public static interface PmLoggerFactory {
        public AbstractLogger createLogger(String var1);
    }
}

