/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.pminstantcounters;

import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.support.servloc.ServiceRepository;
import se.ericsson.crbs.cat.pmapplication.PmThreadSwitcherI;
import se.ericsson.crbs.cat.pmcommon.PmBase;
import se.ericsson.crbs.cat.pmpms.PmMeasuredInstantData;
import se.ericsson.crbs.omf.mao.commonmo.ProcessingFailureException;
import se.ericsson.crbs.omf.mao.commonmo.ResourceUnavailableException;
import se.ericsson.crbs.omf.mao.genericmo.attributes.manager.PmAttribute;

public class PmInstantCountersHandler
extends PmBase
implements PmAttribute {
    private final PmThreadSwitcherI m_threadSwitcher;
    private final Callback m_callback;

    public PmInstantCountersHandler(PmThreadSwitcherI threadSwitcher, Callback callback) {
        this.enter("PmInstantCountersHandler");
        this.m_threadSwitcher = threadSwitcher;
        this.m_callback = callback;
    }

    public void publishService() {
        this.enter("publishService");
        ServiceRepository serviceRepository = ServiceLocatorFacade.getRepository();
        serviceRepository.addService((Object)this, PmAttribute.class, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[][] getCounterValues(String moLocalDistinguishedName, String[] counterNames) throws ResourceUnavailableException, ProcessingFailureException {
        GetCounterValuesRunnable getCounterValuesRunnable;
        this.enter("getCounterValues");
        this.general("Num: " + counterNames.length + " counters requested for MO " + moLocalDistinguishedName);
        GetCounterValuesRunnable getCounterValuesRunnable2 = getCounterValuesRunnable = new GetCounterValuesRunnable(moLocalDistinguishedName, counterNames);
        synchronized (getCounterValuesRunnable2) {
            this.m_threadSwitcher.executeInMainThread(getCounterValuesRunnable);
            while (!getCounterValuesRunnable.hasResults()) {
                long startTime = System.currentTimeMillis();
                try {
                    getCounterValuesRunnable.wait();
                }
                catch (InterruptedException e) {
                    if (System.currentTimeMillis() - startTime > 300000L) {
                        throw new ResourceUnavailableException("PmInstantCountersHandler", "Process interrupted while waiting for values");
                    }
                    this.general("Calling thread ignoring interrupt");
                }
            }
        }
        this.general("Calling thread woke up");
        if (getCounterValuesRunnable.getException() != null) {
            this.general("Received an exception");
            Exception exception = getCounterValuesRunnable.getException();
            if (exception instanceof ResourceUnavailableException) {
                throw (ResourceUnavailableException)exception;
            }
            throw (ProcessingFailureException)exception;
        }
        if (getCounterValuesRunnable.getCounterValues() != null) {
            this.general("Recieved measurement values");
            return getCounterValuesRunnable.getCounterValues();
        }
        return new int[][]{new int[0]};
    }

    public static interface Callback {
        public void instantCounter_getCounterValues(String var1, String[] var2, InstantCounterReceiver var3);
    }

    public static interface InstantCounterReceiver {
        public void receiveInstantCounters(PmMeasuredInstantData var1);
    }

    public class GetCounterValuesRunnable
    implements Runnable,
    InstantCounterReceiver {
        private String m_moLocalDistinguishedName;
        private String[] m_counterNames;
        private int[][] m_counterValues;
        private Exception m_exception;

        public GetCounterValuesRunnable(String moLocalDistinguishedName, String[] counterNames) {
            this.m_moLocalDistinguishedName = moLocalDistinguishedName;
            this.m_counterNames = counterNames;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receiveInstantCounters(PmMeasuredInstantData measuredInstantData) {
            PmInstantCountersHandler.this.enter("GetCounterValuesRunnable.receiveInstantCounters");
            if (this.m_counterValues != null) {
                PmInstantCountersHandler.this.error("instantCounter_getCounterValues generated multiple responses on receiveInstantCounters, this could be caused by using an moLDN present in more than one MO class");
                return;
            }
            GetCounterValuesRunnable getCounterValuesRunnable = this;
            synchronized (getCounterValuesRunnable) {
                this.m_counterValues = measuredInstantData.toPmiResultSet();
                this.m_exception = measuredInstantData.getException();
                this.notify();
            }
        }

        public void run() {
            PmInstantCountersHandler.this.enter("GetCounterValuesRunnable.run");
            PmInstantCountersHandler.this.m_callback.instantCounter_getCounterValues(this.m_moLocalDistinguishedName, this.m_counterNames, this);
        }

        public boolean hasResults() {
            return this.m_counterValues != null || this.m_exception != null;
        }

        public int[][] getCounterValues() {
            return this.m_counterValues;
        }

        public Exception getException() {
            return this.m_exception;
        }
    }
}

