/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.pmpms;

import se.ericsson.cello.pms.generic.BasicScanner;
import se.ericsson.cello.pms.generic.BasicScannerFactory;
import se.ericsson.cello.pms.generic.DataConsumer;
import se.ericsson.cello.pms.generic.GranularityAndAttributeActivationException;
import se.ericsson.cello.pms.generic.GranularityPeriod;
import se.ericsson.cello.pms.generic.GranularityPeriodNotSupportedException;
import se.ericsson.cello.pms.generic.NumberOfCountersExceededException;
import se.ericsson.cello.pms.generic.ObservationClass;
import se.ericsson.cello.pms.generic.ObservationObject;
import se.ericsson.cello.pms.generic.OverloadException;
import se.ericsson.cello.pms.generic.ParameterNotAcceptedException;
import se.ericsson.cello.pms.generic.PerformanceMonitoringState;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.pmapplication.PmThreadSwitcherI;
import se.ericsson.crbs.cat.pmcommon.PmBase;
import se.ericsson.crbs.cat.pmpms.PmScanner;

public class PmScannerFactory
extends PmBase
implements BasicScannerFactory {
    private final PmThreadSwitcherI m_threadSwitcher;
    private final PmScanner.Callback m_callback;
    private int m_nextScannerId;
    private GranularityPeriod m_allowedGp;

    public PmScannerFactory(PmThreadSwitcherI threadSwitcher, PmScanner.Callback callback) {
        this.enter("PmScannerFactory");
        this.info("PmScannerFactory created");
        this.m_threadSwitcher = threadSwitcher;
        this.m_callback = callback;
        this.m_allowedGp = null;
    }

    public void resetAllowedGranularityPeriod() {
        this.m_allowedGp = null;
    }

    public GranularityPeriod getGranularityPeriod() {
        return this.m_allowedGp;
    }

    public BasicScanner create(ObservationClass[] ocList, ObservationObject[] ooList, GranularityPeriod gp, PerformanceMonitoringState state, DataConsumer destination, String measurementName, Coordinator coordinator) throws GranularityPeriodNotSupportedException, NumberOfCountersExceededException, GranularityAndAttributeActivationException, OverloadException, ParameterNotAcceptedException {
        int numErrors = 0;
        StringBuffer errorBuffer = new StringBuffer();
        if (ocList == null || ocList.length == 0) {
            errorBuffer.append("Observation class list must not be empty\n");
            ++numErrors;
        }
        if (ooList != null && ooList.length > 0) {
            errorBuffer.append("Observation object list must be empty\n");
            ++numErrors;
        }
        if (destination == null) {
            errorBuffer.append("DataConsumer must not be null\n");
            ++numErrors;
        }
        if (this.m_allowedGp != null && gp != this.m_allowedGp) {
            errorBuffer.append("GranularityPeriod must not be different from existing scanners");
            ++numErrors;
        }
        if (numErrors > 0) {
            String errorMsg = errorBuffer.toString();
            this.error(errorMsg);
            throw new ParameterNotAcceptedException(errorMsg);
        }
        this.m_allowedGp = gp;
        return new PmScanner(gp, state, destination, measurementName, ocList, coordinator, this.m_nextScannerId++, this.m_threadSwitcher, this.m_callback);
    }
}

