/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.pmproxy;

import enea.ose.system.InSignal;
import enea.ose.system.OseProcess;
import enea.ose.system.Signal;
import enea.ose.system.SignalRegistry;
import enea.ose.system.ThisProcess;
import java.util.ArrayList;
import se.ericsson.cello.support.sigutil.OseNameServer;
import se.ericsson.cello.support.sigutil.SignalHelper;
import se.ericsson.crbs.cat.pmcommon.PmBase;
import se.ericsson.crbs.cat.pmcommon.PmMaps;
import se.ericsson.crbs.cat.pmproxy.PmProxyI;
import se.ericsson.crbs.cat.pmproxy.PmProxyListenerI;
import se.ericsson.crbs.cat.pmproxy.signals.PmBaseSignal;
import se.ericsson.crbs.cat.pmproxy.signals.PmSignalDescriptor;
import se.ericsson.crbs.cat.pmproxy.signals.PmSignals;

public class PmProxy
extends PmBase
implements PmProxyI {
    private final PmMaps.ListenerMap m_listeners = new PmMaps.ListenerMap();
    private SignalRegistry m_sigReg;
    private int m_proxyPid;
    private boolean m_isStarted;
    private boolean m_isStopped;

    public PmProxy() {
        this.enter("PmProxy");
    }

    boolean checkIsStarted() {
        this.enter("checkIsStarted");
        if (!this.m_isStarted) {
            this.error("Invalid operation as CAT PM Proxy is not started");
        }
        return this.m_isStarted;
    }

    boolean checkIsNotStarted() {
        this.enter("checkIsNotStarted");
        if (this.m_isStarted) {
            this.error("Invalid operation as CAT PM Proxy is started");
        }
        return !this.m_isStarted;
    }

    public boolean isStarted() {
        this.enter("isStarted");
        return this.m_isStarted;
    }

    public void setIsStarted(boolean isStarted) {
        this.enter("setIsStarted");
        this.m_isStarted = isStarted;
    }

    private void registerSignalClasses(SignalRegistry sigReg, PmSignalDescriptor[] signalDescriptors) {
        this.enter("registerSignals");
        this.general("registering signals: " + signalDescriptors.length);
        for (int iter = 0; iter < signalDescriptors.length; ++iter) {
            PmSignalDescriptor signalDescriptor = signalDescriptors[iter];
            sigReg.add(signalDescriptor.SignalClass);
        }
    }

    public void start() {
        this.enter("start");
        if (!this.checkIsNotStarted()) {
            return;
        }
        this.info("CAT PM Proxy started");
        this.m_proxyPid = ThisProcess.getThisProcess().getPID();
        this.m_sigReg = new SignalRegistry();
        this.registerSignalClasses(this.m_sigReg, PmSignals.Internal.SignalDescriptors);
        this.registerSignalClasses(this.m_sigReg, PmSignals.Receive.SignalDescriptors);
        OseNameServer.addService((String)"CAT_PM_APPLICATION_SERVICE_NAME");
        this.m_isStarted = true;
        while (!this.m_isStopped) {
            try {
                InSignal insignal = ThisProcess.receive((SignalRegistry)this.m_sigReg);
                PmBaseSignal pmSignal = (PmBaseSignal)insignal;
                this.general("received signal " + pmSignal.getSignalDescription());
                this.distributeSignal(pmSignal);
            }
            catch (Exception e) {
                this.error("Unhandled exception: " + e.getMessage());
            }
        }
    }

    public void stop() {
        this.enter("stop");
        if (!this.checkIsStarted()) {
            return;
        }
        this.m_isStopped = true;
    }

    public void registerSignals(PmProxyListenerI proxyListener, PmSignalDescriptor[] signalDescriptors) {
        this.enter("registerSignals");
        if (!this.checkIsNotStarted()) {
            return;
        }
        for (int sigIdx = 0; sigIdx < signalDescriptors.length; ++sigIdx) {
            PmSignalDescriptor signalDescriptor = signalDescriptors[sigIdx];
            int sigNo = signalDescriptor.Id;
            if (this.addListenerForSigNo(sigNo, proxyListener)) continue;
            this.error("Failed to register signal for signal: " + signalDescriptor.toString());
        }
    }

    public void sendSignal(PmBaseSignal signal, int pid) {
        this.enter("sendSignal");
        if (!this.checkIsStarted()) {
            return;
        }
        OseProcess process = OseProcess.getProcess((int)pid);
        SignalHelper.send((OseProcess)process, (Signal)signal);
        this.general("sent signal: " + signal.getSignalDescription());
    }

    public int getSenderPid(PmBaseSignal signal) {
        this.enter("getSenderPid");
        if (!this.checkIsStarted()) {
            return 0;
        }
        if (signal.getSender() == null) {
            this.error("No sender pid recieved");
            return 0;
        }
        return signal.getSender().getPID();
    }

    public int getProxyPid() {
        this.enter("getProxyPid");
        if (!this.checkIsStarted()) {
            return 0;
        }
        return this.m_proxyPid;
    }

    public int huntForServiceName(String serviceName) {
        this.enter("huntForServiceName");
        if (!this.checkIsStarted()) {
            return 0;
        }
        OseProcess process = OseNameServer.lookup((String)serviceName);
        return process.getPID();
    }

    public void distributeSignal(PmBaseSignal pmSignal) {
        this.enter("distributeSignal");
        if (!this.checkIsStarted()) {
            return;
        }
        int sigNo = pmSignal.getSigNo();
        PmProxyListenerI[] listeners = this.getListenersForSigno(sigNo);
        if (listeners.length == 0) {
            this.error("No listeners for this signal");
            return;
        }
        for (int iter = 0; iter < listeners.length; ++iter) {
            PmProxyListenerI listener = listeners[iter];
            listener.receiveSignal(pmSignal);
        }
    }

    private boolean addListenerForSigNo(int sigNo, PmProxyListenerI proxyListener) {
        this.enter("addListenerForSigNo");
        if (proxyListener == null) {
            this.error("proxyListener must not be null");
            return false;
        }
        ArrayList<PmProxyListenerI> signalListeners = this.m_listeners.get(sigNo);
        if (signalListeners == null && !this.m_listeners.add(sigNo, signalListeners = new ArrayList<PmProxyListenerI>())) {
            this.error("Failed to add listener for sigNo: " + sigNo);
            return false;
        }
        signalListeners.add(proxyListener);
        return true;
    }

    public PmProxyListenerI[] getListenersForSigno(int sigNo) {
        this.enter("getListenersForSigno");
        ArrayList signalListeners = this.m_listeners.get(sigNo);
        if (signalListeners == null) {
            return new PmProxyListenerI[0];
        }
        int size = signalListeners.size();
        if (size == 0) {
            return new PmProxyListenerI[0];
        }
        PmProxyListenerI[] listeners = new PmProxyListenerI[size];
        for (int iter = 0; iter < size; ++iter) {
            listeners[iter] = (PmProxyListenerI)signalListeners.get(iter);
        }
        return listeners;
    }
}

