/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.omf.aue.step2.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.MoDataAccessor;
import se.ericsson.cello.aueframework.converter.MoDataAction;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step2.actions.util.Step2Handler;

public class HandleMaoHwUnitPositionRefAction
implements MoDataAction {
    private static final Class THIS_CLASS = HandleMaoHwUnitPositionRefAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String RESERVED_BY_ATTRIBUTE_NAME = "reservedBy";
    private static final String CABINET_MO_TYPE = "Cabinet";
    private static final String HWUNIT_MO_TYPE = "HwUnit";
    private static final String POSITION_REF_ATTRIBUTE_NAME = "positionRef";
    private static final String STEP2_HWUNITS_UPDATED_TAG = "hwUnitPositionRefsUpdated";
    private static final String STEP2_HWUNITS_LIST_TAG = "hwUnitsWithUpdatedPositionRef";

    public void perform(MoDataWrapper moDataWrapper, ConverterContext converterContext, Coordinator coordinator) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "perform()");
        Step2Handler step2Handler = (Step2Handler)converterContext.getAttribute("CURRENT_STEP2_HANDLER");
        if (step2Handler.retrieveFromAuePersistency("", STEP2_HWUNITS_UPDATED_TAG).equalsIgnoreCase("true")) {
            MoDataAccessor moDataAccessor = converterContext.getMoDataAccessor();
            Collection collection = moDataAccessor.getByType(CABINET_MO_TYPE);
            Collection collection2 = moDataAccessor.getByType(HWUNIT_MO_TYPE);
            Iterator iterator = collection.iterator();
            MoDataWrapper moDataWrapper2 = null;
            if (iterator.hasNext()) {
                moDataWrapper2 = (MoDataWrapper)iterator.next();
            }
            String[] stringArray = this.getLdnsOfUpdatedHwUnits(converterContext);
            for (int i = 0; i < stringArray.length; ++i) {
                MoDataWrapper moDataWrapper3 = null;
                Iterator iterator2 = collection2.iterator();
                logger.traceGeneral(THIS_CLASS, "Iterate over all MOs of type HwUnit");
                while (iterator2.hasNext()) {
                    moDataWrapper3 = (MoDataWrapper)iterator2.next();
                    if (!moDataWrapper3.getLocalDistinguishedName().equalsIgnoreCase(stringArray[i])) continue;
                    this.addReferenceAttribute(moDataWrapper3, POSITION_REF_ATTRIBUTE_NAME, moDataWrapper2.getLocalDistinguishedName(), coordinator);
                    this.updateReservedBy(moDataWrapper2, stringArray[i], coordinator);
                }
            }
        }
    }

    private String[] getLdnsOfUpdatedHwUnits(ConverterContext converterContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "getLdnsOfUpdatedHwUnits()");
        String[] stringArray = new String[]{};
        Step2Handler step2Handler = (Step2Handler)converterContext.getAttribute("CURRENT_STEP2_HANDLER");
        String string = step2Handler.retrieveFromAuePersistency("", STEP2_HWUNITS_LIST_TAG);
        if (string == null || string.length() == 0) {
            logger.traceDebug(THIS_CLASS, "No HwUnits was upated with positionRef.");
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            stringArray = arrayList.toArray(stringArray);
        }
        logger.traceReturn(THIS_CLASS, "getLdnsOfUpdatedHwUnits()");
        return stringArray;
    }

    private void updateReservedBy(MoDataWrapper moDataWrapper, String string, Coordinator coordinator) throws CrbsAueException {
        String string2 = moDataWrapper.getLocalDistinguishedName();
        logger.traceEnter(THIS_CLASS, "updateReservedBy() for " + string2);
        logger.traceGeneral(THIS_CLASS, "Updating reservedBy attribute for " + string2 + " with " + string);
        SequenceAttribute sequenceAttribute = (SequenceAttribute)moDataWrapper.getAttribute(RESERVED_BY_ATTRIBUTE_NAME);
        if (sequenceAttribute == null) {
            sequenceAttribute = new SequenceAttribute(RESERVED_BY_ATTRIBUTE_NAME, true);
        }
        try {
            boolean bl = false;
            Enumeration enumeration = sequenceAttribute.elements();
            while (enumeration.hasMoreElements()) {
                ReferenceAttribute referenceAttribute = (ReferenceAttribute)enumeration.nextElement();
                String string3 = referenceAttribute.getReferenceAsLDN();
                if (!string3.toLowerCase().equals(string2.toLowerCase())) continue;
                logger.traceGeneral(THIS_CLASS, "ReservedBy attribute for " + string2 + " already contains " + string);
                bl = true;
            }
            if (!bl) {
                sequenceAttribute.addElement((Attribute)new ReferenceAttribute("", string, true));
            }
            moDataWrapper.deregisterAttribute(RESERVED_BY_ATTRIBUTE_NAME);
            moDataWrapper.registerPersistentAttr((Attribute)sequenceAttribute);
            moDataWrapper.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        }
        catch (AueException aueException) {
            CrbsAueException crbsAueException = new CrbsAueException(aueException.getMessage());
            crbsAueException.setStackTrace(aueException.getStackTrace());
            throw crbsAueException;
        }
        logger.traceReturn(THIS_CLASS, "updateReservedBy()");
    }

    private void addReferenceAttribute(MoDataWrapper moDataWrapper, String string, String string2, Coordinator coordinator) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "addReferenceAttribute()");
        try {
            ReferenceAttribute referenceAttribute = new ReferenceAttribute(string, string2, true);
            moDataWrapper.deregisterAttribute(string);
            moDataWrapper.registerPersistentAttr((Attribute)referenceAttribute);
            moDataWrapper.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        }
        catch (AueException aueException) {
            CrbsAueException crbsAueException = new CrbsAueException(aueException.getMessage());
            crbsAueException.setStackTrace(aueException.getStackTrace());
            throw crbsAueException;
        }
        logger.traceReturn(THIS_CLASS, "addReferenceAttribute()");
    }
}

