/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.omf.aue.step2.actions;

import java.util.Collection;
import java.util.Iterator;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.MoDataAccessor;
import se.ericsson.cello.aueframework.converter.MoDataAction;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;

public class UpdateReservedByOnEcBusAction
implements MoDataAction {
    private static final Class THIS_CLASS = UpdateReservedByOnEcBusAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String ECPORT_ATT_ECBUSREF = "ecBusRef";
    private static final String ECBUS_ATT_RESERVEDBY = "reservedBy";
    private static final String ECBUS_MO_TYPE = "EcBus";
    private static final String ECPORT_MO_TYPE = "EcPort";

    public void perform(MoDataWrapper moDataWrapper, ConverterContext converterContext, Coordinator coordinator) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "perform()");
        MoDataWrapper moDataWrapper2 = null;
        MoDataAccessor moDataAccessor = converterContext.getMoDataAccessor();
        if (moDataAccessor == null) {
            logger.traceAbnormal(THIS_CLASS, "MoDataAccessor accessor is null");
        } else {
            logger.traceGeneral(THIS_CLASS, "Accessing MOs of type EcBus");
            Collection collection = moDataAccessor.getByType(ECBUS_MO_TYPE);
            if (collection != null) {
                Iterator iterator = collection.iterator();
                logger.traceGeneral(THIS_CLASS, "Iterate over all MOs of type EcBus");
                while (iterator.hasNext()) {
                    moDataWrapper2 = (MoDataWrapper)iterator.next();
                    logger.traceGeneral(THIS_CLASS, "Creating ReservedBy attribute");
                    SequenceAttribute sequenceAttribute = new SequenceAttribute(ECBUS_ATT_RESERVEDBY, true);
                    logger.traceGeneral(THIS_CLASS, "Find and Assert ReservedBy Attribute");
                    this.addReferencesToReservedByAttribute(converterContext, sequenceAttribute, moDataWrapper2.getLocalDistinguishedName());
                    logger.traceGeneral(THIS_CLASS, "deregister and register Attribute: reservedBy");
                    moDataWrapper2.deregisterAttribute(ECBUS_ATT_RESERVEDBY);
                    moDataWrapper2.registerPersistentAttr((Attribute)sequenceAttribute);
                    try {
                        moDataWrapper2.handleTransaction(coordinator, MoData.WRITE_ACCESS);
                    }
                    catch (AueException aueException) {
                        CrbsAueException crbsAueException = new CrbsAueException(aueException.getMessage());
                        crbsAueException.setStackTrace(aueException.getStackTrace());
                        throw crbsAueException;
                    }
                }
            } else {
                logger.traceAbnormal(THIS_CLASS, "ecBusMosCollection  is null");
            }
        }
    }

    private void addReferencesToReservedByAttribute(ConverterContext converterContext, SequenceAttribute sequenceAttribute, String string) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "updateEcBusReservedBy()");
        MoDataWrapper moDataWrapper = null;
        MoDataAccessor moDataAccessor = converterContext.getMoDataAccessor();
        if (moDataAccessor == null) {
            logger.traceAbnormal(THIS_CLASS, "MoDataAccessor accessor is null");
        } else {
            logger.traceGeneral(THIS_CLASS, "Accessing MOs of type EcPort");
            Collection collection = moDataAccessor.getByType(ECPORT_MO_TYPE);
            if (collection != null) {
                logger.traceGeneral(THIS_CLASS, "Iterate over MOs");
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    moDataWrapper = (MoDataWrapper)iterator.next();
                    logger.traceGeneral(THIS_CLASS, "Extract attribute ecBusRef where ldn match the EcBus: " + string);
                    ReferenceAttribute referenceAttribute = (ReferenceAttribute)moDataWrapper.getAttribute(ECPORT_ATT_ECBUSREF);
                    if (!referenceAttribute.getReferenceAsLDN().equals(string)) continue;
                    logger.traceGeneral(THIS_CLASS, "Add EcPort Ldn to EcBus attribute ReservedBy");
                    sequenceAttribute.addElement((Attribute)new ReferenceAttribute("", moDataWrapper.getLocalDistinguishedName(), true));
                }
            } else {
                logger.traceAbnormal(THIS_CLASS, "ecPortMoCollection is null");
            }
        }
        logger.traceReturn(THIS_CLASS, "updateEcBusReservedBy()");
    }
}

