/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.asn1.x509;

import com.maverick.crypto.asn1.ASN1EncodableVector;
import com.maverick.crypto.asn1.ASN1Sequence;
import com.maverick.crypto.asn1.ASN1TaggedObject;
import com.maverick.crypto.asn1.DERBitString;
import com.maverick.crypto.asn1.DEREncodable;
import com.maverick.crypto.asn1.DERInputStream;
import com.maverick.crypto.asn1.DERObject;
import com.maverick.crypto.asn1.DERSequence;
import com.maverick.crypto.asn1.x509.AlgorithmIdentifier;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Enumeration;

public class SubjectPublicKeyInfo
implements DEREncodable {
    private AlgorithmIdentifier y;
    private DERBitString z;

    public static SubjectPublicKeyInfo getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return SubjectPublicKeyInfo.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static SubjectPublicKeyInfo getInstance(Object object) {
        if (object instanceof SubjectPublicKeyInfo) {
            return (SubjectPublicKeyInfo)object;
        }
        if (object instanceof ASN1Sequence) {
            return new SubjectPublicKeyInfo((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public SubjectPublicKeyInfo(AlgorithmIdentifier algorithmIdentifier, DEREncodable dEREncodable) {
        this.z = new DERBitString(dEREncodable);
        this.y = algorithmIdentifier;
    }

    public SubjectPublicKeyInfo(AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        this.z = new DERBitString(byArray);
        this.y = algorithmIdentifier;
    }

    public SubjectPublicKeyInfo(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.y = AlgorithmIdentifier.getInstance(enumeration.nextElement());
        this.z = (DERBitString)enumeration.nextElement();
    }

    public AlgorithmIdentifier getAlgorithmId() {
        return this.y;
    }

    public DERObject getPublicKey() throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.z.getBytes());
        DERInputStream dERInputStream = new DERInputStream(byteArrayInputStream);
        return dERInputStream.readObject();
    }

    public DERBitString getPublicKeyData() {
        return this.z;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.y);
        aSN1EncodableVector.add(this.z);
        return new DERSequence(aSN1EncodableVector);
    }
}

