/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.digests;

import com.maverick.crypto.digests.Digest;

public abstract class GeneralDigest
implements Digest {
    private byte[] b;
    private int c;
    private long d;

    protected GeneralDigest() {
        this.b = new byte[4];
        this.c = 0;
    }

    protected GeneralDigest(GeneralDigest generalDigest) {
        this.b = new byte[generalDigest.b.length];
        System.arraycopy(generalDigest.b, 0, this.b, 0, generalDigest.b.length);
        this.c = generalDigest.c;
        this.d = generalDigest.d;
    }

    public void update(byte by) {
        this.b[this.c++] = by;
        if (this.c == this.b.length) {
            this.processWord(this.b, 0);
            this.c = 0;
        }
        ++this.d;
    }

    public void update(byte[] byArray, int n, int n2) {
        while (this.c != 0 && n2 > 0) {
            this.update(byArray[n]);
            ++n;
            --n2;
        }
        while (n2 > this.b.length) {
            this.processWord(byArray, n);
            n += this.b.length;
            n2 -= this.b.length;
            this.d += (long)this.b.length;
        }
        while (n2 > 0) {
            this.update(byArray[n]);
            ++n;
            --n2;
        }
    }

    public void finish() {
        long l = this.d << 3;
        this.update((byte)-128);
        while (this.c != 0) {
            this.update((byte)0);
        }
        this.processLength(l);
        this.processBlock();
    }

    public void reset() {
        this.d = 0L;
        this.c = 0;
        for (int k = 0; k < this.b.length; ++k) {
            this.b[k] = 0;
        }
    }

    protected abstract void processWord(byte[] var1, int var2);

    protected abstract void processLength(long var1);

    protected abstract void processBlock();

    public abstract int getDigestSize();

    public abstract int doFinal(byte[] var1, int var2);

    public abstract String getAlgorithmName();
}

