/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh;

import com.maverick.events.EventLog;
import com.maverick.ssh.ChannelAdapter;
import com.maverick.ssh.ChannelOpenException;
import com.maverick.ssh.Client;
import com.maverick.ssh.PseudoTerminalModes;
import com.maverick.ssh.ShellEnvironment;
import com.maverick.ssh.ShellProcess;
import com.maverick.ssh.ShellTimeoutException;
import com.maverick.ssh.SshChannel;
import com.maverick.ssh.SshClient;
import com.maverick.ssh.SshException;
import com.maverick.ssh.SshSession;
import com.maverick.ssh2.Ssh2Session;
import java.io.IOException;
import java.io.OutputStream;
import java.util.StringTokenizer;

public class Shell
implements Client {
    SshSession m;
    SshClient r;
    OutputStream y;
    ShellEnvironment ab;
    String s = "[PROMPT]#";
    ShellProcess t;
    String q = null;
    String eb = null;
    String w = "exit";
    String cb = null;
    boolean bb = true;
    boolean u = true;
    final int db = 1;
    final int v = 2;
    final int z = 3;
    int p = 1;
    int x = 5000;
    int n = 10000;
    ShellProcess o;

    public Shell(SshClient sshClient) {
        this.r = sshClient;
    }

    public ShellProcess getSessionInitProcess() {
        return this.o;
    }

    public void setEOL(String string) {
        this.q = string;
    }

    public void setPrompt(String string) {
        this.eb = string;
    }

    public void setExitCommand(String string) {
        this.w = string;
    }

    public void setShellInitTimePeriod(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Period must be > 0");
        }
        this.x = n;
    }

    public synchronized void setPromptTimeoutPeriod(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Period must be >= 0");
        }
        this.n = n;
    }

    public void setFailOnUknownOS(boolean bl) {
        this.bb = bl;
    }

    public void setPromptCommand(String string) {
        this.cb = string;
    }

    public void createSession() throws SshException, ChannelOpenException, ShellTimeoutException {
        this.createSession("vt100", 80, 24);
    }

    public void initializeSession(String string, int n, int n2) throws SshException, ChannelOpenException, ShellTimeoutException {
        if (!this.r.isBuffered()) {
            throw new SshException("The Shell class requires a buffered SshClient instance", 4);
        }
        EventLog.LogEvent(this, "Creating shell with term " + string + " " + n + "x" + n2);
        try {
            if (this.ab == null) {
                this.ab = new ShellEnvironment(this.r, this);
                if (this.ab.getOSType() == 99 && this.bb) {
                    throw new SshException("Shell could not determine the remote operating system", 15);
                }
            }
            this.m = this.r.openSessionChannel();
            EventLog.LogEvent(this, "session channel opened");
            if (this.m instanceof Ssh2Session) {
                ((Ssh2Session)this.m).setSendKeepAliveOnIdle(true);
            }
            this.m.setAutoConsumeInput(true);
            this.m.addChannelEventListener(new _b());
            if (this.isAllocatePseudoTerminal()) {
                PseudoTerminalModes pseudoTerminalModes = new PseudoTerminalModes(this.r);
                pseudoTerminalModes.setTerminalMode(53, false);
                if (!this.m.requestPseudoTerminal(string, n, n2, 0, 0, pseudoTerminalModes)) {
                    throw new SshException("Failed to allocate pty for scripted session", 15);
                }
            }
            if (!this.m.startShell()) {
                throw new SshException("Failed to open a shell for scripted session", 15);
            }
            this.y = this.m.getOutputStream();
            this.o = this.t = new ShellProcess(this, "");
        }
        catch (IOException iOException) {
            throw new SshException(iOException);
        }
    }

    public void createSession(String string, int n, int n2) throws SshException, ChannelOpenException, ShellTimeoutException {
        this.initializeSession(string, n, n2);
        this.initializePrompt();
    }

    public void initializePrompt() throws SshException, ChannelOpenException, ShellTimeoutException {
        try {
            this.t = null;
            this.o = null;
            String string = null;
            if (this.eb != null) {
                this.s = this.eb;
            }
            EventLog.LogEvent(this, "os type is " + this.ab.getOSType());
            switch (this.ab.getOSType()) {
                case 1: {
                    string = "PROMPT=" + this.s;
                    break;
                }
                default: {
                    string = "PS1=" + this.s;
                }
            }
            if (this.cb != null) {
                string = this.cb;
            }
            if (string != null) {
                try {
                    Thread.sleep(this.x);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.type(string);
                this.carriageReturn();
            }
            EventLog.LogEvent(this, "wait for prompt");
            this.b();
        }
        catch (IOException iOException) {
            throw new SshException(iOException);
        }
    }

    public boolean isClosed() {
        return this.m.isClosed();
    }

    private synchronized void b() throws ShellTimeoutException {
        if (this.m.isClosed() || !this.r.isConnected()) {
            throw new ShellTimeoutException("The session or client has disconnected!");
        }
        long l = System.currentTimeMillis();
        while (this.p != 2 && System.currentTimeMillis() - l < (long)this.n) {
            try {
                this.wait(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.p != 2) {
            throw new ShellTimeoutException("The shell did not return to the prompt in the given timeout period " + this.n + "ms");
        }
    }

    public synchronized ShellProcess execute(String string) throws IOException, ShellTimeoutException {
        this.b();
        this.t = new ShellProcess(this, string);
        this.p = 3;
        this.type(string);
        this.carriageReturn();
        return this.t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit() throws ShellTimeoutException, IOException {
        try {
            String string;
            ShellProcess shellProcess = this.execute(this.w);
            while ((string = shellProcess.readLine()) != null) {
            }
        }
        finally {
            try {
                if (this.m != null) {
                    this.m.close();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public void type(String string) throws IOException {
        this.y.write(string.getBytes());
    }

    public void write(byte[] byArray) throws IOException {
        this.y.write(byArray);
    }

    public void type(int n) throws IOException {
        this.y.write(n);
    }

    public void carriageReturn() throws IOException {
        if (this.q == null && this.ab != null) {
            this.y.write(this.ab.getEOL().getBytes());
        } else {
            this.y.write(this.q.getBytes());
        }
    }

    void b(String string) throws IOException {
        if (this.q == null && this.ab != null) {
            this.y.write((string + this.ab.getEOL()).getBytes());
        } else {
            this.y.write((string + this.q).getBytes());
        }
    }

    public ShellEnvironment getEnvironment() {
        return this.ab;
    }

    public void setEnvironment(ShellEnvironment shellEnvironment) {
        this.ab = shellEnvironment;
    }

    public static void setDefaultEOL(String string) {
        ShellEnvironment.g = string;
    }

    public boolean isAllocatePseudoTerminal() {
        return this.u;
    }

    public void setAllocatePseudoTerminal(boolean bl) {
        this.u = bl;
    }

    class _b
    extends ChannelAdapter {
        boolean b = false;
        String c = "\n";
        String d = "\r";
        String e;

        _b() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dataReceived(SshChannel sshChannel, byte[] byArray, int n, int n2) {
            Shell shell = Shell.this;
            synchronized (shell) {
                StringTokenizer stringTokenizer = new StringTokenizer(new String(byArray, n, n2), "\r\n", true);
                while (stringTokenizer.hasMoreTokens()) {
                    String string = stringTokenizer.nextToken();
                    EventLog.LogEvent(this, "Processing: " + string);
                    if (string.startsWith(Shell.this.s)) {
                        EventLog.LogEvent(this, "Found prompt " + Shell.this.s);
                        Shell.this.p = 2;
                        if (Shell.this.t != null) {
                            Shell.this.t.close();
                            Shell.this.t = null;
                        }
                        this.e = null;
                        Shell.this.notifyAll();
                        continue;
                    }
                    if ((string.equals(this.c) || string.equals(this.d)) && this.b) {
                        if (!string.equals(this.c)) continue;
                        this.b = false;
                        continue;
                    }
                    if (Shell.this.p == 3) {
                        if (this.e == null) {
                            this.e = Shell.this.t.getCommandLine();
                        }
                        if (this.e.startsWith(string.trim())) {
                            this.e = this.e.substring(string.trim().length()).trim();
                            this.b = true;
                            continue;
                        }
                        Shell.this.p = 1;
                    }
                    if (Shell.this.t != null && !string.equals(this.c) && !string.equals(this.d)) {
                        Shell.this.t.b(string);
                        continue;
                    }
                    if (Shell.this.t == null || !string.equals(this.c)) continue;
                    Shell.this.t.b();
                }
            }
        }
    }
}

