/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh.components.jce;

import com.maverick.events.EventLog;
import com.maverick.ssh.SshException;
import com.maverick.ssh.components.ComponentFactory;
import com.maverick.ssh.components.ComponentManager;
import com.maverick.ssh.components.Digest;
import com.maverick.ssh.components.SshCipher;
import com.maverick.ssh.components.SshDsaPrivateKey;
import com.maverick.ssh.components.SshDsaPublicKey;
import com.maverick.ssh.components.SshHmac;
import com.maverick.ssh.components.SshKeyPair;
import com.maverick.ssh.components.SshRsaPrivateCrtKey;
import com.maverick.ssh.components.SshRsaPrivateKey;
import com.maverick.ssh.components.SshRsaPublicKey;
import com.maverick.ssh.components.SshSecureRandomGenerator;
import com.maverick.ssh.components.jce.AbstractDigest;
import com.maverick.ssh.components.jce.AbstractHmac;
import com.maverick.ssh.components.jce.AbstractJCECipher;
import com.maverick.ssh.components.jce.JCEAlgorithms;
import com.maverick.ssh.components.jce.JCEProvider;
import com.maverick.ssh.components.jce.SecureRND;
import com.maverick.ssh.components.jce.Ssh1RsaPublicKey;
import com.maverick.ssh.components.jce.Ssh2DsaPrivateKey;
import com.maverick.ssh.components.jce.Ssh2DsaPublicKey;
import com.maverick.ssh.components.jce.Ssh2RsaPrivateCrtKey;
import com.maverick.ssh.components.jce.Ssh2RsaPrivateKey;
import com.maverick.ssh.components.jce.Ssh2RsaPublicKey;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;

public class JCEComponentManager
extends ComponentManager
implements JCEAlgorithms {
    SecureRND s;
    static /* synthetic */ Class class$com$maverick$ssh$components$jce$MD5Digest;
    static /* synthetic */ Class class$com$maverick$ssh$components$jce$SHA1Digest;
    static /* synthetic */ Class class$com$maverick$ssh$components$jce$SHA256Digest;
    static /* synthetic */ Class class$com$maverick$ssh$components$jce$HmacMD5;
    static /* synthetic */ Class class$com$maverick$ssh$components$jce$HmacSha1;
    static /* synthetic */ Class class$com$maverick$ssh$components$jce$HmacMD596;
    static /* synthetic */ Class class$com$maverick$ssh$components$jce$HmacSha196;
    static /* synthetic */ Class class$com$maverick$ssh$components$jce$HmacSha256;
    static /* synthetic */ Class class$com$maverick$ssh$components$jce$Ssh2DsaPublicKey;
    static /* synthetic */ Class class$com$maverick$ssh$components$jce$Ssh2RsaPublicKey;
    static /* synthetic */ Class class$com$maverick$ssh$components$jce$SshX509RsaPublicKey;
    static /* synthetic */ Class class$com$maverick$ssh$components$jce$SshX509DsaPublicKey;
    static /* synthetic */ Class class$com$maverick$ssh$components$jce$SshX509RsaSha1PublicKey;
    static /* synthetic */ Class class$com$maverick$ssh$components$jce$Ssh1Des;
    static /* synthetic */ Class class$com$maverick$ssh$components$jce$Ssh1Des3;
    static /* synthetic */ Class class$com$maverick$ssh$components$jce$TripleDesCtr;
    static /* synthetic */ Class class$com$maverick$ssh$components$jce$AES128Ctr;
    static /* synthetic */ Class class$com$maverick$ssh$components$jce$AES192Ctr;
    static /* synthetic */ Class class$com$maverick$ssh$components$jce$AES256Ctr;
    static /* synthetic */ Class class$com$maverick$ssh$components$jce$TripleDesCbc;
    static /* synthetic */ Class class$com$maverick$ssh$components$jce$BlowfishCbc;
    static /* synthetic */ Class class$com$maverick$ssh$components$jce$AES128Cbc;
    static /* synthetic */ Class class$com$maverick$ssh$components$jce$AES192Cbc;
    static /* synthetic */ Class class$com$maverick$ssh$components$jce$AES256Cbc;
    static /* synthetic */ Class class$com$maverick$ssh$components$jce$ArcFour;
    static /* synthetic */ Class class$com$maverick$ssh$components$jce$ArcFour128;
    static /* synthetic */ Class class$com$maverick$ssh$components$jce$ArcFour256;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$B;

    public static void initializeDefaultProvider(Provider provider) {
        JCEProvider.initializeDefaultProvider(provider);
    }

    public static void initializeProviderForAlgorithm(String string, Provider provider) {
        JCEProvider.initializeProviderForAlgorithm(string, provider);
    }

    public static String getSecureRandomAlgorithm() {
        return JCEProvider.getSecureRandomAlgorithm();
    }

    public static void setSecureRandomAlgorithm(String string) {
        JCEProvider.setSecureRandomAlgorithm(string);
    }

    public static Provider getProviderForAlgorithm(String string) {
        return JCEProvider.getProviderForAlgorithm(string);
    }

    public static SecureRandom getSecureRandom() throws NoSuchAlgorithmException {
        return JCEProvider.getSecureRandom();
    }

    public SshDsaPrivateKey createDsaPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5) throws SshException {
        return new Ssh2DsaPrivateKey(bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5);
    }

    public SshDsaPublicKey createDsaPublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) throws SshException {
        try {
            return new Ssh2DsaPublicKey(bigInteger, bigInteger2, bigInteger3, bigInteger4);
        }
        catch (Throwable throwable) {
            throw new SshException(throwable);
        }
    }

    public SshDsaPublicKey createDsaPublicKey() {
        return new Ssh2DsaPublicKey();
    }

    public SshRsaPrivateCrtKey createRsaPrivateCrtKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6) throws SshException {
        try {
            BigInteger bigInteger7 = bigInteger4.subtract(BigInteger.ONE);
            bigInteger7 = bigInteger3.mod(bigInteger7);
            BigInteger bigInteger8 = bigInteger5.subtract(BigInteger.ONE);
            bigInteger8 = bigInteger3.mod(bigInteger8);
            return new Ssh2RsaPrivateCrtKey(bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger7, bigInteger8, bigInteger6);
        }
        catch (Throwable throwable) {
            throw new SshException(throwable);
        }
    }

    public SshRsaPrivateCrtKey createRsaPrivateCrtKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) throws SshException {
        try {
            return new Ssh2RsaPrivateCrtKey(bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8);
        }
        catch (Throwable throwable) {
            throw new SshException(throwable);
        }
    }

    public SshRsaPrivateKey createRsaPrivateKey(BigInteger bigInteger, BigInteger bigInteger2) throws SshException {
        try {
            return new Ssh2RsaPrivateKey(bigInteger, bigInteger2);
        }
        catch (Throwable throwable) {
            throw new SshException(throwable);
        }
    }

    public SshRsaPublicKey createRsaPublicKey(BigInteger bigInteger, BigInteger bigInteger2, int n) throws SshException {
        try {
            switch (n) {
                case 1: {
                    return new Ssh1RsaPublicKey(bigInteger, bigInteger2);
                }
                case 2: {
                    return new Ssh2RsaPublicKey(bigInteger, bigInteger2);
                }
            }
            throw new SshException("Illegal version number " + n, 5);
        }
        catch (Throwable throwable) {
            throw new SshException(throwable);
        }
    }

    public SshRsaPublicKey createSsh2RsaPublicKey() throws SshException {
        return new Ssh2RsaPublicKey();
    }

    public SshKeyPair generateDsaKeyPair(int n) throws SshException {
        try {
            KeyPairGenerator keyPairGenerator = JCEProvider.getProviderForAlgorithm("DSA") == null ? KeyPairGenerator.getInstance("DSA") : KeyPairGenerator.getInstance("DSA", JCEProvider.getProviderForAlgorithm("DSA"));
            keyPairGenerator.initialize(n);
            KeyPair keyPair = keyPairGenerator.genKeyPair();
            PrivateKey privateKey = keyPair.getPrivate();
            PublicKey publicKey = keyPair.getPublic();
            SshKeyPair sshKeyPair = new SshKeyPair();
            sshKeyPair.setPrivateKey(new Ssh2DsaPrivateKey((DSAPrivateKey)privateKey, (DSAPublicKey)publicKey));
            sshKeyPair.setPublicKey(new Ssh2DsaPublicKey((DSAPublicKey)publicKey));
            return sshKeyPair;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SshException(noSuchAlgorithmException);
        }
    }

    public SshKeyPair generateRsaKeyPair(int n, int n2) throws SshException {
        try {
            KeyPairGenerator keyPairGenerator = JCEProvider.getProviderForAlgorithm("RSA") == null ? KeyPairGenerator.getInstance("RSA") : KeyPairGenerator.getInstance("RSA", JCEProvider.getProviderForAlgorithm("RSA"));
            keyPairGenerator.initialize(n);
            KeyPair keyPair = keyPairGenerator.genKeyPair();
            PrivateKey privateKey = keyPair.getPrivate();
            PublicKey publicKey = keyPair.getPublic();
            SshKeyPair sshKeyPair = new SshKeyPair();
            if (!(privateKey instanceof RSAPrivateCrtKey)) {
                throw new SshException("RSA key generation requires RSAPrivateCrtKey as private key type.", 16);
            }
            sshKeyPair.setPrivateKey(new Ssh2RsaPrivateCrtKey((RSAPrivateCrtKey)privateKey));
            if (n2 == 1) {
                sshKeyPair.setPublicKey(new Ssh1RsaPublicKey((RSAPublicKey)publicKey));
            } else {
                sshKeyPair.setPublicKey(new Ssh2RsaPublicKey((RSAPublicKey)publicKey));
            }
            return sshKeyPair;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SshException(noSuchAlgorithmException);
        }
    }

    public SshSecureRandomGenerator getRND() throws SshException {
        try {
            return this.s == null ? new SecureRND() : this.s;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SshException(noSuchAlgorithmException);
        }
    }

    protected void initializeDigestFactory(ComponentFactory componentFactory) {
        if (this.c("MD5", class$com$maverick$ssh$components$jce$MD5Digest == null ? (class$com$maverick$ssh$components$jce$MD5Digest = JCEComponentManager.class$("com.maverick.ssh.components.jce.MD5Digest")) : class$com$maverick$ssh$components$jce$MD5Digest)) {
            componentFactory.add("MD5", class$com$maverick$ssh$components$jce$MD5Digest == null ? (class$com$maverick$ssh$components$jce$MD5Digest = JCEComponentManager.class$("com.maverick.ssh.components.jce.MD5Digest")) : class$com$maverick$ssh$components$jce$MD5Digest);
        }
        if (this.c("SHA-1", class$com$maverick$ssh$components$jce$SHA1Digest == null ? (class$com$maverick$ssh$components$jce$SHA1Digest = JCEComponentManager.class$("com.maverick.ssh.components.jce.SHA1Digest")) : class$com$maverick$ssh$components$jce$SHA1Digest)) {
            componentFactory.add("SHA-1", class$com$maverick$ssh$components$jce$SHA1Digest == null ? (class$com$maverick$ssh$components$jce$SHA1Digest = JCEComponentManager.class$("com.maverick.ssh.components.jce.SHA1Digest")) : class$com$maverick$ssh$components$jce$SHA1Digest);
        }
        if (this.c("SHA1", class$com$maverick$ssh$components$jce$SHA1Digest == null ? (class$com$maverick$ssh$components$jce$SHA1Digest = JCEComponentManager.class$("com.maverick.ssh.components.jce.SHA1Digest")) : class$com$maverick$ssh$components$jce$SHA1Digest)) {
            componentFactory.add("SHA1", class$com$maverick$ssh$components$jce$SHA1Digest == null ? (class$com$maverick$ssh$components$jce$SHA1Digest = JCEComponentManager.class$("com.maverick.ssh.components.jce.SHA1Digest")) : class$com$maverick$ssh$components$jce$SHA1Digest);
        }
        if (this.c("SHA-256", class$com$maverick$ssh$components$jce$SHA256Digest == null ? (class$com$maverick$ssh$components$jce$SHA256Digest = JCEComponentManager.class$("com.maverick.ssh.components.jce.SHA256Digest")) : class$com$maverick$ssh$components$jce$SHA256Digest)) {
            componentFactory.add("SHA-256", class$com$maverick$ssh$components$jce$SHA256Digest == null ? (class$com$maverick$ssh$components$jce$SHA256Digest = JCEComponentManager.class$("com.maverick.ssh.components.jce.SHA256Digest")) : class$com$maverick$ssh$components$jce$SHA256Digest);
        }
    }

    protected void initializeHmacFactory(ComponentFactory componentFactory) {
        if (this.b("hmac-md5", class$com$maverick$ssh$components$jce$HmacMD5 == null ? (class$com$maverick$ssh$components$jce$HmacMD5 = JCEComponentManager.class$("com.maverick.ssh.components.jce.HmacMD5")) : class$com$maverick$ssh$components$jce$HmacMD5)) {
            componentFactory.add("hmac-md5", class$com$maverick$ssh$components$jce$HmacMD5 == null ? (class$com$maverick$ssh$components$jce$HmacMD5 = JCEComponentManager.class$("com.maverick.ssh.components.jce.HmacMD5")) : class$com$maverick$ssh$components$jce$HmacMD5);
        }
        if (this.b("hmac-sha1", class$com$maverick$ssh$components$jce$HmacSha1 == null ? (class$com$maverick$ssh$components$jce$HmacSha1 = JCEComponentManager.class$("com.maverick.ssh.components.jce.HmacSha1")) : class$com$maverick$ssh$components$jce$HmacSha1)) {
            componentFactory.add("hmac-sha1", class$com$maverick$ssh$components$jce$HmacSha1 == null ? (class$com$maverick$ssh$components$jce$HmacSha1 = JCEComponentManager.class$("com.maverick.ssh.components.jce.HmacSha1")) : class$com$maverick$ssh$components$jce$HmacSha1);
        }
        if (this.b("hmac-md5-96", class$com$maverick$ssh$components$jce$HmacMD596 == null ? (class$com$maverick$ssh$components$jce$HmacMD596 = JCEComponentManager.class$("com.maverick.ssh.components.jce.HmacMD596")) : class$com$maverick$ssh$components$jce$HmacMD596)) {
            componentFactory.add("hmac-md5-96", class$com$maverick$ssh$components$jce$HmacMD596 == null ? (class$com$maverick$ssh$components$jce$HmacMD596 = JCEComponentManager.class$("com.maverick.ssh.components.jce.HmacMD596")) : class$com$maverick$ssh$components$jce$HmacMD596);
        }
        if (this.b("hmac-sha1-96", class$com$maverick$ssh$components$jce$HmacSha196 == null ? (class$com$maverick$ssh$components$jce$HmacSha196 = JCEComponentManager.class$("com.maverick.ssh.components.jce.HmacSha196")) : class$com$maverick$ssh$components$jce$HmacSha196)) {
            componentFactory.add("hmac-sha1-96", class$com$maverick$ssh$components$jce$HmacSha196 == null ? (class$com$maverick$ssh$components$jce$HmacSha196 = JCEComponentManager.class$("com.maverick.ssh.components.jce.HmacSha196")) : class$com$maverick$ssh$components$jce$HmacSha196);
        }
        if (this.b("hmac-sha256", class$com$maverick$ssh$components$jce$HmacSha256 == null ? (class$com$maverick$ssh$components$jce$HmacSha256 = JCEComponentManager.class$("com.maverick.ssh.components.jce.HmacSha256")) : class$com$maverick$ssh$components$jce$HmacSha256)) {
            componentFactory.add("hmac-sha256", class$com$maverick$ssh$components$jce$HmacSha256 == null ? (class$com$maverick$ssh$components$jce$HmacSha256 = JCEComponentManager.class$("com.maverick.ssh.components.jce.HmacSha256")) : class$com$maverick$ssh$components$jce$HmacSha256);
            componentFactory.add("hmac-sha256@ssh.com", class$com$maverick$ssh$components$jce$HmacSha256 == null ? (class$com$maverick$ssh$components$jce$HmacSha256 = JCEComponentManager.class$("com.maverick.ssh.components.jce.HmacSha256")) : class$com$maverick$ssh$components$jce$HmacSha256);
        }
    }

    protected void initializeKeyExchangeFactory(ComponentFactory componentFactory) {
        try {
            Class<?> clazz = Class.forName("com.maverick.ssh.components.jce.DiffieHellmanGroup14Sha1");
            Class<?> clazz2 = Class.forName("com.maverick.ssh.components.jce.DiffieHellmanGroup1Sha1");
            Class<?> clazz3 = Class.forName("com.maverick.ssh.components.jce.DiffieHellmanGroupExchangeSha1");
            Class<?> clazz4 = Class.forName("com.maverick.ssh.components.jce.DiffieHellmanGroupExchangeSha256");
            if (this.e("diffie-hellman-group14-sha1", clazz)) {
                componentFactory.add("diffie-hellman-group14-sha1", clazz);
            }
            if (this.e("diffie-hellman-group1-sha1", clazz2)) {
                componentFactory.add("diffie-hellman-group1-sha1", clazz2);
            }
            if (this.e("diffie-hellman-group-exchange-sha1", clazz3)) {
                componentFactory.add("diffie-hellman-group-exchange-sha1", clazz3);
            }
            if (this.e("diffie-hellman-group-exchange-sha256", clazz4)) {
                componentFactory.add("diffie-hellman-group-exchange-sha256", clazz4);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    protected void initializePublicKeyFactory(ComponentFactory componentFactory) {
        componentFactory.add("ssh-dss", class$com$maverick$ssh$components$jce$Ssh2DsaPublicKey == null ? (class$com$maverick$ssh$components$jce$Ssh2DsaPublicKey = JCEComponentManager.class$("com.maverick.ssh.components.jce.Ssh2DsaPublicKey")) : class$com$maverick$ssh$components$jce$Ssh2DsaPublicKey);
        componentFactory.add("ssh-rsa", class$com$maverick$ssh$components$jce$Ssh2RsaPublicKey == null ? (class$com$maverick$ssh$components$jce$Ssh2RsaPublicKey = JCEComponentManager.class$("com.maverick.ssh.components.jce.Ssh2RsaPublicKey")) : class$com$maverick$ssh$components$jce$Ssh2RsaPublicKey);
        componentFactory.add("x509v3-sign-rsa", class$com$maverick$ssh$components$jce$SshX509RsaPublicKey == null ? (class$com$maverick$ssh$components$jce$SshX509RsaPublicKey = JCEComponentManager.class$("com.maverick.ssh.components.jce.SshX509RsaPublicKey")) : class$com$maverick$ssh$components$jce$SshX509RsaPublicKey);
        componentFactory.add("x509v3-sign-dss", class$com$maverick$ssh$components$jce$SshX509DsaPublicKey == null ? (class$com$maverick$ssh$components$jce$SshX509DsaPublicKey = JCEComponentManager.class$("com.maverick.ssh.components.jce.SshX509DsaPublicKey")) : class$com$maverick$ssh$components$jce$SshX509DsaPublicKey);
        componentFactory.add("x509v3-sign-rsa-sha1", class$com$maverick$ssh$components$jce$SshX509RsaSha1PublicKey == null ? (class$com$maverick$ssh$components$jce$SshX509RsaSha1PublicKey = JCEComponentManager.class$("com.maverick.ssh.components.jce.SshX509RsaSha1PublicKey")) : class$com$maverick$ssh$components$jce$SshX509RsaSha1PublicKey);
    }

    protected void initializeSsh1CipherFactory(ComponentFactory componentFactory) {
        if (this.d("ssh1-des", class$com$maverick$ssh$components$jce$Ssh1Des == null ? (class$com$maverick$ssh$components$jce$Ssh1Des = JCEComponentManager.class$("com.maverick.ssh.components.jce.Ssh1Des")) : class$com$maverick$ssh$components$jce$Ssh1Des)) {
            componentFactory.add("2", class$com$maverick$ssh$components$jce$Ssh1Des == null ? (class$com$maverick$ssh$components$jce$Ssh1Des = JCEComponentManager.class$("com.maverick.ssh.components.jce.Ssh1Des")) : class$com$maverick$ssh$components$jce$Ssh1Des);
        }
        if (this.d("ssh1-3des", class$com$maverick$ssh$components$jce$Ssh1Des3 == null ? (class$com$maverick$ssh$components$jce$Ssh1Des3 = JCEComponentManager.class$("com.maverick.ssh.components.jce.Ssh1Des3")) : class$com$maverick$ssh$components$jce$Ssh1Des3)) {
            componentFactory.add("3", class$com$maverick$ssh$components$jce$Ssh1Des3 == null ? (class$com$maverick$ssh$components$jce$Ssh1Des3 = JCEComponentManager.class$("com.maverick.ssh.components.jce.Ssh1Des3")) : class$com$maverick$ssh$components$jce$Ssh1Des3);
        }
    }

    protected void initializeSsh2CipherFactory(ComponentFactory componentFactory) {
        if (this.d("3des-ctr", class$com$maverick$ssh$components$jce$TripleDesCtr == null ? (class$com$maverick$ssh$components$jce$TripleDesCtr = JCEComponentManager.class$("com.maverick.ssh.components.jce.TripleDesCtr")) : class$com$maverick$ssh$components$jce$TripleDesCtr)) {
            componentFactory.add("3des-ctr", class$com$maverick$ssh$components$jce$TripleDesCtr == null ? (class$com$maverick$ssh$components$jce$TripleDesCtr = JCEComponentManager.class$("com.maverick.ssh.components.jce.TripleDesCtr")) : class$com$maverick$ssh$components$jce$TripleDesCtr);
        }
        if (this.d("aes128-ctr", class$com$maverick$ssh$components$jce$AES128Ctr == null ? (class$com$maverick$ssh$components$jce$AES128Ctr = JCEComponentManager.class$("com.maverick.ssh.components.jce.AES128Ctr")) : class$com$maverick$ssh$components$jce$AES128Ctr)) {
            componentFactory.add("aes128-ctr", class$com$maverick$ssh$components$jce$AES128Ctr == null ? (class$com$maverick$ssh$components$jce$AES128Ctr = JCEComponentManager.class$("com.maverick.ssh.components.jce.AES128Ctr")) : class$com$maverick$ssh$components$jce$AES128Ctr);
        }
        if (this.d("aes192-ctr", class$com$maverick$ssh$components$jce$AES192Ctr == null ? (class$com$maverick$ssh$components$jce$AES192Ctr = JCEComponentManager.class$("com.maverick.ssh.components.jce.AES192Ctr")) : class$com$maverick$ssh$components$jce$AES192Ctr)) {
            componentFactory.add("aes192-ctr", class$com$maverick$ssh$components$jce$AES192Ctr == null ? (class$com$maverick$ssh$components$jce$AES192Ctr = JCEComponentManager.class$("com.maverick.ssh.components.jce.AES192Ctr")) : class$com$maverick$ssh$components$jce$AES192Ctr);
        }
        if (this.d("aes256-ctr", class$com$maverick$ssh$components$jce$AES256Ctr == null ? (class$com$maverick$ssh$components$jce$AES256Ctr = JCEComponentManager.class$("com.maverick.ssh.components.jce.AES256Ctr")) : class$com$maverick$ssh$components$jce$AES256Ctr)) {
            componentFactory.add("aes256-ctr", class$com$maverick$ssh$components$jce$AES256Ctr == null ? (class$com$maverick$ssh$components$jce$AES256Ctr = JCEComponentManager.class$("com.maverick.ssh.components.jce.AES256Ctr")) : class$com$maverick$ssh$components$jce$AES256Ctr);
        }
        if (this.d("3des-cbc", class$com$maverick$ssh$components$jce$TripleDesCbc == null ? (class$com$maverick$ssh$components$jce$TripleDesCbc = JCEComponentManager.class$("com.maverick.ssh.components.jce.TripleDesCbc")) : class$com$maverick$ssh$components$jce$TripleDesCbc)) {
            componentFactory.add("3des-cbc", class$com$maverick$ssh$components$jce$TripleDesCbc == null ? (class$com$maverick$ssh$components$jce$TripleDesCbc = JCEComponentManager.class$("com.maverick.ssh.components.jce.TripleDesCbc")) : class$com$maverick$ssh$components$jce$TripleDesCbc);
        }
        if (this.d("blowfish-cbc", class$com$maverick$ssh$components$jce$BlowfishCbc == null ? (class$com$maverick$ssh$components$jce$BlowfishCbc = JCEComponentManager.class$("com.maverick.ssh.components.jce.BlowfishCbc")) : class$com$maverick$ssh$components$jce$BlowfishCbc)) {
            componentFactory.add("blowfish-cbc", class$com$maverick$ssh$components$jce$BlowfishCbc == null ? (class$com$maverick$ssh$components$jce$BlowfishCbc = JCEComponentManager.class$("com.maverick.ssh.components.jce.BlowfishCbc")) : class$com$maverick$ssh$components$jce$BlowfishCbc);
        }
        if (this.d("aes128-cbc", class$com$maverick$ssh$components$jce$AES128Cbc == null ? (class$com$maverick$ssh$components$jce$AES128Cbc = JCEComponentManager.class$("com.maverick.ssh.components.jce.AES128Cbc")) : class$com$maverick$ssh$components$jce$AES128Cbc)) {
            componentFactory.add("aes128-cbc", class$com$maverick$ssh$components$jce$AES128Cbc == null ? (class$com$maverick$ssh$components$jce$AES128Cbc = JCEComponentManager.class$("com.maverick.ssh.components.jce.AES128Cbc")) : class$com$maverick$ssh$components$jce$AES128Cbc);
        }
        if (this.d("aes192-cbc", class$com$maverick$ssh$components$jce$AES192Cbc == null ? (class$com$maverick$ssh$components$jce$AES192Cbc = JCEComponentManager.class$("com.maverick.ssh.components.jce.AES192Cbc")) : class$com$maverick$ssh$components$jce$AES192Cbc)) {
            componentFactory.add("aes192-cbc", class$com$maverick$ssh$components$jce$AES192Cbc == null ? (class$com$maverick$ssh$components$jce$AES192Cbc = JCEComponentManager.class$("com.maverick.ssh.components.jce.AES192Cbc")) : class$com$maverick$ssh$components$jce$AES192Cbc);
        }
        if (this.d("aes256-cbc", class$com$maverick$ssh$components$jce$AES256Cbc == null ? (class$com$maverick$ssh$components$jce$AES256Cbc = JCEComponentManager.class$("com.maverick.ssh.components.jce.AES256Cbc")) : class$com$maverick$ssh$components$jce$AES256Cbc)) {
            componentFactory.add("aes256-cbc", class$com$maverick$ssh$components$jce$AES256Cbc == null ? (class$com$maverick$ssh$components$jce$AES256Cbc = JCEComponentManager.class$("com.maverick.ssh.components.jce.AES256Cbc")) : class$com$maverick$ssh$components$jce$AES256Cbc);
        }
        if (this.d("arcfour", class$com$maverick$ssh$components$jce$ArcFour == null ? (class$com$maverick$ssh$components$jce$ArcFour = JCEComponentManager.class$("com.maverick.ssh.components.jce.ArcFour")) : class$com$maverick$ssh$components$jce$ArcFour)) {
            componentFactory.add("arcfour", class$com$maverick$ssh$components$jce$ArcFour == null ? (class$com$maverick$ssh$components$jce$ArcFour = JCEComponentManager.class$("com.maverick.ssh.components.jce.ArcFour")) : class$com$maverick$ssh$components$jce$ArcFour);
        }
        if (this.d("arcfour128", class$com$maverick$ssh$components$jce$ArcFour128 == null ? (class$com$maverick$ssh$components$jce$ArcFour128 = JCEComponentManager.class$("com.maverick.ssh.components.jce.ArcFour128")) : class$com$maverick$ssh$components$jce$ArcFour128)) {
            componentFactory.add("arcfour128", class$com$maverick$ssh$components$jce$ArcFour128 == null ? (class$com$maverick$ssh$components$jce$ArcFour128 = JCEComponentManager.class$("com.maverick.ssh.components.jce.ArcFour128")) : class$com$maverick$ssh$components$jce$ArcFour128);
        }
        if (this.d("arcfour256", class$com$maverick$ssh$components$jce$ArcFour256 == null ? (class$com$maverick$ssh$components$jce$ArcFour256 = JCEComponentManager.class$("com.maverick.ssh.components.jce.ArcFour256")) : class$com$maverick$ssh$components$jce$ArcFour256)) {
            componentFactory.add("arcfour256", class$com$maverick$ssh$components$jce$ArcFour256 == null ? (class$com$maverick$ssh$components$jce$ArcFour256 = JCEComponentManager.class$("com.maverick.ssh.components.jce.ArcFour256")) : class$com$maverick$ssh$components$jce$ArcFour256);
        }
    }

    private boolean e(String string, Class clazz) {
        Object object;
        String string2 = "[unknown]";
        Object var4_4 = null;
        try {
            object = "SSH-2.0-J2SSH_Maverick_1.4.43_";
            String string3 = "SSH-2.0-ExampleSSHD_1.2.3_Comments";
            byte[] byArray = new byte[]{20, 9, 23, -34, -78, 80, 43, 43, -33, -62, 73, 10, 4, 125, -72, -88, -20, 0, 0, 0, 27, 100, 105, 102, 102, 105, 101, 45, 104, 101, 108, 108, 109, 97, 110, 45, 103, 114, 111, 117, 112, 49, 52, 45, 115, 104, 97, 49, 0, 0, 0, 15, 115, 115, 104, 45, 100, 115, 115, 44, 115, 115, 104, 45, 114, 115, 97, 0, 0, 0, 32, 97, 101, 115, 49, 50, 56, 45, 99, 98, 99, 44, 51, 100, 101, 115, 45, 99, 98, 99, 44, 98, 108, 111, 119, 102, 105, 115, 104, 45, 99, 98, 99, 0, 0, 0, 32, 97, 101, 115, 49, 50, 56, 45, 99, 98, 99, 44, 51, 100, 101, 115, 45, 99, 98, 99, 44, 98, 108, 111, 119, 102, 105, 115, 104, 45, 99, 98, 99, 0, 0, 0, 18, 104, 109, 97, 99, 45, 115, 104, 97, 49, 44, 104, 109, 97, 99, 45, 109, 100, 53, 0, 0, 0, 18, 104, 109, 97, 99, 45, 115, 104, 97, 49, 44, 104, 109, 97, 99, 45, 109, 100, 53, 0, 0, 0, 9, 110, 111, 110, 101, 44, 122, 108, 105, 98, 0, 0, 0, 9, 110, 111, 110, 101, 44, 122, 108, 105, 98, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            byte[] byArray2 = new byte[]{20, 23, 119, -40, -10, 11, -1, -102, 84, -3, 119, 47, -92, 81, 17, -51, -53, 0, 0, 0, 54, 100, 105, 102, 102, 105, 101, 45, 104, 101, 108, 108, 109, 97, 110, 45, 103, 114, 111, 117, 112, 49, 45, 115, 104, 97, 49, 44, 100, 105, 102, 102, 105, 101, 45, 104, 101, 108, 108, 109, 97, 110, 45, 103, 114, 111, 117, 112, 49, 52, 45, 115, 104, 97, 49, 0, 0, 0, 15, 115, 115, 104, 45, 100, 115, 115, 44, 115, 115, 104, 45, 114, 115, 97, 0, 0, 0, 111, 97, 101, 115, 49, 50, 56, 45, 99, 98, 99, 44, 51, 100, 101, 115, 45, 99, 98, 99, 44, 98, 108, 111, 119, 102, 105, 115, 104, 45, 99, 98, 99, 44, 97, 101, 115, 49, 57, 50, 45, 99, 98, 99, 44, 97, 101, 115, 50, 53, 54, 45, 99, 98, 99, 44, 116, 119, 111, 102, 105, 115, 104, 49, 50, 56, 45, 99, 98, 99, 44, 116, 119, 111, 102, 105, 115, 104, 49, 57, 50, 45, 99, 98, 99, 44, 116, 119, 111, 102, 105, 115, 104, 50, 53, 54, 45, 99, 98, 99, 44, 99, 97, 115, 116, 49, 50, 56, 45, 99, 98, 99, 0, 0, 0, 111, 97, 101, 115, 49, 50, 56, 45, 99, 98, 99, 44, 51, 100, 101, 115, 45, 99, 98, 99, 44, 98, 108, 111, 119, 102, 105, 115, 104, 45, 99, 98, 99, 44, 97, 101, 115, 49, 57, 50, 45, 99, 98, 99, 44, 97, 101, 115, 50, 53, 54, 45, 99, 98, 99, 44, 116, 119, 111, 102, 105, 115, 104, 49, 50, 56, 45, 99, 98, 99, 44, 116, 119, 111, 102, 105, 115, 104, 49, 57, 50, 45, 99, 98, 99, 44, 116, 119, 111, 102, 105, 115, 104, 50, 53, 54, 45, 99, 98, 99, 44, 99, 97, 115, 116, 49, 50, 56, 45, 99, 98, 99, 0, 0, 0, 43, 104, 109, 97, 99, 45, 115, 104, 97, 49, 44, 104, 109, 97, 99, 45, 109, 100, 53, 44, 104, 109, 97, 99, 45, 109, 100, 53, 45, 57, 54, 44, 104, 109, 97, 99, 45, 115, 104, 97, 49, 45, 57, 54, 0, 0, 0, 43, 104, 109, 97, 99, 45, 115, 104, 97, 49, 44, 104, 109, 97, 99, 45, 109, 100, 53, 44, 104, 109, 97, 99, 45, 109, 100, 53, 45, 57, 54, 44, 104, 109, 97, 99, 45, 115, 104, 97, 49, 45, 57, 54, 0, 0, 0, 9, 110, 111, 110, 101, 44, 122, 108, 105, 98, 0, 0, 0, 9, 110, 111, 110, 101, 44, 122, 108, 105, 98, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            var4_4 = clazz.newInstance();
            Method method = clazz.getMethod("performClientExchange", class$java$lang$String == null ? (class$java$lang$String = JCEComponentManager.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = JCEComponentManager.class$("java.lang.String")) : class$java$lang$String, array$B == null ? (array$B = JCEComponentManager.class$("[B")) : array$B, array$B == null ? (array$B = JCEComponentManager.class$("[B")) : array$B);
            method.invoke(var4_4, object, string3, byArray, byArray2);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() instanceof SshException) {
                if (invocationTargetException.getCause().getCause() instanceof NoSuchAlgorithmException) {
                    EventLog.LogEvent(this, "   " + string + " will not be supported: " + invocationTargetException.getCause().getCause().getMessage());
                    return false;
                }
                if (invocationTargetException.getCause().getCause() instanceof InvalidAlgorithmParameterException) {
                    EventLog.LogEvent(this, "   " + string + " will not be supported: " + invocationTargetException.getCause().getCause().getMessage());
                    return false;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            object = clazz.getMethod("getProvider", new Class[0]);
            string2 = (String)((Method)object).invoke(var4_4, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        EventLog.LogEvent(this, "   " + string + " will be supported using JCEProvider " + string2);
        return true;
    }

    private boolean d(String string, Class clazz) {
        try {
            SshCipher sshCipher = (SshCipher)clazz.newInstance();
            byte[] byArray = new byte[1024];
            sshCipher.init(0, byArray, byArray);
            if (sshCipher instanceof AbstractJCECipher) {
                EventLog.LogEvent(this, "   " + string + " will be supported using JCE Provider " + ((AbstractJCECipher)sshCipher).getProvider());
            }
            return true;
        }
        catch (Throwable throwable) {
            EventLog.LogEvent(this, "   " + string + " will not be supported: " + throwable.getMessage());
            return false;
        }
    }

    private boolean c(String string, Class clazz) {
        try {
            Digest digest = (Digest)clazz.newInstance();
            if (digest instanceof AbstractDigest) {
                EventLog.LogEvent(this, "   " + string + " will be supported using JCE Provider " + ((AbstractDigest)digest).getProvider());
            }
            return true;
        }
        catch (Throwable throwable) {
            EventLog.LogEvent(this, "   " + string + " will not be supported: " + throwable.getMessage());
            return false;
        }
    }

    private boolean b(String string, Class clazz) {
        try {
            SshHmac sshHmac = (SshHmac)clazz.newInstance();
            byte[] byArray = new byte[1024];
            sshHmac.init(byArray);
            if (sshHmac instanceof AbstractHmac) {
                EventLog.LogEvent(this, "   " + string + " will be supported using JCE Provider " + ((AbstractHmac)sshHmac).getProvider());
            }
            return true;
        }
        catch (Throwable throwable) {
            EventLog.LogEvent(this, "   " + string + " will not be supported: " + throwable.getMessage());
            return false;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

