/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh2;

import com.maverick.ssh.PublicKeyAuthentication;
import com.maverick.ssh.SshException;
import com.maverick.ssh.components.SshRsaPublicKey;
import com.maverick.ssh2.AuthenticationClient;
import com.maverick.ssh2.AuthenticationProtocol;
import com.maverick.ssh2.AuthenticationResult;
import com.maverick.ssh2.SignatureGenerator;
import com.maverick.util.ByteArrayWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class Ssh2PublicKeyAuthentication
extends PublicKeyAuthentication
implements AuthenticationClient {
    SignatureGenerator u;

    public void authenticate(AuthenticationProtocol authenticationProtocol, String string) throws SshException, AuthenticationResult {
        try {
            byte[] byArray;
            Object object;
            Object object2;
            if (this.getPublicKey() == null) {
                throw new SshException("Public key not set!", 4);
            }
            if (this.getPrivateKey() == null && this.u == null && this.isAuthenticating()) {
                throw new SshException("Private key or signature generator not set!", 4);
            }
            if (this.getUsername() == null) {
                throw new SshException("Username not set!", 4);
            }
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeBinaryString(authenticationProtocol.getSessionIdentifier());
            byteArrayWriter.write(50);
            byteArrayWriter.writeString(this.getUsername());
            byteArrayWriter.writeString(string);
            byteArrayWriter.writeString("publickey");
            byteArrayWriter.writeBoolean(this.isAuthenticating());
            try {
                if (this.getPublicKey() instanceof SshRsaPublicKey && ((SshRsaPublicKey)this.getPublicKey()).getVersion() == 1) {
                    object2 = (SshRsaPublicKey)this.getPublicKey();
                    byteArrayWriter.writeString("ssh-rsa");
                    object = new ByteArrayWriter();
                    ((ByteArrayWriter)object).writeString("ssh-rsa");
                    ((ByteArrayWriter)object).writeBigInteger(object2.getPublicExponent());
                    ((ByteArrayWriter)object).writeBigInteger(object2.getModulus());
                    byArray = ((ByteArrayOutputStream)object).toByteArray();
                    byteArrayWriter.writeBinaryString(byArray);
                } else {
                    byteArrayWriter.writeString(this.getPublicKey().getAlgorithm());
                    byArray = this.getPublicKey().getEncoded();
                    byteArrayWriter.writeBinaryString(byArray);
                }
            }
            catch (Throwable throwable) {
                throw new SshException("Unsupported public key type " + this.getPublicKey().getAlgorithm(), 4);
            }
            object2 = new ByteArrayWriter();
            ((ByteArrayWriter)object2).writeBoolean(this.isAuthenticating());
            ((ByteArrayWriter)object2).writeString(this.getPublicKey().getAlgorithm());
            ((ByteArrayWriter)object2).writeBinaryString(byArray);
            if (this.isAuthenticating()) {
                object = this.u != null ? (Object)this.u.sign(this.getPublicKey(), byteArrayWriter.toByteArray()) : (Object)this.getPrivateKey().sign(byteArrayWriter.toByteArray());
                ByteArrayWriter byteArrayWriter2 = new ByteArrayWriter();
                byteArrayWriter2.writeString(this.getPublicKey().getAlgorithm());
                byteArrayWriter2.writeBinaryString((byte[])object);
                ((ByteArrayWriter)object2).writeBinaryString(byteArrayWriter2.toByteArray());
            }
            authenticationProtocol.sendRequest(this.getUsername(), string, "publickey", ((ByteArrayOutputStream)object2).toByteArray());
            object = authenticationProtocol.readMessage();
            if (object[0] == 60) {
                throw new AuthenticationResult(5);
            }
            authenticationProtocol.d.disconnect(2, "Unexpected message " + (int)object[0] + " received");
            throw new SshException("Unexpected message " + (int)object[0] + " received", 3);
        }
        catch (IOException iOException) {
            throw new SshException(iOException, 5);
        }
    }

    public void setSignatureGenerator(SignatureGenerator signatureGenerator) {
        this.u = signatureGenerator;
    }
}

