/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.publickey;

import com.maverick.ssh.SshException;
import com.maverick.ssh.components.ComponentManager;
import com.maverick.ssh.components.SshKeyPair;
import java.io.IOException;

public class SshKeyPairGenerator {
    public static final String SSH1_RSA = "rsa1";
    public static final String SSH2_RSA = "ssh-rsa";
    public static final String SSH2_DSA = "ssh-dss";

    public static SshKeyPair generateKeyPair(String string, int n) throws IOException, SshException {
        if (!(SSH1_RSA.equalsIgnoreCase(string) || SSH2_RSA.equalsIgnoreCase(string) || SSH2_DSA.equalsIgnoreCase(string))) {
            throw new IOException(string + " is not a supported key algorithm!");
        }
        SshKeyPair sshKeyPair = new SshKeyPair();
        sshKeyPair = SSH1_RSA.equalsIgnoreCase(string) ? ComponentManager.getInstance().generateRsaKeyPair(n, 1) : (SSH2_RSA.equalsIgnoreCase(string) ? ComponentManager.getInstance().generateRsaKeyPair(n, 2) : ComponentManager.getInstance().generateDsaKeyPair(n));
        return sshKeyPair;
    }
}

