/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.export.control;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.EventObject;
import java.util.HashSet;
import se.ericsson.cello.configurationversion.base.CV_IsIncompleteException;
import se.ericsson.cello.configurationversion.base.CV_SubFunctionController;
import se.ericsson.cello.configurationversion.base.FTP_ServerIsNotAccessibleException;
import se.ericsson.cello.configurationversion.base.FormatOfIP_AddressIsFaultyException;
import se.ericsson.cello.configurationversion.base.IllegalInputDataException;
import se.ericsson.cello.configurationversion.base.InsufficientDiskSpaceOnNodeException;
import se.ericsson.cello.configurationversion.control.CV_Controller;
import se.ericsson.cello.configurationversion.export.control.CV_IsInvalidForBackupException;
import se.ericsson.cello.configurationversion.export.control.CV_IsNotFoundException;
import se.ericsson.cello.configurationversion.export.control.CV_NotConnectedToAnUpgradePackageException;
import se.ericsson.cello.configurationversion.export.control.ExportProperties;
import se.ericsson.cello.configurationversion.export.control.ExporterException;
import se.ericsson.cello.configurationversion.export.control.ExporterInterface;
import se.ericsson.cello.configurationversion.export.control.FTP_AccessOrTransferFailedException;
import se.ericsson.cello.configurationversion.export.control.InsufficientDiskSpaceOnFTP_ServerException;
import se.ericsson.cello.configurationversion.export.event.ExportConfirmedEvent;
import se.ericsson.cello.configurationversion.export.event.ExportRejectedEvent;
import se.ericsson.cello.configurationversion.export.event.ExportRequestEvent;
import se.ericsson.cello.configurationversion.export.upgrade.UpgradeBackupDataContainer;
import se.ericsson.cello.configurationversion.export.upgrade.UpgradeBackupDataController;
import se.ericsson.cello.configurationversion.export.upgrade.UpgradeBackupDataException;
import se.ericsson.cello.configurationversion.file.autoconfiguration.create.AutoConfigurationDataFileCreator;
import se.ericsson.cello.configurationversion.file.base.FilePath;
import se.ericsson.cello.configurationversion.file.base.FilePathException;
import se.ericsson.cello.configurationversion.file.configurationversionbackupdata.create.ConfigurationVersionBackupDataCreator;
import se.ericsson.cello.configurationversion.file.cvftpscript.create.CV_FTP_ScriptFileCreator;
import se.ericsson.cello.configurationversion.file.nodeipdata.create.NodeIP_DataFileCreator;
import se.ericsson.cello.configurationversion.main.event.actionresult.ActionInformationResultErrorInformation;
import se.ericsson.cello.configurationversion.main.event.actionresult.CV_ActionResultDataTypeOfInvokedActionValue;
import se.ericsson.cello.configurationversion.main.event.actionresult.CV_IsIncompleteInformation;
import se.ericsson.cello.configurationversion.main.event.actionresult.CV_IsInvalidForBackupInformation;
import se.ericsson.cello.configurationversion.main.event.actionresult.CV_IsNotConnectedToAnUpgradePackageInformation;
import se.ericsson.cello.configurationversion.main.event.actionresult.CV_IsNotFoundInformation;
import se.ericsson.cello.configurationversion.main.event.actionresult.FTP_AccessOrTransferFailedInformation;
import se.ericsson.cello.configurationversion.main.event.actionresult.FTP_ServerIsNotAccessibleInformation;
import se.ericsson.cello.configurationversion.main.event.actionresult.IllegalValueReceivedInInputParameterInformation;
import se.ericsson.cello.configurationversion.main.event.actionresult.InsufficientDiskspaceOnFTP_ServerInformation;
import se.ericsson.cello.configurationversion.main.event.actionresult.InsufficientDiskspaceOnNodeInformation;
import se.ericsson.cello.configurationversion.main.event.actionresult.InvokedActionPutToFTP_ServerInformation;
import se.ericsson.cello.configurationversion.main.event.actionresult.UnspecifiedErrorInformation;
import se.ericsson.cello.configurationversion.main.event.actionresult.UpgradePackageUcfIsCorruptedInformation;
import se.ericsson.cello.configurationversion.main.event.detailedactivity.CreatingBackupEvent;
import se.ericsson.cello.configurationversion.main.event.detailedactivity.ExecutionFailedEvent;
import se.ericsson.cello.configurationversion.main.event.detailedactivity.ExportOfBackupCV_RequestedEvent;
import se.ericsson.cello.configurationversion.main.event.detailedactivity.IdleEvent;
import se.ericsson.cello.configurationversion.main.event.detailedactivity.TransferingBackupToRemoteServerEvent;
import se.ericsson.cello.configurationversion.main.event.mainactivity.ExportingBackupCV_Event;
import se.ericsson.cello.configurationversion.main.event.mainactivity.MainIdleEvent;
import se.ericsson.cello.configurationversion.main.exception.CVFileSystemErrorException;
import se.ericsson.cello.configurationversion.main.exception.CVLLPErrorException;
import se.ericsson.cello.configurationversion.main.exception.ConfigurationVersionException;
import se.ericsson.cello.configurationversion.main.util.CV_ActionResultCreator;
import se.ericsson.cello.configurationversion.preupgrade.CV_PreUpgradeRelationHandler;
import se.ericsson.cello.configurationversion.util.additionalinfo.AdditionalInformationContainer;
import se.ericsson.cello.configurationversion.util.additionalinfo.AdditionalInformationCreator;
import se.ericsson.cello.configurationversion.util.handler.CV_DataHandler;
import se.ericsson.cello.configurationversion.util.handler.CV_DoesNotExistException;
import se.ericsson.cello.configurationversion.util.handler.SignalHandler;
import se.ericsson.cello.configurationversion.util.mohandler.ethernetlink.EthernetLinkMO_handlerInterface;
import se.ericsson.cello.configurationversion.util.mohandler.upgradepackage.UpgradePackageID_IllegalFormatException;
import se.ericsson.cello.configurationversion.util.mohandler.upgradepackage.UpgradePackageMO_HandlerException;
import se.ericsson.cello.configurationversion.util.mohandler.upgradepackage.UpgradePackageMO_HandlerInterface;
import se.ericsson.cello.configurationversion.util.progresshandler.CV_ProgressInformationHandler;
import se.ericsson.cello.configurationversion.util.progresshandler.NotifyingConfigurationVersionPropertyName;
import se.ericsson.cello.managedelement.suaccess.ManagedElementMoSU_Access;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.MibMgr;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.su.froproxy.cv.interfaces.OsaCvMgmntProxyAccess;
import se.ericsson.cello.su.froproxy.swinstall.interfaces.InstallUploadFileResultInformation;
import se.ericsson.cello.su.froproxy.swinstall.interfaces.OsaSwInstallProxyAccess;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.support.thread.BlockingQueue;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMoExtended;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.datacontainer.UCF_ControlResultContainer;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;
import se.ericsson.cello.upgradepackage.util.time.TimeHandler;
import se.ericsson.cello.upgradepackage.verify.ChecksumHandler;
import se.ericsson.cello.upgradepackage.verify.ChecksumHandlerException;
import se.ericsson.cello.upgradepackage.verify.FailedUCFChecksumErrorInformation;

public class Exporter
extends CV_SubFunctionController
implements ExporterInterface,
Runnable {
    private BlockingQueue myQueue = new BlockingQueue();
    private String myZipSuffix = ".zip";
    private String Anonymous = "anonymous";

    public Exporter() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "Exporter()");
        }
        new Thread(this).start();
    }

    public void exportRequest(String string, String string2, String string3, String string4, String string5, String string6) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "exportRequest(String aCV_Name, String aPathOnFTP_Server, String aCV_BackupNameOnFTP_Server, String anFTP_ServerIP_Address, String anFTP_ServerUserID, String anFTP_ServerPassword)", "aCV_Name: " + string + "\n\taPathOnFTP_Server: " + string2 + "\n\taCV_BackupNameOnFTP_Server: " + string3 + "\n\tanFTP_ServerIP_Address: " + string4 + "\n\tanFTP_ServerUserID: " + string5 + "\n\tanFTP_ServerPassword: " + "****");
        }
        ExportRequestEvent exportRequestEvent = new ExportRequestEvent(this, string, string2, string3, string4, string5, string6);
        this.myQueue.enqueue((Object)exportRequestEvent);
    }

    public void run() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "run()");
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "run ( )", "New thread handling export of a CV has been started.");
        }
        EventObject eventObject = null;
        try {
            eventObject = (EventObject)this.myQueue.dequeue();
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "run ()", "Received event: " + eventObject.getClass().getName() + "\n\tEventData: " + eventObject);
            }
            if (eventObject instanceof ExportRequestEvent) {
                this.handleExportRequest((ExportRequestEvent)eventObject);
            } else {
                Trace.warning(this.getClass(), "run ()", "Unexected event received (ignored)\n\tReceived event: " + eventObject.getClass().getName() + "\n\tEventData: " + eventObject);
            }
        }
        catch (ExporterException exporterException) {
            Trace.info(this.getClass(), "run()", "ExporterException caught while waiting for an event or executing an received event (this should not happen).\n\ttheRequestEvent: " + eventObject + "\n\tException data: " + exporterException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "run()", "Exception caught while waiting for an event or executing an received event.theRequestEvent: " + eventObject, throwable);
            if (eventObject instanceof ExportRequestEvent) {
                this.setActionRejectedResult(new UnspecifiedErrorInformation(), throwable.toString(), ((ExportRequestEvent)eventObject).cvName);
            } else {
                this.setActionRejectedResult(new UnspecifiedErrorInformation(), throwable.toString() + "\n\tReceived request event: " + eventObject, "");
            }
            CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
            CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
            CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
            CV_Controller.instance().exportResponse();
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "run ( )", "Thread handling the export of a CV is now stopped.");
        }
        Trace.flushToTraceFile();
    }

    private void copyNeededCV_FilesToC(String string, String string2) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "copyNeededCV_FilesToC(String aCV_Name, String aTmpFilePath)", "aCV_Name: " + string + "\n\taTmpFilePath: " + string2);
        }
        OsaCvMgmntProxyAccess osaCvMgmntProxyAccess = (OsaCvMgmntProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaCvMgmntProxyAccess.class);
        try {
            int n = osaCvMgmntProxyAccess.sendOsaCvCopyFilesFromCvReq(string, string2);
            if (n == 0) {
                return;
            }
            if (n == 6) {
                throw new CV_DoesNotExistException("Could not copy the requested restore files to C disk due to the CV does not exist.\n\tcopyNeededCV_FilesToC(String aCV_Name, String aTmpFilePath)\n\taCV_Name: " + string + "\n\taTmpFilePath: " + string2);
            }
            if (n == 12) {
                throw new InsufficientDiskSpaceOnNodeException("Could not copy the requested restore files to C disk due to insufficient disk space on the Node.\n\tcopyNeededCV_FilesToC(String aCV_Name, String aTmpFilePath)\n\taCV_Name: " + string + "\n\taTmpFilePath: " + string2);
            }
            if (n == 2) {
                throw new CVFileSystemErrorException("ConfigurationVersion", "Could not copy the requested restore files to C disk due to File System Error.\n\tcopyNeededCV_FilesToC(String aCV_Name, String aTmpFilePath)\n\taCV_Name: " + string + "\n\taTmpFilePath: " + string2);
            }
            if (n == 4) {
                throw new CVLLPErrorException("ConfigurationVersion", "Could not copy the requested restore files to C disk due LLP error.\n\tcopyNeededCV_FilesToC(String aCV_Name, String aTmpFilePath)\n\taCV_Name: " + string + "\n\taTmpFilePath: " + string2);
            }
            throw new ExporterException("Could not copy the requested restore files to C disk due to the reason cause " + n + " (" + osaCvMgmntProxyAccess.getResultMsg(n) + ")." + "\n\tcopyNeededCV_FilesToC(String aCV_Name, String aTmpFilePath)" + "\n\taCV_Name: " + string + "\n\taTmpFilePath: " + string2);
        }
        catch (ConfigurationVersionException configurationVersionException) {
            throw configurationVersionException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "copyNeededCV_FilesToC(String aCV_Name, String aTmpFilePath)", "Throwable caught.\n\taCV_Name: " + string + "\n\taTmpFilePath: " + string2, throwable);
            throw new ExporterException("Class name: " + this.getClass().getName() + "\n\tcopyNeededCV_FilesToC(String aCV_Name, String aTmpFilePath)" + "\n\taTmpFilePath: " + string2 + "\n\taCV_Name: " + string + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private void createCvZipArchiveFile(String string, String string2, String string3) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createCvZipArchiveFile(String aBackupCV_ZipArchiveFileName, String aRootPathOfCreatedFiles, String aCV_Name)", "aBackupCV_ZipArchiveFileName: " + string + "\n\taRootPathOfCreatedFiles: " + string2 + "\n\taCV_Name: " + string3);
        }
        try {
            OsaCvMgmntProxyAccess osaCvMgmntProxyAccess = (OsaCvMgmntProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaCvMgmntProxyAccess.class);
            int n = osaCvMgmntProxyAccess.sendOsaCvCreateBackupReq(string, string3, string2);
            if (n == 0) {
                return;
            }
            if (n == 8) {
                throw new CV_IsIncompleteException("Could not zip the CV backup archive file due to the CV is incomplete.\n\tcreateCvZipArchiveFile(String aBackupCV_ZipArchiveFileName, String aRootPathOfCreatedFiles, String aCV_Name)\n\taBackupCV_ZipArchiveFileName: " + string + "\n\taRootPathOfCreatedFiles: " + string2 + "\n\taCV_Name: " + string3);
            }
            if (n == 6) {
                throw new CV_DoesNotExistException("Could not zip the CV backup archive file due to the CV does not exist.\n\tcreateCvZipArchiveFile(String aBackupCV_ZipArchiveFileName, String aRootPathOfCreatedFiles, String aCV_Name)\n\taBackupCV_ZipArchiveFileName: " + string + "\n\taRootPathOfCreatedFiles: " + string2 + "\n\taCV_Name: " + string3);
            }
            if (n == 12) {
                throw new InsufficientDiskSpaceOnNodeException("Could not zip the CV backup archive file due to insufficient disk space on the Node.\n\tcreateCvZipArchiveFile(String aBackupCV_ZipArchiveFileName, String aRootPathOfCreatedFiles, String aCV_Name)\n\taBackupCV_ZipArchiveFileName: " + string + "\n\taRootPathOfCreatedFiles: " + string2 + "\n\taCV_Name: " + string3);
            }
            if (n == 2) {
                throw new CVFileSystemErrorException("Could not zip the CV backup archive file due to File System Error.", "\n\tcreateCvZipArchiveFile(String aBackupCV_ZipArchiveFileName, String aRootPathOfCreatedFiles, String aCV_Name)\n\taBackupCV_ZipArchiveFileName: " + string + "\n\taRootPathOfCreatedFiles: " + string2 + "\n\taCV_Name: " + string3);
            }
            throw new ExporterException("Could not zip the CV backup archive file due to the reason cause " + n + "." + "\n\tcreateCvZipArchiveFile(String aBackupCV_ZipArchiveFileName, String aRootPathOfCreatedFiles, String aCV_Name)" + "\n\taBackupCV_ZipArchiveFileName: " + string + "\n\taRootPathOfCreatedFiles: " + string2 + "\n\taCV_Name: " + string3);
        }
        catch (ConfigurationVersionException configurationVersionException) {
            throw configurationVersionException;
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            Trace.error(this.getClass(), "createCvZipArchiveFile(String aBackupCV_ZipArchiveFileName, String aRootPathOfCreatedFiles, String aCV_Name)", "FroNotAccessibleException caught.\n\taBackupCV_ZipArchiveFileName: " + string + "\n\taRootPathOfCreatedFiles: " + string2 + "\n\taCV_Name: " + string3 + "Throwable caught.", froNotAccessibleException);
            throw new ExporterException("Class name: " + this.getClass().getName() + "\n\tcreateCvZipArchiveFile(String aBackupCV_ZipArchiveFileName, String aRootPathOfCreatedFiles, String aCV_Name)" + "\n\tFroNotAccessibleException caught." + "\n\taBackupCV_ZipArchiveFileName: " + string + "\n\taRootPathOfCreatedFiles: " + string2 + "\n\taCV_Name: " + string3 + "\n\tThrowable caught." + "\n\tThrowable: " + (Object)((Object)froNotAccessibleException) + "\n\tThrowable data: " + froNotAccessibleException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "createCvZipArchiveFile(String aBackupCV_ZipArchiveFileName, String aRootPathOfCreatedFiles, String aCV_Name)", "Throwable caught.\n\taBackupCV_ZipArchiveFileName: " + string + "\n\taRootPathOfCreatedFiles: " + string2 + "\n\taCV_Name: " + string3 + "Throwable caught.", throwable);
            throw new ExporterException("Class name: " + this.getClass().getName() + "\n\tcreateCvZipArchiveFile(String aBackupCV_ZipArchiveFileName, String aRootPathOfCreatedFiles, String aCV_Name)" + "\n\tThrowable caught." + "\n\taBackupCV_ZipArchiveFileName: " + string + "\n\taRootPathOfCreatedFiles: " + string2 + "\n\taCV_Name: " + string3 + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private String createNameForCV_Backup(String string, String string2) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createNameForCV_Backup(String aCV_BackupName, String aCV_Name)", "aCV_BackupName: " + string + "\n\taCV_Name: " + string2);
        }
        String string3 = null;
        if (string != null && string.length() > 0) {
            string3 = string.endsWith(".zip") ? string : string + this.myZipSuffix;
        } else {
            String string4;
            ManagedElementMoSU_Access managedElementMoSU_Access = (ManagedElementMoSU_Access)MibMgr.instance().getMib().getRootMo();
            String string5 = managedElementMoSU_Access.getFullDistinguishedName();
            if (string5.equals(string4 = managedElementMoSU_Access.getLocalDistinguishedName())) {
                EthernetLinkMO_handlerInterface ethernetLinkMO_handlerInterface = ServiceFinder.getEthernetLinkMO_handlerInterface();
                String string6 = ethernetLinkMO_handlerInterface.getNodeIP_Address();
                if (string6 == null) {
                    Trace.info(this.getClass(), "createNameForCV_Backup(String aCV_BackupName, String aCV_Name)", "No site prefix for the ME MOs LDN has been defined and no IP address for the node is available.\n\tThe CV backup name will only consist of the CV name + time stamp followed by the zip suffix.");
                    string3 = string2 + "_" + TimeHandler.createCV_TimeStamp() + this.myZipSuffix;
                } else {
                    string3 = string2 + "_" + string6 + "_" + TimeHandler.createCV_TimeStamp() + this.myZipSuffix;
                }
            } else {
                string3 = string2 + "_" + string5 + "_" + TimeHandler.createCV_TimeStamp() + this.myZipSuffix;
            }
        }
        return string3.replace('/', '%').replace('\\', '%');
    }

    private String getFileStatusMessage(String string, File file) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getFileStatusMessage(String aFileName, File aFile)", "aFileName: " + string + "\n\taFile: " + file);
        }
        try {
            if (file.exists()) {
                return "\n\tThe file '" + string + "' exists.";
            }
            return "\n\tThe file '" + string + "' is missing.";
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getFileStatusMessage(String aFileName, File aFile)", "Exception caught,\n\taFileName: " + string, throwable);
            return "\n\tThe state of file '" + string + "' is unknown (due to Exception caught).";
        }
    }

    private String getUpgradePackageID(String string) throws CV_NotConnectedToAnUpgradePackageException, ExporterException, CV_DoesNotExistException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getUpgradePackageID(String aCV_Name)", "aCV_Name: " + string);
        }
        try {
            CV_DataHandler cV_DataHandler = new CV_DataHandler();
            String string2 = cV_DataHandler.getUpgradePackageID(string);
            if (string2 != null && !string2.equals("")) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "getUpgradePackageID(String aCV_Name)", "Returns the upgrade package ID: " + string2);
                }
                return string2;
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "getUpgradePackageID(String aCV_Name)", "No UpgradePackageID was found for given CV name.\n\taCV_Name: " + string);
            }
            throw new CV_NotConnectedToAnUpgradePackageException(this.getClass().getName() + "\n\tgetUpgradePackageID(String aCV_Name)" + "\n\tNo UpgradePackageID was found for given CV name." + "\n\taCV_Name: " + string);
        }
        catch (CV_DoesNotExistException cV_DoesNotExistException) {
            throw cV_DoesNotExistException;
        }
        catch (ConfigurationVersionException configurationVersionException) {
            throw new ExporterException(configurationVersionException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getUpgradePackageID(String aCV_Name)", "Exception caugth,\n\taCV_Name: " + string, throwable);
            throw new ExporterException(this.getClass().getName() + "\n\tgetUpgradePackageID(String aCV_Name)" + "\n\tException caugth when trying to retreive the upgrade package ID for given CV name," + "\n\taCV_Name: " + string + "\n\tException data: " + throwable.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleExportRequest(ExportRequestEvent exportRequestEvent) throws ExporterException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleExportRequest(ExportRequestEvent anExportRequestEvent)", "anExportRequestEvent: " + exportRequestEvent);
        }
        HashSet<String> hashSet = new HashSet<String>();
        AdditionalInformationCreator additionalInformationCreator = new AdditionalInformationCreator();
        String string = null;
        String string2 = null;
        String string3 = null;
        try {
            try {
                additionalInformationCreator.activate();
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new ExportingBackupCV_Event(this));
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExportOfBackupCV_RequestedEvent(this));
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "handleExportRequest(ExportRequestEvent anExportRequestEvent)", "Validates input parameters.");
                }
                this.validateInputdata(exportRequestEvent);
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "handleExportRequest(ExportRequestEvent anExportRequestEvent)", "Retrieves the upgrade package identity connected of the CV that shall be exported to the FTP Server.");
                }
                String string4 = this.getUpgradePackageID(exportRequestEvent.cvName);
                this.verifyChecksumOfUcf(string4);
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "handleExportRequest(ExportRequestEvent anExportRequestEvent)", "Verifying that the CV is of valid type.");
                }
                this.verifyThatCV_IsOfValidType(exportRequestEvent.cvName);
                ExportProperties exportProperties = new ExportProperties();
                FilePath filePath = new FilePath();
                string = filePath.createValidCV_RootFilePath(exportProperties.cvCMA_FileDisk, exportProperties.getCV_BackupFilesRootPath());
                string3 = filePath.createValidCV_RootFilePath(exportProperties.cvCMA_FileDisk, exportProperties.getCV_BackupFilesTmpPath());
                string2 = filePath.createValidCV_RootFilePath(exportProperties.cvCMA_FileDisk, exportProperties.getCV_BackupName_DirPath());
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "handleExportRequest(ExportRequestEvent anExportRequestEvent)", "Verifying that contents of CV is correct.");
                }
                this.verifyThatCV_ContainsMandatoryInformation(exportRequestEvent.cvName, string3);
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new CreatingBackupEvent(this));
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "handleExportRequest(ExportRequestEvent anExportRequestEvent)", "Creating the Upgrade Package Backup data files.");
                }
                UpgradeBackupDataController upgradeBackupDataController = new UpgradeBackupDataController();
                UpgradeBackupDataContainer upgradeBackupDataContainer = upgradeBackupDataController.createUpgradePackageBackupData(string + "/", string4);
                hashSet.addAll(upgradeBackupDataContainer.backupDataFilePaths);
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "handleExportRequest(ExportRequestEvent anExportRequestEvent)", "Creating the Configuration Version unique data files.");
                }
                ConfigurationVersionBackupDataCreator configurationVersionBackupDataCreator = new ConfigurationVersionBackupDataCreator();
                configurationVersionBackupDataCreator.createFiles(string + "/", exportRequestEvent.cvName);
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "handleExportRequest(ExportRequestEvent anExportRequestEvent)", "Creating the Node IP Configuration file.");
                }
                NodeIP_DataFileCreator nodeIP_DataFileCreator = new NodeIP_DataFileCreator();
                String string5 = nodeIP_DataFileCreator.createFile("3", string + "/");
                hashSet.add(string5);
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "handleExportRequest(ExportRequestEvent anExportRequestEvent)", "Creating the Auto-Configuration Node IP Configuration file.");
                }
                AutoConfigurationDataFileCreator autoConfigurationDataFileCreator = new AutoConfigurationDataFileCreator();
                String string6 = autoConfigurationDataFileCreator.createFile("1", string + "/", "asConfigured", true);
                hashSet.add(string6);
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "handleExportRequest(ExportRequestEvent anExportRequestEvent)", "Creating the CV FTP script file.");
                }
                CV_FTP_ScriptFileCreator cV_FTP_ScriptFileCreator = new CV_FTP_ScriptFileCreator();
                String string7 = cV_FTP_ScriptFileCreator.createFile(string + "/", string3 + "/", exportRequestEvent.cvName);
                hashSet.add(string7);
                String string8 = this.createNameForCV_Backup(exportRequestEvent.cvBackupNameOnFTP_Server, exportRequestEvent.cvName);
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "handleExportRequest(ExportRequestEvent anExportRequestEvent)", "Creating the CV ZIP file " + string8 + " containing all the created configuration/data files.");
                }
                this.createCvZipArchiveFile(string2 + "/" + string8, string, exportRequestEvent.cvName);
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "handleExportRequest(ExportRequestEvent anExportRequestEvent)", "The CV ZIP file is exported (transferred) to the FTP server.");
                }
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new TransferingBackupToRemoteServerEvent(this));
                this.putCV_ZIP_ArchiveFileToFTP_Server(string2 + "/" + string8, exportRequestEvent.ftpServerIP_Address, exportRequestEvent.ftpServerUserID, exportRequestEvent.ftpServerPassword, exportRequestEvent.pathOnFTP_Server + string8);
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "handleExportRequest(ExportRequestEvent anExportRequestEvent)", "Removes all files that were created for the backup CV.\n\tCreated files: " + hashSet);
                }
                this.deleteCreatedFiles(string);
                this.deleteCreatedFiles(string3);
                this.deleteCreatedFiles(string2);
                additionalInformationCreator.deactivate();
                this.setActionConfirmedResult(additionalInformationCreator.getAdditionalInformations(), string8, exportRequestEvent.cvName);
            }
            catch (CV_DoesNotExistException cV_DoesNotExistException) {
                additionalInformationCreator.deactivate();
                this.setActionRejectedResult(additionalInformationCreator.getAdditionalInformations(), new CV_IsNotFoundInformation(), cV_DoesNotExistException.toString(), exportRequestEvent.cvName);
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
                Object var21_38 = null;
                Trace.log1(this.getClass(), "handleExportRequest(ExportRequestEvent anExportRequestEvent)", "Cleaning up.");
                additionalInformationCreator.deactivate();
                additionalInformationCreator = null;
                this.deleteCreatedFiles(string);
                this.deleteCreatedFiles(string3);
                this.deleteCreatedFiles(string2);
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
                Trace.flushToTraceFile();
                CV_Controller.instance().exportResponse();
                return;
            }
            catch (CV_NotConnectedToAnUpgradePackageException cV_NotConnectedToAnUpgradePackageException) {
                additionalInformationCreator.deactivate();
                this.setActionRejectedResult(additionalInformationCreator.getAdditionalInformations(), new CV_IsNotConnectedToAnUpgradePackageInformation(), cV_NotConnectedToAnUpgradePackageException.toString(), exportRequestEvent.cvName);
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
                Object var21_39 = null;
                Trace.log1(this.getClass(), "handleExportRequest(ExportRequestEvent anExportRequestEvent)", "Cleaning up.");
                additionalInformationCreator.deactivate();
                additionalInformationCreator = null;
                this.deleteCreatedFiles(string);
                this.deleteCreatedFiles(string3);
                this.deleteCreatedFiles(string2);
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
                Trace.flushToTraceFile();
                CV_Controller.instance().exportResponse();
                return;
            }
            catch (CV_IsInvalidForBackupException cV_IsInvalidForBackupException) {
                additionalInformationCreator.deactivate();
                this.setActionRejectedResult(additionalInformationCreator.getAdditionalInformations(), new CV_IsInvalidForBackupInformation(), cV_IsInvalidForBackupException.toString(), exportRequestEvent.cvName);
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
                Object var21_40 = null;
                Trace.log1(this.getClass(), "handleExportRequest(ExportRequestEvent anExportRequestEvent)", "Cleaning up.");
                additionalInformationCreator.deactivate();
                additionalInformationCreator = null;
                this.deleteCreatedFiles(string);
                this.deleteCreatedFiles(string3);
                this.deleteCreatedFiles(string2);
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
                Trace.flushToTraceFile();
                CV_Controller.instance().exportResponse();
                return;
            }
            catch (CV_IsNotFoundException cV_IsNotFoundException) {
                additionalInformationCreator.deactivate();
                this.setActionRejectedResult(additionalInformationCreator.getAdditionalInformations(), new CV_IsNotFoundInformation(), cV_IsNotFoundException.toString(), exportRequestEvent.cvName);
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
                Object var21_41 = null;
                Trace.log1(this.getClass(), "handleExportRequest(ExportRequestEvent anExportRequestEvent)", "Cleaning up.");
                additionalInformationCreator.deactivate();
                additionalInformationCreator = null;
                this.deleteCreatedFiles(string);
                this.deleteCreatedFiles(string3);
                this.deleteCreatedFiles(string2);
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
                Trace.flushToTraceFile();
                CV_Controller.instance().exportResponse();
                return;
            }
            catch (CV_IsIncompleteException cV_IsIncompleteException) {
                additionalInformationCreator.deactivate();
                this.setActionRejectedResult(additionalInformationCreator.getAdditionalInformations(), new CV_IsIncompleteInformation(), cV_IsIncompleteException.toString(), exportRequestEvent.cvName);
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
                Object var21_42 = null;
                Trace.log1(this.getClass(), "handleExportRequest(ExportRequestEvent anExportRequestEvent)", "Cleaning up.");
                additionalInformationCreator.deactivate();
                additionalInformationCreator = null;
                this.deleteCreatedFiles(string);
                this.deleteCreatedFiles(string3);
                this.deleteCreatedFiles(string2);
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
                Trace.flushToTraceFile();
                CV_Controller.instance().exportResponse();
                return;
            }
            catch (InsufficientDiskSpaceOnNodeException insufficientDiskSpaceOnNodeException) {
                additionalInformationCreator.deactivate();
                this.setActionRejectedResult(additionalInformationCreator.getAdditionalInformations(), new InsufficientDiskspaceOnNodeInformation(), insufficientDiskSpaceOnNodeException.toString(), exportRequestEvent.cvName);
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
                Object var21_43 = null;
                Trace.log1(this.getClass(), "handleExportRequest(ExportRequestEvent anExportRequestEvent)", "Cleaning up.");
                additionalInformationCreator.deactivate();
                additionalInformationCreator = null;
                this.deleteCreatedFiles(string);
                this.deleteCreatedFiles(string3);
                this.deleteCreatedFiles(string2);
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
                Trace.flushToTraceFile();
                CV_Controller.instance().exportResponse();
                return;
            }
            catch (InsufficientDiskSpaceOnFTP_ServerException insufficientDiskSpaceOnFTP_ServerException) {
                additionalInformationCreator.deactivate();
                this.setActionRejectedResult(additionalInformationCreator.getAdditionalInformations(), new InsufficientDiskspaceOnFTP_ServerInformation(), insufficientDiskSpaceOnFTP_ServerException.toString(), exportRequestEvent.cvName);
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
                Object var21_44 = null;
                Trace.log1(this.getClass(), "handleExportRequest(ExportRequestEvent anExportRequestEvent)", "Cleaning up.");
                additionalInformationCreator.deactivate();
                additionalInformationCreator = null;
                this.deleteCreatedFiles(string);
                this.deleteCreatedFiles(string3);
                this.deleteCreatedFiles(string2);
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
                Trace.flushToTraceFile();
                CV_Controller.instance().exportResponse();
                return;
            }
            catch (FTP_ServerIsNotAccessibleException fTP_ServerIsNotAccessibleException) {
                additionalInformationCreator.deactivate();
                this.setActionRejectedResult(additionalInformationCreator.getAdditionalInformations(), new FTP_ServerIsNotAccessibleInformation(), fTP_ServerIsNotAccessibleException.toString(), exportRequestEvent.cvName);
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
                Object var21_45 = null;
                Trace.log1(this.getClass(), "handleExportRequest(ExportRequestEvent anExportRequestEvent)", "Cleaning up.");
                additionalInformationCreator.deactivate();
                additionalInformationCreator = null;
                this.deleteCreatedFiles(string);
                this.deleteCreatedFiles(string3);
                this.deleteCreatedFiles(string2);
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
                Trace.flushToTraceFile();
                CV_Controller.instance().exportResponse();
                return;
            }
            catch (FTP_AccessOrTransferFailedException fTP_AccessOrTransferFailedException) {
                additionalInformationCreator.deactivate();
                this.setActionRejectedResult(additionalInformationCreator.getAdditionalInformations(), new FTP_AccessOrTransferFailedInformation(), fTP_AccessOrTransferFailedException.toString(), exportRequestEvent.cvName);
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
                Object var21_46 = null;
                Trace.log1(this.getClass(), "handleExportRequest(ExportRequestEvent anExportRequestEvent)", "Cleaning up.");
                additionalInformationCreator.deactivate();
                additionalInformationCreator = null;
                this.deleteCreatedFiles(string);
                this.deleteCreatedFiles(string3);
                this.deleteCreatedFiles(string2);
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
                Trace.flushToTraceFile();
                CV_Controller.instance().exportResponse();
                return;
            }
            catch (FormatOfIP_AddressIsFaultyException formatOfIP_AddressIsFaultyException) {
                additionalInformationCreator.deactivate();
                this.setActionRejectedResult(additionalInformationCreator.getAdditionalInformations(), new IllegalValueReceivedInInputParameterInformation(), formatOfIP_AddressIsFaultyException.toString(), exportRequestEvent.cvName);
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
                Object var21_47 = null;
                Trace.log1(this.getClass(), "handleExportRequest(ExportRequestEvent anExportRequestEvent)", "Cleaning up.");
                additionalInformationCreator.deactivate();
                additionalInformationCreator = null;
                this.deleteCreatedFiles(string);
                this.deleteCreatedFiles(string3);
                this.deleteCreatedFiles(string2);
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
                Trace.flushToTraceFile();
                CV_Controller.instance().exportResponse();
                return;
            }
            catch (IllegalInputDataException illegalInputDataException) {
                additionalInformationCreator.deactivate();
                this.setActionRejectedResult(additionalInformationCreator.getAdditionalInformations(), new IllegalValueReceivedInInputParameterInformation(), illegalInputDataException.toString(), exportRequestEvent.cvName);
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
                Object var21_48 = null;
                Trace.log1(this.getClass(), "handleExportRequest(ExportRequestEvent anExportRequestEvent)", "Cleaning up.");
                additionalInformationCreator.deactivate();
                additionalInformationCreator = null;
                this.deleteCreatedFiles(string);
                this.deleteCreatedFiles(string3);
                this.deleteCreatedFiles(string2);
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
                Trace.flushToTraceFile();
                CV_Controller.instance().exportResponse();
                return;
            }
            catch (UpgradePackageID_IllegalFormatException upgradePackageID_IllegalFormatException) {
                additionalInformationCreator.deactivate();
                this.setActionRejectedResult(additionalInformationCreator.getAdditionalInformations(), new CV_IsNotConnectedToAnUpgradePackageInformation(), upgradePackageID_IllegalFormatException.toString(), exportRequestEvent.cvName);
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
                Object var21_49 = null;
                Trace.log1(this.getClass(), "handleExportRequest(ExportRequestEvent anExportRequestEvent)", "Cleaning up.");
                additionalInformationCreator.deactivate();
                additionalInformationCreator = null;
                this.deleteCreatedFiles(string);
                this.deleteCreatedFiles(string3);
                this.deleteCreatedFiles(string2);
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
                Trace.flushToTraceFile();
                CV_Controller.instance().exportResponse();
                return;
            }
            catch (ChecksumHandlerException checksumHandlerException) {
                additionalInformationCreator.deactivate();
                this.setActionRejectedResult(additionalInformationCreator.getAdditionalInformations(), new UpgradePackageUcfIsCorruptedInformation(), checksumHandlerException.toString(), exportRequestEvent.cvName);
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
                Object var21_50 = null;
                Trace.log1(this.getClass(), "handleExportRequest(ExportRequestEvent anExportRequestEvent)", "Cleaning up.");
                additionalInformationCreator.deactivate();
                additionalInformationCreator = null;
                this.deleteCreatedFiles(string);
                this.deleteCreatedFiles(string3);
                this.deleteCreatedFiles(string2);
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
                Trace.flushToTraceFile();
                CV_Controller.instance().exportResponse();
                return;
            }
            catch (ExporterException exporterException) {
                additionalInformationCreator.deactivate();
                this.setActionRejectedResult(additionalInformationCreator.getAdditionalInformations(), new UnspecifiedErrorInformation(), exporterException.toString(), exportRequestEvent.cvName);
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
                Object var21_51 = null;
                Trace.log1(this.getClass(), "handleExportRequest(ExportRequestEvent anExportRequestEvent)", "Cleaning up.");
                additionalInformationCreator.deactivate();
                additionalInformationCreator = null;
                this.deleteCreatedFiles(string);
                this.deleteCreatedFiles(string3);
                this.deleteCreatedFiles(string2);
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
                Trace.flushToTraceFile();
                CV_Controller.instance().exportResponse();
                return;
            }
            catch (FilePathException filePathException) {
                additionalInformationCreator.deactivate();
                this.setActionRejectedResult(additionalInformationCreator.getAdditionalInformations(), new UnspecifiedErrorInformation(), filePathException.toString(), exportRequestEvent.cvName);
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
                Object var21_52 = null;
                Trace.log1(this.getClass(), "handleExportRequest(ExportRequestEvent anExportRequestEvent)", "Cleaning up.");
                additionalInformationCreator.deactivate();
                additionalInformationCreator = null;
                this.deleteCreatedFiles(string);
                this.deleteCreatedFiles(string3);
                this.deleteCreatedFiles(string2);
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
                Trace.flushToTraceFile();
                CV_Controller.instance().exportResponse();
                return;
            }
            catch (ConfigurationVersionException configurationVersionException) {
                additionalInformationCreator.deactivate();
                this.setActionRejectedResult(additionalInformationCreator.getAdditionalInformations(), new UnspecifiedErrorInformation(), configurationVersionException.toString(), exportRequestEvent.cvName);
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
                Object var21_53 = null;
                Trace.log1(this.getClass(), "handleExportRequest(ExportRequestEvent anExportRequestEvent)", "Cleaning up.");
                additionalInformationCreator.deactivate();
                additionalInformationCreator = null;
                this.deleteCreatedFiles(string);
                this.deleteCreatedFiles(string3);
                this.deleteCreatedFiles(string2);
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
                Trace.flushToTraceFile();
                CV_Controller.instance().exportResponse();
                return;
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "handleExportRequest(ExportRequestEvent anExportRequestEvent)", "Exception caugth,\n\tanExportRequestEvent: " + exportRequestEvent, throwable);
                additionalInformationCreator.deactivate();
                this.setActionRejectedResult(additionalInformationCreator.getAdditionalInformations(), new UnspecifiedErrorInformation(), throwable.toString(), exportRequestEvent.cvName);
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
                Object var21_54 = null;
                Trace.log1(this.getClass(), "handleExportRequest(ExportRequestEvent anExportRequestEvent)", "Cleaning up.");
                additionalInformationCreator.deactivate();
                additionalInformationCreator = null;
                this.deleteCreatedFiles(string);
                this.deleteCreatedFiles(string3);
                this.deleteCreatedFiles(string2);
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
                Trace.flushToTraceFile();
                CV_Controller.instance().exportResponse();
                return;
            }
            Object var21_37 = null;
        }
        catch (Throwable throwable) {
            Object var21_55 = null;
            Trace.log1(this.getClass(), "handleExportRequest(ExportRequestEvent anExportRequestEvent)", "Cleaning up.");
            additionalInformationCreator.deactivate();
            additionalInformationCreator = null;
            this.deleteCreatedFiles(string);
            this.deleteCreatedFiles(string3);
            this.deleteCreatedFiles(string2);
            CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
            CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
            Trace.flushToTraceFile();
            CV_Controller.instance().exportResponse();
            throw throwable;
        }
        Trace.log1(this.getClass(), "handleExportRequest(ExportRequestEvent anExportRequestEvent)", "Cleaning up.");
        additionalInformationCreator.deactivate();
        additionalInformationCreator = null;
        this.deleteCreatedFiles(string);
        this.deleteCreatedFiles(string3);
        this.deleteCreatedFiles(string2);
        CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
        CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
        Trace.flushToTraceFile();
        CV_Controller.instance().exportResponse();
    }

    private void putCV_ZIP_ArchiveFileToFTP_Server(String string, String string2, String string3, String string4, String string5) throws ExporterException, InsufficientDiskSpaceOnFTP_ServerException, FormatOfIP_AddressIsFaultyException, FTP_AccessOrTransferFailedException, FTP_ServerIsNotAccessibleException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "putCV_ZIP_ArchiveFileToFTP_Server(String aFilePath, String anIP_Address, String anUserID, String aPassword, String aPathOnFtpServer)", "aFilePath: " + string + "\n\tanIP_Address: " + string2 + "\n\tanUserID: " + string3 + "\n\taPassword: " + "*****" + "\n\taPathOnFtpServer: " + string5);
        }
        String string6 = string2;
        try {
            InetAddress inetAddress = InetAddress.getByName(string2);
            string6 = inetAddress.getHostAddress();
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "putCV_ZIP_ArchiveFileToFTP_Server(String aFilePath, String anIP_Address, String anUserID, String aPassword, String aPathOnFtpServer)", "theFTP_ServerIP_Address: " + string6);
            }
            OsaSwInstallProxyAccess osaSwInstallProxyAccess = (OsaSwInstallProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaSwInstallProxyAccess.class);
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "putCV_ZIP_ArchiveFileToFTP_Server(String aFilePath, String anIP_Address, String anUserID, String aPassword, String aPathOnFtpServer)", "Sending signal 'OsaSwInstallUploadFileReq3'.");
            }
            InstallUploadFileResultInformation installUploadFileResultInformation = osaSwInstallProxyAccess.sendOsaSwInstallUploadFileReq3(string3, string4, string6, string, string5);
            int n = installUploadFileResultInformation.result;
            if (n == 1) {
                return;
            }
            if (n == 5) {
                throw new FormatOfIP_AddressIsFaultyException("Class name: " + this.getClass().getName() + "Could not export (put) the CV backup archive file to the FTP server due to illegal format of IP address." + "\n\tputCV_ZIP_ArchiveFileToFTP_Server(String aFilePath, String anIP_Address, String anUserID, String aPassword, String aPathOnFtpServer)" + "\n\tAdditional failure reason: " + installUploadFileResultInformation.errorInformation + "\n\taFilePath: " + string + "\n\tanIP_Address: " + string2 + "\n\ttheFTP_ServerIP_Address: " + string6 + "\n\tanUserID: " + string3 + "\n\taPassword: " + "*****" + "\n\taPathOnFtpServer: " + string5);
            }
            if (n == 3) {
                throw new FTP_AccessOrTransferFailedException("Class name: " + this.getClass().getName() + "Could not export (put) the CV backup archive file to the FTP server due to FTP access or transfer failed." + "\n\tputCV_ZIP_ArchiveFileToFTP_Server(String aFilePath, String anIP_Address, String anUserID, String aPassword, String aPathOnFtpServer)" + "\n\tAdditional failure reason: " + installUploadFileResultInformation.errorInformation + "\n\taFilePath: " + string + "\n\tanIP_Address: " + string2 + "\n\ttheFTP_ServerIP_Address: " + string6 + "\n\tanUserID: " + string3 + "\n\taPassword: " + "*****" + "\n\taPathOnFtpServer: " + string5);
            }
            if (n == 10 || n == 4) {
                throw new ExporterException("Class name: " + this.getClass().getName() + "Failed to export (put) the CV backup archive file to the FTP server for any reason (see further additional failure reason below) e.g. the FTP server is full, given path on FTP server does not exist e.t.c." + "\n\tputCV_ZIP_ArchiveFileToFTP_Server(String aFilePath, String anIP_Address, String anUserID, String aPassword, String aPathOnFtpServer)" + "\n\tAdditional failure reason: " + installUploadFileResultInformation.errorInformation + "\n\taFilePath: " + string + "\n\tanIP_Address: " + string2 + "\n\ttheFTP_ServerIP_Address: " + string6 + "\n\tanUserID: " + string3 + "\n\taPassword: " + "*****" + "\n\taPathOnFtpServer: " + string5);
            }
            throw new ExporterException("Class name: " + this.getClass().getName() + "Could not zip the CV backup archive file due to the reason cause " + n + "." + "\n\tputCV_ZIP_ArchiveFileToFTP_Server(String aFilePath, String anIP_Address, String anUserID, String aPassword, String aPathOnFtpServer)" + "\n\tAdditional failure reason: " + installUploadFileResultInformation.errorInformation + "\n\taFilePath: " + string + "\n\tanIP_Address: " + string2 + "\n\ttheFTP_ServerIP_Address: " + string6 + "\n\tanUserID: " + string3 + "\n\taPassword: " + "*****" + "\n\taPathOnFtpServer: " + string5);
        }
        catch (UnknownHostException unknownHostException) {
            throw new FTP_ServerIsNotAccessibleException("Could not look up the given host name address to the FTP Server.\n\tputCV_ZIP_ArchiveFileToFTP_Server(String aFilePath, String anIP_Address, String anUserID, String aPassword, String aPathOnFtpServer)\n\taFilePath: " + string + "\n\tanIP_Address: " + string2 + "\n\tanUserID: " + string3 + "\n\taPassword: " + "****" + "\n\taPathOnFtpServer: " + string5 + "\n\tException data: " + unknownHostException.toString());
        }
        catch (ExporterException exporterException) {
            throw exporterException;
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            Trace.error(this.getClass(), "\n\tputCV_ZIP_ArchiveFileToFTP_Server(String aFilePath, String anIP_Address, String anUserID, String aPassword, String aPathOnFtpServer)", "FroNotAccessibleException caught.\n\taFilePath: " + string + "\n\tanIP_Address: " + string2 + "\n\tanUserID: " + string3 + "\n\taPassword: " + "*****" + "\n\taPathOnFtpServer: " + string5, froNotAccessibleException);
            throw new ExporterException("Class name: " + this.getClass().getName() + "\n\tFroNotAccessibleException caught." + "\n\taFilePath: " + string + "\n\tanIP_Address: " + string2 + "\n\tanUserID: " + string3 + "\n\taPassword: " + "*****" + "\n\taPathOnFtpServer: " + string5 + "\n\tFroNotAccessibleException: " + (Object)((Object)froNotAccessibleException) + "\n\tFroNotAccessibleException data: " + froNotAccessibleException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "putCV_ZIP_ArchiveFileToFTP_Server(String aBackupCV_ZipArchiveFileName, String aRootPathOfCreatedFiles, String aCV_Name)", "Throwable caught.\n\taFilePath: " + string + "\n\tanIP_Address: " + string2 + "\n\tanUserID: " + string3 + "\n\taPassword: " + "*****" + "\n\taPathOnFtpServer: " + string5, throwable);
            throw new ExporterException("Class name: " + this.getClass().getName() + "\n\tputCV_ZIP_ArchiveFileToFTP_Server(String aBackupCV_ZipArchiveFileName, String aRootPathOfCreatedFiles, String aCV_Name)" + "\n\tThrowable caught." + "\n\taFilePath: " + string + "\n\tanIP_Address: " + string2 + "\n\tanUserID: " + string3 + "\n\taPassword: " + "*****" + "\n\taPathOnFtpServer: " + string5 + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private void setActionConfirmedResult(AdditionalInformationContainer additionalInformationContainer, String string, String string2) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setActionResult(AdditionalInformationContainer anAdditionalInformationContainer, String aCV_BackupName, String aCV_Name)", "anAdditionalInformationContainer: " + additionalInformationContainer + "\n\taCV_BackupName: " + string + "\n\taCV_Name: " + string2);
        }
        try {
            CV_ActionResultCreator cV_ActionResultCreator = new CV_ActionResultCreator();
            ExportConfirmedEvent exportConfirmedEvent = new ExportConfirmedEvent(this, additionalInformationContainer.getTraceInfos(), additionalInformationContainer.getTraceWarnings(), string, string2);
            cV_ActionResultCreator.createActionResult(exportConfirmedEvent, (CV_ActionResultDataTypeOfInvokedActionValue)new InvokedActionPutToFTP_ServerInformation());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "setActionResult(AdditionalInformationCreator anAdditionalInformationCreator)", "Throwable caugth when attempting to set the attribute actionResult (ignored)\n\tanAdditionalInformationContainer: " + additionalInformationContainer + "\n\taCV_BackupName: " + string + "\n\taCV_Name: " + string2, throwable);
        }
    }

    private void setActionRejectedResult(ActionInformationResultErrorInformation actionInformationResultErrorInformation, String string, String string2) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setActionRejectedResult(ActionInformationResultErrorInformation anActionResultErrorInformation, String anAdditionalInformationToActionInformation, String aCV_Name)", "\n\tanActionInformationResultErrorInformation: " + actionInformationResultErrorInformation + "\n\tanAdditionalInformationToActionInformation: " + string + "\n\taCV_Name: " + string2);
        }
        this.setActionRejectedResult(new AdditionalInformationContainer(), actionInformationResultErrorInformation, string, string2);
    }

    private void setActionRejectedResult(AdditionalInformationContainer additionalInformationContainer, ActionInformationResultErrorInformation actionInformationResultErrorInformation, String string, String string2) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setActionRejectedResult(AdditionalInformationContainer anAdditionalInformationContainer, ActionInformationResultErrorInformation anActionResultErrorInformation, String anAdditionalInformationToActionInformation, String aCV_Name)", "anAdditionalInformationContainer: " + additionalInformationContainer + "\n\tanActionInformationResultErrorInformation: " + actionInformationResultErrorInformation + "\n\tanAdditionalInformationToActionInformation: " + string + "\n\taCV_Name: " + string2);
        }
        try {
            CV_ActionResultCreator cV_ActionResultCreator = new CV_ActionResultCreator();
            ExportRejectedEvent exportRejectedEvent = new ExportRejectedEvent(this, additionalInformationContainer.getTraceInfos(), additionalInformationContainer.getTraceWarnings(), additionalInformationContainer.getTraceErrors(), actionInformationResultErrorInformation, string, string2);
            cV_ActionResultCreator.createActionResult(exportRejectedEvent, (CV_ActionResultDataTypeOfInvokedActionValue)new InvokedActionPutToFTP_ServerInformation());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "setActionRejectedResult(AdditionalInformationContainer anAdditionalInformationContainer, ActionInformationResultErrorInformation anActionInformationResultErrorInformation, String anAdditionalInformationToActionInformation, String aCV_Name)", "Throwable caugth when attempting to set the attribute actionResult (ignored).\n\tanAdditionalInformationContainer: " + additionalInformationContainer + "\n\tanActionResultErrorInformation: " + actionInformationResultErrorInformation + "\n\tanAdditionalInformationToActionInformation: " + string, throwable);
        }
    }

    private void validateInputdata(ExportRequestEvent exportRequestEvent) throws IllegalInputDataException, ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "validateInputdata(ExportRequestEvent anExportRequestEvent)", "anExportRequestEvent: " + exportRequestEvent);
        }
        this.validateMandatoryString("cvName", exportRequestEvent.cvName);
        this.validateMandatoryString("pathOnFTP_Server", exportRequestEvent.pathOnFTP_Server);
        this.validateMandatoryString("ftpServerIP_Address", exportRequestEvent.ftpServerIP_Address);
        if (exportRequestEvent.ftpServerUserID == null || exportRequestEvent.ftpServerUserID.length() == 0) {
            exportRequestEvent.ftpServerUserID = this.Anonymous;
        }
        if (exportRequestEvent.ftpServerPassword == null || exportRequestEvent.ftpServerPassword.length() == 0) {
            exportRequestEvent.ftpServerPassword = this.Anonymous;
        }
        this.validateLengthOfString(exportRequestEvent.ftpServerUserID, 255, "The max length of the parameter 'ftpServerUserID' is 255 characters.\n\tftpServerUserID: " + exportRequestEvent.ftpServerUserID);
        this.validateLengthOfString(exportRequestEvent.ftpServerPassword, 20, "The max length of the parameter 'ftpServerPassword' is 20 characters.\n\tftpServerUserID length: " + exportRequestEvent.ftpServerPassword.length());
        int n = 40;
        this.validateLengthOfString(exportRequestEvent.cvName, n, "The max length of the parameter 'cvName' is " + n + " characters." + "\n\tcvName: " + exportRequestEvent.cvName);
        this.validateLengthOfString(exportRequestEvent.ftpServerIP_Address, 256, "The max length of the parameter 'ftpServerIpAddress' is 256 characters.\n\tftpServerIpAddress: " + exportRequestEvent.ftpServerIP_Address);
        exportRequestEvent.pathOnFTP_Server = exportRequestEvent.pathOnFTP_Server.replace('\\', '/');
        if (!exportRequestEvent.pathOnFTP_Server.endsWith("/")) {
            exportRequestEvent.pathOnFTP_Server = exportRequestEvent.pathOnFTP_Server + '/';
        }
        this.validateLengthOfAbsoluteFilePathOnFTP_Server("pathOnFTP_Server", exportRequestEvent.pathOnFTP_Server, "cvBackupNameOnFTP_Server", exportRequestEvent.cvBackupNameOnFTP_Server, "cvName", exportRequestEvent.cvName);
    }

    private void validateLengthOfAbsoluteFilePathOnFTP_Server(String string, String string2, String string3, String string4, String string5, String string6) throws IllegalInputDataException, ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "validateLengthOfAbsoluteFilePathOnFTP_Server(String aFilePathOnFTP_ServerName, String aFilePathOnFTP_ServerValue, String aCV_BackupNameName, String aCV_BackupNameValue, String aCV_NameName, String aCV_NameValue)", "aFilePathOnFTP_ServerName: " + string + "\n\taFilePathOnFTP_ServerValue: " + string2 + "\n\taCV_BackupNameName: " + string3 + "\n\taCV_BackupNameValue: " + string4 + "\n\taCV_NameName: " + string5 + "\n\taCV_NameValue: " + string6);
        }
        String string7 = this.createNameForCV_Backup(string4, string6);
        String string8 = string2 + string7;
        this.validateLengthOfString(string8, this.myAllowedNumberOfCharactersInAbsoluteFilePathOnFTP_Server, "The max length of the parameters " + string + " + " + string3 + " is " + this.myAllowedNumberOfCharactersInAbsoluteFilePathOnFTP_Server + " characters." + "\n\tpathOnFTP_Server: " + string2 + "\n\tcvBackupNameOnFTP_Server: " + string4 + "\n\ttheUsedCV_BackupName: " + string7 + "\n\tthePathAndBackupName: " + string8 + "\n\tthePathAndBackupName length: " + string8.length());
    }

    private void verifyThatCV_ContainsMandatoryInformation(String string, String string2) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "verifyThatCV_ContainsMandatoryInformation(String aCV_Name, String aTmpRestoreFilePath)", "aCV_Name: " + string + "\n\taTmpRestoreFilePath: " + string2);
        }
        try {
            this.copyNeededCV_FilesToC(string, string2);
            File file = new File(string2 + "/" + "nodeinformation.xml");
            File file2 = new File(string2 + "/" + "ipnetworkconfig.xml");
            File file3 = new File(string2 + "/" + "nodeinformation2.xml");
            File file4 = new File(string2 + "/" + "ipnetworkconfig2.xml");
            File file5 = new File(string2 + "/" + "subrackinformation.xml");
            File file6 = new File(string2 + "/" + "uplist2.xml");
            File file7 = new File(string2 + "/" + "softwareinformation.xml");
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "verifyThatCV_ContainsMandatoryInformation(String aCV_Name, String aTmpRestoreFilePath)", "Status of files:" + this.getFileStatusMessage("nodeinformation.xml", file) + this.getFileStatusMessage("nodeinformation2.xml", file3) + this.getFileStatusMessage("ipnetworkconfig.xml", file2) + this.getFileStatusMessage("ipnetworkconfig2.xml", file4) + this.getFileStatusMessage("subrackinformation.xml", file5) + this.getFileStatusMessage("uplist2.xml", file6) + this.getFileStatusMessage("softwareinformation.xml", file7));
            }
            if (!file.exists() || !file2.exists()) {
                throw new CV_IsIncompleteException("Could not zip the CV backup archive file due to the CV is incomplete (at least one mandatory file is missing).\n\tverifyThatCV_ContainsMandatoryInformation(String aCV_Name, String aTmpRestoreFilePath)\n\tStatus of mandatory files:" + this.getFileStatusMessage("nodeinformation.xml", file) + this.getFileStatusMessage("ipnetworkconfig.xml", file2) + "\n\tStatus of other files:" + this.getFileStatusMessage("nodeinformation2.xml", file3) + this.getFileStatusMessage("ipnetworkconfig2.xml", file4) + this.getFileStatusMessage("subrackinformation.xml", file5) + this.getFileStatusMessage("uplist2.xml", file6) + this.getFileStatusMessage("softwareinformation.xml", file7));
            }
        }
        catch (ConfigurationVersionException configurationVersionException) {
            throw configurationVersionException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "verifyThatCV_ContainsMandatoryInformation(String aCV_Name, String aTmpRestoreFilePath)", "Throwable caught.aCV_Name: " + string + "\n\taTmpRestoreFilePath: " + string2 + throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tverifyThatCV_ContainsMandatoryInformation(String aCV_Name, String aTmpRestoreFilePath)" + "\n\tThrowable caught." + "\n\taCV_Name: " + string + "\n\taTmpRestoreFilePath: " + string2 + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private void verifyThatCV_IsOfValidType(String string) throws CV_IsInvalidForBackupException, ExporterException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "verifyThatCV_IsOfValidType(String aCV_Name)", "aCV_Name: " + string);
        }
        try {
            CV_DataHandler cV_DataHandler = new CV_DataHandler();
            String string2 = cV_DataHandler.getTypeOfCV(string);
            if (string2 == null) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "verifyThatCV_IsOfValidType()", "The type of CV is invalid for creation of a remote backup.\n\taCV_Name: " + string + "\n\ttheCV_Type: " + string2);
                }
                throw new CV_IsInvalidForBackupException("Class name:" + this.getClass().getName() + "\n\tverifyThatCV_IsOfValidType()" + "\n\tThe type of CV is invalid for creation of a remote backup." + "\n\taCV_Name: " + string + "\n\ttheCV_Type: " + string2);
            }
            SignalHandler signalHandler = new SignalHandler();
            boolean bl = false;
            if (string2.equals(signalHandler.getCV_TypeName(0)) || string2.equals(signalHandler.getCV_TypeName(2)) || string2.equals(signalHandler.getCV_TypeName(3)) || string2.equals(signalHandler.getCV_TypeName(4)) || string2.equals(signalHandler.getCV_TypeName(5)) || string2.equals(signalHandler.getCV_TypeName(8)) || string2.equals(signalHandler.getCV_TypeName(9))) {
                if (!CV_PreUpgradeRelationHandler.getInstance().isCV_OfTypePreUpgrade(string)) {
                    bl = true;
                } else {
                    string2 = string2 + " - PreUpgraded CV";
                }
            }
            if (!bl) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "verifyThatCV_IsOfValidType()", "The type of CV is invalid for creation of a remote backup.\n\taCV_Name: " + string + "\n\ttheCV_Type: " + string2);
                }
                throw new CV_IsInvalidForBackupException("Class name:" + this.getClass().getName() + "\n\tverifyThatCV_IsOfValidType()" + "\n\tThe type of CV is invalid for creation of a remote backup." + "\n\taCV_Name: " + string + "\n\ttheCV_Type: " + string2);
            }
        }
        catch (CV_IsInvalidForBackupException cV_IsInvalidForBackupException) {
            throw cV_IsInvalidForBackupException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "verifyThatCV_IsOfValidType()", "Throwable caught when attempting to verify that the CV type is valid.\n\taCV_Name: " + string + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString(), throwable);
            throw new ExporterException("Class name:" + this.getClass().getName() + "\n\tverifyThatCV_IsOfValidType()" + "\n\tThrowable caught when attempting to verify that the CV type is valid." + "\n\taCV_Name: " + string + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private void verifyChecksumOfUcf(String string) throws UpgradeBackupDataException, UpgradePackageID_IllegalFormatException, ChecksumHandlerException {
        try {
            UpgradePackageMO_HandlerInterface upgradePackageMO_HandlerInterface;
            UpgradePackageMoExtended upgradePackageMoExtended;
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "verifyChecksumOfUcf( String anUpgradePackageId)", "anUpgradePackageId: " + string);
            }
            if ((upgradePackageMoExtended = (upgradePackageMO_HandlerInterface = ServiceFinder.getUpgradePackageMO_HandlerInterface()).getUpgradePackageMo(string)) == null) {
                Trace.info(this.getClass(), "verifyChecksumOfUcf( String anUpgradePackageId)", "The Upgrade Package ID was not found among the Upgrade Package MO instances on the node.anUpgradePackageId: " + string);
                throw new UpgradeBackupDataException("Class name: " + this.getClass().getName() + "\n\tverifyChecksumOfUcf( String anUpgradePackageId)" + "\n\tThe Upgrade Package ID was not found among the Upgrade Package MO instances on the node." + "\n\tanUpgradePackageId: " + string);
            }
            if (!upgradePackageMoExtended.getOrigUcfChecksum(null).equals("") && !upgradePackageMoExtended.getUcfChecksum(null).equals("")) {
                FailedUCFChecksumErrorInformation failedUCFChecksumErrorInformation = new FailedUCFChecksumErrorInformation(true);
                FailedUCFChecksumErrorInformation failedUCFChecksumErrorInformation2 = new FailedUCFChecksumErrorInformation(true);
                ChecksumHandler checksumHandler = new ChecksumHandler();
                UCF_ControlResultContainer uCF_ControlResultContainer = checksumHandler.checksumUCF(upgradePackageMoExtended);
                failedUCFChecksumErrorInformation2 = uCF_ControlResultContainer.isCalculated_StoredChecksumMatched();
                failedUCFChecksumErrorInformation = uCF_ControlResultContainer.isCalculated_StoredOrigChecksumMatched();
                if (!failedUCFChecksumErrorInformation2.isChecksumMatched()) {
                    throw new ChecksumHandlerException(failedUCFChecksumErrorInformation2.getErrorInfo());
                }
                if (!failedUCFChecksumErrorInformation.isChecksumMatched()) {
                    throw new ChecksumHandlerException(failedUCFChecksumErrorInformation.getErrorInfo());
                }
            }
        }
        catch (ChecksumHandlerException checksumHandlerException) {
            throw checksumHandlerException;
        }
        catch (UpgradePackageID_IllegalFormatException upgradePackageID_IllegalFormatException) {
            Trace.info(this.getClass(), "verifyChecksumOfUcf( String anUpgradePackageId)", "UpgradePackageID_IllegalFormatException: The Upgrade Package ID was not found among the Upgrade Package MO instances on the node.anUpgradePackageId: " + string);
        }
        catch (UpgradePackageMO_HandlerException upgradePackageMO_HandlerException) {
            throw new UpgradeBackupDataException(upgradePackageMO_HandlerException.toString());
        }
        catch (MoAccessException moAccessException) {
            throw new UpgradeBackupDataException(moAccessException.toString());
        }
    }
}

