/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.file.configurationversionbackupdata.create;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Vector;
import se.ericsson.cello.configurationversion.file.configurationversionbackupdata.create.ConfigurationVersionBackupDataCreatorException;
import se.ericsson.cello.configurationversion.file.configurationversionbackupdata.create.ConfigurationVersionBackupDataProperties;
import se.ericsson.cello.configurationversion.main.ConfigurationVersionMoExtension;
import se.ericsson.cello.upgradepackage.trace.Trace;

public class ConfigurationVersionBackupDataCreator {
    private ConfigurationVersionBackupDataProperties myProperties = new ConfigurationVersionBackupDataProperties();

    public Vector createFiles(String string, String string2) throws ConfigurationVersionBackupDataCreatorException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createFiles(String aFilePath, String aCV_Name)", "aFilePath: " + string + "\n\taCvName: " + string2);
        }
        Vector<String> vector = null;
        try {
            vector = new Vector<String>();
            vector.addElement(this.createCvPtrFile(string, string2));
            vector.addElement(this.createRollbackIniFile(string));
        }
        catch (IOException iOException) {
            Trace.error(this.getClass(), "createFiles(String aFilePath, String aCV_Name)", "aFilePath: " + string + "\n\taCV_Name: " + string2, iOException);
            throw new ConfigurationVersionBackupDataCreatorException("Error: " + iOException);
        }
        return vector;
    }

    private String createCvPtrFile(String string, String string2) throws ConfigurationVersionBackupDataCreatorException, IOException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createCvPtrFile(String aFilePath, String aCvName)", "aFilePath: " + string + "\n\taCvName: " + string2);
        }
        String string3 = null;
        OutputStreamWriter outputStreamWriter = null;
        try {
            File file = new File(string, this.myProperties.cvPtrFileName);
            outputStreamWriter = new FileWriter(file);
            outputStreamWriter.write(string2);
            string3 = file.getAbsolutePath();
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "createCvPtrFile(String aFilePath, String aCvName)", "aFilePath: " + string + "\n\taCvName: " + string2, throwable);
            throw new ConfigurationVersionBackupDataCreatorException("Error: " + throwable);
        }
        finally {
            if (outputStreamWriter != null) {
                outputStreamWriter.close();
            }
        }
        return string3;
    }

    private String createRollbackIniFile(String string) throws ConfigurationVersionBackupDataCreatorException, IOException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createRollbackIniFile(String aFilePath) ", "aFilePath: " + string);
        }
        String string2 = null;
        OutputStreamWriter outputStreamWriter = null;
        try {
            int n = ConfigurationVersionMoExtension.instance().getRollbackInitTimerValue(null);
            int n2 = ConfigurationVersionMoExtension.instance().getRollbackInitCounterValue(null);
            File file = new File(string, this.myProperties.rollbackIniFileName);
            outputStreamWriter = new FileWriter(file);
            outputStreamWriter.write(this.myProperties.rollbackIsOff + "\n");
            outputStreamWriter.write(n + "\n");
            outputStreamWriter.write(n2 + "\n");
            string2 = file.getAbsolutePath();
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "createRollbackIniFile(String aFilePath) ", "aFilePath: " + string, throwable);
            throw new ConfigurationVersionBackupDataCreatorException("Error: " + throwable);
        }
        finally {
            if (outputStreamWriter != null) {
                outputStreamWriter.close();
            }
        }
        return string2;
    }
}

