/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.file.softwareinformation.parser;

import java.io.PrintStream;
import org.xml.sax.AttributeList;
import org.xml.sax.Locator;
import se.ericsson.cello.configurationversion.file.softwareinformation.parser.Repertoires;
import se.ericsson.cello.configurationversion.file.softwareinformation.parser.Slots;
import se.ericsson.cello.configurationversion.file.softwareinformation.parser.SwAllocationAttributeName;
import se.ericsson.cello.configurationversion.file.softwareinformation.parser.SwAllocationSubElementName;
import se.ericsson.cello.configurationversion.file.softwareinformation.parser.SwAllocationsSubElementName;
import se.ericsson.cello.su.xmlparser.backuprestore.BackupRestoreDataHandler;
import se.ericsson.cello.su.xmlparser.backuprestore.BackupRestoreXmlElement;
import se.ericsson.cello.su.xmlparser.base.UnknownXML_AttributeException;
import se.ericsson.cello.su.xmlparser.base.ValidateException;
import se.ericsson.cello.su.xmlparser.base.XML_ElementInterface;
import se.ericsson.cello.su.xmlparser.base.XML_Exception;
import se.ericsson.cello.sudom.parser.dom.util.locator.LocatorProxy;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.datacontainer.SwAllocationDataContainer;

public class SwAllocation
extends BackupRestoreXmlElement {
    private String myLdn = null;
    private Slots mySlots = null;
    private Repertoires myRepertoires = null;

    public SwAllocation(SwAllocationDataContainer swAllocationDataContainer) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "SwAllocation(SwAllocationDataContainer aSwAllocationDataContainer)", "aSwAllocationDataContainer: " + swAllocationDataContainer);
        }
        if (swAllocationDataContainer.getLdn() != null) {
            this.myLdn = swAllocationDataContainer.getLdn().toString();
        }
        this.mySlots = new Slots(swAllocationDataContainer.getSlotDataContainers());
        this.myRepertoires = new Repertoires(swAllocationDataContainer.getRepertoireNames());
    }

    public SwAllocation(AttributeList attributeList, Locator locator) throws UnknownXML_AttributeException {
        super(locator);
        String[] stringArray;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "SwAllocation(AttributeList anAttributeList, Locator aLocator)", "anAttributeList: " + attributeList + "\n\taLocator: " + LocatorProxy.getLocatorInfo(locator));
        }
        if ((stringArray = SwAllocationAttributeName.verifyNames(attributeList)) == null || stringArray.length > 0) {
            SwAllocation.reportUnknownAttribute(this.getClass(), "SwAllocation(AttributeList anAttributeList, Locator aLocator)", BackupRestoreDataHandler.instance().getCurrentFileName(), SwAllocationsSubElementName.SwAllocation.getValue(), stringArray, locator);
        }
        this.myLdn = attributeList.getValue(SwAllocationAttributeName.Ldn.getValue());
    }

    public XML_ElementInterface createChild(String string, AttributeList attributeList, Locator locator) throws XML_Exception {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createChild(String anElementName, AttributeList anAttributeList, Locator aLocator)", "anElementName: " + string + "\n\tanAttributeList: " + attributeList + "\n\taLocator: " + LocatorProxy.getLocatorInfo(locator));
        }
        if (string.equals(SwAllocationSubElementName.Slots.getValue())) {
            return this.createSlots(attributeList, locator);
        }
        if (string.equals(SwAllocationSubElementName.Repertoires.getValue())) {
            return this.createRepertoires(attributeList, locator);
        }
        return SwAllocation.reportUnknownElement(this.getClass(), "createChild(String anElementName, AttributeList anAttributeList, Locator aLocator)", BackupRestoreDataHandler.instance().getCurrentFileName(), SwAllocationsSubElementName.SwAllocation.getValue(), string, locator);
    }

    public String getLdn() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 21, "getLdn( )", "Returning - myLdn: " + this.myLdn);
        }
        return this.myLdn;
    }

    public Repertoires getRepertoiresElement() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 21, "getRepertoiresElement()", "Returning - myRepertoires: " + this.myRepertoires);
        }
        return this.myRepertoires;
    }

    public Slots getSlotsElement() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 21, "getSlotsElement()", "Returning - mySlots: " + this.mySlots);
        }
        return this.mySlots;
    }

    public void print(PrintStream printStream, String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "print(PrintStream aPrintStream, String anIndentation)", "aPrintStream: " + printStream + "\n\tanIndentation: " + string);
        }
        super.print(printStream, string);
        printStream.println(string + "<" + SwAllocationsSubElementName.SwAllocation.getValue());
        printStream.println("  " + string + SwAllocationAttributeName.Ldn.getValue() + " = \"" + this.myLdn + "\"");
        printStream.println("  " + string + ">");
        if (this.mySlots != null) {
            printStream.println();
            this.mySlots.print(printStream, "  " + string);
        }
        if (this.myRepertoires != null) {
            printStream.println();
            this.myRepertoires.print(printStream, "  " + string);
        }
        printStream.println();
        printStream.println(string + "</" + SwAllocationsSubElementName.SwAllocation.getValue() + ">\n");
    }

    public void validate() throws ValidateException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "validate( )");
        }
        SwAllocationAttributeName.Ldn.validate(this.myLdn, super.getLocator());
        SwAllocationSubElementName.Slots.validate(this.mySlots, super.getLocator());
        SwAllocationSubElementName.Repertoires.validate(this.myRepertoires, super.getLocator());
        if (this.mySlots != null) {
            this.mySlots.validate();
        }
        if (this.myRepertoires != null) {
            this.myRepertoires.validate();
        }
    }

    private XML_ElementInterface createSlots(AttributeList attributeList, Locator locator) throws XML_Exception {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createSlots(AttributeList anAttributeList, Locator aLocator)", "anAttributeList: " + attributeList + "\n\taLocator: " + LocatorProxy.getLocatorInfo(locator));
        }
        if (this.mySlots == null) {
            this.mySlots = new Slots(attributeList, locator);
            return this.mySlots;
        }
        return SwAllocation.errorMoreElementsThanExpected(this.getClass(), "createSlots(AttributeList anAttributeList, Locator aLocator)", BackupRestoreDataHandler.instance().getCurrentFileName(), SwAllocationsSubElementName.SwAllocation.getValue(), SwAllocationSubElementName.Slots.getValue(), locator);
    }

    private XML_ElementInterface createRepertoires(AttributeList attributeList, Locator locator) throws XML_Exception {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createRepertoires(AttributeList anAttributeList, Locator aLocator)", "anAttributeList: " + attributeList + "\n\taLocator: " + LocatorProxy.getLocatorInfo(locator));
        }
        if (this.myRepertoires == null) {
            this.myRepertoires = new Repertoires(attributeList, locator);
            return this.myRepertoires;
        }
        return SwAllocation.errorMoreElementsThanExpected(this.getClass(), "createRepertoires(AttributeList anAttributeList, Locator aLocator)", BackupRestoreDataHandler.instance().getCurrentFileName(), SwAllocationsSubElementName.SwAllocation.getValue(), SwAllocationSubElementName.Repertoires.getValue(), locator);
    }

    public String toString() {
        return "\n\tmyLdn: " + this.myLdn + "\n\tmySlots: " + this.mySlots + "\n\tmyRepertoires: " + this.myRepertoires;
    }
}

