/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.file.subrackinformation.proxy;

import java.io.File;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import se.ericsson.cello.configurationversion.file.parser.XML_ParserFactory;
import se.ericsson.cello.configurationversion.file.subrackinformation.create.SubrackInformationDataFileCreatorException;
import se.ericsson.cello.configurationversion.file.subrackinformation.parser.SubrackAttributeName;
import se.ericsson.cello.configurationversion.file.subrackinformation.parser.SubrackInformationElement;
import se.ericsson.cello.configurationversion.file.subrackinformation.parser.SubrackList;
import se.ericsson.cello.configurationversion.file.subrackinformation.parser.SubrackListSubElementName;
import se.ericsson.cello.configurationversion.main.exception.ConfigurationVersionException;
import se.ericsson.cello.configurationversion.main.exception.UnexpectedXML_FileContentException;
import se.ericsson.cello.configurationversion.main.handler.CV_ArmamentHandler;
import se.ericsson.cello.su.extsuif.upgradepackage.util.enumer.Enumer;
import se.ericsson.cello.su.froproxy.cv.interfaces.CV_ArmamentInformation;
import se.ericsson.cello.su.xmlparser.backuprestore.BackupRestoreDataHandler;
import se.ericsson.cello.su.xmlparser.base.DomProxy;
import se.ericsson.cello.su.xmlparser.base.ValidateException;
import se.ericsson.cello.su.xmlparser.base.XML_RootElement;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.datacontainer.SubrackDataContainer;
import se.ericsson.cello.upgradepackage.util.mohandler.slot.SlotMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;

public class SubrackInformationProxy
extends DomProxy {
    private SubrackInformationElement mySubrackInformationElement = null;

    public SubrackInformationProxy(Integer n) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "SubrackInformationProxy()");
        }
        this.mySubrackInformationElement = new SubrackInformationElement(n.toString());
    }

    public SubrackInformationProxy(CV_ArmamentHandler cV_ArmamentHandler) throws ConfigurationVersionException {
        String string;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "SubrackInformationProxy(CV_ArmamentHandler aCV_ArmamentHandler)", "aCV_ArmamentHandler: " + cV_ArmamentHandler);
        }
        if ((string = this.getSubrackInformationFilePath(cV_ArmamentHandler.backupRestoreFilePath)) != null) {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "SubrackInformationProxy(CV_ArmamentHandler aCV_ArmamentHandler)", "Created the path to subrackinformation file\n\ttheFilePathToSubrackInformationFile: " + string);
            }
            try {
                XML_RootElement xML_RootElement = XML_ParserFactory.instance().parseFile(string, true);
                if (!(xML_RootElement instanceof SubrackInformationElement)) {
                    String string2 = "undefined";
                    if (xML_RootElement != null) {
                        string2 = xML_RootElement.getClass().getName();
                    }
                    throw new ConfigurationVersionException("Illegal type of XML file given as input parameter,\n\tSubrackInformationProxy(CV_ArmamentHandler aCV_ArmamentHandler)\n\tGiven XML file: " + string + "\n\tRoot element type in this file: " + string2);
                }
                this.mySubrackInformationElement = (SubrackInformationElement)xML_RootElement;
            }
            catch (UnexpectedXML_FileContentException unexpectedXML_FileContentException) {
                throw unexpectedXML_FileContentException;
            }
            catch (Throwable throwable) {
                Trace.warning(this.getClass(), "SubrackInformationProxy(CV_ArmamentHandler aCV_ArmamentHandler)", "theFilePathToSubrackInformationFile: " + string + "\n\tThrowable caught." + throwable);
                throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tSubrackInformationProxy(CV_ArmamentHandler aCV_ArmamentHandler)" + "\n\tThrowable caught." + "\n\ttheFilePathToSubrackInformationFile: " + string + "\n\tThrowable data: " + throwable);
            }
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "SubrackInformationProxy(CV_ArmamentHandler aCV_ArmamentHandler)", "Could not find subrackinformation.xml file.\n\tCreating Subrack information element based on the armament information for CV " + cV_ArmamentHandler.cvName + "\n\tAssuming fanConfiguration =" + "1" + " for the CV" + "\n\tAssuming integratedHW =" + "1" + " for the CV");
        }
        try {
            CV_ArmamentInformation cV_ArmamentInformation = cV_ArmamentHandler.getCV_ArmamentInformation();
            Collection collection = cV_ArmamentInformation.getSrNumbers();
            Iterator iterator = collection.iterator();
            SlotMO_HandlerInterface slotMO_HandlerInterface = ServiceFinder.getSlotMO_HandlerInterface();
            LinkedList<SubrackDataContainer> linkedList = new LinkedList<SubrackDataContainer>();
            SubrackDataContainer subrackDataContainer = null;
            Integer n = null;
            while (iterator.hasNext()) {
                n = (Integer)iterator.next();
                subrackDataContainer = new SubrackDataContainer(n.toString(), "1", String.valueOf(1));
                linkedList.add(subrackDataContainer);
            }
            this.mySubrackInformationElement = new SubrackInformationElement("2");
            SubrackList subrackList = new SubrackList();
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "SubrackInformationProxy(CV_ArmamentHandler aCV_ArmamentHandler)", "Setting subrack information\n\ttheSubrackContainers: " + linkedList);
            }
            subrackList.setSubracks(linkedList);
            this.mySubrackInformationElement.setSubrackList(subrackList);
        }
        catch (Throwable throwable) {
            Trace.warning(this.getClass(), "SubrackInformationProxy(CV_ArmamentHandler aCV_ArmamentHandler)", "Throwable caugth when trying to get the armamament information from CV.\n\tException info: " + throwable);
            throw new ConfigurationVersionException(this.getClass().getName() + "\n\tSubrackInformationProxy(CV_ArmamentHandler aCV_ArmamentHandler)" + "\n\tThrowable caugth when trying to get armament information for the CV," + "\n\taCV_ArmamentHandler: " + cV_ArmamentHandler + "\n\ttThrowable data: " + throwable.toString());
        }
    }

    public void createSubrackInformation(Collection collection) throws SubrackInformationDataFileCreatorException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createSubrackInformation(Collection aDependencyChainContainer)", "aSubrackDataContainers: " + collection);
        }
        this.mySubrackInformationElement.setSubrackList(this.createSubrackList(collection));
    }

    private SubrackList createSubrackList(Collection collection) throws SubrackInformationDataFileCreatorException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createSubrackList(Collection aSubrackDataContainers)", "aSubrackDataContainers: " + collection);
        }
        SubrackList subrackList = null;
        subrackList = new SubrackList();
        subrackList.setSubracks(collection);
        return subrackList;
    }

    public Collection getSubracks() {
        return this.mySubrackInformationElement.getSubrackList().getSubracks();
    }

    public Enumer getTypeSubrackElement() {
        return SubrackListSubElementName.Subrack;
    }

    public Enumer getTypeSmnAttribute() {
        return SubrackAttributeName.Smn;
    }

    public Enumer getTypeFanConfigAttribute() {
        return SubrackAttributeName.FanConfiguration;
    }

    public Enumer getTypeIntegratedHardwareAttribute() {
        return SubrackAttributeName.IntegratedHardware;
    }

    public void print(PrintStream printStream) throws ValidateException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "print(PrintStream aPrintStream)", "aPrintStream: " + printStream);
        }
        this.mySubrackInformationElement.validate();
        this.mySubrackInformationElement.print(printStream);
    }

    public void validate() throws ValidateException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "validate()");
        }
        this.mySubrackInformationElement.validate();
    }

    private String getSubrackInformationFilePath(String string) {
        String string2 = "subrackinformation.xml";
        String string3 = string + "/" + string2;
        File file = new File(string3);
        if (!file.exists()) {
            return null;
        }
        BackupRestoreDataHandler.instance().setCurrentFileName(string2);
        return string3;
    }
}

