/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.main.handler;

import se.ericsson.cello.configurationversion.main.exception.ConfigurationVersionException;
import se.ericsson.cello.configurationversion.service.ServiceController;
import se.ericsson.cello.managedelement.meaccess.AutoConfigurationCvHandlerAccess;
import se.ericsson.cello.managedelement.meaccess.ConfigurationVersionMO_HandlerAccess;
import se.ericsson.cello.managedelement.meaccess.MO_HandlerFactoryAccessBase;
import se.ericsson.cello.su.extsuif.configurationversion.service.ServiceSubType;
import se.ericsson.cello.su.extsuif.configurationversion.service.ServiceType;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.upgradepackage.trace.Trace;

public class CV_AutoConfigurationCvHandler
implements AutoConfigurationCvHandlerAccess {
    private boolean isFunctionBusyMarkedByThisAction = false;
    private int counter = 0;
    private static CV_AutoConfigurationCvHandler instance = null;

    public synchronized void createPlugAndPlayCV_AndSetStartableFromMe(String string) throws Exception {
        try {
            while (!this.busyMark() && this.counter < 100) {
                try {
                    if (Trace.valid(this.getClass(), 20)) {
                        Trace.debug(this.getClass(), 20, "createPlugAndPlayCV_AndSetStartableFromMe waiting until ServiceController is set to free or time-out occurs, waited for: " + this.counter * 5 + " sec");
                    }
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++this.counter;
            }
            if (!this.isFunctionBusyMarkedByThisAction) {
                throw new ConfigurationVersionException("Failed to busyMark ServiceController");
            }
            MO_HandlerFactoryAccessBase mO_HandlerFactoryAccessBase = (MO_HandlerFactoryAccessBase)ServiceLocatorFacade.getRepository().getService(MO_HandlerFactoryAccessBase.class);
            ConfigurationVersionMO_HandlerAccess configurationVersionMO_HandlerAccess = mO_HandlerFactoryAccessBase.getConfigurationVersionMO_HandlerAccess();
            configurationVersionMO_HandlerAccess.createPlugAndPlayCV_AndSetStartable(string);
            this.freeMarkIfNeeded(ServiceSubType.autoConfiguration);
        }
        catch (Exception exception) {
            this.freeMarkIfNeeded(ServiceSubType.autoConfiguration);
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "Throwable caught at create of autoConfiguration CV, exception " + exception.toString());
            }
            throw exception;
        }
    }

    private boolean busyMark() {
        boolean bl;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "busyMark()");
        }
        if (bl = ServiceController.instance().busyMark(ServiceType.ConfigurationVersion, ServiceSubType.autoConfiguration)) {
            this.isFunctionBusyMarkedByThisAction = true;
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "busyMark returned : " + bl);
        }
        return bl;
    }

    private void freeMarkIfNeeded(ServiceSubType serviceSubType) {
        if (this.isFunctionBusyMarkedByThisAction) {
            ServiceController.instance().freeMark(ServiceType.ConfigurationVersion, serviceSubType);
            this.isFunctionBusyMarkedByThisAction = false;
        }
    }

    public static synchronized CV_AutoConfigurationCvHandler instance() {
        if (instance == null) {
            instance = new CV_AutoConfigurationCvHandler();
        }
        return instance;
    }
}

