/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.main.handler;

import se.ericsson.cello.configurationversion.configcountdown.ConfigCountdownActivatedController;
import se.ericsson.cello.configurationversion.control.CV_Controller;
import se.ericsson.cello.configurationversion.main.ConfigurationVersionMoExtension;
import se.ericsson.cello.configurationversion.main.exception.ConfigurationVersionException;
import se.ericsson.cello.configurationversion.main.handler.CV_ActionHandler;
import se.ericsson.cello.configurationversion.main.interfaces.CV_ActionProgressInterface;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.su.extsuif.configurationversion.service.ServiceSubType;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.library.SuLib;

public class CV_ConfigCountdownActivatedHandler
extends CV_ActionHandler {
    public CV_ConfigCountdownActivatedHandler(CV_ActionProgressInterface cV_ActionProgressInterface) {
        super(cV_ActionProgressInterface);
    }

    public void setConfigCountdownActivated(boolean bl, Coordinator coordinator) throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setConfigCountdownActivated(boolean value, Coordinator c)", "value: " + bl + "\n\tc: " + SuLib.toString(coordinator));
        }
        if (this.getConfigCountdownActivated() != bl) {
            if (bl) {
                this.activateConfigCountdown();
            } else {
                this.deactivateConfigCountdown();
            }
        }
        this.sendAVC("configCountdownActivated", new Boolean(bl));
    }

    public boolean getConfigCountdownActivated() throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getConfigCountdownActivated()");
        }
        return ConfigurationVersionMoExtension.instance().getConfigCountdownActivated(null);
    }

    private void deactivateConfigCountdown() throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "deactivateConfigCountdown()");
        }
        try {
            this.markAsBusy(true);
            CV_Controller.instance().deactivateConfigCountdown(this);
            super.finished(ServiceSubType.robustReconfiguration);
        }
        catch (ConfigurationVersionException configurationVersionException) {
            this.resetConfigCountdown();
            throw configurationVersionException;
        }
    }

    private void activateConfigCountdown() throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "activateConfigCountdown()");
        }
        try {
            this.markAsBusy(false);
            CV_Controller.instance().activateConfigCountdown(this);
            super.finished(ServiceSubType.robustReconfiguration, true);
        }
        catch (ConfigurationVersionException configurationVersionException) {
            this.resetConfigCountdown();
            throw configurationVersionException;
        }
    }

    private void resetConfigCountdown() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "resetConfigCountdown()");
        }
        try {
            ConfigCountdownActivatedController.instance().resetConfigCountdown();
            super.finished(ServiceSubType.robustReconfiguration);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "resetConfigCountdown()", "failed to reset configCountdown configuration", throwable);
        }
    }

    private void markAsBusy(boolean bl) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "markAsBusy(boolean anIsOnlyClientToBeBusymarked)", "anIsOnlyClientToBeBusymarked: " + bl);
        }
        if (bl) {
            super.busyMarkClientOnly();
        } else {
            super.busyMark(ServiceSubType.robustReconfiguration);
        }
        super.addAsListener();
    }

    private void sendAVC(String string, Object object) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sendAVC(String attrName, Object value)", "attrName: " + string + "\n\tvalue: " + object);
        }
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        NotificationSender.instance().pushAVC((ManagedObject)ConfigurationVersionMoExtension.instance(), stringArray, objectArray);
    }
}

