/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.main.handler;

import se.ericsson.cello.configurationversion.control.CV_Controller;
import se.ericsson.cello.configurationversion.main.ConfigurationVersionMoExtension;
import se.ericsson.cello.configurationversion.main.event.detailedactivity.ConfigurationCountdownActivatedDetailedEvent;
import se.ericsson.cello.configurationversion.main.event.mainactivity.ConfigurationCountdownActivatedEvent;
import se.ericsson.cello.configurationversion.main.exception.FunctionBusyException;
import se.ericsson.cello.configurationversion.main.handler.CV_ActionHandler;
import se.ericsson.cello.configurationversion.main.interfaces.CV_ActionProgressInterface;
import se.ericsson.cello.su.extsuif.configurationversion.service.ServiceSubType;
import se.ericsson.cello.upgradepackage.trace.Trace;

public class CV_RestoreRobustReconfigurationActivatedHandler
extends CV_ActionHandler
implements Runnable {
    public CV_RestoreRobustReconfigurationActivatedHandler(CV_ActionProgressInterface cV_ActionProgressInterface) {
        super(cV_ActionProgressInterface);
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "CV_RestoreRobustReconfigurationActivatedHandler(CV_ActionProgressInterface aCV_ActionProgressInterface)", "aCV_ActionProgressInterface: " + cV_ActionProgressInterface);
        }
        try {
            new Thread((Runnable)this, "CMA_RobustReconfigRecovery_Thread").start();
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "CV_RestoreRobustReconfigurationActivatedHandler(CV_ActionProgressInterface aCV_ActionProgressInterface)", "Failed to start thread handling restoration of data if robust reconfiguration is active at recovery.", throwable);
        }
    }

    public void run() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "run( )");
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "run( )", "New thread handling restoration of data if robust reconfiguration is active at recovery has been started.");
        }
        boolean bl = false;
        try {
            if (ConfigurationVersionMoExtension.instance().getConfigCountdownActivated(null)) {
                bl = true;
                this.busyMark(ServiceSubType.robustReconfiguration);
                CV_Controller.instance().restoreRobustReconfigurationActivated(this);
                this.setCurrentMainActivity(new ConfigurationCountdownActivatedEvent(this));
                this.setCurrentDetailedActivity(new ConfigurationCountdownActivatedDetailedEvent(this));
                this.freeMarkIfNeeded(ServiceSubType.robustReconfiguration, true);
            }
        }
        catch (FunctionBusyException functionBusyException) {
            Trace.error(this.getClass(), "run( )", "FuctionBusyException caugth when trying to restore data due to robust reconfiguration is activated at recovery.", (Throwable)((Object)functionBusyException));
        }
        catch (Throwable throwable) {
            if (!bl) {
                Trace.error(this.getClass(), "run( )", "Throwable caugth when trying to check if robust reconfiguration is activated at recovery.", throwable);
            }
            Trace.error(this.getClass(), "run( )", "Throwable caugth when trying to restore data due to robust reconfiguration is activated at recovery.", throwable);
            this.freeMarkIfNeeded(ServiceSubType.robustReconfiguration, false);
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "run( )", "Thread handling restoration of data if robust reconfiguration is active at recovery is now stopped.");
        }
        Trace.flushToTraceFile();
    }
}

