/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.restore;

import java.util.EventObject;
import se.ericsson.cello.configurationversion.base.CV_SubFunctionController;
import se.ericsson.cello.configurationversion.control.CV_Controller;
import se.ericsson.cello.configurationversion.main.ConfigurationVersionAlarm;
import se.ericsson.cello.configurationversion.main.event.actionresult.CV_ActionResultDataTypeOfInvokedActionValue;
import se.ericsson.cello.configurationversion.main.event.actionresult.InvokedActionConfirmRestoreInformation;
import se.ericsson.cello.configurationversion.main.event.detailedactivity.ExecutionFailedEvent;
import se.ericsson.cello.configurationversion.main.event.detailedactivity.IdleEvent;
import se.ericsson.cello.configurationversion.main.event.detailedactivity.NodeRestartRequestEvent;
import se.ericsson.cello.configurationversion.main.event.detailedactivity.RestoreExecutedEvent;
import se.ericsson.cello.configurationversion.main.event.detailedactivity.SavingFinalCVEvent;
import se.ericsson.cello.configurationversion.main.event.detailedactivity.TerminatingConfirmRestoreTimeSupervisionEvent;
import se.ericsson.cello.configurationversion.main.event.mainactivity.ConfirmingRestoreOfDownloadedBackupCV_Event;
import se.ericsson.cello.configurationversion.main.event.mainactivity.MainIdleEvent;
import se.ericsson.cello.configurationversion.main.event.restoreconfirmationdeadline.RestoreConfirmationDeadlineEvent;
import se.ericsson.cello.configurationversion.main.exception.ConfigurationVersionException;
import se.ericsson.cello.configurationversion.main.util.CV_ActionResultCreator;
import se.ericsson.cello.configurationversion.restore.ConfirmRestoreConfirmedEvent;
import se.ericsson.cello.configurationversion.restore.ConfirmRestoreRequestEvent;
import se.ericsson.cello.configurationversion.restore.RestoreException;
import se.ericsson.cello.configurationversion.restore.RestoreProperties;
import se.ericsson.cello.configurationversion.util.additionalinfo.AdditionalInformationContainer;
import se.ericsson.cello.configurationversion.util.additionalinfo.AdditionalInformationCreator;
import se.ericsson.cello.configurationversion.util.handler.RestoreCV_Handler;
import se.ericsson.cello.configurationversion.util.progresshandler.CV_ProgressInformationHandler;
import se.ericsson.cello.configurationversion.util.progresshandler.NotifyingConfigurationVersionPropertyName;
import se.ericsson.cello.faultmanagement.AdditionalInfo;
import se.ericsson.cello.mao.RestartReasonEnum;
import se.ericsson.cello.support.thread.BlockingQueue;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMo;
import se.ericsson.cello.upgradepackage.trace.Trace;

public class ConfirmRestorer
extends CV_SubFunctionController
implements Runnable {
    private BlockingQueue myQueue = new BlockingQueue();

    public ConfirmRestorer() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "ConfirmRestorer()");
        }
        new Thread(this).start();
    }

    public void confirmRestoreRequest(UpgradePackageMo upgradePackageMo, String string) throws RestoreException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "confirmRestoreRequest(UpgradePackageMo aCurrentUpgradePackage, String aMissingCurrentUP_Information)", "aCurrentUpgradePackage: " + upgradePackageMo + "\n\taMissingCurrentUP_Information: " + string);
        }
        ConfirmRestoreRequestEvent confirmRestoreRequestEvent = new ConfirmRestoreRequestEvent(this, upgradePackageMo, string);
        this.myQueue.enqueue((Object)confirmRestoreRequestEvent);
    }

    public void run() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "run()");
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "run ( )", "New thread handling confimr restore of a downloaded CV has been started.");
        }
        EventObject eventObject = null;
        try {
            eventObject = (EventObject)this.myQueue.dequeue();
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "run ()", "Received event: " + eventObject.getClass().getName() + "\n\tEventData: " + eventObject);
            }
            if (eventObject instanceof ConfirmRestoreRequestEvent) {
                this.handleConfirmRestoreRequest((ConfirmRestoreRequestEvent)eventObject);
            } else {
                Trace.warning(this.getClass(), "run ()", "Unexected event received (ignored)\n\tReceived event: " + eventObject.getClass().getName() + "\n\tEventData: " + eventObject);
            }
        }
        catch (RestoreException restoreException) {
            Trace.info(this.getClass(), "run()", "RestoreException caught while waiting for an event or executing an received event (this should not happen).\n\ttheRequestEvent: " + eventObject + "\n\tException data: " + restoreException.toString());
            try {
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new NodeRestartRequestEvent(this));
                this.requestRollback("The execution of confirm restore failed i.e. the node is restarted on the rollback CV.", new RestartReasonEnum(24, this.getClass()));
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "run()", "Exception caught while waiting for an event or executing an received event.theRequestEvent: " + eventObject, throwable);
            CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
            CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
            CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
            CV_Controller.instance().confirmRestoreResponse();
            try {
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new NodeRestartRequestEvent(this));
                this.requestRollback("The execution of confirm restore failed i.e. the node is restarted on the rollback CV.", new RestartReasonEnum(24, this.getClass()));
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "run ( )", "Thread handling the confirm restore of a CV is now stopped.");
        }
        Trace.flushToTraceFile();
    }

    private String createRestoreFinalCV(UpgradePackageMo upgradePackageMo, String string) throws RestoreException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createRestoreFinalCV(UpgradePackageMo aCurrentUpgradePackage, String aMissingCurrentUP_Information)", "aCurrentUpgradePackage: " + upgradePackageMo + "\n\taMissingCurrentUP_Information: " + string);
        }
        String string2 = "";
        try {
            RestoreCV_Handler restoreCV_Handler = new RestoreCV_Handler();
            if (upgradePackageMo == null) {
                Trace.warning(this.getClass(), "createRestoreFinalCV(UpgradePackageMo aCurrentUpgradePackage, String aMissingCurrentUP_Information)", "Can't create a Final Restore CV due to the Upgrade Package MO connected to the node configuration is missing.\n\tRe-create that Upgrade Package to be able to create CVs.\n\tThe missing UP MO instance: " + string);
                restoreCV_Handler.setDefaultRollbackData();
                AdditionalInfo[] additionalInfoArray = new AdditionalInfo[]{new AdditionalInfo("Create and set CV as startable failed for CV", "Restore Final CV, current UpgradePackage connected to the node configuration is missing.")};
                ConfigurationVersionAlarm.instance().raiseAlarm(additionalInfoArray);
                return "";
            }
            restoreCV_Handler.configureCV_DataAfterConfirm(upgradePackageMo);
        }
        catch (ConfigurationVersionException configurationVersionException) {
            Trace.warning(this.getClass(), "createRestoreFinalCV(UpgradePackageMo aCurrentUpgradePackage, String aMissingCurrentUP_Information)", "ConfigurationVersionException caught.\n\taCurrentUpgradePackage: " + upgradePackageMo + "\n\taMissingCurrentUP_Information: " + string + "\n\tThe creation of the restore final CV or setting of the rollback data for the final CV failed for any reasons," + "\n\tSee earlier error messages for detailed reasons." + "\n\tThe confirmation of the restore is still approved i.e. no rollback for this case will be requested." + "\n\tPlease, make sure that a CV is created manually if this happen (after the confirmation of restore is finished)." + "\n\tConfigurationVersionException data: " + configurationVersionException.toString());
        }
        catch (Throwable throwable) {
            Trace.warning(this.getClass(), "createRestoreFinalCV(UpgradePackageMo aCurrentUpgradePackage, String aMissingCurrentUP_Information)", "Throwable caught.\n\taCurrentUpgradePackage: " + upgradePackageMo + "\n\taMissingCurrentUP_Information: " + string + "\n\tThe creation of the restore final CV or setting of the rollback data for the final CV failed for any reasons," + "\n\tSee earlier error messages for detailed reasons." + "\n\tThe confirmation of the restore is still approved i.e. no rollback for this case will be requested." + "\n\tPlease, make sure that a CV is created manually if this happen (after the confirmation of restore is finished)." + "\n\tThrowable data: " + throwable.toString());
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleConfirmRestoreRequest(ConfirmRestoreRequestEvent confirmRestoreRequestEvent) throws RestoreException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleConfirmRestoreRequest(ConfirmRestoreRequestEvent aConfirmRestoreRequestEvent)", "aConfirmRestoreRequestEvent: " + confirmRestoreRequestEvent);
        }
        AdditionalInformationCreator additionalInformationCreator = new AdditionalInformationCreator();
        try {
            additionalInformationCreator.activate();
            CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new ConfirmingRestoreOfDownloadedBackupCV_Event(this));
            CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new TerminatingConfirmRestoreTimeSupervisionEvent(this));
            this.setRestoreSupervisionTimer(0);
            RestoreProperties restoreProperties = new RestoreProperties();
            this.deleteCreatedFiles(restoreProperties.cvCMA_FileDisk + restoreProperties.getNodeRestoreFilesPath());
            this.deleteCreatedFiles(restoreProperties.cvCMA_FileDisk + restoreProperties.getCV_RestoreFilesPath());
            this.deleteCreatedFiles(restoreProperties.cvCMA_FileDisk + restoreProperties.getCV_TmpPath());
            CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.RestoreConfirmationDeadline, new RestoreConfirmationDeadlineEvent((Object)this, true));
            CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new SavingFinalCVEvent(this));
            String string = this.createRestoreFinalCV(confirmRestoreRequestEvent.currentUpgradePackage, confirmRestoreRequestEvent.missingCurrentUP_Information);
            CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new RestoreExecutedEvent(this));
            additionalInformationCreator.deactivate();
            this.setActionConfirmedResult(additionalInformationCreator.getAdditionalInformations(), string);
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "handleRestoreRequest(RestoreRequestEvent aRestoreRequestEvent)", "Idle marks the CV function.");
            }
            CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
            CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
            CV_Controller.instance().confirmRestoreResponse();
        }
        catch (ConfigurationVersionException configurationVersionException) {
            CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
            additionalInformationCreator.deactivate();
            CV_Controller.instance().confirmRestoreResponse();
            CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new NodeRestartRequestEvent(this));
            this.requestRollback("The execution of confirm restore failed i.e. the node is restarted on the rollback CV.", new RestartReasonEnum(24, this.getClass()));
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "handleConfirmRestoreRequest(ConfirmRestoreRequestEvent aConfirmRestoreRequestEvent)", "Throwable caught.\n\taConfirmRestoreRequestEvent: " + confirmRestoreRequestEvent, throwable);
            CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
            additionalInformationCreator.deactivate();
            CV_Controller.instance().confirmRestoreResponse();
            CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new NodeRestartRequestEvent(this));
            this.requestRollback("The execution of confirm restore failed i.e. the node is restarted on the rollback CV.", new RestartReasonEnum(24, this.getClass()));
        }
        finally {
            Trace.flushToTraceFile();
        }
    }

    private void setActionConfirmedResult(AdditionalInformationContainer additionalInformationContainer, String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setActionConfirmedResult(AdditionalInformationContainer anAdditionalInformationContainer, String aCV_Name)", "anAdditionalInformationContainer: " + additionalInformationContainer + "\n\taCV_Name: " + string);
        }
        try {
            CV_ActionResultCreator cV_ActionResultCreator = new CV_ActionResultCreator();
            ConfirmRestoreConfirmedEvent confirmRestoreConfirmedEvent = new ConfirmRestoreConfirmedEvent(this, additionalInformationContainer.getTraceInfos(), additionalInformationContainer.getTraceWarnings(), string);
            cV_ActionResultCreator.createActionResult(confirmRestoreConfirmedEvent, (CV_ActionResultDataTypeOfInvokedActionValue)new InvokedActionConfirmRestoreInformation());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "setActionResult(AdditionalInformationCreator anAdditionalInformationCreator, String aCV_Name)", "Throwable caugth when attempting to set the attribute actionResult (ignored)\n\tanAdditionalInformationContainer: " + additionalInformationContainer + "\n\taCV_Name: " + string, throwable);
        }
    }
}

