/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.restore;

import java.util.HashSet;
import java.util.Iterator;
import se.ericsson.cello.configurationversion.restore.RestoreParticipatorException;
import se.ericsson.cello.configurationversion.restore.RestoreSubscriptionExtendeed;
import se.ericsson.cello.su.extsuif.upgradepackage.util.time.Timer;
import se.ericsson.cello.su.extsuif.upgradepackage.util.time.TimerEvent;
import se.ericsson.cello.su.extsuif.upgradepackage.util.time.TimerListener;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.upgradepackage.main.interfaces.RestoreParticipator;
import se.ericsson.cello.upgradepackage.main.interfaces.RestoreResponse;
import se.ericsson.cello.upgradepackage.main.interfaces.RestoreSubscription;
import se.ericsson.cello.upgradepackage.trace.Trace;

public class RestoreParticipatorHandler
implements RestoreResponse,
TimerListener {
    private HashSet myRestoreParticipatorsNotResponded = new HashSet();
    private boolean hasAnyRestoreParticipatorReportedFailure = false;
    private Timer mySupervisionTimer = null;
    private static final int TwoMinutes = 0x6DDD00;

    public RestoreParticipatorHandler() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "RestoreParticipatorHandler()");
        }
    }

    public void nodeStartedIndication() throws RestoreParticipatorException {
        RestoreSubscriptionExtendeed restoreSubscriptionExtendeed;
        HashSet hashSet;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "nodeStartedIndication()");
        }
        if (!(hashSet = (restoreSubscriptionExtendeed = (RestoreSubscriptionExtendeed)ServiceLocatorFacade.getRepository().getService(RestoreSubscription.class)).getRestoreParticipators()).isEmpty()) {
            this.mySupervisionTimer = new Timer(0x6DDD00);
            this.mySupervisionTimer.addListener(this);
            this.mySupervisionTimer.startTimer();
        }
        this.myRestoreParticipatorsNotResponded = (HashSet)hashSet.clone();
        Iterator iterator = hashSet.iterator();
        RestoreParticipator restoreParticipator = null;
        while (iterator.hasNext()) {
            restoreParticipator = (RestoreParticipator)iterator.next();
            restoreParticipator.nodeStartedIndication(this);
            if (!Trace.valid(this.getClass(), 22)) continue;
            Trace.debug(this.getClass(), 22, "nodeStartedIndication()", "Restore indication sent to Restore Participator: " + restoreParticipator + "Retore participator name: " + restoreParticipator.getName());
        }
        this.waitForResponseFromAllRestoreParticipators(hashSet);
    }

    public void nodeStartedConfirmed(RestoreParticipator restoreParticipator) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "nodeStartedConfirmed(RestoreParticipator aRestoreParticipator)", "aRestoreParticipator: " + restoreParticipator);
        }
        if (!this.myRestoreParticipatorsNotResponded.remove(restoreParticipator)) {
            Trace.warning(this.getClass(), "nodeStartedConfirmed(RestoreParticipator aRestoreParticipator)", "Unexpected restore participator confirmed (ignored).\n\taRestoreParticipator: " + restoreParticipator + "\n\tRestoreParticipator name: " + restoreParticipator.getName() + "\n\tWaiting for response from participators: " + this.myRestoreParticipatorsNotResponded);
        }
        if (this.myRestoreParticipatorsNotResponded.isEmpty()) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "nodeStartedConfirmed(RestoreParticipator aRestoreParticipator)", "All restore participators have confirmed.");
            }
            this.notifyWaitingForResponse();
        }
    }

    public void nodeStartedRejected(RestoreParticipator restoreParticipator, String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "nodeStartedRejected(RestoreParticipator aRestoreParticipator)", "aRestoreParticipator: " + restoreParticipator);
        }
        if (!this.myRestoreParticipatorsNotResponded.remove(restoreParticipator)) {
            Trace.warning(this.getClass(), "nodeStartedRejected(RestoreParticipator aRestoreParticipator)", "Unexpected restore participator rejected (ignored).\n\taRestoreParticipator: " + restoreParticipator + "\n\tRestoreParticipator name: " + restoreParticipator.getName() + "\n\tWaiting for response from participators: " + this.myRestoreParticipatorsNotResponded);
        } else {
            Trace.error(this.getClass(), "nodeStartedRejected(RestoreParticipator aRestoreParticipator, String anErrorMessage)", "A restore participator has rejected the execution of a restore.\n\tRestore participator: " + restoreParticipator + "\n\tRestore participator name: " + restoreParticipator.getName() + "\n\tReason for rejection: " + string + "\n\tStill waiting for response from participators: " + this.myRestoreParticipatorsNotResponded);
            this.hasAnyRestoreParticipatorReportedFailure = true;
            this.notifyWaitingForResponse();
        }
    }

    public void nodeStartedWarning(RestoreParticipator restoreParticipator, String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "nodeStartedWarning(RestoreParticipator aRestoreParticipator)", "aRestoreParticipator: " + restoreParticipator);
        }
        if (!this.myRestoreParticipatorsNotResponded.remove(restoreParticipator)) {
            Trace.warning(this.getClass(), "nodeStartedWarning(RestoreParticipator aRestoreParticipator)", "Unexpected restore participator reported a warning (ignored).\n\taRestoreParticipator: " + restoreParticipator + "\n\tRestoreParticipator name: " + restoreParticipator.getName() + "\n\tWarning message: " + string + "\n\tWaiting for response from participators: " + this.myRestoreParticipatorsNotResponded);
        }
        Trace.warning(this.getClass(), "nodeStartedWarning(RestoreParticipator aRestoreParticipator)", "A restore participator has reported a warning message: aRestoreParticipator: " + restoreParticipator + "\n\tRestoreParticipator name: " + restoreParticipator.getName() + "\n\tWarning message: " + string);
        if (this.myRestoreParticipatorsNotResponded.isEmpty()) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "nodeStartedWarning(RestoreParticipator aRestoreParticipator)", "All restore participators have confirmed.");
            }
            this.notifyWaitingForResponse();
        }
    }

    public void timerAction(TimerEvent timerEvent) {
        if (!this.myRestoreParticipatorsNotResponded.isEmpty()) {
            this.hasAnyRestoreParticipatorReportedFailure = true;
            Trace.error(this.getClass(), "timerAction(TimerEvent e)", "The execution of the restore function failed due to no response received from restore participator(s) listed below.\n\tRestore participator(s): " + this.myRestoreParticipatorsNotResponded);
            this.notifyWaitingForResponse();
        } else if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "timerAction(TimerEvent e)", "Timeout occured while waiting for responses from restore participators.\n\tIgnored due to not waiting any longer for any repsonse.");
        }
    }

    private synchronized void notifyWaitingForResponse() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "notifyWaitingForResponse()");
        }
        try {
            this.notify();
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "notifyWaitingForResponse()", "Throwable caught when trying to notify the party waiting for response from restore participators.", throwable);
        }
    }

    private synchronized void waitForResponseFromAllRestoreParticipators(HashSet hashSet) throws RestoreParticipatorException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "waitForResponseFromAllRestoreParticipators(HashSet aRestoreParticipators)", "aRestoreParticipators: " + hashSet);
        }
        try {
            if (!this.myRestoreParticipatorsNotResponded.isEmpty()) {
                this.wait();
            }
            if (this.mySupervisionTimer != null) {
                this.mySupervisionTimer.stopTimer();
                this.mySupervisionTimer.removeListener(this);
            }
            if (this.hasAnyRestoreParticipatorReportedFailure) {
                throw new RestoreParticipatorException("A restore participator has reported failure.\n\tFor reasons, see earlier log messages.");
            }
        }
        catch (RestoreParticipatorException restoreParticipatorException) {
            throw restoreParticipatorException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "waitForResponseFromAllRestoreParticipators()", "Throwable caught while waiting for response from restore participators.\n\tThe restore participators are: " + hashSet, throwable);
            throw new RestoreParticipatorException(throwable.toString());
        }
    }
}

