/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.service;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import se.ericsson.cello.configurationversion.service.CS_Exception;
import se.ericsson.cello.configurationversion.service.CelloConfigurationServiceException;
import se.ericsson.cello.configurationversion.service.CelloConfigurationServiceListenerInterface;
import se.ericsson.cello.configurationversion.service.ConfigurationServiceFacade;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.trace.UpgradeTraceHandler;

public class CelloConfigurationServiceStatusObserver
implements Runnable {
    private Collection myListener = new HashSet();

    public CelloConfigurationServiceStatusObserver() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "CelloConfigurationServiceStatusObserver()");
        }
        new Thread(this).start();
    }

    public void addAsListener(CelloConfigurationServiceListenerInterface celloConfigurationServiceListenerInterface) throws CelloConfigurationServiceException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addAsListener(CelloConfigurationServiceListenerInterface aCelloConfigurationServiceListenerInterface)", "aCelloConfigurationServiceListenerInterface: " + celloConfigurationServiceListenerInterface);
        }
        if (this.myListener == null) {
            throw new CelloConfigurationServiceException("Not possible to add as listener due to CS is up and running");
        }
        this.myListener.add(celloConfigurationServiceListenerInterface);
    }

    public int getNumberOfListeners() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getNumberOfListeners()");
        }
        if (this.myListener != null) {
            return this.myListener.size();
        }
        return 0;
    }

    public void removeAsListener(CelloConfigurationServiceListenerInterface celloConfigurationServiceListenerInterface) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "removeAsListener(CelloConfigurationServiceListenerInterface aCelloConfigurationServiceListenerInterface)", "aCelloConfigurationServiceListenerInterface: " + celloConfigurationServiceListenerInterface);
        }
        if (this.myListener != null) {
            this.myListener.remove(celloConfigurationServiceListenerInterface);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "run()", "Waiting for the Configuration Service to be started... (registered).");
        }
        try {
            try {
                ConfigurationServiceFacade.getConfigurationServiceInterface().waitForCS();
                UpgradeTraceHandler.instance().reloadSWM_Version();
                Trace.log1(this.getClass(), "run()", "The Configuration Service is up and running.");
                Iterator iterator = this.myListener.iterator();
                CelloConfigurationServiceListenerInterface celloConfigurationServiceListenerInterface = null;
                while (iterator.hasNext()) {
                    celloConfigurationServiceListenerInterface = (CelloConfigurationServiceListenerInterface)iterator.next();
                    try {
                        celloConfigurationServiceListenerInterface.csUpAndRunning();
                    }
                    catch (Throwable throwable) {
                        Trace.error(this.getClass(), "run ( )", "Throwable caught when notifying the listener about that CS is up and running.\n\ttheCelloConfigurationServiceListenerInterface: " + celloConfigurationServiceListenerInterface, throwable);
                    }
                }
                Object var5_6 = null;
            }
            catch (CS_Exception cS_Exception) {
                Object var5_7 = null;
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "run ( )", "The thread observing the configuration service is stoped.");
                }
                Trace.flushToTraceFile();
                this.myListener = null;
                return;
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "run ( )", "Throwable caught when waiting for CS to start UP.", throwable);
                Object var5_8 = null;
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "run ( )", "The thread observing the configuration service is stoped.");
                }
                Trace.flushToTraceFile();
                this.myListener = null;
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "run ( )", "The thread observing the configuration service is stoped.");
            }
            Trace.flushToTraceFile();
            this.myListener = null;
            throw throwable;
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "run ( )", "The thread observing the configuration service is stoped.");
        }
        Trace.flushToTraceFile();
        this.myListener = null;
    }
}

