/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.service;

import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import se.ericsson.cello.configurationversion.service.CS_Exception;
import se.ericsson.cello.configurationversion.service.ConfigurationServiceInterface;
import se.ericsson.cello.support.corba.CelloOrb;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.time.TimeHandler;

public class ConfigurationService
implements ConfigurationServiceInterface {
    public void waitForCS() throws CS_Exception {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "waitForCS ()");
        }
        while (true) {
            try {
                NamingContext namingContext = CelloOrb.instance().getRootNamingContext();
                if (namingContext != null) {
                    NameComponent nameComponent = new NameComponent("CelloConfigurationService", "");
                    NameComponent[] nameComponentArray = new NameComponent[]{nameComponent};
                    namingContext.resolve(nameComponentArray);
                    break;
                }
                Trace.log1(this.getClass(), "waitForCS()", "Configuration Service not ready, trying again after 7 seconds.");
                TimeHandler.sleep(7000L);
            }
            catch (UserException userException) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "run()", "Configuration Service not ready (org.omg.CORBA.UserException caught), trying again after 7 seconds.");
                }
                TimeHandler.sleep(7000L);
            }
            catch (SystemException systemException) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "run()", "Configuration Service not ready (org.omg.CORBA.SystemException caught), trying again after 7 seconds.");
                }
                TimeHandler.sleep(7000L);
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "run ( )", "Throwable caught when trying to look up the Configuration Service from the Corba name server.", throwable);
                throw new CS_Exception("Throwable caught when trying to look up the Configuration Service from the Corba name server.");
            }
            Trace.flushToTraceFile();
        }
    }
}

