/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.util.handler;

import se.ericsson.cello.configurationversion.create.CV_Creator;
import se.ericsson.cello.configurationversion.main.ConfigurationVersionAlarm;
import se.ericsson.cello.configurationversion.main.ConfigurationVersionMoExtension;
import se.ericsson.cello.configurationversion.main.exception.ConfigurationVersionException;
import se.ericsson.cello.configurationversion.main.handler.CV_AttributeStartableConfigurationVersionHandler;
import se.ericsson.cello.configurationversion.rollbacklist.RollbackListContentsController;
import se.ericsson.cello.configurationversion.startable.SetStartableController;
import se.ericsson.cello.faultmanagement.AdditionalInfo;
import se.ericsson.cello.managedelement.meaccess.MO_HandlerException;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMo;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.library.SuLib;
import se.ericsson.cello.upgradepackage.util.mohandler.configurationversion.ConfigurationVersionMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;

public class RestoreCV_Handler {
    public RestoreCV_Handler() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "RestoreCV_Handler( )");
        }
    }

    public void configureCV_DataAfterConfirm(UpgradePackageMo upgradePackageMo) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "configureCV_DataAfterConfirm(UpgradePackageMo aCurrentUpgradePackageMO)", "aCurrentUpgradePackageMO: " + upgradePackageMo);
        }
        try {
            String string = this.createRestoreFinalCV(upgradePackageMo);
            this.setCV_AsStartable(string);
            this.setRollbackCounterToInitialValue();
        }
        catch (ConfigurationVersionException configurationVersionException) {
            String string = "RF";
            try {
                ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
                string = configurationVersionMO_HandlerInterface.createNameForRestoreFinalCV(upgradePackageMo);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.raiseConfigurationVersionAlarm(string);
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "configureCV_DataAfterConfirm(UpgradePackageMo aCurrentUpgradePackageMO)", "ConfigurationVersionException caught,\n\taCurrentUpgradePackageMO: " + upgradePackageMo + "\n\tConfigurationVersionException: " + (Object)((Object)configurationVersionException) + "\n\tConfigurationVersionException data: " + configurationVersionException.toString());
            }
            throw configurationVersionException;
        }
    }

    private void raiseConfigurationVersionAlarm(String string) {
        AdditionalInfo[] additionalInfoArray = new AdditionalInfo[]{new AdditionalInfo("Create and set CV as startable failed for CV", string)};
        ConfigurationVersionAlarm.instance().raiseAlarm(additionalInfoArray);
    }

    public void configureCV_DataAtEmergency(UpgradePackageMo upgradePackageMo) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "configureCV_DataAtEmergency(UpgradePackageMo aCurrentUpgradePackageMO)", "aCurrentUpgradePackageMO: " + upgradePackageMo);
        }
        try {
            String string = this.createEmergencyRestoreFinalCV(upgradePackageMo);
            this.setCV_AsStartable(string);
        }
        catch (ConfigurationVersionException configurationVersionException) {
            String string = "EF";
            try {
                ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
                string = configurationVersionMO_HandlerInterface.createNameForEmergencyRestoreFinalCV(upgradePackageMo);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.raiseConfigurationVersionAlarm(string);
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "configureCV_DataAtEmergency(UpgradePackageMo aCurrentUpgradePackageMO)", "ConfigurationVersionException caught,\n\taCurrentUpgradePackageMO: " + upgradePackageMo + "\n\tConfigurationVersionException: " + (Object)((Object)configurationVersionException) + "\n\tConfigurationVersionException data: " + configurationVersionException.toString());
            }
            throw configurationVersionException;
        }
    }

    public void configureCV_DataBeforeRestart(UpgradePackageMo upgradePackageMo, String string, boolean bl) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "configureCV_DataBeforeRestart(UpgradePackageMo aCurrentUpgradePackageMO, String aNameOfTheCV_ToBeRestored, boolean anIsBestEffortRequested)", "aCurrentUpgradePackageMO: " + upgradePackageMo + "\n\taNameOfTheCV_ToBeRestored: " + string + "\n\tanIsBestEffortRequested: " + bl);
        }
        try {
            block12: {
                String string2;
                String string3;
                block11: {
                    block10: {
                        string3 = null;
                        try {
                            string3 = this.createRestoreRollbackCV(upgradePackageMo);
                        }
                        catch (ConfigurationVersionException configurationVersionException) {
                            if (bl) break block10;
                            throw configurationVersionException;
                        }
                    }
                    string2 = null;
                    try {
                        string2 = this.getStartableCV();
                    }
                    catch (ConfigurationVersionException configurationVersionException) {
                        if (bl) break block11;
                        throw configurationVersionException;
                    }
                }
                try {
                    this.setRollbackDataBeforeRestart(string2, string3);
                }
                catch (ConfigurationVersionException configurationVersionException) {
                    if (bl) break block12;
                    throw configurationVersionException;
                }
            }
            this.setCV_AsStartable(string);
        }
        catch (ConfigurationVersionException configurationVersionException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "configureCV_DataBeforeRestart(UpgradePackageMo aCurrentUpgradePackageMO, String aNameOfTheCV_ToBeRestored, boolean anIsBestEffortRequested)", "ConfigurationVersionException caught,\n\taCurrentUpgradePackageMO: " + upgradePackageMo + "\n\taNameOfTheCV_ToBeRestored: " + string + "\n\tanIsBestEffortRequested: " + bl + "\n\tConfigurationVersionException: " + (Object)((Object)configurationVersionException) + "\n\tConfigurationVersionException data: " + configurationVersionException.toString());
            }
            throw configurationVersionException;
        }
    }

    public void setDefaultRollbackData() {
        block3: {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "setDefaultRollbackData( )");
            }
            try {
                this.setRollbackCounterToInitialValue();
            }
            catch (ConfigurationVersionException configurationVersionException) {
                if (!Trace.valid(this.getClass(), 22)) break block3;
                Trace.debug(this.getClass(), 22, "setDefaultRollbackData( )", "ConfigurationVersionException caught,\n\tConfigurationVersionException: " + (Object)((Object)configurationVersionException) + "\n\tConfigurationVersionException data: " + configurationVersionException.toString());
            }
        }
    }

    private void createCV(UpgradePackageMo upgradePackageMo, String string, int n, String string2) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createCV(UpgradePackageMo aCurrentUpgradePackageMO, String aCV_Name, int aType, String aComment)", "aCurrentUpgradePackageMO: " + upgradePackageMo + "\n\taCV_Name: " + string + "\n\taType: " + n + "\n\taComment: " + string2);
        }
        String string3 = null;
        try {
            string3 = upgradePackageMo != null ? upgradePackageMo.getUpgradePackageDocumentId(null) : SuLib.createUpgradePackageDocumentId("Initial", "Configuration");
            CV_Creator cV_Creator = new CV_Creator(false);
            cV_Creator.create(upgradePackageMo, string, "", n, string3, "Cello Packet Platform", string2, true);
            Trace.log1(this.getClass(), "createCV(UpgradePackageMo aCurrentUpgradePackageMO, String aCV_Name, int aType, String aComment)", "CV '" + string + "' has been created.");
        }
        catch (ConfigurationVersionException configurationVersionException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "createCV(UpgradePackageMo aCurrentUpgradePackageMO, String aCV_Name, int aType, String aComment)", "ConfigurationVersionException caught,\n\taCurrentUpgradePackageMO: " + upgradePackageMo + "\n\taCV_Name: " + string + "\n\taType: " + n + "\n\taComment: " + string2 + "\n\tConfigurationVersionException: " + (Object)((Object)configurationVersionException) + "\n\tConfigurationVersionException data: " + configurationVersionException.toString());
            }
            throw configurationVersionException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "createCV(UpgradePackageMo aCurrentUpgradePackageMO, String aCV_Name, int aType, String aComment)", "Throwable caught,\n\taCurrentUpgradePackageMO: " + upgradePackageMo + "\n\taCV_Name: " + string + "\n\taType: " + n + "\n\taComment: " + string2, throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tcreateCV(UpgradePackageMo aCurrentUpgradePackageMO, String aCV_Name, int aType, String aComment)" + "\n\taCurrentUpgradePackageMO: " + upgradePackageMo + "\n\taCV_Name: " + string + "\n\taType: " + n + "\n\taComment: " + string2 + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private String createEmergencyRestoreFinalCV(UpgradePackageMo upgradePackageMo) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createEmergencyRestoreFinalCV(UpgradePackageMo aCurrentUpgradePackageMO)", "aCurrentUpgradePackageMO: " + upgradePackageMo);
        }
        try {
            ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
            String string = configurationVersionMO_HandlerInterface.createNameForEmergencyRestoreFinalCV(upgradePackageMo);
            this.createCV(upgradePackageMo, string, 8, "Final CV autocreated at Emerg. Restore.");
            return string;
        }
        catch (MO_HandlerException mO_HandlerException) {
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tcreateEmergencyRestoreFinalCV(UpgradePackageMo aCurrentUpgradePackageMO)" + "\n\taCurrentUpgradePackageMO: " + upgradePackageMo + "\n\tConfigurationVersionMO_HandlerException caught when trying to create a name " + "for an Emergency Restore Final CV." + "\n\tConfigurationVersionMO_HandlerException: " + (Object)((Object)mO_HandlerException) + "\n\tConfigurationVersionMO_HandlerException data: " + mO_HandlerException.toString());
        }
    }

    private String createRestoreFinalCV(UpgradePackageMo upgradePackageMo) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createRestoreFinalCV(UpgradePackageMo aCurrentUpgradePackageMO)", "aCurrentUpgradePackageMO: " + upgradePackageMo);
        }
        try {
            ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
            String string = configurationVersionMO_HandlerInterface.createNameForRestoreFinalCV(upgradePackageMo);
            this.createCV(upgradePackageMo, string, 8, "Final CV autocreated at Restore CV.");
            return string;
        }
        catch (MO_HandlerException mO_HandlerException) {
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tcreateRestoreFinalCV(UpgradePackageMo aCurrentUpgradePackageMO)" + "\n\taCurrentUpgradePackageMO: " + upgradePackageMo + "\n\tConfigurationVersionMO_HandlerException caught when trying to create a name " + "for a Restore Final CV." + "\n\tConfigurationVersionMO_HandlerException: " + (Object)((Object)mO_HandlerException) + "\n\tConfigurationVersionMO_HandlerException data: " + mO_HandlerException.toString());
        }
    }

    private String createRestoreRollbackCV(UpgradePackageMo upgradePackageMo) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createRestoreRollbackCV(UpgradePackageMo aCurrentUpgradePackageMO)", "aCurrentUpgradePackageMO: " + upgradePackageMo);
        }
        try {
            ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
            String string = configurationVersionMO_HandlerInterface.createNameForRestoreRollbackCV(upgradePackageMo);
            this.createCV(upgradePackageMo, string, 5, "Rollback CV autocreated at Restore CV.");
            return string;
        }
        catch (MO_HandlerException mO_HandlerException) {
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tcreateRestoreRollbackCV(UpgradePackageMo aCurrentUpgradePackageMO)" + "\n\taCurrentUpgradePackageMO: " + upgradePackageMo + "\n\tConfigurationVersionMO_HandlerException caught when trying to create a name " + "for a Restore Rollback CV." + "\n\tConfigurationVersionMO_HandlerException: " + (Object)((Object)mO_HandlerException) + "\n\tConfigurationVersionMO_HandlerException data: " + mO_HandlerException.toString());
        }
    }

    private String getStartableCV() throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getStartableCV( )");
        }
        CV_AttributeStartableConfigurationVersionHandler cV_AttributeStartableConfigurationVersionHandler = new CV_AttributeStartableConfigurationVersionHandler();
        return cV_AttributeStartableConfigurationVersionHandler.get();
    }

    private void setCV_AsStartable(String string) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setCV_AsStartable(String aCV_Name)", "aCV_Name: " + string);
        }
        try {
            SetStartableController setStartableController = new SetStartableController(false);
            setStartableController.setStartable(string, true, false);
        }
        catch (ConfigurationVersionException configurationVersionException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "setCV_AsStartable(String aCV_Name)", "ConfigurationVersionException caught,\n\taCV_Name: " + string + "\n\tConfigurationVersionException: " + (Object)((Object)configurationVersionException) + "\n\tConfigurationVersionException data: " + configurationVersionException.toString());
            }
            throw configurationVersionException;
        }
    }

    private void setRollbackCounterToInitialValue() throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setRollbackCounterToInitialValue( )");
        }
        try {
            ConfigurationVersionMoExtension configurationVersionMoExtension = ConfigurationVersionMoExtension.instance();
            if (configurationVersionMoExtension.getRollbackOn(null)) {
                int n = configurationVersionMoExtension.getRollbackInitCounterValue(null);
                configurationVersionMoExtension.setRollbackCounterForSU(n, null);
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "setRollbackCounterToInitialValue( )", "Throwable caught.", throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tsetRollbackCounterToInitialValue( )" + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private void setRollbackDataBeforeRestart(String string, String string2) throws ConfigurationVersionException {
        RollbackListContentsController rollbackListContentsController;
        block14: {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "setRollbackDataBeforeRestart(String aNameOfTheOldStartableCV, String aNameOfTheCreatedRollbackCV)", "aNameOfTheOldStartableCV: " + string + "\n\taNameOfTheCreatedRollbackCV: " + string2);
            }
            rollbackListContentsController = new RollbackListContentsController(false);
            try {
                if (string != null) {
                    rollbackListContentsController.setFirstInRollbackList(string);
                }
            }
            catch (ConfigurationVersionException configurationVersionException) {
                if (!Trace.valid(this.getClass(), 22)) break block14;
                Trace.debug(this.getClass(), 22, "setRollbackDataBeforeRestart(String aNameOfTheOldStartableCV, String aNameOfTheCreatedRollbackCV)", "ConfigurationVersionException (caught and ignored) when trying to set the old startable CV as the first entry in the Rollback List,\n\taNameOfTheOldStartableCV: " + string + "\n\taNameOfTheCreatedRollbackCV: " + string2 + "\n\tConfigurationVersionException info: " + configurationVersionException.toString());
            }
        }
        try {
            ConfigurationVersionMoExtension configurationVersionMoExtension;
            boolean bl;
            if (string2 != null) {
                rollbackListContentsController.setFirstInRollbackList(string2);
            }
            if (!(bl = (configurationVersionMoExtension = ConfigurationVersionMoExtension.instance()).getRollbackOn(null))) {
                configurationVersionMoExtension.setRollbackOn(true, null);
            }
            try {
                configurationVersionMoExtension.setRollbackCounter(1, null);
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "setRollbackDataBeforeRestart(String aNameOfTheOldStartableCV, String aNameOfTheCreatedRollbackCV)", "Throwable caught when trying to set rollbackCounter to 1,\n\taNameOfTheOldStartableCV: " + string + "\n\taNameOfTheCreatedRollbackCV: " + string2, throwable);
                if (!bl) {
                    try {
                        configurationVersionMoExtension.setRollbackOn(bl, null);
                    }
                    catch (Throwable throwable2) {
                        Trace.error(this.getClass(), "setRollbackDataBeforeRestart(String aNameOfTheOldStartableCV, String aNameOfTheCreatedRollbackCV)", "Throwable caught when trying to restore the old value for rollbackOn after failure to set the rollbackCounter,\n\taNameOfTheOldStartableCV: " + string + "\n\taNameOfTheCreatedRollbackCV: " + string2, throwable2);
                    }
                }
                throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tsetRollbackDataBeforeRestart(String aNameOfTheOldStartableCV, String aNameOfTheCreatedRollbackCV)" + "\n\taNameOfTheOldStartableCV: " + string + "\n\taNameOfTheCreatedRollbackCV: " + string2 + "\n\tThrowable caught when trying to set rollbackCounter to 1," + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
            }
        }
        catch (ConfigurationVersionException configurationVersionException) {
            Trace.error(this.getClass(), "setRollbackDataBeforeRestart(String aNameOfTheOldStartableCV, String aNameOfTheCreatedRollbackCV)", "ConfigurationVersionException caught,\n\taNameOfTheOldStartableCV: " + string + "\n\taNameOfTheCreatedRollbackCV: " + string2, (Throwable)((Object)configurationVersionException));
            throw configurationVersionException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "setRollbackDataBeforeRestart(String aNameOfTheOldStartableCV, String aNameOfTheCreatedRollbackCV)", "Throwable caught,\n\taNameOfTheOldStartableCV: " + string + "\n\taNameOfTheCreatedRollbackCV: " + string2, throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tsetRollbackDataBeforeRestart(String aNameOfTheOldStartableCV, String aNameOfTheCreatedRollbackCV)" + "\n\taNameOfTheOldStartableCV: " + string + "\n\taNameOfTheCreatedRollbackCV: " + string2 + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }
}

