/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.verify.hwconfiguration;

import java.util.Collection;
import java.util.Iterator;
import se.ericsson.cello.configurationversion.main.exception.ConfigurationVersionException;
import se.ericsson.cello.configurationversion.verify.base.VerifyException;
import se.ericsson.cello.configurationversion.verify.hwconfiguration.ComparedSlotInformation;
import se.ericsson.cello.configurationversion.verify.hwconfiguration.HW_ConfigurationDiffInformation;
import se.ericsson.cello.configurationversion.verify.hwconfiguration.MasterSlotInformation;
import se.ericsson.cello.configurationversion.verify.hwconfiguration.SubrackInformation;
import se.ericsson.cello.su.froproxy.cv.interfaces.CV_ArmamentInformation;
import se.ericsson.cello.su.froproxy.cv.interfaces.CelloCvArmaInfo;
import se.ericsson.cello.sudom.extsuif.proxy.exceptions.InvalidProductRevisionFormatException;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumberAndRevision;
import se.ericsson.cello.upgradepackage.trace.Trace;

public class HW_ConfigurationVerifier {
    public HW_ConfigurationDiffInformation getHardwareCompatibilityInfo(CV_ArmamentInformation cV_ArmamentInformation, CV_ArmamentInformation cV_ArmamentInformation2) throws VerifyException {
        if (Trace.valid(this.getClass(), 23)) {
            Trace.debug(this.getClass(), 23, "getHardwareCompatibilityInfo(CV_ArmamentInformation aMasterCV_ArmamentInformation, CV_ArmamentInformation aCV_ArmamentInformationToBeCompared)", "aMasterCV_ArmamentInformation: " + cV_ArmamentInformation + "\n\taCV_ArmamentInformationToBeCompared: " + cV_ArmamentInformation2);
        }
        try {
            HW_ConfigurationDiffInformation hW_ConfigurationDiffInformation = new HW_ConfigurationDiffInformation();
            this.checkSrNumber(cV_ArmamentInformation, cV_ArmamentInformation2, hW_ConfigurationDiffInformation);
            return hW_ConfigurationDiffInformation;
        }
        catch (ConfigurationVersionException configurationVersionException) {
            throw new VerifyException(configurationVersionException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getHardwareCompatibilityInfo(CV_ArmamentInformation aMasterCV_ArmamentInformation, CV_ArmamentInformation aCV_ArmamentInformationToBeCompared)", "Exception caught," + throwable);
            throw new VerifyException(throwable.toString());
        }
    }

    private void compareConfiguration(Collection collection, Collection collection2, Integer n, HW_ConfigurationDiffInformation hW_ConfigurationDiffInformation) throws VerifyException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "compareConfiguration(Collection aMasterCelloCvArmaInfo, Collection aComparedCvArmaInfo, Integer  aSrNumber, HW_ConfigurationDiffInformation aTheHWConfDiffInfo)", "aMasterCelloCvArmaInfo: " + collection + "\n\taComparedCvArmaInfo: " + collection2 + "\n\taSrNumber: " + n);
        }
        try {
            if (!collection.isEmpty()) {
                this.checkSlots(collection, collection2, n, hW_ConfigurationDiffInformation);
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "compareConfiguration(Collection aMasterCelloCvArmaInfo, Collection aComparedCvArmaInfo, Integer  aSrNumber, HW_ConfigurationDiffInformation aTheHWConfDiffInfo)", "Exception caught,\n\taMasterCelloCvArmaInfo: " + collection + "\n\taComparedCvArmaInfo: " + collection2 + "\n\taSrNumber: " + n, throwable);
            throw new VerifyException(throwable.toString());
        }
    }

    private void checkSrNumber(CV_ArmamentInformation cV_ArmamentInformation, CV_ArmamentInformation cV_ArmamentInformation2, HW_ConfigurationDiffInformation hW_ConfigurationDiffInformation) throws VerifyException {
        if (Trace.valid(this.getClass(), 23)) {
            Trace.debug(this.getClass(), 23, "checkSrNumber(CV_ArmamentInformation aMasterCV_ArmamentInformation, CV_ArmamentInformation aCV_ArmamentInformationToBeCompared, HW_ConfigurationDiffInformation aTheHWConfDiffInfo)", "aMasterCV_ArmamentInformation: " + cV_ArmamentInformation + "\n\taCV_ArmamentInformationToBeCompared: " + cV_ArmamentInformation2 + "\n\taTheHWConfDiffInfo: " + hW_ConfigurationDiffInformation);
        }
        Collection collection = cV_ArmamentInformation.getSrNumbers();
        Iterator iterator = collection.iterator();
        Integer n = null;
        while (iterator.hasNext()) {
            n = (Integer)iterator.next();
            if (cV_ArmamentInformation2.containsSrNumber(n)) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "checkSmn(CV_ArmamentInformation aMasterCV_ArmamentInformation, CV_ArmamentInformation aCV_ArmamentInformationToBeCompared, HW_ConfigurationDiffInformation aTheHWConfDiffInfo)", "Same srNumber found, going to check configuration. ");
                }
                this.compareConfiguration(cV_ArmamentInformation.getCelloCvArmaInfo(n), cV_ArmamentInformation2.getCelloCvArmaInfo(n), n, hW_ConfigurationDiffInformation);
                continue;
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "checkSmn(CV_ArmamentInformation aMasterCV_ArmamentInformation, CV_ArmamentInformation aCV_ArmamentInformationToBeCompared, HW_ConfigurationDiffInformation aTheHWConfDiffInfo)", "srNumber not found in master armament information. ");
            }
            this.addToNotMatchingSubrack(cV_ArmamentInformation, n, hW_ConfigurationDiffInformation);
        }
    }

    private void checkSlots(Collection collection, Collection collection2, Integer n, HW_ConfigurationDiffInformation hW_ConfigurationDiffInformation) throws VerifyException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "(Collection aMasterCelloCvArmaInfo, Collection aComparedCvArmaInfo, Integer  aSrNumber, HW_ConfigurationDiffInformation aTheHWConfDiffInfo)", "aMasterCelloCvArmaInfo: " + collection + "\n\taComparedCvArmaInfo: " + collection2 + "\n\taSrNumber: " + n);
        }
        SubrackInformation subrackInformation = new SubrackInformation(n);
        try {
            Iterator iterator = null;
            MasterSlotInformation masterSlotInformation = null;
            ComparedSlotInformation comparedSlotInformation = null;
            CelloCvArmaInfo celloCvArmaInfo = null;
            CelloCvArmaInfo celloCvArmaInfo2 = null;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = true;
            Iterator iterator2 = collection.iterator();
            while (iterator2.hasNext()) {
                bl = false;
                bl3 = false;
                bl2 = false;
                iterator = collection2.iterator();
                celloCvArmaInfo = (CelloCvArmaInfo)iterator2.next();
                int n2 = celloCvArmaInfo.getSlotNumber();
                ProductNumberAndRevision productNumberAndRevision = new ProductNumberAndRevision(celloCvArmaInfo.getProductNumber(), celloCvArmaInfo.getProductRevision());
                int n3 = celloCvArmaInfo.getPiuRole();
                masterSlotInformation = new MasterSlotInformation(n2, productNumberAndRevision, n3);
                while (iterator.hasNext()) {
                    celloCvArmaInfo2 = (CelloCvArmaInfo)iterator.next();
                    int n4 = celloCvArmaInfo2.getSlotNumber();
                    ProductNumberAndRevision productNumberAndRevision2 = new ProductNumberAndRevision(celloCvArmaInfo2.getProductNumber(), celloCvArmaInfo2.getProductRevision());
                    int n5 = celloCvArmaInfo2.getPiuRole();
                    comparedSlotInformation = new ComparedSlotInformation(n4, productNumberAndRevision, productNumberAndRevision2, n3, n5);
                    String string = productNumberAndRevision.productNumber;
                    String string2 = productNumberAndRevision.revision;
                    String string3 = productNumberAndRevision2.productNumber;
                    String string4 = productNumberAndRevision2.revision;
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "checkSlots(Collection aMasterCelloCvArmaInfo, Collection aComparedCvArmaInfo, Integer  aSrNumber, HW_ConfigurationDiffInformation aTheHWConfDiffInfo) ", "theMasterSlotNumber: " + n2 + "\n\tmasterProdNr: " + string + "\n\tmasterProdRev: " + string2 + "\n\ttheComparedSlotNumber: " + n4 + "\n\tcomparedProdNr: " + string3 + "\n\tcomparedProdRev: " + string4);
                    }
                    if (n2 == n4) {
                        bl2 = true;
                        if (productNumberAndRevision.equals(string3, string4)) {
                            bl3 = true;
                            break;
                        }
                        if (productNumberAndRevision2.equalsShortRevision(string, string2)) {
                            bl = true;
                            break;
                        }
                        if (productNumberAndRevision2.equalsWildcardRevision(string, string2)) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    bl2 = false;
                    bl = false;
                }
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "checkSlots(Collection aMasterCelloCvArmaInfo, Collection aComparedCvArmaInfo, Integer  aSrNumber, HW_ConfigurationDiffInformation aTheHWConfDiffInfo)", "sameSlot: " + bl2 + "\n\tisCompatible: " + bl + "\n\tisMatching: " + bl3 + "\n\tmissingSlot: " + bl4);
                }
                if (bl2 && bl3) {
                    subrackInformation.slotsWithMatchingPIUs.add(masterSlotInformation);
                    if (!Trace.valid(this.getClass(), 20)) continue;
                    Trace.debug(this.getClass(), 20, "checkSlots(Collection aMasterCelloCvArmaInfo, Collection aComparedCvArmaInfo, Integer  aSrNumber, HW_ConfigurationDiffInformation aTheHWConfDiffInfo)", "Exact match found: " + masterSlotInformation + "\n\tadding to slotsWithMatchingPIUs: " + subrackInformation.slotsWithMatchingPIUs.toString());
                    continue;
                }
                if (bl2 && bl) {
                    subrackInformation.slotsWithCompatiblePIUs.add(comparedSlotInformation);
                    if (!Trace.valid(this.getClass(), 20)) continue;
                    Trace.debug(this.getClass(), 20, "checkSlots(Collection aMasterCelloCvArmaInfo, Collection aComparedCvArmaInfo, Integer  aSrNumber, HW_ConfigurationDiffInformation aTheHWConfDiffInfo)", "compatible PIU found. Master slotInfo: " + masterSlotInformation + "\n\tCompared slotInfo: " + comparedSlotInformation + "\n\tadding to slotsWithCompatiblePIUs: " + subrackInformation.slotsWithCompatiblePIUs.toString());
                    continue;
                }
                if (!bl2 && bl4) {
                    subrackInformation.slotsWithNoPIUs.add(masterSlotInformation);
                    if (!Trace.valid(this.getClass(), 20)) continue;
                    Trace.debug(this.getClass(), 20, "checkSlots(Collection aMasterCelloCvArmaInfo, Collection aComparedCvArmaInfo, Integer  aSrNumber, HW_ConfigurationDiffInformation aTheHWConfDiffInfo)", "Missing slots found. Master slotInfo: " + masterSlotInformation + "\n\tadding to slotsWithNoPIUs: " + subrackInformation.slotsWithNoPIUs.toString());
                    continue;
                }
                if (!bl2 || bl) continue;
                subrackInformation.slotsWithIncompatiblePIUs.add(comparedSlotInformation);
                if (!Trace.valid(this.getClass(), 20)) continue;
                Trace.debug(this.getClass(), 20, "checkSlots(Collection aMasterCelloCvArmaInfo, Collection aComparedCvArmaInfo, Integer  aSrNumber, HW_ConfigurationDiffInformation aTheHWConfDiffInfo)", "Incompatible PIU found. Master slotInfo: " + masterSlotInformation + "\n\tCompared slotInfo: " + comparedSlotInformation + "\n\tadding to slotsWithIncompatiblePIUs: " + subrackInformation.slotsWithIncompatiblePIUs.toString());
            }
            hW_ConfigurationDiffInformation.matchingSubracks.add(subrackInformation);
        }
        catch (InvalidProductRevisionFormatException invalidProductRevisionFormatException) {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "checkSlots(Collection aMasterCelloCvArmaInfo, Collection aComparedCvArmaInfo, Integer  aSrNumber, HW_ConfigurationDiffInformation aTheHWConfDiffInfo)", "aMasterSubrackInfoContainer: " + collection + "\ntaComparedSubrackInfoContainer: " + collection2 + "\n\taSrNumber: " + n);
            }
            throw new VerifyException(invalidProductRevisionFormatException.toString());
        }
    }

    private void addToNotMatchingSubrack(CV_ArmamentInformation cV_ArmamentInformation, Integer n, HW_ConfigurationDiffInformation hW_ConfigurationDiffInformation) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addToNotMatchingSubrack(CV_ArmamentInformation aMasterCV_ArmamentInformation, Integer aSrNumber, HW_ConfigurationDiffInformation aTheHWConfDiffInfo)", "aMasterCV_ArmamentInformation: " + cV_ArmamentInformation + "\n\taSrNumber: " + n);
        }
        SubrackInformation subrackInformation = new SubrackInformation(n);
        CelloCvArmaInfo celloCvArmaInfo = null;
        ProductNumberAndRevision productNumberAndRevision = null;
        Collection collection = cV_ArmamentInformation.getCelloCvArmaInfo(n);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            celloCvArmaInfo = (CelloCvArmaInfo)iterator.next();
            productNumberAndRevision = new ProductNumberAndRevision(celloCvArmaInfo.getProductNumber(), celloCvArmaInfo.getProductRevision());
            MasterSlotInformation masterSlotInformation = new MasterSlotInformation(celloCvArmaInfo.getSlotNumber(), productNumberAndRevision, celloCvArmaInfo.getPiuRole());
            subrackInformation.slotsWithNoPIUs.add(masterSlotInformation);
        }
        hW_ConfigurationDiffInformation.notMatchingSubracks.add(subrackInformation);
    }
}

